# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import Extra,  BaseModel, Field, StrictBool
from lightly.openapi_generated.swagger_client.models.datasource_config_verify_data_errors import DatasourceConfigVerifyDataErrors

class DatasourceConfigVerifyData(BaseModel):
    """
    DatasourceConfigVerifyData
    """
    can_read: StrictBool = Field(..., alias="canRead")
    can_write: StrictBool = Field(..., alias="canWrite")
    can_list: StrictBool = Field(..., alias="canList")
    can_overwrite: StrictBool = Field(..., alias="canOverwrite")
    errors: Optional[DatasourceConfigVerifyDataErrors] = None
    __properties = ["canRead", "canWrite", "canList", "canOverwrite", "errors"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> DatasourceConfigVerifyData:
        """Create an instance of DatasourceConfigVerifyData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors' if by_alias else 'errors'] = self.errors.to_dict(by_alias=by_alias)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DatasourceConfigVerifyData:
        """Create an instance of DatasourceConfigVerifyData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DatasourceConfigVerifyData.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in DatasourceConfigVerifyData) in the input: " + str(obj))

        _obj = DatasourceConfigVerifyData.parse_obj({
            "can_read": obj.get("canRead"),
            "can_write": obj.get("canWrite"),
            "can_list": obj.get("canList"),
            "can_overwrite": obj.get("canOverwrite"),
            "errors": DatasourceConfigVerifyDataErrors.from_dict(obj.get("errors")) if obj.get("errors") is not None else None
        })
        return _obj

