# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import Extra,  BaseModel, Field, constr
from lightly.openapi_generated.swagger_client.models.configuration_value_data_type import ConfigurationValueDataType

class ConfigurationEntry(BaseModel):
    """
    ConfigurationEntry
    """
    name: constr(strict=True, min_length=1) = Field(..., description="the name of this entry which is displayed in the UI")
    path: constr(strict=True, min_length=1) = Field(..., description="the path is the dotnotation which is used to easily access the customMetadata JSON structure of a sample e.g myArray[0].myObject.field")
    default_value: Optional[Any] = Field(..., alias="defaultValue", description="the default value used if its not possible to extract the value using the path or if the value extracted is nullish")
    value_data_type: ConfigurationValueDataType = Field(..., alias="valueDataType")
    __properties = ["name", "path", "defaultValue", "valueDataType"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> ConfigurationEntry:
        """Create an instance of ConfigurationEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if default_value (nullable) is None
        # and __fields_set__ contains the field
        if self.default_value is None and "default_value" in self.__fields_set__:
            _dict['defaultValue' if by_alias else 'default_value'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConfigurationEntry:
        """Create an instance of ConfigurationEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConfigurationEntry.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in ConfigurationEntry) in the input: " + str(obj))

        _obj = ConfigurationEntry.parse_obj({
            "name": obj.get("name"),
            "path": obj.get("path"),
            "default_value": obj.get("defaultValue"),
            "value_data_type": obj.get("valueDataType")
        })
        return _obj

