from pathlib import Pathfrom typing import Dict, Listdef supported_file_extensions():    return [        "bin",        "pcd",        "ply",        "xyz",        "obj",        "ctm",        "off",        "stl",    ]def available_dataloaders() -> List:    import os.path    import pkgutil    pkgpath = os.path.dirname(__file__)    dataloaders = [name for _, name, _ in pkgutil.iter_modules([pkgpath])]    dataloaders.remove("point_cloud2")    return dataloadersdef jumpable_dataloaders():    _jumpable_dataloaders = available_dataloaders()    _jumpable_dataloaders.remove("mcap")    _jumpable_dataloaders.remove("ouster")    _jumpable_dataloaders.remove("rosbag")    return _jumpable_dataloadersdef dataloader_types() -> Dict:    import ast    import importlib    dataloaders = available_dataloaders()    _types = {}    for dataloader in dataloaders:        script = importlib.util.find_spec(f".{dataloader}", __name__).origin        with open(script) as f:            tree = ast.parse(f.read(), script)            classes = [cls for cls in tree.body if isinstance(cls, ast.ClassDef)]            _types[dataloader] = classes[0].name  # assuming there is only 1 class    return _typesdef dataset_factory(dataloader: str, data_dir: Path, *args, **kwargs):    import importlib    dataloader_type = dataloader_types()[dataloader]    module = importlib.import_module(f".{dataloader}", __name__)    assert hasattr(module, dataloader_type), f"{dataloader_type} is not defined in {module}"    dataset = getattr(module, dataloader_type)    return dataset(data_dir=data_dir, *args, **kwargs)