import typing as tfrom asyncio import Lockfrom atproto_core.uri import AtUrifrom atproto_client import modelsfrom atproto_client.client.async_raw import AsyncClientRawfrom atproto_client.client.methods_mixin import SessionMethodsMixin, TimeMethodsMixinfrom atproto_client.client.methods_mixin.backward_compatibility import _BackwardCompatibilityfrom atproto_client.client.methods_mixin.session import AsyncSessionDispatchMixinfrom atproto_client.client.session import Session, SessionEvent, SessionResponsefrom atproto_client.exceptions import LoginRequiredErrorfrom atproto_client.models.languages import DEFAULT_LANGUAGE_CODE1from atproto_client.utils import TextBuilderif t.TYPE_CHECKING:    from atproto_client.client.base import InvokeType    from atproto_client.request import Responseclass AsyncClient(    _BackwardCompatibility, AsyncSessionDispatchMixin, SessionMethodsMixin, TimeMethodsMixin, AsyncClientRaw):    """High-level client for XRPC of ATProto."""    def __init__(self, base_url: t.Optional[str] = None, *args: t.Any, **kwargs: t.Any) -> None:        super().__init__(base_url, *args, **kwargs)        self._refresh_lock = Lock()        self.me: t.Optional['models.AppBskyActorDefs.ProfileViewDetailed'] = None    async def _invoke(self, invoke_type: 'InvokeType', **kwargs: t.Any) -> 'Response':        session_refreshing = kwargs.pop('session_refreshing', False)        if session_refreshing:            return await super()._invoke(invoke_type, **kwargs)        async with self._refresh_lock:            if self._access_jwt and self._should_refresh_session():                await self._refresh_and_set_session()        return await super()._invoke(invoke_type, **kwargs)    async def _set_session(self, event: SessionEvent, session: SessionResponse) -> None:        session = self._set_session_common(session)        await self._call_on_session_change_callbacks(event, session.copy())    async def _get_and_set_session(self, login: str, password: str) -> 'models.ComAtprotoServerCreateSession.Response':        session = await self.com.atproto.server.create_session(            models.ComAtprotoServerCreateSession.Data(identifier=login, password=password)        )        await self._set_session(SessionEvent.CREATE, session)        return session    async def _refresh_and_set_session(self) -> 'models.ComAtprotoServerRefreshSession.Response':        if not self._refresh_jwt:            raise LoginRequiredError        refresh_session = await self.com.atproto.server.refresh_session(            headers=self._get_auth_headers(self._refresh_jwt), session_refreshing=True        )        await self._set_session(SessionEvent.REFRESH, refresh_session)        return refresh_session    async def _import_session_string(self, session_string: str) -> Session:        import_session = Session.decode(session_string)        await self._set_session(SessionEvent.IMPORT, import_session)        return import_session    async def login(        self, login: t.Optional[str] = None, password: t.Optional[str] = None, session_string: t.Optional[str] = None    ) -> 'models.AppBskyActorDefs.ProfileViewDetailed':        """Authorize a client and get profile info.        Args:            login: Handle/username of the account.            password: Main or app-specific password of the account.            session_string: Session string (use :py:attr:`~export_session_string` to obtain it).        Note:            Either `session_string` or `login` and `password` should be provided.        Returns:            :obj:`models.AppBskyActorDefs.ProfileViewDetailed`: Profile information.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        if session_string:            session = await self._import_session_string(session_string)        elif login and password:            session = await self._get_and_set_session(login, password)        else:            raise ValueError('Either session_string or login and password should be provided.')        self.me = await self.app.bsky.actor.get_profile(models.AppBskyActorGetProfile.Params(actor=session.handle))        return self.me    async def send_post(        self,        text: t.Union[str, TextBuilder],        profile_identify: t.Optional[str] = None,        reply_to: t.Optional['models.AppBskyFeedPost.ReplyRef'] = None,        embed: t.Optional[            t.Union[                'models.AppBskyEmbedImages.Main',                'models.AppBskyEmbedExternal.Main',                'models.AppBskyEmbedRecord.Main',                'models.AppBskyEmbedRecordWithMedia.Main',            ]        ] = None,        langs: t.Optional[t.List[str]] = None,        facets: t.Optional[t.List['models.AppBskyRichtextFacet.Main']] = None,    ) -> 'models.AppBskyFeedPost.CreateRecordResponse':        """Send post.        Note:            If `profile_identify` is not provided will be sent to the current profile.            The async default language is ``en``.            Available languages are async defined in :py:mod:`atproto.xrpc_client.models.languages`.        Args:            text: Text of the post.            profile_identify: Handle or DID. Where to send post.            reply_to: Root and parent of the post to reply to.            embed: Embed models that should be attached to the post.            langs: List of used languages in the post.            facets: List of facets (rich text items).        Returns:            :obj:`models.AppBskyFeedPost.CreateRecordResponse`: Reference to the created record.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        if isinstance(text, TextBuilder):            facets = text.build_facets()            text = text.build_text()        repo = self.me and self.me.did        if profile_identify:            repo = profile_identify        if not repo:            raise LoginRequiredError        if not langs:            langs = [DEFAULT_LANGUAGE_CODE1]        record = models.AppBskyFeedPost.Record(            created_at=self.get_current_time_iso(),            text=text,            reply=reply_to,            embed=embed,            langs=langs,            facets=facets,        )        return await self.app.bsky.feed.post.create(repo, record)    async def delete_post(self, post_uri: str) -> bool:        """Delete post.        Args:            post_uri: AT URI of the post.        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        uri = AtUri.from_str(post_uri)        return await self.app.bsky.feed.post.delete(uri.hostname, uri.rkey)    async def send_image(        self,        text: t.Union[str, TextBuilder],        image: bytes,        image_alt: str,        profile_identify: t.Optional[str] = None,        reply_to: t.Optional['models.AppBskyFeedPost.ReplyRef'] = None,        langs: t.Optional[t.List[str]] = None,        facets: t.Optional[t.List['models.AppBskyRichtextFacet.Main']] = None,    ) -> 'models.AppBskyFeedPost.CreateRecordResponse':        """Send post with attached image.        Note:            If `profile_identify` is not provided will be sent to the current profile.        Args:            text: Text of the post.            image: Binary image to attach.            image_alt: Text version of the image            profile_identify: Handle or DID. Where to send post.            reply_to: Root and parent of the post to reply to.            langs: List of used languages in the post.            facets: List of facets (rich text items).        Returns:            :obj:`models.AppBskyFeedPost.CreateRecordResponse`: Reference to the created record.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        upload = await self.com.atproto.repo.upload_blob(image)        images = [models.AppBskyEmbedImages.Image(alt=image_alt, image=upload.blob)]        return await self.send_post(            text,            profile_identify=profile_identify,            reply_to=reply_to,            embed=models.AppBskyEmbedImages.Main(images=images),            langs=langs,            facets=facets,        )    async def get_post(        self, post_rkey: str, profile_identify: t.Optional[str] = None, cid: t.Optional[str] = None    ) -> 'models.AppBskyFeedPost.GetRecordResponse':        """Get post.        Args:            post_rkey: ID (slug) of the post.            profile_identify: Handler or DID. Who created the post.            cid: The CID of the version of the post.        Returns:            :obj:`models.AppBskyFeedPost.GetRecordResponse`: Post.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        repo = self.me and self.me.did        if profile_identify:            repo = profile_identify        if not repo:            raise LoginRequiredError        return await self.app.bsky.feed.post.get(repo, post_rkey, cid)    async def get_posts(self, uris: t.List[str]) -> 'models.AppBskyFeedGetPosts.Response':        """Get posts.        Args:            uris: Uris (AT URI).        Example:            .. code-block:: python                client.get_posts(['at://did:plc:kvwvcn5iqfooopmyzvb4qzba/app.bsky.feed.post/3k2yihcrp6f2c'])        Returns:            :obj:`models.AppBskyFeedGetPosts.Response`: Posts.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_posts(            models.AppBskyFeedGetPosts.Params(                uris=uris,            )        )    async def get_post_thread(        self, uri: str, depth: t.Optional[int] = None, parent_height: t.Optional[int] = None    ) -> 'models.AppBskyFeedGetPostThread.Response':        """Get post thread.        Args:            uri: AT URI.            depth: Depth of the thread.            parent_height: Height of the parent post.        Returns:            :obj:`models.AppBskyFeedGetPostThread.Response`: Post thread.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_post_thread(            models.AppBskyFeedGetPostThread.Params(                uri=uri,                depth=depth,                parent_height=parent_height,            )        )    async def get_likes(        self, uri: str, cid: t.Optional[str] = None, cursor: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyFeedGetLikes.Response':        """Get likes.        Args:            uri: AT URI.            cid: CID.            cursor: Cursor of the last like in the previous page.            limit: Limit count of likes to return.        Returns:            :obj:`models.AppBskyFeedGetLikes.Response`: Likes.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_likes(            models.AppBskyFeedGetLikes.Params(uri=uri, cid=cid, cursor=cursor, limit=limit)        )    async def get_reposted_by(        self, uri: str, cid: t.Optional[str] = None, cursor: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyFeedGetRepostedBy.Response':        """Get reposted by (reposts).        Args:            uri: AT URI.            cid: CID.            cursor: Cursor of the last like in the previous page.            limit: Limit count of likes to return.        Returns:            :obj:`models.AppBskyFeedGetRepostedBy.Response`: Reposts.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_reposted_by(            models.AppBskyFeedGetRepostedBy.Params(uri=uri, cid=cid, cursor=cursor, limit=limit)        )    async def get_timeline(        self, algorithm: t.Optional[str] = None, cursor: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyFeedGetTimeline.Response':        """Get home timeline.        Args:            algorithm: Algorithm.            cursor: Cursor of the last like in the previous page.            limit: Limit count of likes to return.        Returns:            :obj:`models.AppBskyFeedGetTimeline.Response`: Home timeline.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_timeline(            models.AppBskyFeedGetTimeline.Params(algorithm=algorithm, cursor=cursor, limit=limit)        )    async def get_author_feed(        self, actor: str, cursor: t.Optional[str] = None, filter: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyFeedGetAuthorFeed.Response':        """Get author (profile) feed.        Args:            actor: Actor (handle or DID).            cursor: Cursor of the last like in the previous page.            filter: Filter.            limit: Limit count of likes to return.        Returns:            :obj:`models.AppBskyFeedGetAuthorFeed.Response`: Feed.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.feed.get_author_feed(            models.AppBskyFeedGetAuthorFeed.Params(actor=actor, cursor=cursor, filter=filter, limit=limit)        )    async def like(        self,        uri: t.Optional[str] = None,        cid: t.Optional[str] = None,        subject: t.Optional['models.ComAtprotoRepoStrongRef.Main'] = None,    ) -> 'models.AppBskyFeedLike.CreateRecordResponse':        """Like the record.        Args:            cid: The CID of the record.            uri: The URI of the record.            subject: DEPRECATED.        Note:            Record could be post, custom feed, etc.        Returns:            :obj:`models.AppBskyFeedLike.CreateRecordResponse`: Reference to the created record.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        subject_obj = self._strong_ref_arg_backward_compatibility(uri, cid, subject)        repo = self.me and self.me.did        if not repo:            raise LoginRequiredError        record = models.AppBskyFeedLike.Record(created_at=self.get_current_time_iso(), subject=subject_obj)        return await self.app.bsky.feed.like.create(repo, record)    async def unlike(self, like_uri: str) -> bool:        """Unlike the post.        Args:            like_uri: AT URI of the like.        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        uri = AtUri.from_str(like_uri)        return await self.app.bsky.feed.like.delete(uri.hostname, uri.rkey)    async def repost(        self,        uri: t.Optional[str] = None,        cid: t.Optional[str] = None,        subject: t.Optional['models.ComAtprotoRepoStrongRef.Main'] = None,    ) -> 'models.AppBskyFeedRepost.CreateRecordResponse':        """Repost post.        Args:            cid: The CID of the post.            uri: The URI of the post.            subject: DEPRECATED.        Returns:            :obj:`models.AppBskyFeedRepost.CreateRecordResponse`: Reference to the reposted record.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        subject_obj = self._strong_ref_arg_backward_compatibility(uri, cid, subject)        repo = self.me and self.me.did        if not repo:            raise LoginRequiredError        record = models.AppBskyFeedRepost.Record(created_at=self.get_current_time_iso(), subject=subject_obj)        return await self.app.bsky.feed.repost.create(repo, record)    async def unrepost(self, repost_uri: str) -> bool:        """Unrepost the post (delete repost).        Args:            repost_uri: AT URI of the repost.        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        uri = AtUri.from_str(repost_uri)        return await self.app.bsky.feed.repost.delete(uri.hostname, uri.rkey)    async def follow(self, subject: str) -> 'models.AppBskyGraphFollow.CreateRecordResponse':        """Follow the profile.        Args:            subject: DID of the profile.        Returns:            :obj:`models.AppBskyGraphFollow.CreateRecordResponse`: Reference to the created record.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        repo = self.me and self.me.did        if not repo:            raise LoginRequiredError        record = models.AppBskyGraphFollow.Record(created_at=self.get_current_time_iso(), subject=subject)        return await self.app.bsky.graph.follow.create(repo, record)    async def unfollow(self, follow_uri: str) -> bool:        """Unfollow the profile.        Args:            follow_uri: AT URI of the follow.        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        uri = AtUri.from_str(follow_uri)        return await self.app.bsky.graph.follow.delete(uri.hostname, uri.rkey)    async def get_follows(        self, actor: str, cursor: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyGraphGetFollows.Response':        """Get follows of the profile.        Args:            actor: Actor (handle or DID).            cursor: Cursor of the next page.            limit: Limit count of follows to return.        Returns:            :obj:`models.AppBskyGraphGetFollows.Response`: Follows.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.graph.get_follows(            models.AppBskyGraphGetFollows.Params(actor=actor, cursor=cursor, limit=limit)        )    async def get_followers(        self, actor: str, cursor: t.Optional[str] = None, limit: t.Optional[int] = None    ) -> 'models.AppBskyGraphGetFollowers.Response':        """Get followers of the profile.        Args:            actor: Actor (handle or DID).            cursor: Cursor of the next page.            limit: Limit count of followers to return.        Returns:            :obj:`models.AppBskyGraphGetFollowers.Response`: Followers.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.graph.get_followers(            models.AppBskyGraphGetFollowers.Params(actor=actor, cursor=cursor, limit=limit)        )    async def get_profile(self, actor: str) -> 'models.AppBskyActorDefs.ProfileViewDetailed':        """Get profile.        Args:            actor: Actor (handle or DID).        Returns:            :obj:`models.AppBskyActorDefs.ProfileViewDetailed`: Profile.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.actor.get_profile(models.AppBskyActorGetProfile.Params(actor=actor))    async def get_profiles(self, actors: t.List[str]) -> 'models.AppBskyActorGetProfiles.Response':        """Get profiles.        Args:            actors: List of actors (handles or DIDs).        Returns:            :obj:`models.AppBskyActorGetProfiles.Response`: Profiles.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.actor.get_profiles(models.AppBskyActorGetProfiles.Params(actors=actors))    async def mute(self, actor: str) -> bool:        """Mute actor (profile).        Args:            actor: Actor (handle or DID).        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.graph.mute_actor(models.AppBskyGraphMuteActor.Data(actor=actor))    async def unmute(self, actor: str) -> bool:        """Unmute actor (profile).        Args:            actor: Actor (handle or DID).        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.app.bsky.graph.unmute_actor(models.AppBskyGraphUnmuteActor.Data(actor=actor))    async def resolve_handle(self, handle: str) -> 'models.ComAtprotoIdentityResolveHandle.Response':        """Resolve the handle.        Args:            handle: Handle.        Returns:            :obj:`models.ComAtprotoIdentityResolveHandle.Response`: Resolved handle (DID).        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.com.atproto.identity.resolve_handle(            models.ComAtprotoIdentityResolveHandle.Params(handle=handle)        )    async def update_handle(self, handle: str) -> bool:        """Update the handle.        Args:            handle: New handle.        Returns:            :obj:`bool`: Success status.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.com.atproto.identity.update_handle(models.ComAtprotoIdentityUpdateHandle.Data(handle=handle))    async def upload_blob(self, data: bytes) -> 'models.ComAtprotoRepoUploadBlob.Response':        """Upload blob.        Args:            data: Binary data.        Returns:            :obj:`models.ComAtprotoRepoUploadBlob.Response`: Uploaded blob reference.        Raises:            :class:`atproto.exceptions.AtProtocolError`: Base exception.        """        return await self.com.atproto.repo.upload_blob(data)    #: Alias for :attr:`unfollow`    delete_follow = unfollow    #: Alias for :attr:`unlike`    delete_like = unlike    #: Alias for :attr:`unrepost`    delete_repost = unrepost    #: Alias for :attr:`send_post`    post = send_post    #: Alias for :attr:`delete_post`    unsend = delete_post