# -*- coding: utf-8 -*-
"""Credit Card fraud Detection using Libra.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1khr-nqQVkP_XMUQ5y8GWrK5AUS41lyzC

# Credit Card Fraud Detection Using Libra

I have used the Kaggle dataset for the prediction of credit card fraud. The data has already gone through the principal component analysis, so it is now reduced to less dimensional data as compared to the original one. It requires follow a systematic approach while solving this problem. In General way you will follow the sequence: Data analysis and preprocessing, Data cleaning, Machine learning.  But with Libra you don't have to worry about it.

Link of dataset 

```
https://www.kaggle.com/mlg-ulb/creditcardfraud
```


Most of the transactions were Non-Fraudulent (99.83 Percent) of the time, while Fraudulent transactions occur (0.17 Percent) of the time in the dataset. Which means that the data is highly imabalance. Let us check how well Libra preprocess the data and gives us the reslt.

# Installing Libra
"""

pip install -U libra

"""# Importing client from libra
Everything is built around the client object. You can call different queries on it and everything will be stored under the models field of the object.
"""

from libra import client

"""# Using Libra
We pass the location of our file in the client object and named it as newClient. Now to access various qureies refer to the documentation. I am using decision tree here. So the command for it is newClient.decision_tree_query() and pass in an instruction. Instructiion is an English language statement that represents the task you would like to be completed. eg: 'predict the median house value' or 'please estimate the number of households'. Should correspond to a column in the dataset. Libra Automatically detects the target column but just to be sure that it select the right column, I have passed the target column name.
"""

newClient = client('/content/drive/My Drive/Colab Notebooks/creditcard.csv')
newClient.decision_tree_query('Class')

"""With just two lines of code we acquired a score of aprroximately 0.99 which is the best we can get. If you check out other kernels you would observe that only a handful of people got 0.99 accuracy and that took them hours to preprocess the data and write code for it. In that case libra saves you alot of time and gives the best result. Libra uses something known as Intelligent preprocessing so that you don't need to preprocess the data, all by yourself.

# You don't need to worry about analysing the results.
newClient.analyze() Creates confusion matrix and ROC Curve for all classification problems. Also calculates recall, precision, f1, and f2 score.
"""

newClient.analyze()

"""newClient.info() Returns all the keys, representing each category of data generated for the dataset."""

newClient.info()

"""`newClient.model()` returns a dictionary of that model. It includes everything from accuracy, precision, recall,F! score to all the preprocsiing technique that have been used. It's more helpful for people who are already know about these concepts and can code them. Non tech users need not to worry about this."""

newClient.model()

"""# Accessing the model

`newClient.model() `return a dictionary and if you want to access the model then you can directly use newClient.model()['model']
"""

newClient.model()['model']

"""***It's that simple. Anyone can use it. :)***"""