# -*- coding: utf-8 -*-
"""Using the SVM Query through Libra

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1M2hhiYhpSUftUWFEcz04bSm-03wzTsv2

Here's another great example of how to use Libra. Let's assume we want to analyze some data and classify wheat types. First, we call libra.
"""

!pip install libra


from libra import client

"""Now, we'll be uploading our dataset. Since Colab resets storage, you'll have to upload it again through https://drive.google.com/file/d/15jM8aW9sw18efiQj39BFEbZn6TAAKEVf/view?usp=sharing

The original, unformatted version is here: http://archive.ics.uci.edu/ml/datasets/seeds

Now, let's create the client object.
"""

client_wheat = client('wheat.csv')

"""After the dataset has been uploaded, we can start creating a neural network to analyze parts of it. We will be classifying the examples based on their wheat type"""

client_wheat.svm_query('Classify by wheat type')

"""Here are some other useful methods"""

client_wheat.analyze()

"""Here's how to get more specific information. client_name.models['query type'] will return all the information available. 

client_name.info() will give you the keys for the model. Now you can use this to access specific information that you require
"""

client_wheat.models['svm']

client_wheat.info()

client_wheat.models['svm']['accuracy']