'''
This adapter accepts a text as input which describes the annotated data.
Each line in text are formatted as:
[image absolute path],[pos/neg flag],[num of bboxes],[x1],[y1],[width1],[height1],[x2],[y2],[width2],[height2]......
'''

import cv2
import numpy
from ChasingTrainFramework_GeneralOneClassDetection.data_provider_base.base_data_adapter import DataAdapterBaseclass


class TextListAdapter(DataAdapterBaseclass):

    def __init__(self, data_list_file_path):

        DataAdapterBaseclass.__init__(self)
        fin = open(data_list_file_path, 'r')
        self.lines = fin.readlines()
        fin.close()
        self.line_counter = 0

    def __del__(self):
        pass

    def get_one(self):
        """
        This function use 'yield' to return samples
        """
        while self.line_counter < len(self.lines):

            line = self.lines[self.line_counter].strip('\n').split(',')
            if line[1] == '1':  #
                assert len(line[3:]) == 4 * int(line[2])

            im = cv2.imread(line[0], cv2.IMREAD_UNCHANGED)

            if line[1] == '0':
                yield im, '0'
                self.line_counter += 1
                continue

            num_bboxes = int(line[2])
            bboxes = []
            for i in range(num_bboxes):
                x = float(line[3 + i * 4])
                y = float(line[3 + i * 4 + 1])
                width = float(line[3 + i * 4 + 2])
                height = float(line[3 + i * 4 + 3])

                bboxes.append([x, y, width, height])

            bboxes = numpy.array(bboxes, dtype=numpy.float32)
            yield im, bboxes

            self.line_counter += 1


if __name__ == '__main__':
    pass
