from langchain import PromptTemplate, HuggingFaceHub, LLMChain

template = """Question: {question}

Answer: Let's think step by step."""
prompt = PromptTemplate(template=template, input_variables=["question"])
llm_chain = LLMChain(
    prompt=prompt,
    llm=HuggingFaceHub(
        repo_id="google/flan-t5-xl", model_kwargs={"temperature": 0, "max_length": 64}
    ),
)
question = "Who won the FIFA World Cup in the year 1994? "

print(llm_chain.run(question))
