from . import Image, ImageFilefrom ._binary import i32be as i32def _accept(prefix):    return len(prefix) >= 8 and i32(prefix, 0) >= 20 and i32(prefix, 4) in (1, 2)### Image plugin for the GIMP brush format.class GbrImageFile(ImageFile.ImageFile):    format = "GBR"    format_description = "GIMP brush file"    def _open(self):        header_size = i32(self.fp.read(4))        version = i32(self.fp.read(4))        if header_size < 20:            raise SyntaxError("not a GIMP brush")        if version not in (1, 2):            raise SyntaxError(f"Unsupported GIMP brush version: {version}")        width = i32(self.fp.read(4))        height = i32(self.fp.read(4))        color_depth = i32(self.fp.read(4))        if width <= 0 or height <= 0:            raise SyntaxError("not a GIMP brush")        if color_depth not in (1, 4):            raise SyntaxError(f"Unsupported GIMP brush color depth: {color_depth}")        if version == 1:            comment_length = header_size - 20        else:            comment_length = header_size - 28            magic_number = self.fp.read(4)            if magic_number != b"GIMP":                raise SyntaxError("not a GIMP brush, bad magic number")            self.info["spacing"] = i32(self.fp.read(4))        comment = self.fp.read(comment_length)[:-1]        if color_depth == 1:            self.mode = "L"        else:            self.mode = "RGBA"        self._size = width, height        self.info["comment"] = comment        # Image might not be small        Image._decompression_bomb_check(self.size)        # Data is an uncompressed block of w * h * bytes/pixel        self._data_size = width * height * color_depth    def load(self):        if self.im:            # Already loaded            return        self.im = Image.core.new(self.mode, self.size)        self.frombytes(self.fp.read(self._data_size))## registryImage.register_open(GbrImageFile.format, GbrImageFile, _accept)Image.register_extension(GbrImageFile.format, ".gbr")