"""Data loader."""import itertoolsimport numpy as npimport torchfrom torch.utils.data._utils.collate import default_collatefrom torch.utils.data.distributed import DistributedSamplerfrom torch.utils.data.sampler import RandomSamplerfrom .build import build_datasetdef detection_collate(batch):    """    Collate function for detection task. Concatanate bboxes, labels and    metadata from different samples in the first dimension instead of    stacking them to have a batch-size dimension.    Args:        batch (tuple or list): data batch to collate.    Returns:        (tuple): collated detection data batch.    """    inputs, labels, video_idx, extra_data = zip(*batch)    inputs, video_idx = default_collate(inputs), default_collate(video_idx)    labels = torch.tensor(np.concatenate(labels, axis=0)).float()    collated_extra_data = {}    for key in extra_data[0].keys():        data = [d[key] for d in extra_data]        if key == "boxes" or key == "ori_boxes":            # Append idx info to the bboxes before concatenating them.            bboxes = [                np.concatenate(                    [np.full((data[i].shape[0], 1), float(i)), data[i]], axis=1                )                for i in range(len(data))            ]            bboxes = np.concatenate(bboxes, axis=0)            collated_extra_data[key] = torch.tensor(bboxes).float()        elif key == "metadata":            collated_extra_data[key] = torch.tensor(                list(itertools.chain(*data))            ).view(-1, 2)        else:            collated_extra_data[key] = default_collate(data)    return inputs, labels, video_idx, collated_extra_datadef construct_loader(cfg, split):    """    Constructs the data loader for the given dataset.    Args:        cfg (CfgNode): configs. Details can be found in            slowfast/config/defaults.py        split (str): the split of the data loader. Options include `train`,            `val`, and `test`.    """    assert split in ["train", "val", "test"]    if split in ["train"]:        dataset_name = cfg.TRAIN.DATASET        batch_size = int(cfg.TRAIN.BATCH_SIZE / cfg.NUM_GPUS)        shuffle = True        drop_last = True    elif split in ["val"]:        dataset_name = cfg.TRAIN.DATASET        batch_size = int(cfg.TRAIN.BATCH_SIZE / cfg.NUM_GPUS)        shuffle = False        drop_last = False    elif split in ["test"]:        dataset_name = cfg.TEST.DATASET        batch_size = int(cfg.TEST.BATCH_SIZE / cfg.NUM_GPUS)        shuffle = False        drop_last = False    # Construct the dataset    dataset = build_dataset(dataset_name, cfg, split)    # Create a sampler for multi-process training    sampler = DistributedSampler(dataset) if cfg.NUM_GPUS > 1 else None    # Create a loader    loader = torch.utils.data.DataLoader(        dataset,        batch_size=batch_size,        shuffle=(False if sampler else shuffle),        sampler=sampler,        num_workers=cfg.DATA_LOADER.NUM_WORKERS,        pin_memory=cfg.DATA_LOADER.PIN_MEMORY,        drop_last=drop_last,        collate_fn=detection_collate if cfg.DETECTION.ENABLE else None,    )    return loaderdef shuffle_dataset(loader, cur_epoch):    """"    Shuffles the data.    Args:        loader (loader): data loader to perform shuffle.        cur_epoch (int): number of the current epoch.    """    assert isinstance(        loader.sampler, (RandomSampler, DistributedSampler)    ), "Sampler type '{}' not supported".format(type(loader.sampler))    # RandomSampler handles shuffling automatically    if isinstance(loader.sampler, DistributedSampler):        # DistributedSampler shuffles data based on epoch        loader.sampler.set_epoch(cur_epoch)