from langchain import chains
from tests.unit_tests import assert_all_importable

EXPECTED_ALL = [
    "APIChain",
    "AnalyzeDocumentChain",
    "ArangoGraphQAChain",
    "ChatVectorDBChain",
    "ConstitutionalChain",
    "ConversationChain",
    "ConversationalRetrievalChain",
    "FalkorDBQAChain",
    "FlareChain",
    "GraphCypherQAChain",
    "GraphQAChain",
    "GraphSparqlQAChain",
    "OntotextGraphDBQAChain",
    "HugeGraphQAChain",
    "HypotheticalDocumentEmbedder",
    "KuzuQAChain",
    "LLMChain",
    "LLMCheckerChain",
    "LLMMathChain",
    "LLMRequestsChain",
    "LLMRouterChain",
    "LLMSummarizationCheckerChain",
    "MapReduceChain",
    "MapReduceDocumentsChain",
    "MapRerankDocumentsChain",
    "MultiPromptChain",
    "MultiRetrievalQAChain",
    "MultiRouteChain",
    "NatBotChain",
    "NebulaGraphQAChain",
    "NeptuneOpenCypherQAChain",
    "NeptuneSparqlQAChain",
    "OpenAIModerationChain",
    "OpenAPIEndpointChain",
    "QAGenerationChain",
    "QAWithSourcesChain",
    "ReduceDocumentsChain",
    "RefineDocumentsChain",
    "RetrievalQA",
    "RetrievalQAWithSourcesChain",
    "RouterChain",
    "SequentialChain",
    "SimpleSequentialChain",
    "StuffDocumentsChain",
    "TransformChain",
    "VectorDBQA",
    "VectorDBQAWithSourcesChain",
    "create_citation_fuzzy_match_chain",
    "create_extraction_chain",
    "create_extraction_chain_pydantic",
    "create_qa_with_sources_chain",
    "create_qa_with_structure_chain",
    "create_tagging_chain",
    "create_tagging_chain_pydantic",
    "generate_example",
    "load_chain",
    "create_sql_query_chain",
    "create_history_aware_retriever",
    "create_retrieval_chain",
    "load_summarize_chain",
    "create_structured_output_runnable",
]


def test_all_imports() -> None:
    assert set(chains.__all__) == set(EXPECTED_ALL)
    assert_all_importable(chains)
