"""**Chains** are easily reusable components linked together.

Chains encode a sequence of calls to components like models, document retrievers,
other Chains, etc., and provide a simple interface to this sequence.

The Chain interface makes it easy to create apps that are:

    - **Stateful:** add Memory to any Chain to give it state,
    - **Observable:** pass Callbacks to a Chain to execute additional functionality,
      like logging, outside the main sequence of component calls,
    - **Composable:** combine Chains with other components, including other Chains.

**Class hierarchy:**

.. code-block::

    Chain --> <name>Chain  # Examples: LLMChain, MapReduceChain, RouterChain
"""

from langchain.chains.api.base import APIChain
from langchain.chains.api.openapi.chain import OpenAPIEndpointChain
from langchain.chains.combine_documents.base import AnalyzeDocumentChain
from langchain.chains.combine_documents.map_reduce import MapReduceDocumentsChain
from langchain.chains.combine_documents.map_rerank import MapRerankDocumentsChain
from langchain.chains.combine_documents.reduce import ReduceDocumentsChain
from langchain.chains.combine_documents.refine import RefineDocumentsChain
from langchain.chains.combine_documents.stuff import StuffDocumentsChain
from langchain.chains.constitutional_ai.base import ConstitutionalChain
from langchain.chains.conversation.base import ConversationChain
from langchain.chains.conversational_retrieval.base import (
    ChatVectorDBChain,
    ConversationalRetrievalChain,
)
from langchain.chains.example_generator import generate_example
from langchain.chains.flare.base import FlareChain
from langchain.chains.graph_qa.arangodb import ArangoGraphQAChain
from langchain.chains.graph_qa.base import GraphQAChain
from langchain.chains.graph_qa.cypher import GraphCypherQAChain
from langchain.chains.graph_qa.falkordb import FalkorDBQAChain
from langchain.chains.graph_qa.hugegraph import HugeGraphQAChain
from langchain.chains.graph_qa.kuzu import KuzuQAChain
from langchain.chains.graph_qa.nebulagraph import NebulaGraphQAChain
from langchain.chains.graph_qa.neptune_cypher import NeptuneOpenCypherQAChain
from langchain.chains.graph_qa.neptune_sparql import NeptuneSparqlQAChain
from langchain.chains.graph_qa.ontotext_graphdb import OntotextGraphDBQAChain
from langchain.chains.graph_qa.sparql import GraphSparqlQAChain
from langchain.chains.history_aware_retriever import create_history_aware_retriever
from langchain.chains.hyde.base import HypotheticalDocumentEmbedder
from langchain.chains.llm import LLMChain
from langchain.chains.llm_checker.base import LLMCheckerChain
from langchain.chains.llm_math.base import LLMMathChain
from langchain.chains.llm_requests import LLMRequestsChain
from langchain.chains.llm_summarization_checker.base import LLMSummarizationCheckerChain
from langchain.chains.loading import load_chain
from langchain.chains.mapreduce import MapReduceChain
from langchain.chains.moderation import OpenAIModerationChain
from langchain.chains.natbot.base import NatBotChain
from langchain.chains.openai_functions import (
    create_citation_fuzzy_match_chain,
    create_extraction_chain,
    create_extraction_chain_pydantic,
    create_qa_with_sources_chain,
    create_qa_with_structure_chain,
    create_tagging_chain,
    create_tagging_chain_pydantic,
)
from langchain.chains.qa_generation.base import QAGenerationChain
from langchain.chains.qa_with_sources.base import QAWithSourcesChain
from langchain.chains.qa_with_sources.retrieval import RetrievalQAWithSourcesChain
from langchain.chains.qa_with_sources.vector_db import VectorDBQAWithSourcesChain
from langchain.chains.retrieval import create_retrieval_chain
from langchain.chains.retrieval_qa.base import (
    RetrievalQA,
    VectorDBQA,
)
from langchain.chains.router import (
    LLMRouterChain,
    MultiPromptChain,
    MultiRetrievalQAChain,
    MultiRouteChain,
    RouterChain,
)
from langchain.chains.sequential import SequentialChain, SimpleSequentialChain
from langchain.chains.sql_database.query import create_sql_query_chain
from langchain.chains.structured_output import create_structured_output_runnable
from langchain.chains.summarize import load_summarize_chain
from langchain.chains.transform import TransformChain

__all__ = [
    "APIChain",
    "AnalyzeDocumentChain",
    "ArangoGraphQAChain",
    "ChatVectorDBChain",
    "ConstitutionalChain",
    "ConversationChain",
    "ConversationalRetrievalChain",
    "FalkorDBQAChain",
    "FlareChain",
    "GraphCypherQAChain",
    "GraphQAChain",
    "GraphSparqlQAChain",
    "OntotextGraphDBQAChain",
    "HugeGraphQAChain",
    "HypotheticalDocumentEmbedder",
    "KuzuQAChain",
    "LLMChain",
    "LLMCheckerChain",
    "LLMMathChain",
    "LLMRequestsChain",
    "LLMRouterChain",
    "LLMSummarizationCheckerChain",
    "MapReduceChain",
    "MapReduceDocumentsChain",
    "MapRerankDocumentsChain",
    "MultiPromptChain",
    "MultiRetrievalQAChain",
    "MultiRouteChain",
    "NatBotChain",
    "NebulaGraphQAChain",
    "NeptuneOpenCypherQAChain",
    "NeptuneSparqlQAChain",
    "OpenAIModerationChain",
    "OpenAPIEndpointChain",
    "QAGenerationChain",
    "QAWithSourcesChain",
    "ReduceDocumentsChain",
    "RefineDocumentsChain",
    "RetrievalQA",
    "RetrievalQAWithSourcesChain",
    "RouterChain",
    "SequentialChain",
    "SimpleSequentialChain",
    "StuffDocumentsChain",
    "TransformChain",
    "VectorDBQA",
    "VectorDBQAWithSourcesChain",
    "create_citation_fuzzy_match_chain",
    "create_extraction_chain",
    "create_extraction_chain_pydantic",
    "create_qa_with_sources_chain",
    "create_qa_with_structure_chain",
    "create_tagging_chain",
    "create_tagging_chain_pydantic",
    "generate_example",
    "load_chain",
    "create_sql_query_chain",
    "create_retrieval_chain",
    "create_history_aware_retriever",
    "create_structured_output_runnable",
    "load_summarize_chain",
]
