from __future__ import print_functionimport numpy as npfrom copy import deepcopyfrom scipy.ndimage import map_coordinatesfrom scipy.ndimage.filters import gaussian_filter, gaussian_gradient_magnitudedef generate_elastic_transform_coordinates(shape, alpha, sigma):    n_dim = len(shape)    offsets = []    for _ in range(n_dim):        offsets.append(gaussian_filter((np.random.random(shape) * 2 - 1), sigma, mode="constant", cval=0) * alpha)    tmp = tuple([np.arange(i) for i in shape])    coords = np.meshgrid(*tmp, indexing='ij')    indices = [np.reshape(i + j, (-1, 1)) for i, j in zip(offsets, coords)]    return indicesdef create_zero_centered_coordinate_mesh(shape):    tmp = tuple([np.arange(i) for i in shape])    coords = np.array(np.meshgrid(*tmp, indexing='ij')).astype(float)    for d in range(len(shape)):        coords[d] -= ((np.array(shape).astype(float) - 1) / 2.)[d]    return coordsdef elastic_deform_coordinates(coordinates, alpha, sigma):    n_dim = len(coordinates)    offsets = []    for _ in range(n_dim):        offsets.append(            gaussian_filter((np.random.random(coordinates.shape[1:]) * 2 - 1), sigma, mode="constant", cval=0) * alpha)    offsets = np.array(offsets)    indices = offsets + coordinates    return indicesdef rotate_coords_3d(coords, angle_x, angle_y, angle_z):    rot_matrix = np.identity(len(coords))    rot_matrix = create_matrix_rotation_x_3d(angle_x, rot_matrix)    rot_matrix = create_matrix_rotation_y_3d(angle_y, rot_matrix)    rot_matrix = create_matrix_rotation_z_3d(angle_z, rot_matrix)    coords = np.dot(coords.reshape(len(coords), -1).transpose(), rot_matrix).transpose().reshape(coords.shape)    return coordsdef rotate_coords_2d(coords, angle):    rot_matrix = create_matrix_rotation_2d(angle)    coords = np.dot(coords.reshape(len(coords), -1).transpose(), rot_matrix).transpose().reshape(coords.shape)    return coordsdef scale_coords(coords, scale):    return coords * scaledef uncenter_coords(coords):    shp = coords.shape[1:]    coords = deepcopy(coords)    for d in range(coords.shape[0]):        coords[d] += (shp[d] - 1) / 2.    return coordsdef interpolate_img(img, coords, order=3, mode='nearest', cval=0.0):    return map_coordinates(img, coords, order=order, mode=mode, cval=cval)def generate_noise(shape, alpha, sigma):    noise = np.random.random(shape) * 2 - 1    noise = gaussian_filter(noise, sigma, mode="constant", cval=0) * alpha    return noise