from sklearn.base import BaseEstimator
from typing import List


class BaseLLM(BaseEstimator):
    """ The base representation model for fine-tuning topic representations """
    def extract_keywords(self, documents: List[str], candidate_keywords: List[List[str]] = None):
        """ Extract topics

        Arguments:
            documents: The documents to extract keywords from
            candidate_keywords: A list of candidate keywords that the LLM will fine-tune
                        For example, it will create a nicer representation of 
                        the candidate keywords, remove redundant keywords, or 
                        shorten them depending on the input prompt.

        Returns:
            all_keywords: All keywords for each document
        """
        return [None for document in documents]
