from detectron2.layers import ShapeSpecfrom detectron2.utils.registry import Registryfrom .backbone import BackboneBACKBONE_REGISTRY = Registry("BACKBONE")BACKBONE_REGISTRY.__doc__ = """Registry for backbones, which extract feature maps from imagesThe registered object must be a callable that accepts two arguments:1. A :class:`detectron2.config.CfgNode`2. A :class:`detectron2.layers.ShapeSpec`, which contains the input shape specification.Registered object must return instance of :class:`Backbone`."""def build_backbone(cfg, input_shape=None):    """    Build a backbone from `cfg.MODEL.BACKBONE.NAME`.    Returns:        an instance of :class:`Backbone`    """    if input_shape is None:        input_shape = ShapeSpec(channels=len(cfg.MODEL.PIXEL_MEAN))    backbone_name = cfg.MODEL.BACKBONE.NAME    backbone = BACKBONE_REGISTRY.get(backbone_name)(cfg, input_shape)    assert isinstance(backbone, Backbone)    return backbone