"""
Adapted from keras example cifar10_cnn.py
Train NASNet-CIFAR on the CIFAR10 small images dataset.
"""
from __future__ import print_function
import os
import numpy as np
import matplotlib.pyplot as plt

from keras.datasets import cifar10
from keras.preprocessing.image import ImageDataGenerator
from keras.utils import np_utils
from keras.callbacks import ModelCheckpoint
from keras.optimizers import SGD
from keras import backend as K

from clr import LRFinder
from models.small.model import MiniVGG

plt.style.use('seaborn-white')

batch_size = 128
nb_classes = 10
nb_epoch = 1  # Only finding lr
data_augmentation = True

# input image dimensions
img_rows, img_cols = 32, 32
# The CIFAR10 images are RGB.
img_channels = 3

# The data, shuffled and split between train and test sets:
(X_train, y_train), (X_test, y_test) = cifar10.load_data()

# Convert class vectors to binary class matrices.
Y_train = np_utils.to_categorical(y_train, nb_classes)
Y_test = np_utils.to_categorical(y_test, nb_classes)

X_train = X_train.astype('float32')
X_test = X_test.astype('float32')

# preprocess input
mean = np.mean(X_train, axis=(0, 1, 2), keepdims=True).astype('float32')
std = np.mean(X_train, axis=(0, 1, 2), keepdims=True).astype('float32')

print("Channel Mean : ", mean)
print("Channel Std : ", std)

X_train = (X_train - mean) / (std)
X_test = (X_test - mean) / (std)

# Learning rate finder callback setup
num_samples = X_train.shape[0]

MOMENTUMS = [0.9, 0.95, 0.99]

# for momentum in MOMENTUMS:
#     K.clear_session()
#
#     # Learning rate range obtained from `find_lr_schedule.py`
#     # NOTE : Minimum is 10x smaller than the max found above !
#     # NOTE : It is preferable to use the validation data here to get a correct value
#     lr_finder = LRFinder(num_samples, batch_size, minimum_lr=0.00125, maximum_lr=0.0125,
#                          validation_data=(X_test, Y_test),
#                          validation_sample_rate=5,
#                          lr_scale='linear', save_dir='weights/momentum/momentum-%s/' % str(momentum),
#                          verbose=True)
#
#     model = MiniVGG((img_rows, img_cols, img_channels),
#                     dropout=0, weights=None, classes=nb_classes)
#     model.summary()
#
#     # set the weight_decay here !
#     # lr doesnt matter as it will be over written by the callback
#     optimizer = SGD(lr=0.00125, momentum=momentum, nesterov=True)
#     model.compile(loss='categorical_crossentropy', optimizer=optimizer, metrics=['accuracy'])
#
#     # model.load_weights(weights_file)
#
#     if not data_augmentation:
#         print('Not using data augmentation.')
#         model.fit(X_train, Y_train,
#                   batch_size=batch_size,
#                   epochs=nb_epoch,
#                   validation_data=(X_test, Y_test),
#                   shuffle=True,
#                   verbose=1,
#                   callbacks=[lr_finder])
#     else:
#         print('Using real-time data augmentation.')
#         # This will do preprocessing and realtime data augmentation:
#         datagen = ImageDataGenerator(
#             featurewise_center=False,  # set input mean to 0 over the dataset
#             samplewise_center=False,  # set each sample mean to 0
#             featurewise_std_normalization=False,  # divide inputs by std of the dataset
#             samplewise_std_normalization=False,  # divide each input by its std
#             zca_whitening=False,  # apply ZCA whitening
#             rotation_range=0,  # randomly rotate images in the range (degrees, 0 to 180)
#             width_shift_range=0,  # randomly shift images horizontally (fraction of total width)
#             height_shift_range=0,  # randomly shift images vertically (fraction of total height)
#             horizontal_flip=True,  # randomly flip images
#             vertical_flip=False)  # randomly flip images
#
#         # Compute quantities required for featurewise normalization
#         # (std, mean, and principal components if ZCA whitening is applied).
#         datagen.fit(X_train)
#
#         # Fit the model on the batches generated by datagen.flow().
#         model.fit_generator(datagen.flow(X_train, Y_train, batch_size=batch_size, shuffle=True),
#                             steps_per_epoch=X_train.shape[0] // batch_size,
#                             validation_data=(X_test, Y_test),
#                             epochs=nb_epoch, verbose=1,
#                             callbacks=[lr_finder])

# from plot we see, the model isnt impacted by the weight_decay very much at all
# so we can use any of them.

for momentum in MOMENTUMS:
    directory = 'weights/momentum/momentum-%s/' % str(momentum)

    losses, lrs = LRFinder.restore_schedule_from_dir(directory, 10, 5)
    plt.plot(lrs, losses, label='momentum=%0.2f' % momentum)

plt.title("Momentum")
plt.xlabel("Learning rate")
plt.ylabel("Validation Loss")
plt.legend()
plt.show()
