import json
import textwrap


class Vulnerability:
    def __init__(self, kind=None, description=None, transactions=None):
        self.type = kind
        self.description = description
        self.transactions = transactions
        self.confirmed = False

    def __str__(self):
        return textwrap.dedent(
            """\
            Type = {type}
            Description = {description}
            Transactions = {transactions}
            """.format(
                type=self.type,
                description=self.description,
                transactions=self.transactions,
                sort_keys=True,
                indent=4,
            )
        )

    def json(self):
        return json.dumps(self)
