import osimport selectimport sysimport rclpyfrom geometry_msgs.msg import Twistfrom std_msgs.msg import Stringfrom rclpy.qos import QoSProfilefrom rcl_interfaces.msg import SetParametersResultif os.name == 'nt':    import msvcrtelse:    import termios    import ttyJETBOT_MAX_LIN_VEL = 0.2    # parameter /jetbot/teleop_keyboard/max_linear_vel   (.63172 for real JetBot)JETBOT_MAX_ANG_VEL = 2.0    # parameter /jetbot/teleop_keyboard/max_angular_vel  (12.5 for real JetBot)LIN_VEL_STEP_SIZE = 0.01ANG_VEL_STEP_SIZE = 0.1msg = """Control Your JetBot!---------------------------Moving around:        w   a    s    d        xw/x : increase/decrease linear velocitya/d : increase/decrease angular velocityspace key, s : force stopc : collect data (when in data collection mode)CTRL-C to quit"""e = """Communications Failed"""def get_key(settings):    if os.name == 'nt':        return msvcrt.getch().decode('utf-8')    tty.setraw(sys.stdin.fileno())    rlist, _, _ = select.select([sys.stdin], [], [], 0.1)    if rlist:        key = sys.stdin.read(1)    else:        key = ''    termios.tcsetattr(sys.stdin, termios.TCSADRAIN, settings)    return keydef print_vels(target_linear_velocity, target_angular_velocity):    print('currently:\tlinear velocity {0:.03f}\t angular velocity {1:.03f} '.format(        target_linear_velocity,        target_angular_velocity))def make_simple_profile(output, input, slop):    if input > output:        output = min(input, output + slop)    elif input < output:        output = max(input, output - slop)    else:        output = input    return outputdef constrain(input_vel, low_bound, high_bound):    if input_vel < low_bound:        input_vel = low_bound    elif input_vel > high_bound:        input_vel = high_bound    else:        input_vel = input_vel    return input_veldef check_linear_limit_velocity(velocity):    return constrain(velocity, -JETBOT_MAX_LIN_VEL, JETBOT_MAX_LIN_VEL)def check_angular_limit_velocity(velocity):    return constrain(velocity, -JETBOT_MAX_ANG_VEL, JETBOT_MAX_ANG_VEL)def parameters_callback(params):    global JETBOT_MAX_LIN_VEL    global JETBOT_MAX_ANG_VEL        for param in params:        if param.name == 'max_linear_vel':            self.max_linear_vel = param.value        elif param.name == 'max_angular_vel':            self.max_angular_vel = param.value        else:            raise ValueError(f'unknown parameter {param.name}')                return SetParametersResult(successful=True)def main():    global JETBOT_MAX_LIN_VEL    global JETBOT_MAX_ANG_VEL        settings = None    if os.name != 'nt':        settings = termios.tcgetattr(sys.stdin)    rclpy.init()    qos = QoSProfile(depth=10)    node = rclpy.create_node('teleop_keyboard', namespace='jetbot')    pub = node.create_publisher(Twist, 'cmd_vel', qos)    key_pub = node.create_publisher(String, 'keys', qos)        node.declare_parameter('max_linear_vel', JETBOT_MAX_LIN_VEL)    node.declare_parameter('max_angular_vel', JETBOT_MAX_ANG_VEL)        JETBOT_MAX_LIN_VEL = node.get_parameter('max_linear_vel').value    JETBOT_MAX_ANG_VEL = node.get_parameter('max_angular_vel').value        node.add_on_set_parameters_callback(parameters_callback)        print('JETBOT_MAX_LIN_VEL', JETBOT_MAX_LIN_VEL)        status = 0    target_linear_velocity = 0.0    target_angular_velocity = 0.0    control_linear_velocity = 0.0    control_angular_velocity = 0.0    try:        print(msg)        while(1):            key = get_key(settings)                        if len(key) > 0:                key_msg = String()                key_msg.data = key                key_pub.publish(key_msg)                        if key == 'w':                target_linear_velocity =\                    check_linear_limit_velocity(target_linear_velocity + LIN_VEL_STEP_SIZE)                #status = status + 1                print_vels(target_linear_velocity, target_angular_velocity)            elif key == 'x':                target_linear_velocity =\                    check_linear_limit_velocity(target_linear_velocity - LIN_VEL_STEP_SIZE)                #status = status + 1                print_vels(target_linear_velocity, target_angular_velocity)            elif key == 'a':                target_angular_velocity =\                    check_angular_limit_velocity(target_angular_velocity + ANG_VEL_STEP_SIZE)                #status = status + 1                print_vels(target_linear_velocity, target_angular_velocity)            elif key == 'd':                target_angular_velocity =\                    check_angular_limit_velocity(target_angular_velocity - ANG_VEL_STEP_SIZE)                #status = status + 1                print_vels(target_linear_velocity, target_angular_velocity)            elif key == ' ' or key == 's':                target_linear_velocity = 0.0                target_angular_velocity = 0.0                print_vels(target_linear_velocity, target_angular_velocity)            else:                if (key == '\x03'):                    break                        status += 1                        if status == 20:                print(msg)                status = 0            twist = Twist()            control_linear_velocity = make_simple_profile(                control_linear_velocity,                target_linear_velocity,                LIN_VEL_STEP_SIZE) #(LIN_VEL_STEP_SIZE / 2.0))            twist.linear.x = float(control_linear_velocity)            twist.linear.y = 0.0            twist.linear.z = 0.0            control_angular_velocity = make_simple_profile(                control_angular_velocity,                target_angular_velocity,                ANG_VEL_STEP_SIZE) #(ANG_VEL_STEP_SIZE / 2.0))            twist.angular.x = 0.0            twist.angular.y = 0.0            twist.angular.z = float(control_angular_velocity)            print_vels(control_linear_velocity, control_angular_velocity)            pub.publish(twist)    except Exception as e:        print(e)    finally:        twist = Twist()        twist.linear.x = 0.0        twist.linear.y = 0.0        twist.linear.z = 0.0        twist.angular.x = 0.0        twist.angular.y = 0.0        twist.angular.z = 0.0        pub.publish(twist)        if os.name != 'nt':            termios.tcsetattr(sys.stdin, termios.TCSADRAIN, settings)if __name__ == '__main__':    main()