# Generated by Django 3.1.2 on 2021-02-27 14:27

import json

import django_migration_linter
from django.db import migrations, models
from django.db import transaction


def migrate_outputascii_to_generatedascii(apps, schema_editor):
    generatedascii_model = apps.get_model('app', 'GeneratedASCII')
    outputascii_model = apps.get_model('app', 'OutputASCII')
    with transaction.atomic():
        for generatedascii_obj in generatedascii_model.objects.select_for_update('output_ascii'):
            json_list = []
            for outputascii_obj in outputascii_model.objects.filter(generated_ascii=generatedascii_obj).order_by('id'):
                json_list.append({
                    'method_name': outputascii_obj.method_name,
                    'ascii_txt': outputascii_obj.ascii_txt,
                })
            generatedascii_obj.output_ascii = json.dumps(json_list)
            generatedascii_obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('app', '0006_feedback_date'),
    ]

    operations = [
        django_migration_linter.IgnoreMigration(),
        migrations.AddField(
            model_name='generatedascii',
            name='output_ascii',
            field=models.JSONField(null=True),
        ),
        migrations.RunPython(migrate_outputascii_to_generatedascii),
        migrations.DeleteModel(
            name='OutputASCII',
        ),
    ]
