e = 2.718281828459045
"""
IEEE 754 floating-point representation of Euler's constant.

``e = 2.71828182845904523536028747135266249775724709369995...``
"""

inf = float("inf")
"""
IEEE 754 floating-point representation of (positive) infinity.
"""

nan = float("nan")
"""
IEEE 754 floating-point representation of Not a Number (``NaN``).
"""

newaxis = None
"""
An alias for ``None`` which is useful for indexing arrays.
"""

pi = 3.141592653589793
"""
IEEE 754 floating-point representation of the mathematical constant ``π``.

``pi = 3.1415926535897932384626433...``
"""

__all__ = ["e", "inf", "nan", "newaxis", "pi"]
