from scraper.common import ScrapeResult, Scraper, ScraperFactory


class MikesComputerShopScrapeResult(ScrapeResult):
    def parse(self):
        alert_subject = 'In Stock'
        alert_content = ''

        # get name of product
        tag = self.soup.body.select_one('.gd-1.Title')
        if tag:
            alert_content += tag.text.strip() + '\n'
        else:
            self.logger.warning(f'missing title: {self.url}')

        # get listed price
        tag = self.soup.body.select_one('.price')
        price_str = self.set_price(tag.getText())
        if price_str:
            alert_subject = f'In Stock for {price_str}'
        else:
            self.logger.warning(f'missing price: {self.url}')

        # check for state
        tag = self.soup.body.select_one('gd-1.State.Available')
        if tag:
            self.alert_subject = alert_subject
            self.alert_content = f'{alert_content.strip()}\n{self.url}'



@ScraperFactory.register
class MikesComputerShopScraper(Scraper):
    @staticmethod
    def get_domain():
        return 'mikescomputershop'

    @staticmethod
    def get_driver_type():
        return 'requests'

    @staticmethod
    def get_result_type():
        return MikesComputerShopScrapeResult
