"""Fine-tuning the library models for sequence to sequence."""# You can also adapt this script on your own sequence to sequence task. Pointers for this are left as comments.import loggingimport osimport sysimport jsonfrom dataclasses import dataclass, fieldfrom typing import Optionalimport datasetsimport nltk  # Here to have a nice missing dependency error message early onimport numpy as npfrom datasets import load_datasetimport transformersfrom filelock import FileLockfrom transformers import (    AutoConfig,    AutoModelForSeq2SeqLM,    AutoModelForCausalLM,  # add    AutoTokenizer,    HfArgumentParser,    Seq2SeqTrainingArguments,    set_seed, )from transformers.file_utils import is_offline_modefrom transformers.trainer_utils import get_last_checkpointfrom model.bloom import BloomForCausalLM_WithLossfrom model.codegen import CodeGenForCausalLM_WithLossfrom model.gpt_neox import GPTNeoXForCausalLM_WithLossfrom uie_collator import DataCollatorForUIEfrom uie_dataset import gen_cache_pathfrom uie_trainer import UIETrainer, DenserEvalCallback, skip_instructionsfrom compute_metrics import compute_metrics, compute_grouped_metrics# off wandbos.environ['WANDB_DISABLED'] = "True"# os.environ['CUDA_VISIBLE_DEVICES'] = '0'logger = logging.getLogger(__name__)CURRENT_DIR = os.path.dirname(__file__)try:    nltk.data.find("tokenizers/punkt")except (LookupError, OSError):    if is_offline_mode():        raise LookupError(            "Offline mode: run this script without TRANSFORMERS_OFFLINE first to download nltk data files"        )    with FileLock(".lock") as lock:        nltk.download("punkt", quiet=True)@dataclassclass ModelArguments:    """    Arguments pertaining to which model/config/tokenizer we are going to fine-tune from.    """    model_name_or_path: str = field(        metadata={"help": "Path to pretrained model or model identifier from huggingface.co/models"}    )    config_name: Optional[str] = field(        default=None, metadata={"help": "Pretrained config name or path if not the same as model_name"}    )    tokenizer_name: Optional[str] = field(        default=None, metadata={"help": "Pretrained tokenizer name or path if not the same as model_name"}    )    cache_dir: Optional[str] = field(        default=None,        metadata={"help": "Where to store the pretrained models downloaded from huggingface.co"},    )    use_fast_tokenizer: bool = field(        default=True,        metadata={"help": "Whether to use one of the fast tokenizer (backed by the tokenizers library) or not."},    )    model_revision: str = field(        default="main",        metadata={"help": "The specific model version to use (can be a branch name, tag name or commit id)."},    )    use_auth_token: bool = field(        default=False,        metadata={            "help": "Will use the token generated when running `transformers-cli login` (necessary to use this script "                    "with private models)."        },    )    resize_position_embeddings: Optional[bool] = field(        default=None,        metadata={            "help": "Whether to automatically resize the position embeddings if `max_source_length` exceeds "                    "the model's position embeddings."        },    )@dataclassclass DataTrainingArguments:    """    Arguments pertaining to what data we are going to input our model for training and eval.    """    lang: str = field(default=None, metadata={"help": "Language id for multilingual model."})    data_dir: str = field(        default=None, metadata={"help": "The directory for saving the UIE train/dev/test splits."}    )    task_config_dir: str = field(        default=None, metadata={"help": "The json file for config training and testing tasks"}    )    instruction_file: str = field(        default=None, metadata={"help": "The instruction file for different tasks."}    )    instruction_strategy: Optional[str] = field(        default='single', metadata={            "help": "How many different instructions to use? Support 'single' and 'multiple' mode."        }    )    overwrite_cache: bool = field(        default=False, metadata={"help": "Overwrite the cached training and evaluation sets"}    )    input_record_file: str = field(        default=None, metadata={"help": "file to record model input"}    )    preprocessing_num_workers: Optional[int] = field(        default=None,        metadata={"help": "The number of processes to use for the preprocessing."},    )    max_source_length: Optional[int] = field(        default=512,        metadata={            "help": "The maximum total input sequence length after tokenization. Sequences longer "                    "than this will be truncated, sequences shorter will be padded."        },    )    # for decoder model, it means max_new_tokens    max_target_length: Optional[int] = field(        default=50,        metadata={            "help": "The maximum total sequence length for target text after tokenization. Sequences longer "                    "than this will be truncated, sequences shorter will be padded."        },    )    repetition_penalty: Optional[float] = field(        default=1.0,        metadata={            "help": "Penalty for repeat tokens in decode stage."        },    )    num_beams: Optional[int] = field(        default=1,        metadata={            "help": "Number of beams to use for evaluation. This argument will be passed to ``model.generate``, "                    "which is used during ``evaluate`` and ``predict``."        },    )    max_num_instances_per_task: int = field(        default=10000, metadata={"help": "The maximum number of instances we will consider for each training task."}    )    max_num_instances_per_eval_task: int = field(        default=200,        metadata={"help": "The maximum number of instances we will consider for each validation/test task."}    )    max_train_samples: Optional[int] = field(        default=None,        metadata={            "help": "For debugging purposes or quicker training, truncate the number of training examples to this "                    "value if set."        },    )    max_eval_samples: Optional[int] = field(        default=None,        metadata={            "help": "For debugging purposes or quicker training, truncate the number of evaluation examples to this "                    "value if set."        },    )    max_predict_samples: Optional[int] = field(        default=None,        metadata={            "help": "For debugging purposes or quicker training, truncate the number of prediction examples to this "                    "value if set."        },    )    num_examples: Optional[int] = field(        default=0,        metadata={"help": "number of in-context positive examples."}    )    ignore_pad_token_for_loss: bool = field(        default=True,        metadata={            "help": "Whether to ignore the tokens corresponding to padded labels in the loss computation or not."        },    )    add_task_name: Optional[bool] = field(        default=False,        metadata={"help": "whether to preappend task name before the task input."}    )    add_dataset_name: Optional[bool] = field(        default=False,        metadata={"help": "whether to preappend dataset name before the task input."}    )    common_dataset_name: Optional[str] = field(        default=None,        metadata={"help": "common dataset name for zero shot."}    )    over_sampling: Optional[str] = field(        default=False,        metadata={"help": "Whether to over sampling the dataset to max_num_instances_per_task"}    )@dataclassclass UIETrainingArguments(Seq2SeqTrainingArguments):    gradient_checkpointing: Optional[bool] = field(        default=False,        metadata={"help": "Whether to use computing time to gain more memory"}    )    denser_evaluation: Optional[bool] = field(        default=False,        metadata={"help": "If specifid, the model will do more evaluation at the beginning of training."}    )    do_demo: bool = field(default=False, metadata={"help": "Whether to run the model as a demo in the terminal."})def main():    # See all possible arguments in src/transformers/training_args.py    # or by passing the --help flag to this script.    # We now keep distinct sets of args, for a cleaner separation of concerns.    parser = HfArgumentParser((ModelArguments, DataTrainingArguments, UIETrainingArguments))    if len(sys.argv) == 2 and sys.argv[1].endswith(".json"):        # If we pass only one argument to the script and it's the path to a json file,        # let's parse it to get our arguments.        model_args, data_args, training_args = parser.parse_json_file(json_file=os.path.abspath(sys.argv[1]))    else:        model_args, data_args, training_args = parser.parse_args_into_dataclasses()    # Setup logging    logging.basicConfig(        format="%(asctime)s - %(levelname)s - %(name)s - %(message)s",        datefmt="%m/%d/%Y %H:%M:%S",        handlers=[logging.StreamHandler(sys.stdout)],    )    log_level = training_args.get_process_log_level()    logger.setLevel(log_level)    datasets.utils.logging.set_verbosity(log_level)    transformers.utils.logging.set_verbosity(log_level)    transformers.utils.logging.enable_default_handler()    transformers.utils.logging.enable_explicit_format()    # Log on each process the small summary:    logger.warning(        f"Process rank: {training_args.local_rank}, device: {training_args.device}, n_gpu: {training_args.n_gpu}"        + f"distributed training: {bool(training_args.local_rank != -1)}, 16-bits training: {training_args.fp16}"    )    logger.info(f"Training/evaluation parameters {training_args}")    # Detecting last checkpoint.    last_checkpoint = None    if os.path.isdir(training_args.output_dir) and training_args.do_train and not training_args.overwrite_output_dir:        last_checkpoint = get_last_checkpoint(training_args.output_dir)        if last_checkpoint is None and len(os.listdir(training_args.output_dir)) > 0:            raise ValueError(                f"Output directory ({training_args.output_dir}) already exists and is not empty. "                "Use --overwrite_output_dir to overcome."            )        elif last_checkpoint is not None and training_args.resume_from_checkpoint is None:            logger.info(                f"Checkpoint detected, resuming training at {last_checkpoint}. To avoid this behavior, change "                "the `--output_dir` or add `--overwrite_output_dir` to train from scratch."            )    # Set seed before initializing model.    set_seed(training_args.seed)    data_cache_dir = gen_cache_path(training_args.output_dir, data_args)    # Get the UIE dataset    raw_datasets = load_dataset(        os.path.join(CURRENT_DIR, "uie_dataset.py"),        data_dir=data_args.data_dir,        task_config_dir=data_args.task_config_dir,        instruction_file=data_args.instruction_file,        instruction_strategy=data_args.instruction_strategy,        cache_dir=data_cache_dir,  # for debug, change dataset size, otherwise open it        max_num_instances_per_task=data_args.max_num_instances_per_task,        max_num_instances_per_eval_task=data_args.max_num_instances_per_eval_task,        num_examples=data_args.num_examples,        over_sampling=data_args.over_sampling    )    raw_datasets.cleanup_cache_files()    # Load pretrained model and tokenizer    #    # Distributed training:    # The .from_pretrained methods guarantee that only one local process can concurrently    # download model & vocab.    config = AutoConfig.from_pretrained(        model_args.config_name if model_args.config_name else model_args.model_name_or_path,        cache_dir=model_args.cache_dir,        revision=model_args.model_revision,        use_auth_token=True if model_args.use_auth_token else None,    )    tokenizer = AutoTokenizer.from_pretrained(        model_args.tokenizer_name if model_args.tokenizer_name else model_args.model_name_or_path,        cache_dir=model_args.cache_dir,        use_fast=model_args.use_fast_tokenizer,        revision=model_args.model_revision,        use_auth_token=True if model_args.use_auth_token else None,    )    if 'bloom' in model_args.model_name_or_path.lower():        model_class = BloomForCausalLM_WithLoss        if tokenizer.pad_token is None:            tokenizer.pad_token = tokenizer.eos_token        tokenizer.padding_side = 'left'    elif 'codegen' in model_args.model_name_or_path.lower():        model_class = CodeGenForCausalLM_WithLoss        tokenizer.pad_token = tokenizer.eos_token        tokenizer.padding_side = 'left'    elif 'neox' in model_args.model_name_or_path.lower():  # add neox        model_class = GPTNeoXForCausalLM_WithLoss        if tokenizer.pad_token is None:            tokenizer.pad_token = tokenizer.eos_token        tokenizer.padding_side = 'left'    else:        model_class = AutoModelForSeq2SeqLM    model = model_class.from_pretrained(        model_args.model_name_or_path,        from_tf=bool(".ckpt" in model_args.model_name_or_path),        config=config,        cache_dir=model_args.cache_dir,        revision=model_args.model_revision,        use_auth_token=True if model_args.use_auth_token else None,    )    model.resize_token_embeddings(len(tokenizer))    if (            hasattr(model.config, "max_position_embeddings")            and model.config.max_position_embeddings < data_args.max_source_length    ):        if model_args.resize_position_embeddings is None:            logger.warning(                f"Increasing the model's number of position embedding vectors from {model.config.max_position_embeddings} "                f"to {data_args.max_source_length}."            )            model.resize_position_embeddings(data_args.max_source_length)        elif model_args.resize_position_embeddings:            model.resize_position_embeddings(data_args.max_source_length)        else:            raise ValueError(                f"`--max_source_length` is set to {data_args.max_source_length}, but the model only has {model.config.max_position_embeddings}"                f" position encodings. Consider either reducing `--max_source_length` to {model.config.max_position_embeddings} or to automatically "                "resize the model's position encodings by passing `--resize_position_embeddings`."            )    if training_args.label_smoothing_factor > 0 and not hasattr(model, "prepare_decoder_input_ids_from_labels"):        logger.warning(            "label_smoothing is enabled but the `prepare_decoder_input_ids_from_labels` method is not defined for"            f"`{model.__class__.__name__}`. This will lead to loss being calculated twice and will take up more memory"        )    if training_args.do_train:        if "train" not in raw_datasets:            raise ValueError("--do_train requires a train dataset")        train_dataset = raw_datasets["train"]        if data_args.max_train_samples is not None:            train_dataset = train_dataset.select(range(data_args.max_train_samples))    if training_args.do_eval:        if "validation" not in raw_datasets:            raise ValueError("--do_eval requires a validation dataset")        eval_dataset = raw_datasets["validation"]        if data_args.max_eval_samples is not None:            eval_dataset = eval_dataset.select(range(data_args.max_eval_samples))    if training_args.do_predict:        if "test" not in raw_datasets:            raise ValueError("--do_predict requires a test dataset")        predict_dataset = raw_datasets["test"]        if data_args.max_predict_samples is not None:            predict_dataset = predict_dataset.select(range(data_args.max_predict_samples))    # Data collator    label_pad_token_id = -100 if data_args.ignore_pad_token_for_loss else tokenizer.pad_token_id    data_collator = DataCollatorForUIE(        tokenizer,        model=model,        padding="longest",        max_source_length=data_args.max_source_length,        max_target_length=data_args.max_target_length,        label_pad_token_id=label_pad_token_id,        pad_to_multiple_of=8 if training_args.fp16 else None,        add_task_name=data_args.add_task_name,        add_dataset_name=data_args.add_dataset_name,        common_dataset_name=data_args.common_dataset_name,        num_examples=data_args.num_examples,        input_record_file=data_args.input_record_file    )    # we don't want to remove unused columns because we will prepare each batch during training,    # and some of the information will also be used in evaluation.    training_args.remove_unused_columns = False    # Metric    def compute_rouge_metrics(dataset, preds, save_prefix=None):        decoded_preds = skip_instructions(model, preds, tokenizer)        references = [e["Instance"]["label"] for e in dataset]        result = compute_metrics(predictions=decoded_preds, references=references)        result_per_task = compute_grouped_metrics(predictions=decoded_preds, references=references,                                                  groups=dataset["Task"])        result.update(result_per_task)        categories = dataset["Dataset"]        result_per_category = compute_grouped_metrics(predictions=decoded_preds, references=references,                                                      groups=categories)        result.update(result_per_category)        prediction_lens = [np.count_nonzero(pred != tokenizer.pad_token_id) for pred in preds]        result["gen_len"] = np.mean(prediction_lens)        result = {k: round(v, 4) for k, v in result.items()}        if save_prefix is not None:            with open(os.path.join(training_args.output_dir, f"{save_prefix}_eval_predictions.jsonl"), "w") as fout:                for example, pred in zip(dataset, decoded_preds):                    fout.write(json.dumps({                        "Task": example["Task"],                        "Dataset": example["Dataset"],                        "Instance": example["Instance"],                        "Prediction": pred                    }) + "\n")        return result    print(f"-----Gradient checkpointing: {training_args.gradient_checkpointing} -----")    if training_args.gradient_checkpointing:        model.gradient_checkpointing_enable()    trainer = UIETrainer(        model=model,        args=training_args,        train_dataset=train_dataset if training_args.do_train else None,        eval_dataset=eval_dataset if training_args.do_eval else None,        tokenizer=tokenizer,        data_collator=data_collator,        compute_metrics=compute_rouge_metrics,        callbacks=[DenserEvalCallback] if training_args.denser_evaluation else None    )    all_metrics = {"run_name": training_args.run_name}    # Training    # 训练epoch数，按照 num_train_epochs 传入，在trainer中解析    # TODO, train debug, bloomz, flan-t5    if training_args.do_train:        checkpoint = None        if training_args.resume_from_checkpoint is not None:            checkpoint = training_args.resume_from_checkpoint        elif last_checkpoint is not None:            checkpoint = last_checkpoint        train_result = trainer.train(resume_from_checkpoint=checkpoint)        trainer.save_model()  # Saves the tokenizer too for easy upload        metrics = train_result.metrics        max_train_samples = (            data_args.max_train_samples if data_args.max_train_samples is not None else len(train_dataset)        )        metrics["train_samples"] = min(max_train_samples, len(train_dataset))        trainer.log_metrics("train", metrics)        trainer.save_metrics("train", metrics)        trainer.save_state()        logger.info(f"Metrics {metrics}")        all_metrics.update(metrics)    # Evaluation    results = {}    # in case the batch is shorter than max length, the output should be padded    max_new_tokens = (        training_args.generation_max_length        if training_args.generation_max_length is not None        else data_args.max_target_length    )    num_beams = data_args.num_beams if data_args.num_beams is not None else training_args.generation_num_beams    repetition_penalty = data_args.repetition_penalty    if training_args.do_predict:        logger.info("*** Prediction ***")        logger.info("*** Loading CheckPoint ***")        checkpoint = None        if os.path.isdir(training_args.output_dir):            checkpoint = get_last_checkpoint(training_args.output_dir)        if training_args.resume_from_checkpoint is not None:            checkpoint = training_args.resume_from_checkpoint        # without last ckpt and resume ckpt, would predict with current model        if checkpoint:            model = model_class.from_pretrained(checkpoint)            trainer = UIETrainer(                model=model,                args=training_args,                train_dataset=train_dataset if training_args.do_train else None,                eval_dataset=eval_dataset if training_args.do_eval else None,                tokenizer=tokenizer,                data_collator=data_collator,                compute_metrics=compute_rouge_metrics,                callbacks=[DenserEvalCallback] if training_args.denser_evaluation else None            )        if data_args.max_predict_samples is not None:            predict_dataset = predict_dataset.select(range(data_args.max_predict_samples))        predict_results = trainer.predict(            predict_dataset,            metric_key_prefix="predict",            max_new_tokens=max_new_tokens,            num_beams=num_beams,            repetition_penalty=repetition_penalty,            pad_token_id=tokenizer.pad_token_id        )        metrics = predict_results.metrics        max_predict_samples = (            data_args.max_predict_samples if data_args.max_predict_samples is not None else len(predict_dataset)        )        metrics["predict_samples"] = min(max_predict_samples, len(predict_dataset))        trainer.log(metrics)        trainer.log_metrics("predict", metrics)        trainer.save_metrics("predict", metrics)        all_metrics.update(metrics)    if training_args.do_demo:        logger.info("Serving the model as a demo...")        user_input = ''        while True:            user_input = input("Please enter your input to the model, or enter 'quit' to exit: ")            if user_input.lower() == "quit":                break            inputs = tokenizer([user_input], return_tensors="pt")            _, preds, _ = trainer.prediction_step(model, inputs=inputs, prediction_loss_only=False)            print(f"Model generates: {tokenizer.decode(preds[0], skip_special_tokens=True)}\n\n")    return resultsif __name__ == "__main__":    main()