"""
A dictionary mapping intended to normalize the numerals in Indic languages from 
native script to Roman script. This is done to ensure that the figures / numbers 
mentioned in native script are perfectly preserved during translation.
"""
INDIC_NUM_MAP = {
    "\u09e6": "0",
    "0": "0",
    "\u0ae6": "0",
    "\u0ce6": "0",
    "\u0966": "0",
    "\u0660": "0",
    "\uabf0": "0",
    "\u0b66": "0",
    "\u0a66": "0",
    "\u1c50": "0",
    "\u06f0": "0",
    "\u09e7": "1",
    "1": "1",
    "\u0ae7": "1",
    "\u0967": "1",
    "\u0ce7": "1",
    "\u06f1": "1",
    "\uabf1": "1",
    "\u0b67": "1",
    "\u0a67": "1",
    "\u1c51": "1",
    "\u0c67": "1",
    "\u09e8": "2",
    "2": "2",
    "\u0ae8": "2",
    "\u0968": "2",
    "\u0ce8": "2",
    "\u06f2": "2",
    "\uabf2": "2",
    "\u0b68": "2",
    "\u0a68": "2",
    "\u1c52": "2",
    "\u0c68": "2",
    "\u09e9": "3",
    "3": "3",
    "\u0ae9": "3",
    "\u0969": "3",
    "\u0ce9": "3",
    "\u06f3": "3",
    "\uabf3": "3",
    "\u0b69": "3",
    "\u0a69": "3",
    "\u1c53": "3",
    "\u0c69": "3",
    "\u09ea": "4",
    "4": "4",
    "\u0aea": "4",
    "\u096a": "4",
    "\u0cea": "4",
    "\u06f4": "4",
    "\uabf4": "4",
    "\u0b6a": "4",
    "\u0a6a": "4",
    "\u1c54": "4",
    "\u0c6a": "4",
    "\u09eb": "5",
    "5": "5",
    "\u0aeb": "5",
    "\u096b": "5",
    "\u0ceb": "5",
    "\u06f5": "5",
    "\uabf5": "5",
    "\u0b6b": "5",
    "\u0a6b": "5",
    "\u1c55": "5",
    "\u0c6b": "5",
    "\u09ec": "6",
    "6": "6",
    "\u0aec": "6",
    "\u096c": "6",
    "\u0cec": "6",
    "\u06f6": "6",
    "\uabf6": "6",
    "\u0b6c": "6",
    "\u0a6c": "6",
    "\u1c56": "6",
    "\u0c6c": "6",
    "\u09ed": "7",
    "7": "7",
    "\u0aed": "7",
    "\u096d": "7",
    "\u0ced": "7",
    "\u06f7": "7",
    "\uabf7": "7",
    "\u0b6d": "7",
    "\u0a6d": "7",
    "\u1c57": "7",
    "\u0c6d": "7",
    "\u09ee": "8",
    "8": "8",
    "\u0aee": "8",
    "\u096e": "8",
    "\u0cee": "8",
    "\u06f8": "8",
    "\uabf8": "8",
    "\u0b6e": "8",
    "\u0a6e": "8",
    "\u1c58": "8",
    "\u0c6e": "8",
    "\u09ef": "9",
    "9": "9",
    "\u0aef": "9",
    "\u096f": "9",
    "\u0cef": "9",
    "\u06f9": "9",
    "\uabf9": "9",
    "\u0b6f": "9",
    "\u0a6f": "9",
    "\u1c59": "9",
    "\u0c6f": "9",
}
