import os, sysimport cv2import numpy as npfrom time import timefrom scipy.io import savematimport argparsefrom tqdm import tqdmimport torchsys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))from decalib.deca import DECAfrom decalib.datasets import datasetsfrom decalib.utils import utilfrom decalib.utils.config import cfg as deca_cfgfrom decalib.utils.tensor_cropper import transform_pointsdef main(args):    # if args.rasterizer_type != 'standard':    #     args.render_orig = False    savefolder = args.savefolder    device = args.device    os.makedirs(savefolder, exist_ok=True)    # load test images    testdata = datasets.TestData(args.inputpath, iscrop=args.iscrop, face_detector=args.detector, sample_step=args.sample_step)    # run DECA    deca_cfg.model.use_tex = args.useTex    deca_cfg.rasterizer_type = args.rasterizer_type    deca = DECA(config = deca_cfg, device=device)    # for i in range(len(testdata)):    code = {}    for i in tqdm(range(len(testdata))):        name = testdata[i]['imagename']        images = testdata[i]['image'].to(device)[None,...]        with torch.no_grad():            codedict = deca.encode(images)            # opdict, visdict = deca.decode(codedict) #tensor            if args.render_orig:                tform = testdata[i]['tform'][None, ...]                tform = torch.inverse(tform).transpose(1,2).to(device)                original_image = testdata[i]['original_image'][None, ...].to(device)                _, orig_visdict = deca.decode(codedict, render_orig=True, original_image=original_image, tform=tform)                orig_visdict['inputs'] = original_image        if args.saveDepth or args.saveKpt or args.saveObj or args.saveMat or args.saveImages:            os.makedirs(os.path.join(savefolder, name), exist_ok=True)        # -- save results        if args.saveDepth:            depth_image = deca.render.render_depth(opdict['trans_verts']).repeat(1,3,1,1)            visdict['depth_images'] = depth_image            cv2.imwrite(os.path.join(savefolder, name, name + '_depth.jpg'), util.tensor2image(depth_image[0]))        if args.saveKpt:            np.savetxt(os.path.join(savefolder, name, name + '_kpt2d.txt'), opdict['landmarks2d'][0].cpu().numpy())            np.savetxt(os.path.join(savefolder, name, name + '_kpt3d.txt'), opdict['landmarks3d'][0].cpu().numpy())        if args.saveObj:            deca.save_obj(os.path.join(savefolder, name, name + '.obj'), opdict)        if args.saveCode:            dict = {}            for k, v in codedict.items():                if k in ['pose', 'cam', 'exp', 'shape']:                    dict[k] = v.detach().cpu().numpy().tolist()            code[name] = dict        if args.saveMat:            opdict = util.dict_tensor2npy(opdict)            savemat(os.path.join(savefolder, name, name + '.mat'), opdict)        if args.saveVis:            cv2.imwrite(os.path.join(savefolder, name + '_vis.jpg'), deca.visualize(visdict))            if args.render_orig:                cv2.imwrite(os.path.join(savefolder, name + '_vis_original_size.jpg'), deca.visualize(orig_visdict))        if args.saveImages:            for vis_name in ['inputs', 'rendered_images', 'albedo_images', 'shape_images', 'shape_detail_images', 'landmarks2d']:                if vis_name not in visdict.keys():                    continue                image = util.tensor2image(visdict[vis_name][0])                cv2.imwrite(os.path.join(savefolder, name, name + '_' + vis_name +'.jpg'), util.tensor2image(visdict[vis_name][0]))                if args.render_orig:                    image = util.tensor2image(orig_visdict[vis_name][0])                    cv2.imwrite(os.path.join(savefolder, name, 'orig_' + name + '_' + vis_name +'.jpg'), util.tensor2image(orig_visdict[vis_name][0]))    if args.saveCode:        import json        json_folder = savefolder.replace('deca', '')        json.dump(code, open(os.path.join(json_folder, 'code.json'), 'w'))    print(f'-- please check the results in {savefolder}')if __name__ == '__main__':    parser = argparse.ArgumentParser(description='DECA: Detailed Expression Capture and Animation')    parser.add_argument('-i', '--inputpath', default='TestSamples/examples', type=str,                        help='path to the test data, can be image folder, image path, image list, video')    parser.add_argument('-s', '--savefolder', default='TestSamples/examples/results', type=str,                        help='path to the output directory, where results(obj, txt files) will be stored.')    parser.add_argument('--device', default='cuda', type=str,                        help='set device, cpu for using cpu' )    # process test images    parser.add_argument('--iscrop', default=True, type=lambda x: x.lower() in ['true', '1'],                        help='whether to crop input image, set false only when the test image are well cropped' )    parser.add_argument('--sample_step', default=10, type=int,                        help='sample images from video data for every step' )    parser.add_argument('--detector', default='fan', type=str,                        help='detector for cropping face, check decalib/detectors.py for details' )    # rendering option    parser.add_argument('--rasterizer_type', default='standard', type=str,                        help='rasterizer type: pytorch3d or standard' )    parser.add_argument('--render_orig', default=True, type=lambda x: x.lower() in ['true', '1'],                        help='whether to render results in original image size, currently only works when rasterizer_type=standard')    # save    parser.add_argument('--useTex', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to use FLAME texture model to generate uv texture map, \                            set it to True only if you downloaded texture model' )    parser.add_argument('--saveVis', default=True, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save visualization of output' )    parser.add_argument('--saveKpt', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save 2D and 3D keypoints' )    parser.add_argument('--saveDepth', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save depth image' )    parser.add_argument('--saveObj', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save outputs as .obj, detail mesh will end with _detail.obj. \                            Note that saving objs could be slow' )    parser.add_argument('--saveMat', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save outputs as .mat' )    parser.add_argument('--saveCode', default=True, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save FLAME parameters')    parser.add_argument('--saveImages', default=False, type=lambda x: x.lower() in ['true', '1'],                        help='whether to save visualization output as seperate images' )    main(parser.parse_args())