
# test_semantic_softmax_loss.py
# tests auto-generated by https://www.codium.ai/
# testing https://github.com/Alibaba-MIIL/ImageNet21K/blob/2715baf0e38673809812409678f7d12e592cbaba/tests/test_semantic_softmax_loss.py#L5 class


import unittest
from src_files.semantic.semantic_loss import SemanticSoftmaxLoss
from src_files.semantic.semantics import ImageNet21kSemanticSoftmax

"""
Code Analysis for SemanticSoftmaxLoss() class:
- The class SemanticSoftmaxLoss is a subclass of torch.nn.Module, which is a base class for all neural network modules in PyTorch. 
- The __init__() method initializes the class with a semantic_softmax_processor object and its arguments.
- The forward() method calculates the semantic cross-entropy loss distance between logits and targets.
- The method splits the logits into semantic logits and converts the targets into semantic targets.
- It then calculates the cross-entropy loss for each semantic logit and target and adds them together to get the total loss.
- Finally, it multiplies the total loss by the normalization factor list to get the final loss.
"""


"""
Test strategies:
- test_init(): tests that the class is initialized correctly with the semantic_softmax_processor object and its arguments.
- test_forward_happy_path(): tests that the forward() method calculates the correct semantic cross-entropy loss distance between logits and targets when given valid inputs.
- test_forward_invalid_logits(): tests that the forward() method raises an error when given invalid logits.
- test_forward_invalid_targets(): tests that the forward() method raises an error when given invalid targets.
- test_split_logits_to_semantic_logits(): tests that the split_logits_to_semantic_logits() method correctly splits the logits into semantic logits.
- test_convert_targets_to_semantic_targets(): tests that the convert_targets_to_semantic_targets() method correctly converts the targets into semantic targets.
- test_calculate_cross_entropy_loss(): tests that the calculate_cross_entropy_loss() method correctly calculates the cross-entropy loss for each semantic logit and target.
- test_calculate_total_loss(): tests that the calculate_total_loss() method correctly adds the cross-entropy losses together to get the total loss.
"""


class TestSemanticSoftmaxLoss(unittest.TestCase):
    def setUp(self):
        self.semantic_softmax_processor = SemanticSoftmaxProcessorMock()
        self.semantic_softmax_loss = SemanticSoftmaxLoss(self.semantic_softmax_processor)

    def test_init(self):
        self.assertEqual(self.semantic_softmax_loss.semantic_softmax_processor, self.semantic_softmax_processor)
        self.assertEqual(self.semantic_softmax_loss.args, self.semantic_softmax_processor.args)

    def test_forward_happy_path(self):
        logits = torch.randn(3, 5)
        targets = torch.tensor([1, 2, 3])
        loss = self.semantic_softmax_loss(logits, targets)
        self.assertIsNotNone(loss)

    def test_forward_invalid_logits(self):
        logits = None
        targets = torch.tensor([1, 2, 3])
        with self.assertRaises(ValueError):
            self.semantic_softmax_loss(logits, targets)

    def test_forward_invalid_targets(self):
        logits = torch.randn(3, 5)
        targets = None
        with self.assertRaises(ValueError):
            self.semantic_softmax_loss(logits, targets)

    def test_split_logits_to_semantic_logits(self):
        logits = torch.randn(3, 5)
        semantic_logit_list = self.semantic_softmax_processor.split_logits_to_semantic_logits(logits)
        self.assertEqual(len(semantic_logit_list), 3)

    def test_convert_targets_to_semantic_targets(self):
        targets = torch.tensor([1, 2, 3])
        semantic_targets = self.semantic_softmax_processor.convert_targets_to_semantic_targets(targets)
        self.assertEqual(semantic_targets.shape, (3, 3))

    def test_calculate_cross_entropy_loss(self):
        logits = torch.randn(3, 5)
        targets = torch.tensor([1, 2, 3])
        semantic_logit_list = self.semantic_softmax_processor.split_logits_to_semantic_logits(logits)
        semantic_targets = self.semantic_softmax_processor.convert_targets_to_semantic_targets(targets)
        losses = []
        for i in range(len(semantic_logit_list)):
            logits = semantic_logit_list[i]
            targets = semantic_targets[:, i]
            log_preds = F.log_softmax(logits, dim=1)
            targets = targets.clone()
            targets[targets < 0] = 0
            num_classes = logits.size()[-1]
            targets = torch.zeros_like(logits).scatter_(1, targets.unsqueeze(1), 1)
            targets.mul_(1 - self.args.label_smooth).add_(self.args.label_smooth / num_classes)
            cross_entropy = -targets * log_preds
            cross_entropy *= (targets >= 0).unsqueeze(1)
            cross_entropy = cross_
