# ==========================================================================================# Adobe’s modifications are Copyright 2019 Adobe. All rights reserved.# Adobe’s modifications are licensed under the Creative Commons Attribution-NonCommercial-ShareAlike# 4.0 International Public License (CC-NC-SA-4.0). To view a copy of the license, visit# https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode.# ==========================================================================================# BSD-3 License# Redistribution and use in source and binary forms, with or without# modification, are permitted provided that the following conditions are met:# * Redistributions of source code must retain the above copyright notice, this#   list of conditions and the following disclaimer.# * Redistributions in binary form must reproduce the above copyright notice,#   this list of conditions and the following disclaimer in the documentation#   and/or other materials provided with the distribution.# * Neither the name of the copyright holder nor the names of its#   contributors may be used to endorse or promote products derived from#   this software without specific prior written permission.# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USEfrom torch import nnfrom .utils import *__all__ = ['MobileNetV2', 'mobilenet_v2']model_urls = {    'mobilenet_v2': 'https://download.pytorch.org/models/mobilenet_v2-b0353104.pth',}class ConvBNReLU(nn.Sequential):    def __init__(self, in_planes, out_planes, kernel_size=3, stride=1, groups=1):        padding = (kernel_size - 1) // 2        super(ConvBNReLU, self).__init__(            nn.Conv2d(in_planes, out_planes, kernel_size, stride, padding, groups=groups, bias=False),            nn.BatchNorm2d(out_planes),            nn.ReLU6(inplace=True)        )class InvertedResidual(nn.Module):    def __init__(self, inp, oup, stride, expand_ratio, filter_size=1):        super(InvertedResidual, self).__init__()        self.stride = stride        assert stride in [1, 2]        hidden_dim = int(round(inp * expand_ratio))        self.use_res_connect = self.stride == 1 and inp == oup        layers = []        if expand_ratio != 1:            # pw            layers.append(ConvBNReLU(inp, hidden_dim, kernel_size=1))        if(stride==1):            layers.extend([                # dw                ConvBNReLU(hidden_dim, hidden_dim, stride=stride, groups=hidden_dim),                # pw-linear                nn.Conv2d(hidden_dim, oup, 1, 1, 0, bias=False),                nn.BatchNorm2d(oup),            ])        else:            layers.extend([                # dw                ConvBNReLU(hidden_dim, hidden_dim, stride=1, groups=hidden_dim),                Downsample(filt_size=filter_size, stride=stride, channels=hidden_dim),                 # pw-linear                nn.Conv2d(hidden_dim, oup, 1, 1, 0, bias=False),                nn.BatchNorm2d(oup),            ])        self.conv = nn.Sequential(*layers)    def forward(self, x):        if self.use_res_connect:            return x + self.conv(x)        else:            return self.conv(x)class MobileNetV2(nn.Module):    def __init__(self, num_classes=1000, width_mult=1.0, filter_size=1):        super(MobileNetV2, self).__init__()        block = InvertedResidual        input_channel = 32        last_channel = 1280        inverted_residual_setting = [            # t, c, n, s            [1, 16, 1, 1],            [6, 24, 2, 2],            [6, 32, 3, 2],            [6, 64, 4, 2],            [6, 96, 3, 1],            [6, 160, 3, 2],            [6, 320, 1, 1],        ]        # building first layer        input_channel = int(input_channel * width_mult)        self.last_channel = int(last_channel * max(1.0, width_mult))        features = [ConvBNReLU(3, input_channel, stride=2)]        # building inverted residual blocks        for t, c, n, s in inverted_residual_setting:            output_channel = int(c * width_mult)            for i in range(n):                stride = s if i == 0 else 1                features.append(block(input_channel, output_channel, stride, expand_ratio=t, filter_size=filter_size))                input_channel = output_channel        # building last several layers        features.append(ConvBNReLU(input_channel, self.last_channel, kernel_size=1))        # make it nn.Sequential        self.features = nn.Sequential(*features)        # building classifier        self.classifier = nn.Sequential(            # nn.Dropout(0.2),            nn.Linear(self.last_channel, num_classes),        )        # weight initialization        for m in self.modules():            if isinstance(m, nn.Conv2d):                nn.init.kaiming_normal_(m.weight, mode='fan_out')                if m.bias is not None:                    nn.init.zeros_(m.bias)            elif isinstance(m, nn.BatchNorm2d):                nn.init.ones_(m.weight)                nn.init.zeros_(m.bias)            elif isinstance(m, nn.Linear):                nn.init.normal_(m.weight, 0, 0.01)                nn.init.zeros_(m.bias)    def forward(self, x):        x = self.features(x)        x = x.mean([2, 3])        x = self.classifier(x)        return xdef mobilenet_v2(pretrained=False, progress=True, filter_size=1, **kwargs):    """    Constructs a MobileNetV2 architecture from    `"MobileNetV2: Inverted Residuals and Linear Bottlenecks" <https://arxiv.org/abs/1801.04381>`_.    Args:        pretrained (bool): If True, returns a model pre-trained on ImageNet        progress (bool): If True, displays a progress bar of the download to stderr    """    model = MobileNetV2(filter_size=filter_size, **kwargs)    # if pretrained:        # state_dict = load_state_dict_from_url(model_urls['mobilenet_v2'],                                              # progress=progress)        # model.load_state_dict(state_dict)    return model    