import pathlib
import math
import numpy as np
import torch
import torch.nn as nn
import torch.nn.functional as F

from registry import registry
from models.model_base import Model, StandardTransform, StandardNormalization
from mldb.utils import load_model_checkpoint_bytes


__weights_dict = dict()

def load_weights(weight_file):
    if weight_file == None:
        return
    try:
        weights_dict = np.load(weight_file, allow_pickle=True).item()
    except:
        weights_dict = np.load(weight_file, encoding='bytes').item()

    return weights_dict

class KitModel(nn.Module):
    def __init__(self, weight_file):
        super(KitModel, self).__init__()
        global __weights_dict
        __weights_dict = load_weights(weight_file)

        self.bn_data = self.__batch_normalization(2, 'bn_data', num_features=3, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.conv0 = self.__conv(2, name='conv0', in_channels=3, out_channels=64, kernel_size=(7, 7), stride=(2, 2), groups=1, bias=False)
        self.bn0 = self.__batch_normalization(2, 'bn0', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit1_bn1 = self.__batch_normalization(2, 'stage1_unit1_bn1', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit1_conv1 = self.__conv(2, name='stage1_unit1_conv1', in_channels=64, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit1_sc = self.__conv(2, name='stage1_unit1_sc', in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit1_bn2 = self.__batch_normalization(2, 'stage1_unit1_bn2', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit1_conv2 = self.__conv(2, name='stage1_unit1_conv2', in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit1_bn3 = self.__batch_normalization(2, 'stage1_unit1_bn3', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit1_conv3 = self.__conv(2, name='stage1_unit1_conv3', in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit2_bn1 = self.__batch_normalization(2, 'stage1_unit2_bn1', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit2_conv1 = self.__conv(2, name='stage1_unit2_conv1', in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit2_bn2 = self.__batch_normalization(2, 'stage1_unit2_bn2', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit2_conv2 = self.__conv(2, name='stage1_unit2_conv2', in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit2_bn3 = self.__batch_normalization(2, 'stage1_unit2_bn3', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit2_conv3 = self.__conv(2, name='stage1_unit2_conv3', in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit3_bn1 = self.__batch_normalization(2, 'stage1_unit3_bn1', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit3_conv1 = self.__conv(2, name='stage1_unit3_conv1', in_channels=256, out_channels=64, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit3_bn2 = self.__batch_normalization(2, 'stage1_unit3_bn2', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit3_conv2 = self.__conv(2, name='stage1_unit3_conv2', in_channels=64, out_channels=64, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage1_unit3_bn3 = self.__batch_normalization(2, 'stage1_unit3_bn3', num_features=64, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage1_unit3_conv3 = self.__conv(2, name='stage1_unit3_conv3', in_channels=64, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit1_bn1 = self.__batch_normalization(2, 'stage2_unit1_bn1', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit1_conv1 = self.__conv(2, name='stage2_unit1_conv1', in_channels=256, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit1_sc = self.__conv(2, name='stage2_unit1_sc', in_channels=256, out_channels=512, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=False)
        self.stage2_unit1_bn2 = self.__batch_normalization(2, 'stage2_unit1_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit1_conv2 = self.__conv(2, name='stage2_unit1_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.stage2_unit1_bn3 = self.__batch_normalization(2, 'stage2_unit1_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit1_conv3 = self.__conv(2, name='stage2_unit1_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit2_bn1 = self.__batch_normalization(2, 'stage2_unit2_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit2_conv1 = self.__conv(2, name='stage2_unit2_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit2_bn2 = self.__batch_normalization(2, 'stage2_unit2_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit2_conv2 = self.__conv(2, name='stage2_unit2_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit2_bn3 = self.__batch_normalization(2, 'stage2_unit2_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit2_conv3 = self.__conv(2, name='stage2_unit2_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit3_bn1 = self.__batch_normalization(2, 'stage2_unit3_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit3_conv1 = self.__conv(2, name='stage2_unit3_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit3_bn2 = self.__batch_normalization(2, 'stage2_unit3_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit3_conv2 = self.__conv(2, name='stage2_unit3_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit3_bn3 = self.__batch_normalization(2, 'stage2_unit3_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit3_conv3 = self.__conv(2, name='stage2_unit3_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit4_bn1 = self.__batch_normalization(2, 'stage2_unit4_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit4_conv1 = self.__conv(2, name='stage2_unit4_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit4_bn2 = self.__batch_normalization(2, 'stage2_unit4_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit4_conv2 = self.__conv(2, name='stage2_unit4_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit4_bn3 = self.__batch_normalization(2, 'stage2_unit4_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit4_conv3 = self.__conv(2, name='stage2_unit4_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit5_bn1 = self.__batch_normalization(2, 'stage2_unit5_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit5_conv1 = self.__conv(2, name='stage2_unit5_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit5_bn2 = self.__batch_normalization(2, 'stage2_unit5_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit5_conv2 = self.__conv(2, name='stage2_unit5_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit5_bn3 = self.__batch_normalization(2, 'stage2_unit5_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit5_conv3 = self.__conv(2, name='stage2_unit5_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit6_bn1 = self.__batch_normalization(2, 'stage2_unit6_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit6_conv1 = self.__conv(2, name='stage2_unit6_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit6_bn2 = self.__batch_normalization(2, 'stage2_unit6_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit6_conv2 = self.__conv(2, name='stage2_unit6_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit6_bn3 = self.__batch_normalization(2, 'stage2_unit6_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit6_conv3 = self.__conv(2, name='stage2_unit6_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit7_bn1 = self.__batch_normalization(2, 'stage2_unit7_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit7_conv1 = self.__conv(2, name='stage2_unit7_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit7_bn2 = self.__batch_normalization(2, 'stage2_unit7_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit7_conv2 = self.__conv(2, name='stage2_unit7_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit7_bn3 = self.__batch_normalization(2, 'stage2_unit7_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit7_conv3 = self.__conv(2, name='stage2_unit7_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit8_bn1 = self.__batch_normalization(2, 'stage2_unit8_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit8_conv1 = self.__conv(2, name='stage2_unit8_conv1', in_channels=512, out_channels=128, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit8_bn2 = self.__batch_normalization(2, 'stage2_unit8_bn2', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit8_conv2 = self.__conv(2, name='stage2_unit8_conv2', in_channels=128, out_channels=128, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage2_unit8_bn3 = self.__batch_normalization(2, 'stage2_unit8_bn3', num_features=128, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage2_unit8_conv3 = self.__conv(2, name='stage2_unit8_conv3', in_channels=128, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit1_bn1 = self.__batch_normalization(2, 'stage3_unit1_bn1', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit1_conv1 = self.__conv(2, name='stage3_unit1_conv1', in_channels=512, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit1_sc = self.__conv(2, name='stage3_unit1_sc', in_channels=512, out_channels=1024, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=False)
        self.stage3_unit1_bn2 = self.__batch_normalization(2, 'stage3_unit1_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit1_conv2 = self.__conv(2, name='stage3_unit1_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.stage3_unit1_bn3 = self.__batch_normalization(2, 'stage3_unit1_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit1_conv3 = self.__conv(2, name='stage3_unit1_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit2_bn1 = self.__batch_normalization(2, 'stage3_unit2_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit2_conv1 = self.__conv(2, name='stage3_unit2_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit2_bn2 = self.__batch_normalization(2, 'stage3_unit2_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit2_conv2 = self.__conv(2, name='stage3_unit2_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit2_bn3 = self.__batch_normalization(2, 'stage3_unit2_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit2_conv3 = self.__conv(2, name='stage3_unit2_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit3_bn1 = self.__batch_normalization(2, 'stage3_unit3_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit3_conv1 = self.__conv(2, name='stage3_unit3_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit3_bn2 = self.__batch_normalization(2, 'stage3_unit3_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit3_conv2 = self.__conv(2, name='stage3_unit3_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit3_bn3 = self.__batch_normalization(2, 'stage3_unit3_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit3_conv3 = self.__conv(2, name='stage3_unit3_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit4_bn1 = self.__batch_normalization(2, 'stage3_unit4_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit4_conv1 = self.__conv(2, name='stage3_unit4_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit4_bn2 = self.__batch_normalization(2, 'stage3_unit4_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit4_conv2 = self.__conv(2, name='stage3_unit4_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit4_bn3 = self.__batch_normalization(2, 'stage3_unit4_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit4_conv3 = self.__conv(2, name='stage3_unit4_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit5_bn1 = self.__batch_normalization(2, 'stage3_unit5_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit5_conv1 = self.__conv(2, name='stage3_unit5_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit5_bn2 = self.__batch_normalization(2, 'stage3_unit5_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit5_conv2 = self.__conv(2, name='stage3_unit5_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit5_bn3 = self.__batch_normalization(2, 'stage3_unit5_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit5_conv3 = self.__conv(2, name='stage3_unit5_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit6_bn1 = self.__batch_normalization(2, 'stage3_unit6_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit6_conv1 = self.__conv(2, name='stage3_unit6_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit6_bn2 = self.__batch_normalization(2, 'stage3_unit6_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit6_conv2 = self.__conv(2, name='stage3_unit6_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit6_bn3 = self.__batch_normalization(2, 'stage3_unit6_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit6_conv3 = self.__conv(2, name='stage3_unit6_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit7_bn1 = self.__batch_normalization(2, 'stage3_unit7_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit7_conv1 = self.__conv(2, name='stage3_unit7_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit7_bn2 = self.__batch_normalization(2, 'stage3_unit7_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit7_conv2 = self.__conv(2, name='stage3_unit7_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit7_bn3 = self.__batch_normalization(2, 'stage3_unit7_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit7_conv3 = self.__conv(2, name='stage3_unit7_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit8_bn1 = self.__batch_normalization(2, 'stage3_unit8_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit8_conv1 = self.__conv(2, name='stage3_unit8_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit8_bn2 = self.__batch_normalization(2, 'stage3_unit8_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit8_conv2 = self.__conv(2, name='stage3_unit8_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit8_bn3 = self.__batch_normalization(2, 'stage3_unit8_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit8_conv3 = self.__conv(2, name='stage3_unit8_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit9_bn1 = self.__batch_normalization(2, 'stage3_unit9_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit9_conv1 = self.__conv(2, name='stage3_unit9_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit9_bn2 = self.__batch_normalization(2, 'stage3_unit9_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit9_conv2 = self.__conv(2, name='stage3_unit9_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit9_bn3 = self.__batch_normalization(2, 'stage3_unit9_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit9_conv3 = self.__conv(2, name='stage3_unit9_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit10_bn1 = self.__batch_normalization(2, 'stage3_unit10_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit10_conv1 = self.__conv(2, name='stage3_unit10_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit10_bn2 = self.__batch_normalization(2, 'stage3_unit10_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit10_conv2 = self.__conv(2, name='stage3_unit10_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit10_bn3 = self.__batch_normalization(2, 'stage3_unit10_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit10_conv3 = self.__conv(2, name='stage3_unit10_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit11_bn1 = self.__batch_normalization(2, 'stage3_unit11_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit11_conv1 = self.__conv(2, name='stage3_unit11_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit11_bn2 = self.__batch_normalization(2, 'stage3_unit11_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit11_conv2 = self.__conv(2, name='stage3_unit11_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit11_bn3 = self.__batch_normalization(2, 'stage3_unit11_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit11_conv3 = self.__conv(2, name='stage3_unit11_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit12_bn1 = self.__batch_normalization(2, 'stage3_unit12_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit12_conv1 = self.__conv(2, name='stage3_unit12_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit12_bn2 = self.__batch_normalization(2, 'stage3_unit12_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit12_conv2 = self.__conv(2, name='stage3_unit12_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit12_bn3 = self.__batch_normalization(2, 'stage3_unit12_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit12_conv3 = self.__conv(2, name='stage3_unit12_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit13_bn1 = self.__batch_normalization(2, 'stage3_unit13_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit13_conv1 = self.__conv(2, name='stage3_unit13_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit13_bn2 = self.__batch_normalization(2, 'stage3_unit13_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit13_conv2 = self.__conv(2, name='stage3_unit13_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit13_bn3 = self.__batch_normalization(2, 'stage3_unit13_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit13_conv3 = self.__conv(2, name='stage3_unit13_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit14_bn1 = self.__batch_normalization(2, 'stage3_unit14_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit14_conv1 = self.__conv(2, name='stage3_unit14_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit14_bn2 = self.__batch_normalization(2, 'stage3_unit14_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit14_conv2 = self.__conv(2, name='stage3_unit14_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit14_bn3 = self.__batch_normalization(2, 'stage3_unit14_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit14_conv3 = self.__conv(2, name='stage3_unit14_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit15_bn1 = self.__batch_normalization(2, 'stage3_unit15_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit15_conv1 = self.__conv(2, name='stage3_unit15_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit15_bn2 = self.__batch_normalization(2, 'stage3_unit15_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit15_conv2 = self.__conv(2, name='stage3_unit15_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit15_bn3 = self.__batch_normalization(2, 'stage3_unit15_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit15_conv3 = self.__conv(2, name='stage3_unit15_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit16_bn1 = self.__batch_normalization(2, 'stage3_unit16_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit16_conv1 = self.__conv(2, name='stage3_unit16_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit16_bn2 = self.__batch_normalization(2, 'stage3_unit16_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit16_conv2 = self.__conv(2, name='stage3_unit16_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit16_bn3 = self.__batch_normalization(2, 'stage3_unit16_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit16_conv3 = self.__conv(2, name='stage3_unit16_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit17_bn1 = self.__batch_normalization(2, 'stage3_unit17_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit17_conv1 = self.__conv(2, name='stage3_unit17_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit17_bn2 = self.__batch_normalization(2, 'stage3_unit17_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit17_conv2 = self.__conv(2, name='stage3_unit17_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit17_bn3 = self.__batch_normalization(2, 'stage3_unit17_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit17_conv3 = self.__conv(2, name='stage3_unit17_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit18_bn1 = self.__batch_normalization(2, 'stage3_unit18_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit18_conv1 = self.__conv(2, name='stage3_unit18_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit18_bn2 = self.__batch_normalization(2, 'stage3_unit18_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit18_conv2 = self.__conv(2, name='stage3_unit18_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit18_bn3 = self.__batch_normalization(2, 'stage3_unit18_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit18_conv3 = self.__conv(2, name='stage3_unit18_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit19_bn1 = self.__batch_normalization(2, 'stage3_unit19_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit19_conv1 = self.__conv(2, name='stage3_unit19_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit19_bn2 = self.__batch_normalization(2, 'stage3_unit19_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit19_conv2 = self.__conv(2, name='stage3_unit19_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit19_bn3 = self.__batch_normalization(2, 'stage3_unit19_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit19_conv3 = self.__conv(2, name='stage3_unit19_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit20_bn1 = self.__batch_normalization(2, 'stage3_unit20_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit20_conv1 = self.__conv(2, name='stage3_unit20_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit20_bn2 = self.__batch_normalization(2, 'stage3_unit20_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit20_conv2 = self.__conv(2, name='stage3_unit20_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit20_bn3 = self.__batch_normalization(2, 'stage3_unit20_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit20_conv3 = self.__conv(2, name='stage3_unit20_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit21_bn1 = self.__batch_normalization(2, 'stage3_unit21_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit21_conv1 = self.__conv(2, name='stage3_unit21_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit21_bn2 = self.__batch_normalization(2, 'stage3_unit21_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit21_conv2 = self.__conv(2, name='stage3_unit21_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit21_bn3 = self.__batch_normalization(2, 'stage3_unit21_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit21_conv3 = self.__conv(2, name='stage3_unit21_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit22_bn1 = self.__batch_normalization(2, 'stage3_unit22_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit22_conv1 = self.__conv(2, name='stage3_unit22_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit22_bn2 = self.__batch_normalization(2, 'stage3_unit22_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit22_conv2 = self.__conv(2, name='stage3_unit22_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit22_bn3 = self.__batch_normalization(2, 'stage3_unit22_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit22_conv3 = self.__conv(2, name='stage3_unit22_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit23_bn1 = self.__batch_normalization(2, 'stage3_unit23_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit23_conv1 = self.__conv(2, name='stage3_unit23_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit23_bn2 = self.__batch_normalization(2, 'stage3_unit23_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit23_conv2 = self.__conv(2, name='stage3_unit23_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit23_bn3 = self.__batch_normalization(2, 'stage3_unit23_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit23_conv3 = self.__conv(2, name='stage3_unit23_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit24_bn1 = self.__batch_normalization(2, 'stage3_unit24_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit24_conv1 = self.__conv(2, name='stage3_unit24_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit24_bn2 = self.__batch_normalization(2, 'stage3_unit24_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit24_conv2 = self.__conv(2, name='stage3_unit24_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit24_bn3 = self.__batch_normalization(2, 'stage3_unit24_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit24_conv3 = self.__conv(2, name='stage3_unit24_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit25_bn1 = self.__batch_normalization(2, 'stage3_unit25_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit25_conv1 = self.__conv(2, name='stage3_unit25_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit25_bn2 = self.__batch_normalization(2, 'stage3_unit25_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit25_conv2 = self.__conv(2, name='stage3_unit25_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit25_bn3 = self.__batch_normalization(2, 'stage3_unit25_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit25_conv3 = self.__conv(2, name='stage3_unit25_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit26_bn1 = self.__batch_normalization(2, 'stage3_unit26_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit26_conv1 = self.__conv(2, name='stage3_unit26_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit26_bn2 = self.__batch_normalization(2, 'stage3_unit26_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit26_conv2 = self.__conv(2, name='stage3_unit26_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit26_bn3 = self.__batch_normalization(2, 'stage3_unit26_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit26_conv3 = self.__conv(2, name='stage3_unit26_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit27_bn1 = self.__batch_normalization(2, 'stage3_unit27_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit27_conv1 = self.__conv(2, name='stage3_unit27_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit27_bn2 = self.__batch_normalization(2, 'stage3_unit27_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit27_conv2 = self.__conv(2, name='stage3_unit27_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit27_bn3 = self.__batch_normalization(2, 'stage3_unit27_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit27_conv3 = self.__conv(2, name='stage3_unit27_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit28_bn1 = self.__batch_normalization(2, 'stage3_unit28_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit28_conv1 = self.__conv(2, name='stage3_unit28_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit28_bn2 = self.__batch_normalization(2, 'stage3_unit28_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit28_conv2 = self.__conv(2, name='stage3_unit28_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit28_bn3 = self.__batch_normalization(2, 'stage3_unit28_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit28_conv3 = self.__conv(2, name='stage3_unit28_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit29_bn1 = self.__batch_normalization(2, 'stage3_unit29_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit29_conv1 = self.__conv(2, name='stage3_unit29_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit29_bn2 = self.__batch_normalization(2, 'stage3_unit29_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit29_conv2 = self.__conv(2, name='stage3_unit29_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit29_bn3 = self.__batch_normalization(2, 'stage3_unit29_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit29_conv3 = self.__conv(2, name='stage3_unit29_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit30_bn1 = self.__batch_normalization(2, 'stage3_unit30_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit30_conv1 = self.__conv(2, name='stage3_unit30_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit30_bn2 = self.__batch_normalization(2, 'stage3_unit30_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit30_conv2 = self.__conv(2, name='stage3_unit30_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit30_bn3 = self.__batch_normalization(2, 'stage3_unit30_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit30_conv3 = self.__conv(2, name='stage3_unit30_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit31_bn1 = self.__batch_normalization(2, 'stage3_unit31_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit31_conv1 = self.__conv(2, name='stage3_unit31_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit31_bn2 = self.__batch_normalization(2, 'stage3_unit31_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit31_conv2 = self.__conv(2, name='stage3_unit31_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit31_bn3 = self.__batch_normalization(2, 'stage3_unit31_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit31_conv3 = self.__conv(2, name='stage3_unit31_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit32_bn1 = self.__batch_normalization(2, 'stage3_unit32_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit32_conv1 = self.__conv(2, name='stage3_unit32_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit32_bn2 = self.__batch_normalization(2, 'stage3_unit32_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit32_conv2 = self.__conv(2, name='stage3_unit32_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit32_bn3 = self.__batch_normalization(2, 'stage3_unit32_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit32_conv3 = self.__conv(2, name='stage3_unit32_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit33_bn1 = self.__batch_normalization(2, 'stage3_unit33_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit33_conv1 = self.__conv(2, name='stage3_unit33_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit33_bn2 = self.__batch_normalization(2, 'stage3_unit33_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit33_conv2 = self.__conv(2, name='stage3_unit33_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit33_bn3 = self.__batch_normalization(2, 'stage3_unit33_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit33_conv3 = self.__conv(2, name='stage3_unit33_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit34_bn1 = self.__batch_normalization(2, 'stage3_unit34_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit34_conv1 = self.__conv(2, name='stage3_unit34_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit34_bn2 = self.__batch_normalization(2, 'stage3_unit34_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit34_conv2 = self.__conv(2, name='stage3_unit34_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit34_bn3 = self.__batch_normalization(2, 'stage3_unit34_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit34_conv3 = self.__conv(2, name='stage3_unit34_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit35_bn1 = self.__batch_normalization(2, 'stage3_unit35_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit35_conv1 = self.__conv(2, name='stage3_unit35_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit35_bn2 = self.__batch_normalization(2, 'stage3_unit35_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit35_conv2 = self.__conv(2, name='stage3_unit35_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit35_bn3 = self.__batch_normalization(2, 'stage3_unit35_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit35_conv3 = self.__conv(2, name='stage3_unit35_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit36_bn1 = self.__batch_normalization(2, 'stage3_unit36_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit36_conv1 = self.__conv(2, name='stage3_unit36_conv1', in_channels=1024, out_channels=256, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit36_bn2 = self.__batch_normalization(2, 'stage3_unit36_bn2', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit36_conv2 = self.__conv(2, name='stage3_unit36_conv2', in_channels=256, out_channels=256, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage3_unit36_bn3 = self.__batch_normalization(2, 'stage3_unit36_bn3', num_features=256, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage3_unit36_conv3 = self.__conv(2, name='stage3_unit36_conv3', in_channels=256, out_channels=1024, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit1_bn1 = self.__batch_normalization(2, 'stage4_unit1_bn1', num_features=1024, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit1_conv1 = self.__conv(2, name='stage4_unit1_conv1', in_channels=1024, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit1_sc = self.__conv(2, name='stage4_unit1_sc', in_channels=1024, out_channels=2048, kernel_size=(1, 1), stride=(2, 2), groups=1, bias=False)
        self.stage4_unit1_bn2 = self.__batch_normalization(2, 'stage4_unit1_bn2', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit1_conv2 = self.__conv(2, name='stage4_unit1_conv2', in_channels=512, out_channels=512, kernel_size=(3, 3), stride=(2, 2), groups=1, bias=False)
        self.stage4_unit1_bn3 = self.__batch_normalization(2, 'stage4_unit1_bn3', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit1_conv3 = self.__conv(2, name='stage4_unit1_conv3', in_channels=512, out_channels=2048, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit2_bn1 = self.__batch_normalization(2, 'stage4_unit2_bn1', num_features=2048, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit2_conv1 = self.__conv(2, name='stage4_unit2_conv1', in_channels=2048, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit2_bn2 = self.__batch_normalization(2, 'stage4_unit2_bn2', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit2_conv2 = self.__conv(2, name='stage4_unit2_conv2', in_channels=512, out_channels=512, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit2_bn3 = self.__batch_normalization(2, 'stage4_unit2_bn3', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit2_conv3 = self.__conv(2, name='stage4_unit2_conv3', in_channels=512, out_channels=2048, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit3_bn1 = self.__batch_normalization(2, 'stage4_unit3_bn1', num_features=2048, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit3_conv1 = self.__conv(2, name='stage4_unit3_conv1', in_channels=2048, out_channels=512, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit3_bn2 = self.__batch_normalization(2, 'stage4_unit3_bn2', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit3_conv2 = self.__conv(2, name='stage4_unit3_conv2', in_channels=512, out_channels=512, kernel_size=(3, 3), stride=(1, 1), groups=1, bias=False)
        self.stage4_unit3_bn3 = self.__batch_normalization(2, 'stage4_unit3_bn3', num_features=512, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.stage4_unit3_conv3 = self.__conv(2, name='stage4_unit3_conv3', in_channels=512, out_channels=2048, kernel_size=(1, 1), stride=(1, 1), groups=1, bias=False)
        self.bn1 = self.__batch_normalization(2, 'bn1', num_features=2048, eps=1.9999999494757503e-05, momentum=0.8999999761581421)
        self.fc1 = self.__dense(name = 'fc1', in_features = 2048, out_features = 11221, bias = True)

    def forward(self, x):
        bn_data         = self.bn_data(x)
        conv0_pad       = F.pad(bn_data, (3, 3, 3, 3))
        conv0           = self.conv0(conv0_pad)
        bn0             = self.bn0(conv0)
        relu0           = F.relu(bn0)
        pooling0_pad    = F.pad(relu0, (1, 1, 1, 1), value=float('-inf'))
        pooling0        = F.max_pool2d(pooling0_pad, kernel_size=(3, 3), stride=(2, 2), padding=0, ceil_mode=False)
        stage1_unit1_bn1 = self.stage1_unit1_bn1(pooling0)
        stage1_unit1_relu1 = F.relu(stage1_unit1_bn1)
        stage1_unit1_conv1 = self.stage1_unit1_conv1(stage1_unit1_relu1)
        stage1_unit1_sc = self.stage1_unit1_sc(stage1_unit1_relu1)
        stage1_unit1_bn2 = self.stage1_unit1_bn2(stage1_unit1_conv1)
        stage1_unit1_relu2 = F.relu(stage1_unit1_bn2)
        stage1_unit1_conv2_pad = F.pad(stage1_unit1_relu2, (1, 1, 1, 1))
        stage1_unit1_conv2 = self.stage1_unit1_conv2(stage1_unit1_conv2_pad)
        stage1_unit1_bn3 = self.stage1_unit1_bn3(stage1_unit1_conv2)
        stage1_unit1_relu3 = F.relu(stage1_unit1_bn3)
        stage1_unit1_conv3 = self.stage1_unit1_conv3(stage1_unit1_relu3)
        plus0           = stage1_unit1_conv3 + stage1_unit1_sc
        stage1_unit2_bn1 = self.stage1_unit2_bn1(plus0)
        stage1_unit2_relu1 = F.relu(stage1_unit2_bn1)
        stage1_unit2_conv1 = self.stage1_unit2_conv1(stage1_unit2_relu1)
        stage1_unit2_bn2 = self.stage1_unit2_bn2(stage1_unit2_conv1)
        stage1_unit2_relu2 = F.relu(stage1_unit2_bn2)
        stage1_unit2_conv2_pad = F.pad(stage1_unit2_relu2, (1, 1, 1, 1))
        stage1_unit2_conv2 = self.stage1_unit2_conv2(stage1_unit2_conv2_pad)
        stage1_unit2_bn3 = self.stage1_unit2_bn3(stage1_unit2_conv2)
        stage1_unit2_relu3 = F.relu(stage1_unit2_bn3)
        stage1_unit2_conv3 = self.stage1_unit2_conv3(stage1_unit2_relu3)
        plus1           = stage1_unit2_conv3 + plus0
        stage1_unit3_bn1 = self.stage1_unit3_bn1(plus1)
        stage1_unit3_relu1 = F.relu(stage1_unit3_bn1)
        stage1_unit3_conv1 = self.stage1_unit3_conv1(stage1_unit3_relu1)
        stage1_unit3_bn2 = self.stage1_unit3_bn2(stage1_unit3_conv1)
        stage1_unit3_relu2 = F.relu(stage1_unit3_bn2)
        stage1_unit3_conv2_pad = F.pad(stage1_unit3_relu2, (1, 1, 1, 1))
        stage1_unit3_conv2 = self.stage1_unit3_conv2(stage1_unit3_conv2_pad)
        stage1_unit3_bn3 = self.stage1_unit3_bn3(stage1_unit3_conv2)
        stage1_unit3_relu3 = F.relu(stage1_unit3_bn3)
        stage1_unit3_conv3 = self.stage1_unit3_conv3(stage1_unit3_relu3)
        plus2           = stage1_unit3_conv3 + plus1
        stage2_unit1_bn1 = self.stage2_unit1_bn1(plus2)
        stage2_unit1_relu1 = F.relu(stage2_unit1_bn1)
        stage2_unit1_conv1 = self.stage2_unit1_conv1(stage2_unit1_relu1)
        stage2_unit1_sc = self.stage2_unit1_sc(stage2_unit1_relu1)
        stage2_unit1_bn2 = self.stage2_unit1_bn2(stage2_unit1_conv1)
        stage2_unit1_relu2 = F.relu(stage2_unit1_bn2)
        stage2_unit1_conv2_pad = F.pad(stage2_unit1_relu2, (1, 1, 1, 1))
        stage2_unit1_conv2 = self.stage2_unit1_conv2(stage2_unit1_conv2_pad)
        stage2_unit1_bn3 = self.stage2_unit1_bn3(stage2_unit1_conv2)
        stage2_unit1_relu3 = F.relu(stage2_unit1_bn3)
        stage2_unit1_conv3 = self.stage2_unit1_conv3(stage2_unit1_relu3)
        plus3           = stage2_unit1_conv3 + stage2_unit1_sc
        stage2_unit2_bn1 = self.stage2_unit2_bn1(plus3)
        stage2_unit2_relu1 = F.relu(stage2_unit2_bn1)
        stage2_unit2_conv1 = self.stage2_unit2_conv1(stage2_unit2_relu1)
        stage2_unit2_bn2 = self.stage2_unit2_bn2(stage2_unit2_conv1)
        stage2_unit2_relu2 = F.relu(stage2_unit2_bn2)
        stage2_unit2_conv2_pad = F.pad(stage2_unit2_relu2, (1, 1, 1, 1))
        stage2_unit2_conv2 = self.stage2_unit2_conv2(stage2_unit2_conv2_pad)
        stage2_unit2_bn3 = self.stage2_unit2_bn3(stage2_unit2_conv2)
        stage2_unit2_relu3 = F.relu(stage2_unit2_bn3)
        stage2_unit2_conv3 = self.stage2_unit2_conv3(stage2_unit2_relu3)
        plus4           = stage2_unit2_conv3 + plus3
        stage2_unit3_bn1 = self.stage2_unit3_bn1(plus4)
        stage2_unit3_relu1 = F.relu(stage2_unit3_bn1)
        stage2_unit3_conv1 = self.stage2_unit3_conv1(stage2_unit3_relu1)
        stage2_unit3_bn2 = self.stage2_unit3_bn2(stage2_unit3_conv1)
        stage2_unit3_relu2 = F.relu(stage2_unit3_bn2)
        stage2_unit3_conv2_pad = F.pad(stage2_unit3_relu2, (1, 1, 1, 1))
        stage2_unit3_conv2 = self.stage2_unit3_conv2(stage2_unit3_conv2_pad)
        stage2_unit3_bn3 = self.stage2_unit3_bn3(stage2_unit3_conv2)
        stage2_unit3_relu3 = F.relu(stage2_unit3_bn3)
        stage2_unit3_conv3 = self.stage2_unit3_conv3(stage2_unit3_relu3)
        plus5           = stage2_unit3_conv3 + plus4
        stage2_unit4_bn1 = self.stage2_unit4_bn1(plus5)
        stage2_unit4_relu1 = F.relu(stage2_unit4_bn1)
        stage2_unit4_conv1 = self.stage2_unit4_conv1(stage2_unit4_relu1)
        stage2_unit4_bn2 = self.stage2_unit4_bn2(stage2_unit4_conv1)
        stage2_unit4_relu2 = F.relu(stage2_unit4_bn2)
        stage2_unit4_conv2_pad = F.pad(stage2_unit4_relu2, (1, 1, 1, 1))
        stage2_unit4_conv2 = self.stage2_unit4_conv2(stage2_unit4_conv2_pad)
        stage2_unit4_bn3 = self.stage2_unit4_bn3(stage2_unit4_conv2)
        stage2_unit4_relu3 = F.relu(stage2_unit4_bn3)
        stage2_unit4_conv3 = self.stage2_unit4_conv3(stage2_unit4_relu3)
        plus6           = stage2_unit4_conv3 + plus5
        stage2_unit5_bn1 = self.stage2_unit5_bn1(plus6)
        stage2_unit5_relu1 = F.relu(stage2_unit5_bn1)
        stage2_unit5_conv1 = self.stage2_unit5_conv1(stage2_unit5_relu1)
        stage2_unit5_bn2 = self.stage2_unit5_bn2(stage2_unit5_conv1)
        stage2_unit5_relu2 = F.relu(stage2_unit5_bn2)
        stage2_unit5_conv2_pad = F.pad(stage2_unit5_relu2, (1, 1, 1, 1))
        stage2_unit5_conv2 = self.stage2_unit5_conv2(stage2_unit5_conv2_pad)
        stage2_unit5_bn3 = self.stage2_unit5_bn3(stage2_unit5_conv2)
        stage2_unit5_relu3 = F.relu(stage2_unit5_bn3)
        stage2_unit5_conv3 = self.stage2_unit5_conv3(stage2_unit5_relu3)
        plus7           = stage2_unit5_conv3 + plus6
        stage2_unit6_bn1 = self.stage2_unit6_bn1(plus7)
        stage2_unit6_relu1 = F.relu(stage2_unit6_bn1)
        stage2_unit6_conv1 = self.stage2_unit6_conv1(stage2_unit6_relu1)
        stage2_unit6_bn2 = self.stage2_unit6_bn2(stage2_unit6_conv1)
        stage2_unit6_relu2 = F.relu(stage2_unit6_bn2)
        stage2_unit6_conv2_pad = F.pad(stage2_unit6_relu2, (1, 1, 1, 1))
        stage2_unit6_conv2 = self.stage2_unit6_conv2(stage2_unit6_conv2_pad)
        stage2_unit6_bn3 = self.stage2_unit6_bn3(stage2_unit6_conv2)
        stage2_unit6_relu3 = F.relu(stage2_unit6_bn3)
        stage2_unit6_conv3 = self.stage2_unit6_conv3(stage2_unit6_relu3)
        plus8           = stage2_unit6_conv3 + plus7
        stage2_unit7_bn1 = self.stage2_unit7_bn1(plus8)
        stage2_unit7_relu1 = F.relu(stage2_unit7_bn1)
        stage2_unit7_conv1 = self.stage2_unit7_conv1(stage2_unit7_relu1)
        stage2_unit7_bn2 = self.stage2_unit7_bn2(stage2_unit7_conv1)
        stage2_unit7_relu2 = F.relu(stage2_unit7_bn2)
        stage2_unit7_conv2_pad = F.pad(stage2_unit7_relu2, (1, 1, 1, 1))
        stage2_unit7_conv2 = self.stage2_unit7_conv2(stage2_unit7_conv2_pad)
        stage2_unit7_bn3 = self.stage2_unit7_bn3(stage2_unit7_conv2)
        stage2_unit7_relu3 = F.relu(stage2_unit7_bn3)
        stage2_unit7_conv3 = self.stage2_unit7_conv3(stage2_unit7_relu3)
        plus9           = stage2_unit7_conv3 + plus8
        stage2_unit8_bn1 = self.stage2_unit8_bn1(plus9)
        stage2_unit8_relu1 = F.relu(stage2_unit8_bn1)
        stage2_unit8_conv1 = self.stage2_unit8_conv1(stage2_unit8_relu1)
        stage2_unit8_bn2 = self.stage2_unit8_bn2(stage2_unit8_conv1)
        stage2_unit8_relu2 = F.relu(stage2_unit8_bn2)
        stage2_unit8_conv2_pad = F.pad(stage2_unit8_relu2, (1, 1, 1, 1))
        stage2_unit8_conv2 = self.stage2_unit8_conv2(stage2_unit8_conv2_pad)
        stage2_unit8_bn3 = self.stage2_unit8_bn3(stage2_unit8_conv2)
        stage2_unit8_relu3 = F.relu(stage2_unit8_bn3)
        stage2_unit8_conv3 = self.stage2_unit8_conv3(stage2_unit8_relu3)
        plus10          = stage2_unit8_conv3 + plus9
        stage3_unit1_bn1 = self.stage3_unit1_bn1(plus10)
        stage3_unit1_relu1 = F.relu(stage3_unit1_bn1)
        stage3_unit1_conv1 = self.stage3_unit1_conv1(stage3_unit1_relu1)
        stage3_unit1_sc = self.stage3_unit1_sc(stage3_unit1_relu1)
        stage3_unit1_bn2 = self.stage3_unit1_bn2(stage3_unit1_conv1)
        stage3_unit1_relu2 = F.relu(stage3_unit1_bn2)
        stage3_unit1_conv2_pad = F.pad(stage3_unit1_relu2, (1, 1, 1, 1))
        stage3_unit1_conv2 = self.stage3_unit1_conv2(stage3_unit1_conv2_pad)
        stage3_unit1_bn3 = self.stage3_unit1_bn3(stage3_unit1_conv2)
        stage3_unit1_relu3 = F.relu(stage3_unit1_bn3)
        stage3_unit1_conv3 = self.stage3_unit1_conv3(stage3_unit1_relu3)
        plus11          = stage3_unit1_conv3 + stage3_unit1_sc
        stage3_unit2_bn1 = self.stage3_unit2_bn1(plus11)
        stage3_unit2_relu1 = F.relu(stage3_unit2_bn1)
        stage3_unit2_conv1 = self.stage3_unit2_conv1(stage3_unit2_relu1)
        stage3_unit2_bn2 = self.stage3_unit2_bn2(stage3_unit2_conv1)
        stage3_unit2_relu2 = F.relu(stage3_unit2_bn2)
        stage3_unit2_conv2_pad = F.pad(stage3_unit2_relu2, (1, 1, 1, 1))
        stage3_unit2_conv2 = self.stage3_unit2_conv2(stage3_unit2_conv2_pad)
        stage3_unit2_bn3 = self.stage3_unit2_bn3(stage3_unit2_conv2)
        stage3_unit2_relu3 = F.relu(stage3_unit2_bn3)
        stage3_unit2_conv3 = self.stage3_unit2_conv3(stage3_unit2_relu3)
        plus12          = stage3_unit2_conv3 + plus11
        stage3_unit3_bn1 = self.stage3_unit3_bn1(plus12)
        stage3_unit3_relu1 = F.relu(stage3_unit3_bn1)
        stage3_unit3_conv1 = self.stage3_unit3_conv1(stage3_unit3_relu1)
        stage3_unit3_bn2 = self.stage3_unit3_bn2(stage3_unit3_conv1)
        stage3_unit3_relu2 = F.relu(stage3_unit3_bn2)
        stage3_unit3_conv2_pad = F.pad(stage3_unit3_relu2, (1, 1, 1, 1))
        stage3_unit3_conv2 = self.stage3_unit3_conv2(stage3_unit3_conv2_pad)
        stage3_unit3_bn3 = self.stage3_unit3_bn3(stage3_unit3_conv2)
        stage3_unit3_relu3 = F.relu(stage3_unit3_bn3)
        stage3_unit3_conv3 = self.stage3_unit3_conv3(stage3_unit3_relu3)
        plus13          = stage3_unit3_conv3 + plus12
        stage3_unit4_bn1 = self.stage3_unit4_bn1(plus13)
        stage3_unit4_relu1 = F.relu(stage3_unit4_bn1)
        stage3_unit4_conv1 = self.stage3_unit4_conv1(stage3_unit4_relu1)
        stage3_unit4_bn2 = self.stage3_unit4_bn2(stage3_unit4_conv1)
        stage3_unit4_relu2 = F.relu(stage3_unit4_bn2)
        stage3_unit4_conv2_pad = F.pad(stage3_unit4_relu2, (1, 1, 1, 1))
        stage3_unit4_conv2 = self.stage3_unit4_conv2(stage3_unit4_conv2_pad)
        stage3_unit4_bn3 = self.stage3_unit4_bn3(stage3_unit4_conv2)
        stage3_unit4_relu3 = F.relu(stage3_unit4_bn3)
        stage3_unit4_conv3 = self.stage3_unit4_conv3(stage3_unit4_relu3)
        plus14          = stage3_unit4_conv3 + plus13
        stage3_unit5_bn1 = self.stage3_unit5_bn1(plus14)
        stage3_unit5_relu1 = F.relu(stage3_unit5_bn1)
        stage3_unit5_conv1 = self.stage3_unit5_conv1(stage3_unit5_relu1)
        stage3_unit5_bn2 = self.stage3_unit5_bn2(stage3_unit5_conv1)
        stage3_unit5_relu2 = F.relu(stage3_unit5_bn2)
        stage3_unit5_conv2_pad = F.pad(stage3_unit5_relu2, (1, 1, 1, 1))
        stage3_unit5_conv2 = self.stage3_unit5_conv2(stage3_unit5_conv2_pad)
        stage3_unit5_bn3 = self.stage3_unit5_bn3(stage3_unit5_conv2)
        stage3_unit5_relu3 = F.relu(stage3_unit5_bn3)
        stage3_unit5_conv3 = self.stage3_unit5_conv3(stage3_unit5_relu3)
        plus15          = stage3_unit5_conv3 + plus14
        stage3_unit6_bn1 = self.stage3_unit6_bn1(plus15)
        stage3_unit6_relu1 = F.relu(stage3_unit6_bn1)
        stage3_unit6_conv1 = self.stage3_unit6_conv1(stage3_unit6_relu1)
        stage3_unit6_bn2 = self.stage3_unit6_bn2(stage3_unit6_conv1)
        stage3_unit6_relu2 = F.relu(stage3_unit6_bn2)
        stage3_unit6_conv2_pad = F.pad(stage3_unit6_relu2, (1, 1, 1, 1))
        stage3_unit6_conv2 = self.stage3_unit6_conv2(stage3_unit6_conv2_pad)
        stage3_unit6_bn3 = self.stage3_unit6_bn3(stage3_unit6_conv2)
        stage3_unit6_relu3 = F.relu(stage3_unit6_bn3)
        stage3_unit6_conv3 = self.stage3_unit6_conv3(stage3_unit6_relu3)
        plus16          = stage3_unit6_conv3 + plus15
        stage3_unit7_bn1 = self.stage3_unit7_bn1(plus16)
        stage3_unit7_relu1 = F.relu(stage3_unit7_bn1)
        stage3_unit7_conv1 = self.stage3_unit7_conv1(stage3_unit7_relu1)
        stage3_unit7_bn2 = self.stage3_unit7_bn2(stage3_unit7_conv1)
        stage3_unit7_relu2 = F.relu(stage3_unit7_bn2)
        stage3_unit7_conv2_pad = F.pad(stage3_unit7_relu2, (1, 1, 1, 1))
        stage3_unit7_conv2 = self.stage3_unit7_conv2(stage3_unit7_conv2_pad)
        stage3_unit7_bn3 = self.stage3_unit7_bn3(stage3_unit7_conv2)
        stage3_unit7_relu3 = F.relu(stage3_unit7_bn3)
        stage3_unit7_conv3 = self.stage3_unit7_conv3(stage3_unit7_relu3)
        plus17          = stage3_unit7_conv3 + plus16
        stage3_unit8_bn1 = self.stage3_unit8_bn1(plus17)
        stage3_unit8_relu1 = F.relu(stage3_unit8_bn1)
        stage3_unit8_conv1 = self.stage3_unit8_conv1(stage3_unit8_relu1)
        stage3_unit8_bn2 = self.stage3_unit8_bn2(stage3_unit8_conv1)
        stage3_unit8_relu2 = F.relu(stage3_unit8_bn2)
        stage3_unit8_conv2_pad = F.pad(stage3_unit8_relu2, (1, 1, 1, 1))
        stage3_unit8_conv2 = self.stage3_unit8_conv2(stage3_unit8_conv2_pad)
        stage3_unit8_bn3 = self.stage3_unit8_bn3(stage3_unit8_conv2)
        stage3_unit8_relu3 = F.relu(stage3_unit8_bn3)
        stage3_unit8_conv3 = self.stage3_unit8_conv3(stage3_unit8_relu3)
        plus18          = stage3_unit8_conv3 + plus17
        stage3_unit9_bn1 = self.stage3_unit9_bn1(plus18)
        stage3_unit9_relu1 = F.relu(stage3_unit9_bn1)
        stage3_unit9_conv1 = self.stage3_unit9_conv1(stage3_unit9_relu1)
        stage3_unit9_bn2 = self.stage3_unit9_bn2(stage3_unit9_conv1)
        stage3_unit9_relu2 = F.relu(stage3_unit9_bn2)
        stage3_unit9_conv2_pad = F.pad(stage3_unit9_relu2, (1, 1, 1, 1))
        stage3_unit9_conv2 = self.stage3_unit9_conv2(stage3_unit9_conv2_pad)
        stage3_unit9_bn3 = self.stage3_unit9_bn3(stage3_unit9_conv2)
        stage3_unit9_relu3 = F.relu(stage3_unit9_bn3)
        stage3_unit9_conv3 = self.stage3_unit9_conv3(stage3_unit9_relu3)
        plus19          = stage3_unit9_conv3 + plus18
        stage3_unit10_bn1 = self.stage3_unit10_bn1(plus19)
        stage3_unit10_relu1 = F.relu(stage3_unit10_bn1)
        stage3_unit10_conv1 = self.stage3_unit10_conv1(stage3_unit10_relu1)
        stage3_unit10_bn2 = self.stage3_unit10_bn2(stage3_unit10_conv1)
        stage3_unit10_relu2 = F.relu(stage3_unit10_bn2)
        stage3_unit10_conv2_pad = F.pad(stage3_unit10_relu2, (1, 1, 1, 1))
        stage3_unit10_conv2 = self.stage3_unit10_conv2(stage3_unit10_conv2_pad)
        stage3_unit10_bn3 = self.stage3_unit10_bn3(stage3_unit10_conv2)
        stage3_unit10_relu3 = F.relu(stage3_unit10_bn3)
        stage3_unit10_conv3 = self.stage3_unit10_conv3(stage3_unit10_relu3)
        plus20          = stage3_unit10_conv3 + plus19
        stage3_unit11_bn1 = self.stage3_unit11_bn1(plus20)
        stage3_unit11_relu1 = F.relu(stage3_unit11_bn1)
        stage3_unit11_conv1 = self.stage3_unit11_conv1(stage3_unit11_relu1)
        stage3_unit11_bn2 = self.stage3_unit11_bn2(stage3_unit11_conv1)
        stage3_unit11_relu2 = F.relu(stage3_unit11_bn2)
        stage3_unit11_conv2_pad = F.pad(stage3_unit11_relu2, (1, 1, 1, 1))
        stage3_unit11_conv2 = self.stage3_unit11_conv2(stage3_unit11_conv2_pad)
        stage3_unit11_bn3 = self.stage3_unit11_bn3(stage3_unit11_conv2)
        stage3_unit11_relu3 = F.relu(stage3_unit11_bn3)
        stage3_unit11_conv3 = self.stage3_unit11_conv3(stage3_unit11_relu3)
        plus21          = stage3_unit11_conv3 + plus20
        stage3_unit12_bn1 = self.stage3_unit12_bn1(plus21)
        stage3_unit12_relu1 = F.relu(stage3_unit12_bn1)
        stage3_unit12_conv1 = self.stage3_unit12_conv1(stage3_unit12_relu1)
        stage3_unit12_bn2 = self.stage3_unit12_bn2(stage3_unit12_conv1)
        stage3_unit12_relu2 = F.relu(stage3_unit12_bn2)
        stage3_unit12_conv2_pad = F.pad(stage3_unit12_relu2, (1, 1, 1, 1))
        stage3_unit12_conv2 = self.stage3_unit12_conv2(stage3_unit12_conv2_pad)
        stage3_unit12_bn3 = self.stage3_unit12_bn3(stage3_unit12_conv2)
        stage3_unit12_relu3 = F.relu(stage3_unit12_bn3)
        stage3_unit12_conv3 = self.stage3_unit12_conv3(stage3_unit12_relu3)
        plus22          = stage3_unit12_conv3 + plus21
        stage3_unit13_bn1 = self.stage3_unit13_bn1(plus22)
        stage3_unit13_relu1 = F.relu(stage3_unit13_bn1)
        stage3_unit13_conv1 = self.stage3_unit13_conv1(stage3_unit13_relu1)
        stage3_unit13_bn2 = self.stage3_unit13_bn2(stage3_unit13_conv1)
        stage3_unit13_relu2 = F.relu(stage3_unit13_bn2)
        stage3_unit13_conv2_pad = F.pad(stage3_unit13_relu2, (1, 1, 1, 1))
        stage3_unit13_conv2 = self.stage3_unit13_conv2(stage3_unit13_conv2_pad)
        stage3_unit13_bn3 = self.stage3_unit13_bn3(stage3_unit13_conv2)
        stage3_unit13_relu3 = F.relu(stage3_unit13_bn3)
        stage3_unit13_conv3 = self.stage3_unit13_conv3(stage3_unit13_relu3)
        plus23          = stage3_unit13_conv3 + plus22
        stage3_unit14_bn1 = self.stage3_unit14_bn1(plus23)
        stage3_unit14_relu1 = F.relu(stage3_unit14_bn1)
        stage3_unit14_conv1 = self.stage3_unit14_conv1(stage3_unit14_relu1)
        stage3_unit14_bn2 = self.stage3_unit14_bn2(stage3_unit14_conv1)
        stage3_unit14_relu2 = F.relu(stage3_unit14_bn2)
        stage3_unit14_conv2_pad = F.pad(stage3_unit14_relu2, (1, 1, 1, 1))
        stage3_unit14_conv2 = self.stage3_unit14_conv2(stage3_unit14_conv2_pad)
        stage3_unit14_bn3 = self.stage3_unit14_bn3(stage3_unit14_conv2)
        stage3_unit14_relu3 = F.relu(stage3_unit14_bn3)
        stage3_unit14_conv3 = self.stage3_unit14_conv3(stage3_unit14_relu3)
        plus24          = stage3_unit14_conv3 + plus23
        stage3_unit15_bn1 = self.stage3_unit15_bn1(plus24)
        stage3_unit15_relu1 = F.relu(stage3_unit15_bn1)
        stage3_unit15_conv1 = self.stage3_unit15_conv1(stage3_unit15_relu1)
        stage3_unit15_bn2 = self.stage3_unit15_bn2(stage3_unit15_conv1)
        stage3_unit15_relu2 = F.relu(stage3_unit15_bn2)
        stage3_unit15_conv2_pad = F.pad(stage3_unit15_relu2, (1, 1, 1, 1))
        stage3_unit15_conv2 = self.stage3_unit15_conv2(stage3_unit15_conv2_pad)
        stage3_unit15_bn3 = self.stage3_unit15_bn3(stage3_unit15_conv2)
        stage3_unit15_relu3 = F.relu(stage3_unit15_bn3)
        stage3_unit15_conv3 = self.stage3_unit15_conv3(stage3_unit15_relu3)
        plus25          = stage3_unit15_conv3 + plus24
        stage3_unit16_bn1 = self.stage3_unit16_bn1(plus25)
        stage3_unit16_relu1 = F.relu(stage3_unit16_bn1)
        stage3_unit16_conv1 = self.stage3_unit16_conv1(stage3_unit16_relu1)
        stage3_unit16_bn2 = self.stage3_unit16_bn2(stage3_unit16_conv1)
        stage3_unit16_relu2 = F.relu(stage3_unit16_bn2)
        stage3_unit16_conv2_pad = F.pad(stage3_unit16_relu2, (1, 1, 1, 1))
        stage3_unit16_conv2 = self.stage3_unit16_conv2(stage3_unit16_conv2_pad)
        stage3_unit16_bn3 = self.stage3_unit16_bn3(stage3_unit16_conv2)
        stage3_unit16_relu3 = F.relu(stage3_unit16_bn3)
        stage3_unit16_conv3 = self.stage3_unit16_conv3(stage3_unit16_relu3)
        plus26          = stage3_unit16_conv3 + plus25
        stage3_unit17_bn1 = self.stage3_unit17_bn1(plus26)
        stage3_unit17_relu1 = F.relu(stage3_unit17_bn1)
        stage3_unit17_conv1 = self.stage3_unit17_conv1(stage3_unit17_relu1)
        stage3_unit17_bn2 = self.stage3_unit17_bn2(stage3_unit17_conv1)
        stage3_unit17_relu2 = F.relu(stage3_unit17_bn2)
        stage3_unit17_conv2_pad = F.pad(stage3_unit17_relu2, (1, 1, 1, 1))
        stage3_unit17_conv2 = self.stage3_unit17_conv2(stage3_unit17_conv2_pad)
        stage3_unit17_bn3 = self.stage3_unit17_bn3(stage3_unit17_conv2)
        stage3_unit17_relu3 = F.relu(stage3_unit17_bn3)
        stage3_unit17_conv3 = self.stage3_unit17_conv3(stage3_unit17_relu3)
        plus27          = stage3_unit17_conv3 + plus26
        stage3_unit18_bn1 = self.stage3_unit18_bn1(plus27)
        stage3_unit18_relu1 = F.relu(stage3_unit18_bn1)
        stage3_unit18_conv1 = self.stage3_unit18_conv1(stage3_unit18_relu1)
        stage3_unit18_bn2 = self.stage3_unit18_bn2(stage3_unit18_conv1)
        stage3_unit18_relu2 = F.relu(stage3_unit18_bn2)
        stage3_unit18_conv2_pad = F.pad(stage3_unit18_relu2, (1, 1, 1, 1))
        stage3_unit18_conv2 = self.stage3_unit18_conv2(stage3_unit18_conv2_pad)
        stage3_unit18_bn3 = self.stage3_unit18_bn3(stage3_unit18_conv2)
        stage3_unit18_relu3 = F.relu(stage3_unit18_bn3)
        stage3_unit18_conv3 = self.stage3_unit18_conv3(stage3_unit18_relu3)
        plus28          = stage3_unit18_conv3 + plus27
        stage3_unit19_bn1 = self.stage3_unit19_bn1(plus28)
        stage3_unit19_relu1 = F.relu(stage3_unit19_bn1)
        stage3_unit19_conv1 = self.stage3_unit19_conv1(stage3_unit19_relu1)
        stage3_unit19_bn2 = self.stage3_unit19_bn2(stage3_unit19_conv1)
        stage3_unit19_relu2 = F.relu(stage3_unit19_bn2)
        stage3_unit19_conv2_pad = F.pad(stage3_unit19_relu2, (1, 1, 1, 1))
        stage3_unit19_conv2 = self.stage3_unit19_conv2(stage3_unit19_conv2_pad)
        stage3_unit19_bn3 = self.stage3_unit19_bn3(stage3_unit19_conv2)
        stage3_unit19_relu3 = F.relu(stage3_unit19_bn3)
        stage3_unit19_conv3 = self.stage3_unit19_conv3(stage3_unit19_relu3)
        plus29          = stage3_unit19_conv3 + plus28
        stage3_unit20_bn1 = self.stage3_unit20_bn1(plus29)
        stage3_unit20_relu1 = F.relu(stage3_unit20_bn1)
        stage3_unit20_conv1 = self.stage3_unit20_conv1(stage3_unit20_relu1)
        stage3_unit20_bn2 = self.stage3_unit20_bn2(stage3_unit20_conv1)
        stage3_unit20_relu2 = F.relu(stage3_unit20_bn2)
        stage3_unit20_conv2_pad = F.pad(stage3_unit20_relu2, (1, 1, 1, 1))
        stage3_unit20_conv2 = self.stage3_unit20_conv2(stage3_unit20_conv2_pad)
        stage3_unit20_bn3 = self.stage3_unit20_bn3(stage3_unit20_conv2)
        stage3_unit20_relu3 = F.relu(stage3_unit20_bn3)
        stage3_unit20_conv3 = self.stage3_unit20_conv3(stage3_unit20_relu3)
        plus30          = stage3_unit20_conv3 + plus29
        stage3_unit21_bn1 = self.stage3_unit21_bn1(plus30)
        stage3_unit21_relu1 = F.relu(stage3_unit21_bn1)
        stage3_unit21_conv1 = self.stage3_unit21_conv1(stage3_unit21_relu1)
        stage3_unit21_bn2 = self.stage3_unit21_bn2(stage3_unit21_conv1)
        stage3_unit21_relu2 = F.relu(stage3_unit21_bn2)
        stage3_unit21_conv2_pad = F.pad(stage3_unit21_relu2, (1, 1, 1, 1))
        stage3_unit21_conv2 = self.stage3_unit21_conv2(stage3_unit21_conv2_pad)
        stage3_unit21_bn3 = self.stage3_unit21_bn3(stage3_unit21_conv2)
        stage3_unit21_relu3 = F.relu(stage3_unit21_bn3)
        stage3_unit21_conv3 = self.stage3_unit21_conv3(stage3_unit21_relu3)
        plus31          = stage3_unit21_conv3 + plus30
        stage3_unit22_bn1 = self.stage3_unit22_bn1(plus31)
        stage3_unit22_relu1 = F.relu(stage3_unit22_bn1)
        stage3_unit22_conv1 = self.stage3_unit22_conv1(stage3_unit22_relu1)
        stage3_unit22_bn2 = self.stage3_unit22_bn2(stage3_unit22_conv1)
        stage3_unit22_relu2 = F.relu(stage3_unit22_bn2)
        stage3_unit22_conv2_pad = F.pad(stage3_unit22_relu2, (1, 1, 1, 1))
        stage3_unit22_conv2 = self.stage3_unit22_conv2(stage3_unit22_conv2_pad)
        stage3_unit22_bn3 = self.stage3_unit22_bn3(stage3_unit22_conv2)
        stage3_unit22_relu3 = F.relu(stage3_unit22_bn3)
        stage3_unit22_conv3 = self.stage3_unit22_conv3(stage3_unit22_relu3)
        plus32          = stage3_unit22_conv3 + plus31
        stage3_unit23_bn1 = self.stage3_unit23_bn1(plus32)
        stage3_unit23_relu1 = F.relu(stage3_unit23_bn1)
        stage3_unit23_conv1 = self.stage3_unit23_conv1(stage3_unit23_relu1)
        stage3_unit23_bn2 = self.stage3_unit23_bn2(stage3_unit23_conv1)
        stage3_unit23_relu2 = F.relu(stage3_unit23_bn2)
        stage3_unit23_conv2_pad = F.pad(stage3_unit23_relu2, (1, 1, 1, 1))
        stage3_unit23_conv2 = self.stage3_unit23_conv2(stage3_unit23_conv2_pad)
        stage3_unit23_bn3 = self.stage3_unit23_bn3(stage3_unit23_conv2)
        stage3_unit23_relu3 = F.relu(stage3_unit23_bn3)
        stage3_unit23_conv3 = self.stage3_unit23_conv3(stage3_unit23_relu3)
        plus33          = stage3_unit23_conv3 + plus32
        stage3_unit24_bn1 = self.stage3_unit24_bn1(plus33)
        stage3_unit24_relu1 = F.relu(stage3_unit24_bn1)
        stage3_unit24_conv1 = self.stage3_unit24_conv1(stage3_unit24_relu1)
        stage3_unit24_bn2 = self.stage3_unit24_bn2(stage3_unit24_conv1)
        stage3_unit24_relu2 = F.relu(stage3_unit24_bn2)
        stage3_unit24_conv2_pad = F.pad(stage3_unit24_relu2, (1, 1, 1, 1))
        stage3_unit24_conv2 = self.stage3_unit24_conv2(stage3_unit24_conv2_pad)
        stage3_unit24_bn3 = self.stage3_unit24_bn3(stage3_unit24_conv2)
        stage3_unit24_relu3 = F.relu(stage3_unit24_bn3)
        stage3_unit24_conv3 = self.stage3_unit24_conv3(stage3_unit24_relu3)
        plus34          = stage3_unit24_conv3 + plus33
        stage3_unit25_bn1 = self.stage3_unit25_bn1(plus34)
        stage3_unit25_relu1 = F.relu(stage3_unit25_bn1)
        stage3_unit25_conv1 = self.stage3_unit25_conv1(stage3_unit25_relu1)
        stage3_unit25_bn2 = self.stage3_unit25_bn2(stage3_unit25_conv1)
        stage3_unit25_relu2 = F.relu(stage3_unit25_bn2)
        stage3_unit25_conv2_pad = F.pad(stage3_unit25_relu2, (1, 1, 1, 1))
        stage3_unit25_conv2 = self.stage3_unit25_conv2(stage3_unit25_conv2_pad)
        stage3_unit25_bn3 = self.stage3_unit25_bn3(stage3_unit25_conv2)
        stage3_unit25_relu3 = F.relu(stage3_unit25_bn3)
        stage3_unit25_conv3 = self.stage3_unit25_conv3(stage3_unit25_relu3)
        plus35          = stage3_unit25_conv3 + plus34
        stage3_unit26_bn1 = self.stage3_unit26_bn1(plus35)
        stage3_unit26_relu1 = F.relu(stage3_unit26_bn1)
        stage3_unit26_conv1 = self.stage3_unit26_conv1(stage3_unit26_relu1)
        stage3_unit26_bn2 = self.stage3_unit26_bn2(stage3_unit26_conv1)
        stage3_unit26_relu2 = F.relu(stage3_unit26_bn2)
        stage3_unit26_conv2_pad = F.pad(stage3_unit26_relu2, (1, 1, 1, 1))
        stage3_unit26_conv2 = self.stage3_unit26_conv2(stage3_unit26_conv2_pad)
        stage3_unit26_bn3 = self.stage3_unit26_bn3(stage3_unit26_conv2)
        stage3_unit26_relu3 = F.relu(stage3_unit26_bn3)
        stage3_unit26_conv3 = self.stage3_unit26_conv3(stage3_unit26_relu3)
        plus36          = stage3_unit26_conv3 + plus35
        stage3_unit27_bn1 = self.stage3_unit27_bn1(plus36)
        stage3_unit27_relu1 = F.relu(stage3_unit27_bn1)
        stage3_unit27_conv1 = self.stage3_unit27_conv1(stage3_unit27_relu1)
        stage3_unit27_bn2 = self.stage3_unit27_bn2(stage3_unit27_conv1)
        stage3_unit27_relu2 = F.relu(stage3_unit27_bn2)
        stage3_unit27_conv2_pad = F.pad(stage3_unit27_relu2, (1, 1, 1, 1))
        stage3_unit27_conv2 = self.stage3_unit27_conv2(stage3_unit27_conv2_pad)
        stage3_unit27_bn3 = self.stage3_unit27_bn3(stage3_unit27_conv2)
        stage3_unit27_relu3 = F.relu(stage3_unit27_bn3)
        stage3_unit27_conv3 = self.stage3_unit27_conv3(stage3_unit27_relu3)
        plus37          = stage3_unit27_conv3 + plus36
        stage3_unit28_bn1 = self.stage3_unit28_bn1(plus37)
        stage3_unit28_relu1 = F.relu(stage3_unit28_bn1)
        stage3_unit28_conv1 = self.stage3_unit28_conv1(stage3_unit28_relu1)
        stage3_unit28_bn2 = self.stage3_unit28_bn2(stage3_unit28_conv1)
        stage3_unit28_relu2 = F.relu(stage3_unit28_bn2)
        stage3_unit28_conv2_pad = F.pad(stage3_unit28_relu2, (1, 1, 1, 1))
        stage3_unit28_conv2 = self.stage3_unit28_conv2(stage3_unit28_conv2_pad)
        stage3_unit28_bn3 = self.stage3_unit28_bn3(stage3_unit28_conv2)
        stage3_unit28_relu3 = F.relu(stage3_unit28_bn3)
        stage3_unit28_conv3 = self.stage3_unit28_conv3(stage3_unit28_relu3)
        plus38          = stage3_unit28_conv3 + plus37
        stage3_unit29_bn1 = self.stage3_unit29_bn1(plus38)
        stage3_unit29_relu1 = F.relu(stage3_unit29_bn1)
        stage3_unit29_conv1 = self.stage3_unit29_conv1(stage3_unit29_relu1)
        stage3_unit29_bn2 = self.stage3_unit29_bn2(stage3_unit29_conv1)
        stage3_unit29_relu2 = F.relu(stage3_unit29_bn2)
        stage3_unit29_conv2_pad = F.pad(stage3_unit29_relu2, (1, 1, 1, 1))
        stage3_unit29_conv2 = self.stage3_unit29_conv2(stage3_unit29_conv2_pad)
        stage3_unit29_bn3 = self.stage3_unit29_bn3(stage3_unit29_conv2)
        stage3_unit29_relu3 = F.relu(stage3_unit29_bn3)
        stage3_unit29_conv3 = self.stage3_unit29_conv3(stage3_unit29_relu3)
        plus39          = stage3_unit29_conv3 + plus38
        stage3_unit30_bn1 = self.stage3_unit30_bn1(plus39)
        stage3_unit30_relu1 = F.relu(stage3_unit30_bn1)
        stage3_unit30_conv1 = self.stage3_unit30_conv1(stage3_unit30_relu1)
        stage3_unit30_bn2 = self.stage3_unit30_bn2(stage3_unit30_conv1)
        stage3_unit30_relu2 = F.relu(stage3_unit30_bn2)
        stage3_unit30_conv2_pad = F.pad(stage3_unit30_relu2, (1, 1, 1, 1))
        stage3_unit30_conv2 = self.stage3_unit30_conv2(stage3_unit30_conv2_pad)
        stage3_unit30_bn3 = self.stage3_unit30_bn3(stage3_unit30_conv2)
        stage3_unit30_relu3 = F.relu(stage3_unit30_bn3)
        stage3_unit30_conv3 = self.stage3_unit30_conv3(stage3_unit30_relu3)
        plus40          = stage3_unit30_conv3 + plus39
        stage3_unit31_bn1 = self.stage3_unit31_bn1(plus40)
        stage3_unit31_relu1 = F.relu(stage3_unit31_bn1)
        stage3_unit31_conv1 = self.stage3_unit31_conv1(stage3_unit31_relu1)
        stage3_unit31_bn2 = self.stage3_unit31_bn2(stage3_unit31_conv1)
        stage3_unit31_relu2 = F.relu(stage3_unit31_bn2)
        stage3_unit31_conv2_pad = F.pad(stage3_unit31_relu2, (1, 1, 1, 1))
        stage3_unit31_conv2 = self.stage3_unit31_conv2(stage3_unit31_conv2_pad)
        stage3_unit31_bn3 = self.stage3_unit31_bn3(stage3_unit31_conv2)
        stage3_unit31_relu3 = F.relu(stage3_unit31_bn3)
        stage3_unit31_conv3 = self.stage3_unit31_conv3(stage3_unit31_relu3)
        plus41          = stage3_unit31_conv3 + plus40
        stage3_unit32_bn1 = self.stage3_unit32_bn1(plus41)
        stage3_unit32_relu1 = F.relu(stage3_unit32_bn1)
        stage3_unit32_conv1 = self.stage3_unit32_conv1(stage3_unit32_relu1)
        stage3_unit32_bn2 = self.stage3_unit32_bn2(stage3_unit32_conv1)
        stage3_unit32_relu2 = F.relu(stage3_unit32_bn2)
        stage3_unit32_conv2_pad = F.pad(stage3_unit32_relu2, (1, 1, 1, 1))
        stage3_unit32_conv2 = self.stage3_unit32_conv2(stage3_unit32_conv2_pad)
        stage3_unit32_bn3 = self.stage3_unit32_bn3(stage3_unit32_conv2)
        stage3_unit32_relu3 = F.relu(stage3_unit32_bn3)
        stage3_unit32_conv3 = self.stage3_unit32_conv3(stage3_unit32_relu3)
        plus42          = stage3_unit32_conv3 + plus41
        stage3_unit33_bn1 = self.stage3_unit33_bn1(plus42)
        stage3_unit33_relu1 = F.relu(stage3_unit33_bn1)
        stage3_unit33_conv1 = self.stage3_unit33_conv1(stage3_unit33_relu1)
        stage3_unit33_bn2 = self.stage3_unit33_bn2(stage3_unit33_conv1)
        stage3_unit33_relu2 = F.relu(stage3_unit33_bn2)
        stage3_unit33_conv2_pad = F.pad(stage3_unit33_relu2, (1, 1, 1, 1))
        stage3_unit33_conv2 = self.stage3_unit33_conv2(stage3_unit33_conv2_pad)
        stage3_unit33_bn3 = self.stage3_unit33_bn3(stage3_unit33_conv2)
        stage3_unit33_relu3 = F.relu(stage3_unit33_bn3)
        stage3_unit33_conv3 = self.stage3_unit33_conv3(stage3_unit33_relu3)
        plus43          = stage3_unit33_conv3 + plus42
        stage3_unit34_bn1 = self.stage3_unit34_bn1(plus43)
        stage3_unit34_relu1 = F.relu(stage3_unit34_bn1)
        stage3_unit34_conv1 = self.stage3_unit34_conv1(stage3_unit34_relu1)
        stage3_unit34_bn2 = self.stage3_unit34_bn2(stage3_unit34_conv1)
        stage3_unit34_relu2 = F.relu(stage3_unit34_bn2)
        stage3_unit34_conv2_pad = F.pad(stage3_unit34_relu2, (1, 1, 1, 1))
        stage3_unit34_conv2 = self.stage3_unit34_conv2(stage3_unit34_conv2_pad)
        stage3_unit34_bn3 = self.stage3_unit34_bn3(stage3_unit34_conv2)
        stage3_unit34_relu3 = F.relu(stage3_unit34_bn3)
        stage3_unit34_conv3 = self.stage3_unit34_conv3(stage3_unit34_relu3)
        plus44          = stage3_unit34_conv3 + plus43
        stage3_unit35_bn1 = self.stage3_unit35_bn1(plus44)
        stage3_unit35_relu1 = F.relu(stage3_unit35_bn1)
        stage3_unit35_conv1 = self.stage3_unit35_conv1(stage3_unit35_relu1)
        stage3_unit35_bn2 = self.stage3_unit35_bn2(stage3_unit35_conv1)
        stage3_unit35_relu2 = F.relu(stage3_unit35_bn2)
        stage3_unit35_conv2_pad = F.pad(stage3_unit35_relu2, (1, 1, 1, 1))
        stage3_unit35_conv2 = self.stage3_unit35_conv2(stage3_unit35_conv2_pad)
        stage3_unit35_bn3 = self.stage3_unit35_bn3(stage3_unit35_conv2)
        stage3_unit35_relu3 = F.relu(stage3_unit35_bn3)
        stage3_unit35_conv3 = self.stage3_unit35_conv3(stage3_unit35_relu3)
        plus45          = stage3_unit35_conv3 + plus44
        stage3_unit36_bn1 = self.stage3_unit36_bn1(plus45)
        stage3_unit36_relu1 = F.relu(stage3_unit36_bn1)
        stage3_unit36_conv1 = self.stage3_unit36_conv1(stage3_unit36_relu1)
        stage3_unit36_bn2 = self.stage3_unit36_bn2(stage3_unit36_conv1)
        stage3_unit36_relu2 = F.relu(stage3_unit36_bn2)
        stage3_unit36_conv2_pad = F.pad(stage3_unit36_relu2, (1, 1, 1, 1))
        stage3_unit36_conv2 = self.stage3_unit36_conv2(stage3_unit36_conv2_pad)
        stage3_unit36_bn3 = self.stage3_unit36_bn3(stage3_unit36_conv2)
        stage3_unit36_relu3 = F.relu(stage3_unit36_bn3)
        stage3_unit36_conv3 = self.stage3_unit36_conv3(stage3_unit36_relu3)
        plus46          = stage3_unit36_conv3 + plus45
        stage4_unit1_bn1 = self.stage4_unit1_bn1(plus46)
        stage4_unit1_relu1 = F.relu(stage4_unit1_bn1)
        stage4_unit1_conv1 = self.stage4_unit1_conv1(stage4_unit1_relu1)
        stage4_unit1_sc = self.stage4_unit1_sc(stage4_unit1_relu1)
        stage4_unit1_bn2 = self.stage4_unit1_bn2(stage4_unit1_conv1)
        stage4_unit1_relu2 = F.relu(stage4_unit1_bn2)
        stage4_unit1_conv2_pad = F.pad(stage4_unit1_relu2, (1, 1, 1, 1))
        stage4_unit1_conv2 = self.stage4_unit1_conv2(stage4_unit1_conv2_pad)
        stage4_unit1_bn3 = self.stage4_unit1_bn3(stage4_unit1_conv2)
        stage4_unit1_relu3 = F.relu(stage4_unit1_bn3)
        stage4_unit1_conv3 = self.stage4_unit1_conv3(stage4_unit1_relu3)
        plus47          = stage4_unit1_conv3 + stage4_unit1_sc
        stage4_unit2_bn1 = self.stage4_unit2_bn1(plus47)
        stage4_unit2_relu1 = F.relu(stage4_unit2_bn1)
        stage4_unit2_conv1 = self.stage4_unit2_conv1(stage4_unit2_relu1)
        stage4_unit2_bn2 = self.stage4_unit2_bn2(stage4_unit2_conv1)
        stage4_unit2_relu2 = F.relu(stage4_unit2_bn2)
        stage4_unit2_conv2_pad = F.pad(stage4_unit2_relu2, (1, 1, 1, 1))
        stage4_unit2_conv2 = self.stage4_unit2_conv2(stage4_unit2_conv2_pad)
        stage4_unit2_bn3 = self.stage4_unit2_bn3(stage4_unit2_conv2)
        stage4_unit2_relu3 = F.relu(stage4_unit2_bn3)
        stage4_unit2_conv3 = self.stage4_unit2_conv3(stage4_unit2_relu3)
        plus48          = stage4_unit2_conv3 + plus47
        stage4_unit3_bn1 = self.stage4_unit3_bn1(plus48)
        stage4_unit3_relu1 = F.relu(stage4_unit3_bn1)
        stage4_unit3_conv1 = self.stage4_unit3_conv1(stage4_unit3_relu1)
        stage4_unit3_bn2 = self.stage4_unit3_bn2(stage4_unit3_conv1)
        stage4_unit3_relu2 = F.relu(stage4_unit3_bn2)
        stage4_unit3_conv2_pad = F.pad(stage4_unit3_relu2, (1, 1, 1, 1))
        stage4_unit3_conv2 = self.stage4_unit3_conv2(stage4_unit3_conv2_pad)
        stage4_unit3_bn3 = self.stage4_unit3_bn3(stage4_unit3_conv2)
        stage4_unit3_relu3 = F.relu(stage4_unit3_bn3)
        stage4_unit3_conv3 = self.stage4_unit3_conv3(stage4_unit3_relu3)
        plus49          = stage4_unit3_conv3 + plus48
        bn1             = self.bn1(plus49)
        relu1           = F.relu(bn1)
        pool1           = F.avg_pool2d(input = relu1, kernel_size = relu1.size()[2:])
        flatten0        = pool1.view(pool1.size(0), -1)
        fc1             = self.fc1(flatten0)
        softmax         = F.softmax(fc1)
        return softmax

    @staticmethod
    def __batch_normalization(dim, name, **kwargs):
        if   dim == 0 or dim == 1:  layer = nn.BatchNorm1d(**kwargs)
        elif dim == 2:  layer = nn.BatchNorm2d(**kwargs)
        elif dim == 3:  layer = nn.BatchNorm3d(**kwargs)
        else:           raise NotImplementedError()

        if 'scale' in __weights_dict[name]:
            layer.state_dict()['weight'].copy_(torch.from_numpy(__weights_dict[name]['scale']))
        else:
            layer.weight.data.fill_(1)

        if 'bias' in __weights_dict[name]:
            layer.state_dict()['bias'].copy_(torch.from_numpy(__weights_dict[name]['bias']))
        else:
            layer.bias.data.fill_(0)

        layer.state_dict()['running_mean'].copy_(torch.from_numpy(__weights_dict[name]['mean']))
        layer.state_dict()['running_var'].copy_(torch.from_numpy(__weights_dict[name]['var']))
        return layer

    @staticmethod
    def __conv(dim, name, **kwargs):
        if   dim == 1:  layer = nn.Conv1d(**kwargs)
        elif dim == 2:  layer = nn.Conv2d(**kwargs)
        elif dim == 3:  layer = nn.Conv3d(**kwargs)
        else:           raise NotImplementedError()

        layer.state_dict()['weight'].copy_(torch.from_numpy(__weights_dict[name]['weights']))
        if 'bias' in __weights_dict[name]:
            layer.state_dict()['bias'].copy_(torch.from_numpy(__weights_dict[name]['bias']))
        return layer

    @staticmethod
    def __dense(name, **kwargs):
        layer = nn.Linear(**kwargs)
        layer.state_dict()['weight'].copy_(torch.from_numpy(__weights_dict[name]['weights']))
        if 'bias' in __weights_dict[name]:
            layer.state_dict()['bias'].copy_(torch.from_numpy(__weights_dict[name]['bias']))
        return layer


synset_mapping = [
209,213,245,257,261,265,267,277,279,283,300,301,308,315,326,377,383,451,456,483,
511,528,552,558,575,589,592,595,596,598,609,615,616,639,644,648,650,655,667,668,
684,688,690,691,693,696,699,701,704,707,710,715,719,720,721,722,737,740,743,749,
750,755,762,769,775,780,786,791,794,803,805,806,811,812,813,814,815,816,818,825,
847,849,855,857,868,872,875,898,900,903,908,916,924,925,931,949,950,957,997,1000,
1022,1025,1026,1028,1035,1040,1041,1067,1069,1077,1083,1084,1092,1094,1098,1103,1109,1130,1139,1140,
1142,1143,1147,1149,1150,1151,1155,1165,1166,1178,1181,1186,1190,1196,1200,1203,1214,1218,1220,1233,
1240,1242,1260,1271,1313,1327,1332,1347,1357,1361,1372,1391,0,1392,1393,1394,1395,1397,1398,1400,
1402,1403,1404,1405,1406,0,0,0,1411,1413,1414,1416,1417,1418,1419,0,1420,1421,1422,1425,1426,1427,
1428,1429,1430,1431,1432,1433,1438,1440,1442,1443,1444,1445,1446,1447,1449,1450,1451,1452,1453,1454,
1456,1457,1458,1463,1464,1465,1466,1467,1469,1471,1472,1473,1474,1476,1477,1479,1480,1481,1482,1484,
1487,1489,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,1506,1507,1509,1510,1511,0,
1512,1514,1515,1517,1518,1519,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1532,1533,1534,1535,
0,1538,1539,1541,1542,1543,0,1545,1546,1547,1548,1551,1552,1553,1554,1558,1561,1562,1563,1574,1575,
1577,1579,1581,1587,1593,1600,1602,1603,1604,1606,1610,1612,1616,1618,1619,1623,1624,1648,1649,1653,
1656,1658,1661,1666,1673,1679,1700,1725,1731,1737,1740,1741,1745,1761,1765,1769,1774,1775,1785,1791,
1798,1799,1802,1803,1856,1859,1863,1870,1872,1877,1892,1895,1904,1919,1922,1925,1996,2005,2018,2022,
2023,2026,2031,2054,2058,2064,2077,2088,2098,2100,2101,2137,2139,2145,2146,2148,2150,2151,2155,2157,
2163,2166,2185,2186,2191,2195,2196,2198,2200,2201,2204,2207,2209,2210,2211,2214,2215,2216,2217,2218,
2220,2224,2227,2228,2234,2235,2239,2251,2267,2347,2349,2381,2384,2386,2397,2407,2411,2418,2423,2425,
2444,2454,2458,2468,2475,2479,2484,2511,2515,2549,2552,2616,2638,2642,2652,2656,2663,2669,2671,2676,
2677,2678,2683,2685,2687,2693,2696,2709,2719,2721,2726,2731,2732,2751,2753,2755,2760,2774,2777,2785,
2801,2803,2811,2820,2823,2830,2862,2866,2879,2890,2893,2898,2914,2920,2934,2957,2960,2967,2968,2996,
3004,3006,3018,3019,3052,3063,3090,3112,3118,3120,3121,3156,3165,3166,3168,3182,3190,3199,3207,3209,
3214,3217,3233,3242,3244,3259,3261,3262,3263,3296,3305,3307,3309,3320,3325,3337,3361,3364,3372,3379,
3409,3416,3417,3424,3447,3466,3480,3493,3505,3526,3530,3563,3564,3568,3572,3575,3576,3585,3594,3595,
3612,3617,3638,3674,3676,3687,3688,3700,3703,3714,3730,3732,3734,3751,3752,3758,3768,3814,3831,3835,
3847,3859,3886,3887,3891,3922,3925,3939,3967,3993,4021,4037,4039,4043,4058,4095,4108,4112,4123,4131,
4132,4134,4145,4149,4163,4170,4200,4222,4228,4279,4281,4284,4285,4291,4292,4297,4307,4325,4328,4333,
4344,4363,4364,4366,4373,4375,4379,4386,4387,4403,4405,4409,4413,4419,4484,4492,4494,4498,4501,4504,
4510,4534,4602,4604,4616,4625,4626,4630,4638,4639,4646,4684,4700,4711,4718,4724,4733,4742,4760,4777,
4779,4787,4789,4797,4807,4810,4816,4824,4851,4852,4855,4865,4879,4885,4886,4887,4888,4904,4915,4918,
4929,4942,4953,4954,4956,4967,4968,4990,4994,4998,5000,5014,5017,5018,5024,5027,5030,5034,5035,5036,
5039,5042,5048,5055,5056,5059,5060,5070,5075,5076,5077,5079,5086,5104,5105,5118,5120,5148,5156,5166,
5168,5171,5173,5180,5203,5215,5239,5240,5243,5250,5252,5255,5257,5261,5263,5265,5277,5292,5293,5294,
5302,5303,5311,5321,5327,5332,5344,5345,5363,5373,5380,5387,5388,5389,5390,5393,5401,5403,5407,5419,
5426,5431,5438,5444,5447,5455,5461,5474,5479,5492,5493,5495,5501,5508,5510,5531,5536,5545,5551,5564,
5567,5569,5570,5584,5592,5599,5613,5614,5620,5626,5631,5635,5642,5653,5691,5695,5702,5706,5712,5725,
5733,5742,5760,5788,5809,5812,5814,5820,5838,5842,5856,5861,5871,5887,5889,5892,5904,5906,5912,5915,
5917,5920,5934,5971,6006,6024,6026,6030,6031,6044,6048,6049,6091,6098,6111,6119,6120,6127,6150,6153,
6154,6162,6163,6164,6174,6180,6185,6188,6191,6193,6202,6210,6216,6218,6242,6246,6269,6299,6302,6303,
6314,6330,6331,6337,6342,6349,6357,6360,6371,6375,6379,6386,6394,6396,6397,6401,6419,6422,6430,6433,
6435,6436,6448,6455,6482,6495,6509,0,6533,6547,6564,6566,6574,6580,6582,6594,6607,6611,6623,6645,
6649,6659,6662,6668,6673,6688,6695,6702,6704,6707,6710,6713,6714,6731,6745,6757,6761,6767,6773,6780,
6790,6791,6796,6798,6813,6815,6832,6836,6842,6855,6856,6861,6863,6866,6869,6879,6888,6895,6927,6929,
6941,6957,6959,6964,6966,6971,6983,6988,6993,7001,7006,7023,7025,7144,7151,7155,7157,7158,7163,7181,
7215,7230,7231,7261,7324,7327,7335,7398,7442,7449,7459,7460,7485,7502,7505,7506,7513,7514,7516,7517,
7518,7519,7526,7567,7590,7614,7626,7631,7642,7657,7658,7659,7663,7679,7710,7733,7817,7828,7893,7936,
7941,7948,7972,8008,8139,8182,8186,8257,8272,8280,8284,8303,8320,8341,8356,8357,8388,8390,8589,8845,
9137,9627,9696,9858,9972,10081,10494,10680,10921,10932,10985,10989,10994,10998,11002,11048,11204]


def classifier_loader():
    return KitModel(load_model_checkpoint_bytes('resnet152-imagenet11k'))


registry.add_model(
    Model(
        name = 'resnet152-imagenet11k',
        arch = 'resnet152',
        transform = StandardTransform(img_resize_size=256, img_crop_size=224),
        normalization = StandardNormalization(mean=[0, 0, 0],
                                              std=[0.00392156862745098, 0.00392156862745098, 0.00392156862745098]),
        classifier_loader = classifier_loader,
        eval_batch_size = 10,
        classify = lambda images, model: model(images).t()[synset_mapping].t()
    )
)
