import pretrainedmodels
from torch import nn

from registry import registry
from models.model_base import Model, StandardTransform, StandardNormalization
from mldb.utils import load_model_state_dict


model_params = {
'alexnet': {   'arch': 'alexnet',
               'eval_batch_size': 256,
               'img_crop_size': 224,
               'img_resize_size': 256,
               'input_space': 'RGB',
               'mean': [0.485, 0.456, 0.406],
               'pretrained': 'imagenet',
               'std': [0.229, 0.224, 0.225]},
'bninception': {   'arch': 'bninception',
                   'eval_batch_size': 32,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'BGR',
                   'mean': [0.40784313725490196, 0.4588235294117647, 0.5019607843137255],
                   'pretrained': 'imagenet',
                   'std': [0.00392156862745098, 0.00392156862745098, 0.00392156862745098]},
'cafferesnet101': {   'arch': 'cafferesnet101',
                      'eval_batch_size': 256,
                      'img_crop_size': 224,
                      'img_resize_size': 256,
                      'input_space': 'BGR',
                      'mean': [0.40384352941176466, 0.4546921568627451, 0.4814576470588235],
                      'pretrained': 'imagenet',
                      'std': [0.00392156862745098, 0.00392156862745098, 0.00392156862745098]},
'densenet121': {   'arch': 'densenet121',
                   'eval_batch_size': 256,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'densenet161': {   'arch': 'densenet161',
                   'eval_batch_size': 256,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'densenet169': {   'arch': 'densenet169',
                   'eval_batch_size': 256,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'densenet201': {   'arch': 'densenet201',
                   'eval_batch_size': 256,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'dpn107': {   'arch': 'dpn107',
              'eval_batch_size': 16,
              'img_crop_size': 224,
              'img_resize_size': 256,
              'input_space': 'RGB',
              'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
              'pretrained': 'imagenet+5k',
              'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'dpn131': {   'arch': 'dpn131',
              'eval_batch_size': 16,
              'img_crop_size': 224,
              'img_resize_size': 256,
              'input_space': 'RGB',
              'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
              'pretrained': 'imagenet',
              'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'dpn68': {   'arch': 'dpn68',
             'eval_batch_size': 16,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
             'pretrained': 'imagenet',
             'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'dpn68b': {   'arch': 'dpn68b',
              'eval_batch_size': 16,
              'img_crop_size': 224,
              'img_resize_size': 256,
              'input_space': 'RGB',
              'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
              'pretrained': 'imagenet+5k',
              'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'dpn92': {   'arch': 'dpn92',
             'eval_batch_size': 16,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
             'pretrained': 'imagenet+5k',
             'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'dpn98': {   'arch': 'dpn98',
             'eval_batch_size': 16,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.48627450980392156, 0.4588235294117647, 0.40784313725490196],
             'pretrained': 'imagenet',
             'std': [0.23482446870963955, 0.23482446870963955, 0.23482446870963955]},
'fbresnet152': {   'arch': 'fbresnet152',
                   'eval_batch_size': 32,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'inceptionresnetv2': {   'arch': 'inceptionresnetv2',
                         'eval_batch_size': 16,
                         'img_crop_size': 299,
                         'img_resize_size': 341,
                         'input_space': 'RGB',
                         'mean': [0.5, 0.5, 0.5],
                         'pretrained': 'imagenet',
                         'std': [0.5, 0.5, 0.5]},
'inceptionv3': {   'arch': 'inceptionv3',
                   'eval_batch_size': 16,
                   'img_crop_size': 299,
                   'img_resize_size': 341,
                   'input_space': 'RGB',
                   'mean': [0.5, 0.5, 0.5],
                   'pretrained': 'imagenet',
                   'std': [0.5, 0.5, 0.5]},
'inceptionv4': {   'arch': 'inceptionv4',
                   'eval_batch_size': 16,
                   'img_crop_size': 299,
                   'img_resize_size': 341,
                   'input_space': 'RGB',
                   'mean': [0.5, 0.5, 0.5],
                   'pretrained': 'imagenet',
                   'std': [0.5, 0.5, 0.5]},
'nasnetalarge': {   'arch': 'nasnetalarge',
                    'eval_batch_size': 16,
                    'img_crop_size': 331,
                    'img_resize_size': 378,
                    'input_space': 'RGB',
                    'mean': [0.5, 0.5, 0.5],
                    'pretrained': 'imagenet',
                    'std': [0.5, 0.5, 0.5]},
'nasnetamobile': {   'arch': 'nasnetamobile',
                     'eval_batch_size': 16,
                     'img_crop_size': 224,
                     'img_resize_size': 256,
                     'input_space': 'RGB',
                     'mean': [0.5, 0.5, 0.5],
                     'pretrained': 'imagenet',
                     'std': [0.5, 0.5, 0.5]},
'pnasnet5large': {   'arch': 'pnasnet5large',
                     'eval_batch_size': 8,
                     'img_crop_size': 331,
                     'img_resize_size': 378,
                     'input_space': 'RGB',
                     'mean': [0.5, 0.5, 0.5],
                     'pretrained': 'imagenet',
                     'std': [0.5, 0.5, 0.5]},
'polynet': {   'arch': 'polynet',
               'eval_batch_size': 256,
               'img_crop_size': 331,
               'img_resize_size': 378,
               'input_space': 'RGB',
               'mean': [0.485, 0.456, 0.406],
               'pretrained': 'imagenet',
               'std': [0.229, 0.224, 0.225]},
'resnet101': {   'arch': 'resnet101',
                 'eval_batch_size': 256,
                 'img_crop_size': 224,
                 'img_resize_size': 256,
                 'input_space': 'RGB',
                 'mean': [0.485, 0.456, 0.406],
                 'pretrained': 'imagenet',
                 'std': [0.229, 0.224, 0.225]},
'resnet152': {   'arch': 'resnet152',
                 'eval_batch_size': 256,
                 'img_crop_size': 224,
                 'img_resize_size': 256,
                 'input_space': 'RGB',
                 'mean': [0.485, 0.456, 0.406],
                 'pretrained': 'imagenet',
                 'std': [0.229, 0.224, 0.225]},
'resnet18': {   'arch': 'resnet18',
                'eval_batch_size': 256,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'resnet34': {   'arch': 'resnet34',
                'eval_batch_size': 256,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'resnet50': {   'arch': 'resnet50',
                'eval_batch_size': 256,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'resnext101_32x4d': {   'arch': 'resnext101_32x4d',
                        'eval_batch_size': 256,
                        'img_crop_size': 224,
                        'img_resize_size': 256,
                        'input_space': 'RGB',
                        'mean': [0.485, 0.456, 0.406],
                        'pretrained': 'imagenet',
                        'std': [0.229, 0.224, 0.225]},
'resnext101_64x4d': {   'arch': 'resnext101_64x4d',
                        'eval_batch_size': 256,
                        'img_crop_size': 224,
                        'img_resize_size': 256,
                        'input_space': 'RGB',
                        'mean': [0.485, 0.456, 0.406],
                        'pretrained': 'imagenet',
                        'std': [0.229, 0.224, 0.225]},
'se_resnet101': {   'arch': 'se_resnet101',
                    'eval_batch_size': 256,
                    'img_crop_size': 224,
                    'img_resize_size': 256,
                    'input_space': 'RGB',
                    'mean': [0.485, 0.456, 0.406],
                    'pretrained': 'imagenet',
                    'std': [0.229, 0.224, 0.225]},
'se_resnet152': {   'arch': 'se_resnet152',
                    'eval_batch_size': 256,
                    'img_crop_size': 224,
                    'img_resize_size': 256,
                    'input_space': 'RGB',
                    'mean': [0.485, 0.456, 0.406],
                    'pretrained': 'imagenet',
                    'std': [0.229, 0.224, 0.225]},
'se_resnet50': {   'arch': 'se_resnet50',
                   'eval_batch_size': 256,
                   'img_crop_size': 224,
                   'img_resize_size': 256,
                   'input_space': 'RGB',
                   'mean': [0.485, 0.456, 0.406],
                   'pretrained': 'imagenet',
                   'std': [0.229, 0.224, 0.225]},
'se_resnext101_32x4d': {   'arch': 'se_resnext101_32x4d',
                           'eval_batch_size': 256,
                           'img_crop_size': 224,
                           'img_resize_size': 256,
                           'input_space': 'RGB',
                           'mean': [0.485, 0.456, 0.406],
                           'pretrained': 'imagenet',
                           'std': [0.229, 0.224, 0.225]},
'se_resnext50_32x4d': {   'arch': 'se_resnext50_32x4d',
                          'eval_batch_size': 256,
                          'img_crop_size': 224,
                          'img_resize_size': 256,
                          'input_space': 'RGB',
                          'mean': [0.485, 0.456, 0.406],
                          'pretrained': 'imagenet',
                          'std': [0.229, 0.224, 0.225]},
'senet154': {   'arch': 'senet154',
                'eval_batch_size': 256,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'vgg11': {   'arch': 'vgg11',
             'eval_batch_size': 32,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.485, 0.456, 0.406],
             'pretrained': 'imagenet',
             'std': [0.229, 0.224, 0.225]},
'vgg11_bn': {   'arch': 'vgg11_bn',
                'eval_batch_size': 32,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'vgg13': {   'arch': 'vgg13',
             'eval_batch_size': 32,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.485, 0.456, 0.406],
             'pretrained': 'imagenet',
             'std': [0.229, 0.224, 0.225]},
'vgg13_bn': {   'arch': 'vgg13_bn',
                'eval_batch_size': 32,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'vgg16': {   'arch': 'vgg16',
             'eval_batch_size': 32,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.485, 0.456, 0.406],
             'pretrained': 'imagenet',
             'std': [0.229, 0.224, 0.225]},
'vgg16_bn': {   'arch': 'vgg16_bn',
                'eval_batch_size': 32,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'vgg19': {   'arch': 'vgg19',
             'eval_batch_size': 32,
             'img_crop_size': 224,
             'img_resize_size': 256,
             'input_space': 'RGB',
             'mean': [0.485, 0.456, 0.406],
             'pretrained': 'imagenet',
             'std': [0.229, 0.224, 0.225]},
'vgg19_bn': {   'arch': 'vgg19_bn',
                'eval_batch_size': 32,
                'img_crop_size': 224,
                'img_resize_size': 256,
                'input_space': 'RGB',
                'mean': [0.485, 0.456, 0.406],
                'pretrained': 'imagenet',
                'std': [0.229, 0.224, 0.225]},
'xception': {   'arch': 'xception',
                'eval_batch_size': 16,
                'img_crop_size': 299,
                'img_resize_size': 341,
                'input_space': 'RGB',
                'mean': [0.5, 0.5, 0.5],
                'pretrained': 'imagenet',
                'std': [0.5, 0.5, 0.5]}}

squeezenets = {
'squeezenet1_0': {   'arch': 'squeezenet1_0',
                     'eval_batch_size': 256,
                     'img_crop_size': 224,
                     'img_resize_size': 256,
                     'input_space': 'RGB',
                     'mean': [0.485, 0.456, 0.406],
                     'pretrained': 'imagenet',
                     'std': [0.229, 0.224, 0.225]},
'squeezenet1_1': {   'arch': 'squeezenet1_1',
                     'eval_batch_size': 256,
                     'img_crop_size': 224,
                     'img_resize_size': 256,
                     'input_space': 'RGB',
                     'mean': [0.485, 0.456, 0.406],
                     'pretrained': 'imagenet',
                     'std': [0.229, 0.224, 0.225]}}


def gen_classifier_loader(name, d):
    def classifier_loader():
        model = pretrainedmodels.__dict__[d['arch']](num_classes=1000, pretrained=None)
        load_model_state_dict(model, name)
        return model
    return classifier_loader


for name, d in model_params.items():
    registry.add_model(
        Model(
            name = name,
            arch = d['arch'],
            transform = StandardTransform(d['img_resize_size'], d['img_crop_size']),
            normalization = StandardNormalization(d['mean'], d['std'], d['input_space']),
            classifier_loader = gen_classifier_loader(name, d),
            eval_batch_size = d['eval_batch_size'],
            adversarial_batch_size = d['adversarial_batch_size'] if 'adversarial_batch_size' in d else None,
        )
    )


for name, d in squeezenets.items():
    registry.add_model(
        Model(
            name = name,
            arch = d['arch'],
            transform = StandardTransform(d['img_resize_size'], d['img_crop_size']),
            classifier_loader = gen_classifier_loader(name, d),
            eval_batch_size = d['eval_batch_size'],
            normalization = StandardNormalization(d['mean'], d['std'], d['input_space']),
            adversarial_batch_size = d['adversarial_batch_size'] if 'adversarial_batch_size' in d else None,
            classify = lambda images, model: model(images).squeeze(3).squeeze(2)
        )
    )
