#
# An example of a VD for CWE131
# In this example, we target CVE-2022-26495
# https://nvd.nist.gov/vuln/detail/CVE-2022-26495
#
# The vulnerability is an integer overflow in handle_info function
# inside nbd-server.c and exists in nbd upto 3.24
# The integer overflow can lead to heap-based buffer overflow and possible arbitrary code execution
#
#
# static bool handle_info(CLIENT* client, uint32_t opt, GArray* servers, uint32_t cflags) {
#     uint32_t namelen, len;
#      ...
#     socket_read(client, &namelen, sizeof(namelen));
#     namelen = htonl(namelen);
#      ...
#     if(namelen > 0) {
#         name = malloc(namelen + 1);
#         name[namelen] = 0;
#         socket_read(client, name, namelen);
#      }
#     ...
# }
# The VD that we can generate from this information is as follows
# Sink := malloc
# Source := Return value of htonl
# Constraint := Value passed to `malloc` should not be smaller than `namelen`
#


def apply_constraint(state, expr, init_val, **kwargs):
    #
    # Here, expr represents `namelen+1`.
    # The init_val can be represented a list of values that were combined to produce `namelen`
    # It can be visualized as : [namelen, 1]
    # However, since 1 is a constant, the actual init_val looks like : [namelen]
    #
    for x in init_val:
        if x.length < expr.length:
            x = x.zero_extend(expr.length-x.length)
        state.solver.add(expr < x)
    return


def specify_sources():
    #
    # Depending upon compiler flags, the call to `htonl` may be optimized away.
    # However, for this example, the binary has been compiled with the `-g` compilation flag
    #
    return {'htonl': 0}


def specify_sinks():
    #
    # Our sink is malloc just like the CWE131 module.
    #

    maps = {'malloc': ['n']}
    return maps


def save_results(reports):
    return
