# iOS:
#   https://www.gkgigs.com/list-apple-ios-version-history/
#   https://betawiki.net/wiki/Category:IOS
# watchOS:
#   https://www.gkgigs.com/latest-watchos-version/
#   https://www.theiphonewiki.com/wiki/beta_Firmware
# macOS:
#   https://www.gkgigs.com/list-of-all-macos-version-history/
#   https://betawiki.net/wiki/Category:MacOS_versions

from os.path import join

OS_build = {
    "1A543a": "iPhone OS 1.0",
    "1C25": "iPhone OS 1.0.1",
    "1C28": "iPhone OS 1.0.2",
    "3A100a": "iPhone OS 1.1",
    "3A101a": "iPhone OS 1.1",
    "3A109a": "iPhone OS 1.1.1",
    "3A110a": "iPhone OS 1.1.1",
    "3B48b": "iPhone OS 1.1.2",
    "4A93": "iPhone OS 1.1.3",
    "4A102": "iPhone OS 1.1.4",
    "4B1": "iPhone OS 1.1.5",
    "5A147p": "iPhone OS 2.0 beta 1",
    "5A225c": "iPhone OS 2.0 beta 2",
    "5A240d": "iPhone OS 2.0 beta 3",
    "5A258f": "iPhone OS 2.0 beta 4",
    "5A345": "iPhone OS 2.0 GM",
    "5A347": "iPhone OS 2.0",
    "5B108": "iPhone OS 2.0.1",
    "5C1": "iPhone OS 2.0.2",
    "5F136": "iPhone OS 2.1",
    "5F137": "iPhone OS 2.1.1",
    "5F138": "iPhone OS 2.1.1",
    "5G77": "iPhone OS 2.2",
    "5G77a": "iPhone OS 2.2",
    "5H11": "iPhone OS 2.2.1",
    "5H11a": "iPhone OS 2.2.1",
    "7A238j": "iPhone OS 3.0 beta 1",
    "7A259g": "iPhone OS 3.0 beta 2",
    "7A280f": "iPhone OS 3.0 beta 3",
    "7A300g": "iPhone OS 3.0 beta 4",
    "7A312g": "iPhone OS 3.0 beta 5",
    "7A341": "iPhone OS 3.0",
    "7A400": "iPhone OS 3.0.1",
    "7C97d": "iPhone OS 3.1 beta 1",
    "7C106c": "iPhone OS 3.1 beta 2",
    "7C116a": "iPhone OS 3.1 beta 3",
    "7C144": "iPhone OS 3.1",
    "7C145": "iPhone OS 3.1.1",
    "7C146": "iPhone OS 3.1.1",
    "7D11": "iPhone OS 3.1.2",
    "7E18": "iPhone OS 3.1.3",
    "7B327": "iPhone OS 3.2 beta",
    "7B367": "iPhone OS 3.2",
    "7B405": "iPhone OS 3.2.1",
    "7B500": "iPhone OS 3.2.2",
    "8A230m": "iOS 4.0 beta 1",
    "8A248c": "iOS 4.0 beta 2",
    "8A260b": "iOS 4.0 beta 3",
    "8A274b": "iOS 4.0 beta 4",
    "8A293": "iOS 4.0",
    "8A306": "iOS 4.0.1",
    "8A400": "iOS 4.0.2",
    "8B5080c": "iOS 4.1 beta 1",
    "8B5091b": "iOS 4.1 beta 2",
    "8B5097d": "iOS 4.1 beta 3",
    "8B117": "iOS 4.1",
    "8B119": "iOS 4.1.1",
    "8C5091e": "iOS 4.2 beta 1",
    "8C5101c": "iOS 4.2 beta 2",
    "8C5115c": "iOS 4.2 beta 3",
    "8C134": "iOS 4.2",
    "8C148": "iOS 4.2.1",
    "8C148a": "iOS 4.2.1",
    "8C150": "iOS 4.2.2",
    "8C152": "iOS 4.2.3",
    "8C154": "iOS 4.2.4",
    "8E5074b": "iOS 4.2.5 beta 1",
    "8E5128a": "iOS 4.2.5 beta 2",
    "8E128": "iOS 4.2.5",
    "8E200": "iOS 4.2.6",
    "8E303": "iOS 4.2.7",
    "8E401": "iOS 4.2.8",
    "8E501": "iOS 4.2.9",
    "8E600": "iOS 4.2.10",
    "8F5148b": "iOS 4.3 beta 1",
    "8F5153d": "iOS 4.3 beta 2",
    "8F5166b": "iOS 4.3 beta 3",
    "8F190": "iOS 4.3",
    "8F191": "iOS 4.3",
    "8G4": "iOS 4.3.1",
    "8H7": "iOS 4.3.2",
    "8H8": "iOS 4.3.2",
    "8J2": "iOS 4.3.3",
    "8J3": "iOS 4.3.3",
    "8K2": "iOS 4.3.4",
    "8L1": "iOS 4.3.5",
    "9A5220p": "iOS 5.0 beta 1",
    "9A5248d": "iOS 5.0 beta 2",
    "9A5259f": "iOS 5.0 beta 3",
    "9A5274d": "iOS 5.0 beta 4",
    "9A5288d": "iOS 5.0 beta 5",
    "9A5302b": "iOS 5.0 beta 6",
    "9A5313e": "iOS 5.0 beta 7",
    "9A332": "iOS 5.0 GM",
    "9A334": "iOS 5.0",
    "9A402": "iOS 5.0.1 beta 1",
    "9A404": "iOS 5.0.1 beta 2",
    "9A405": "iOS 5.0.1",
    "9A406": "iOS 5.0.1",
    "9B5117b": "iOS 5.1 beta 1",
    "9B5127c": "iOS 5.1 beta 2",
    "9B5141a": "iOS 5.1 beta 3",
    "9B174": "iOS 5.1 GM",
    "9B176": "iOS 5.1",
    "9B179": "iOS 5.1",
    "9B206": "iOS 5.1.1",
    "9B208": "iOS 5.1.1",
    "10A5316k": "iOS 6.0 beta 1",
    "10A5316l": "iOS 6.0 beta 1",
    "10A5338d": "iOS 6.0 beta 2",
    "10A5355d": "iOS 6.0 beta 3",
    "10A5355e": "iOS 6.0 beta 3",
    "10A5376e": "iOS 6.0 beta 4",
    "10A5403a": "iOS 6.0 beta 5",
    "10A403": "iOS 6.0",
    "10A404": "iOS 6.0",
    "10A405": "iOS 6.0",
    "10A406": "iOS 6.0",
    "10A407": "iOS 6.0",
    "10A444": "iOS 6.0",
    "10A523": "iOS 6.0.1",
    "10A525": "iOS 6.0.1",
    "10A8426": "iOS 6.0.1",
    "10A550": "iOS 6.0.2",
    "10A551": "iOS 6.0.2",
    "10A8500": "iOS 6.0.2",
    "10B5095e": "iOS 6.1 beta 1",
    "10B5095f": "iOS 6.1 beta 1",
    "10B5105c": "iOS 6.1 beta 2",
    "10B5117b": "iOS 6.1 beta 3",
    "10B5126b": "iOS 6.1 beta 4",
    "10B137": "iOS 6.1 beta 5/GM",
    "10B141": "iOS 6.1",
    "10B142": "iOS 6.1",
    "10B143": "iOS 6.1",
    "10B144": "iOS 6.1",
    "10B5145a": "iOS 6.1.1 beta 1",
    "10B145": "iOS 6.1.1",
    "10B146": "iOS 6.1.2",
    "10B147": "iOS 6.1.2",
    "10B311": "iOS 6.1.3 beta 1",
    "10B318": "iOS 6.1.3 beta 2",
    "10B318a": "iOS 6.1.3 beta 2",
    "10B329b": "iOS 6.1.3 beta 3",
    "10B329": "iOS 6.1.3",
    "10B350": "iOS 6.1.4",
    "10B400": "iOS 6.1.5",
    "10B500": "iOS 6.1.6",
    "11A4372q": "iOS 7.0 beta 1",
    "11A4400f": "iOS 7.0 beta 2",
    "11A4414c": "iOS 7.0 beta 3",
    "11A4414e": "iOS 7.0 beta 3",
    "11A4435d": "iOS 7.0 beta 4",
    "11A4449a": "iOS 7.0 beta 5",
    "11A4449d": "iOS 7.0 beta 6",
    "11A465": "iOS 7.0",
    "11A466": "iOS 7.0",
    "11A470a": "iOS 7.0.1",
    "11A501": "iOS 7.0.2",
    "11B508": "iOS 7.0.3 beta",
    "11B511": "iOS 7.0.3",
    "11B553": "iOS 7.0.4",
    "11B554a": "iOS 7.0.4",
    "11B601": "iOS 7.0.5",
    "11B651": "iOS 7.0.6",
    "11D5099e": "iOS 7.1 beta 1",
    "11D5115d": "iOS 7.1 beta 2",
    "11D5127c": "iOS 7.1 beta 3",
    "11D5134c": "iOS 7.1 beta 4",
    "11D5145e": "iOS 7.1 beta 5",
    "11D167": "iOS 7.1",
    "11D169": "iOS 7.1",
    "11D201": "iOS 7.1.1",
    "11D257": "iOS 7.1.2",
    "12A4265u": "iOS 8.0 beta 1",
    "12A4297e": "iOS 8.0 beta 2",
    "12A4318c": "iOS 8.0 beta 3",
    "12A4331d": "iOS 8.0 beta 4",
    "12A4345d": "iOS 8.0 beta 5",
    "12A4345f": "iOS 8.0 beta 6",
    "12A4363b": "iOS 8.0 beta 7",
    "12A4365a": "iOS 8.0 beta 8",
    "12A365": "iOS 8.0",
    "12A366": "iOS 8.0",
    "12A402": "iOS 8.0.1",
    "12A405": "iOS 8.0.2",
    "12B396": "iOS 8.1 beta 1",
    "12B401": "iOS 8.1 beta 2",
    "12B407": "iOS 8.1 beta 3",
    "12B408": "iOS 8.1 beta 4",
    "12B410": "iOS 8.1",
    "12B411": "iOS 8.1",
    "12B432": "iOS 8.1.1 beta 1",
    "12B435": "iOS 8.1.1",
    "12B436": "iOS 8.1.1",
    "12B440": "iOS 8.1.2",
    "12B466": "iOS 8.1.3",
    "12D5436c": "iOS 8.2 beta 1",
    "12D5445d": "iOS 8.2 beta 2",
    "12D5452a": "iOS 8.2 beta 3",
    "12D5461b": "iOS 8.2 beta 4",
    "12D5480a": "iOS 8.2 beta 5",
    "12D506": "iOS 8.2 GM",
    "12D508": "iOS 8.2",
    "12D632": "iOS 8.2.1",
    "12F5027b": "iOS 8.3 beta 1",
    "12F5037c": "iOS 8.3 beta 2",
    "12F5047a": "iOS 8.3 beta 3",
    "12F61": "iOS 8.3 beta 4/GM",
    "12F69": "iOS 8.3",
    "12F70": "iOS 8.3",
    "12H4074d": "iOS 8.4 beta 1",
    "12H4086d": "iOS 8.4 beta 2",
    "12H4098c": "iOS 8.4 beta 3",
    "12H4125a": "iOS 8.4 beta 4",
    "12H141": "iOS 8.4 GM",
    "12H143": "iOS 8.4",
    "12H304": "iOS 8.4.1 beta 1",
    "12H318": "iOS 8.4.1 beta 2/GM",
    "12H321": "iOS 8.4.1",
    "13A4254u": "iOS 9.0 beta 1",
    "13A4254v": "iOS 9.0 beta 1",
    "13A4280e": "iOS 9.0 beta 2",
    "13A4293f": "iOS 9.0 beta 3",
    "13A4293g": "iOS 9.0 beta 3",
    "13A4305g": "iOS 9.0 beta 4",
    "13A4325a": "iOS 9.0 beta 5",
    "13A4325c": "iOS 9.0 beta 5",
    "13A4340b": "iOS 9.0 beta 6",
    "13A340": "iOS 9.0",
    "13A341": "iOS 9.0",
    "13A342": "iOS 9.0",
    "13A343": "iOS 9.0",
    "13A344": "iOS 9.0",
    "13A404": "iOS 9.0.1",
    "13A405": "iOS 9.0.1",
    "13A452": "iOS 9.0.2",
    "13B5110e": "iOS 9.1 beta 1",
    "13B5119b": "iOS 9.1 beta 2",
    "13B5130a": "iOS 9.1 beta 3",
    "13B134": "iOS 9.1 beta 4",
    "13B136": "iOS 9.1 beta 5",
    "13B137": "iOS 9.1 beta 6",
    "13B138": "iOS 9.1 beta 7",
    "13B139": "iOS 9.1 beta 8/GM",
    "13B143": "iOS 9.1",
    "13B144": "iOS 9.1.1",
    "13C5055d": "iOS 9.2 beta 1",
    "13C5060d": "iOS 9.2 beta 2",
    "13C70": "iOS 9.2 beta 3",
    "13C71": "iOS 9.2 beta 4",
    "13C75": "iOS 9.2",
    "13D11": "iOS 9.2.2 beta 1",
    "13D14": "iOS 9.2.2 beta 2/GM",
    "13D15": "iOS 9.2.1",
    "13D20": "iOS 9.2.2",
    "13E5181d": "iOS 9.3 beta 1",
    "13E5181f": "iOS 9.3 beta 1",
    "13E5191d": "iOS 9.3 beta 2",
    "13E5200d": "iOS 9.3 beta 3",
    "13E5214d": "iOS 9.3 beta 4",
    "13E5225a": "iOS 9.3 beta 5",
    "13E5230a": "iOS 9.3 beta 6",
    "13E5231a": "iOS 9.3 beta 7",
    "13E5233a": "iOS 9.3 beta 8",
    "13E5234a": "iOS 9.3 beta 9",
    "13E5235a": "iOS 9.3 beta 10",
    "13E233": "iOS 9.3",
    "13E234": "iOS 9.3",
    "13E235": "iOS 9.3",
    "13E236": "iOS 9.3",
    "13E237": "iOS 9.3",
    "13E238": "iOS 9.3.1",
    "13F51a": "iOS 9.3.2 beta 1",
    "13F61": "iOS 9.3.2 beta 2",
    "13F65": "iOS 9.3.2 beta 3",
    "13F68": "iOS 9.3.2 beta 4/GM",
    "13F69": "iOS 9.3.2",
    "13F72": "iOS 9.3.2",
    "13G12": "iOS 9.3.3 beta 1",
    "13G21": "iOS 9.3.3 beta 2",
    "13G29": "iOS 9.3.3 beta 3",
    "13G33": "iOS 9.3.3 beta 4",
    "13G34": "iOS 9.3.3",
    "13G35": "iOS 9.3.4",
    "13G36": "iOS 9.3.5",
    "13G37": "iOS 9.3.6",
    "14A5261v": "iOS 10.0 beta 1",
    "14A5297c": "iOS 10.0 beta 2",
    "14A5309d": "iOS 10.0 beta 3",
    "14A5322e": "iOS 10.0 beta 4",
    "14A5335b": "iOS 10.0 beta 5",
    "14A5341a": "iOS 10.0 beta 6",
    "14A5345a": "iOS 10.0 beta 7",
    "14A5346a": "iOS 10.0 beta 8",
    "14A346": "iOS 10.0",
    "14A403": "iOS 10.0.1",
    "14A456": "iOS 10.0.2",
    "14A551": "iOS 10.0.3",
    "14B55c": "iOS 10.1 beta 1",
    "14B67": "iOS 10.1 beta 2",
    "14B71": "iOS 10.1 beta 3",
    "14B72b": "iOS 10.1 beta 4",
    "14B72": "iOS 10.1",
    "14B72c": "iOS 10.1",
    "14B100": "iOS 10.1.1",
    "14B150": "iOS 10.1.1",
    "14C5062e": "iOS 10.2 beta 1",
    "14C5069c": "iOS 10.2 beta 2",
    "14C5077b": "iOS 10.2 beta 3",
    "14C82": "iOS 10.2 beta 4",
    "14C89": "iOS 10.2 beta 5",
    "14C90": "iOS 10.2 beta 6",
    "14C91": "iOS 10.2 beta 6",
    "14C92": "iOS 10.2",
    "14D10": " iOS 10.2.1 beta 1",
    "14D15": " iOS 10.2.1 beta 2",
    "14D23": " iOS 10.2.1 beta 3",
    "14D27": "iOS 10.2.1",
    "14E5230e": "iOS 10.3 beta 1",
    "14E5239e": "iOS 10.3 beta 2",
    "14E5249d": "iOS 10.3 beta 3",
    "14E5260b": "iOS 10.3 beta 4",
    "14E5269a": "iOS 10.3 beta 5",
    "14E5273a": "iOS 10.3 beta 6",
    "14E5277a": "iOS 10.3 beta 7",
    "14E277": "iOS 10.3",
    "14E8301": "iOS 10.3.1 beta",
    "14E304": "iOS 10.3.1",
    "14F5065b": "iOS 10.3.2 beta 1",
    "14F5075a": "iOS 10.3.2 beta 2",
    "14F5080b": "iOS 10.3.2 beta 3",
    "14F5086a": "iOS 10.3.2 beta 4",
    "14F5089a": "iOS 10.3.2 beta 5",
    "14F89": "iOS 10.3.2",
    "14F8089": "iOS 10.3.2",
    "14F90": "iOS 10.3.2",
    "14F91": "iOS 10.3.2",
    "14G5028a": "iOS 10.3.3 beta 1",
    "14G5037b": "iOS 10.3.3 beta 2",
    "14G5047a": "iOS 10.3.3 beta 3",
    "14G5053a": "iOS 10.3.3 beta 4",
    "14G5056a": "iOS 10.3.3 beta 5",
    "14G57": "iOS 10.3.3 GM",
    "14G58": "iOS 10.3.3 GM2",
    "14G60": "iOS 10.3.3",
    "14G61": "iOS 10.3.4",
    "15A5278f": "iOS 11.0 beta 1",
    "15A5304i": "iOS 11.0 beta 2",
    "15A5304j": "iOS 11.0 beta 2",
    "15A5318g": "iOS 11.0 beta 3",
    "15A5327g": "iOS 11.0 beta 4",
    "15A5341f": "iOS 11.0 beta 5",
    "15A5354b": "iOS 11.0 beta 6",
    "15A5362a": "iOS 11.0 beta 7",
    "15A5368a": "iOS 11.0 beta 8",
    "15A5370a": "iOS 11.0 beta 9",
    "15A5372a": "iOS 11.0 beta 10",
    "15A372": "iOS 11.0",
    "15A402": "iOS 11.0.1",
    "15A403": "iOS 11.0.1",
    "15A8391": "iOS 11.0.1",
    "15A421": "iOS 11.0.2",
    "15A432": "iOS 11.0.3",
    "15B5066f": "iOS 11.1 beta 1",
    "15B5078e": "iOS 11.1 beta 2",
    "15B5086a": "iOS 11.1 beta 3",
    "15B92": "iOS 11.1 beta 4",
    "15B93": "iOS 11.1",
    "15B101": "iOS 11.1",
    "15B150": "iOS 11.1.1",
    "15B202": "iOS 11.1.2",
    "15C113": "iOS 11.2",
    "15C114": "iOS 11.2",
    "15C153": "iOS 11.2.1",
    "15C202": "iOS 11.2.2",
    "15D60": "iOS 11.2.5",
    "15D100": "iOS 11.2.6",
    "15E216": "iOS 11.3",
    "15E218": "iOS 11.3",
    "15E302": "iOS 11.3.1",
    "15F79": "iOS 11.4",
    "15G77": "iOS 11.4.1",
    "16A5288q": "iOS 12.0 beta 1",
    "16A5308e": "iOS 12.0 beta 2",
    "16A5318d": "iOS 12.0 beta 3",
    "16A5327f": "iOS 12.0 beta 4",
    "16A5339e": "iOS 12.0 beta 5",
    "16A5345f": "iOS 12.0 beta 6",
    "16A5354b": "iOS 12.0 beta 7",
    "16A5357b": "iOS 12.0 beta 8",
    "16A5362a": "iOS 12.0 beta 9",
    "16A5364a": "iOS 12.0 beta 10",
    "16A5365b": "iOS 12.0 beta 11",
    "16A5366a": "iOS 12.0 beta 12",
    "16A366": "iOS 12.0",
    "16A367": "iOS 12.0",
    "16A404": "iOS 12.0.1",
    "16A405": "iOS 12.0.1",
    "16B5059d": "iOS 12.1 beta 1",
    "16B5068i": "iOS 12.1 beta 2",
    "16B5077c": "iOS 12.1 beta 3",
    "16B5084a": "iOS 12.1 beta 4",
    "16B5089b": "iOS 12.1 beta 5",
    "16B92": "iOS 12.1",
    "16B93": "iOS 12.1",
    "16B94": "iOS 12.1",
    "16C5036c": "iOS 12.1.1 beta 1",
    "16C5043b": "iOS 12.1.1 beta 2",
    "16C5049a": "iOS 12.1.1 beta 3",
    "16C5050a": "iOS 12.1.1 beta 4",
    "16C50": "iOS 12.1.1",
    "16C5101a": "iOS 12.1.2 beta",
    "16C101": "iOS 12.1.2",
    "16C104": "iOS 12.1.2",
    "16D5024a": "iOS 12.1.3 beta 1",
    "16D5032a": "iOS 12.1.3 beta 2",
    "16D5037a": "iOS 12.1.3 beta 3",
    "16D5039a": "iOS 12.1.3 beta 4",
    "16D39": "iOS 12.1.3",
    "16D40": "iOS 12.1.3",
    "16D57": "iOS 12.1.4",
    "16E5181f": "iOS 12.2 beta",
    "16E5191d": "iOS 12.2 beta 2",
    "16E5201e": "iOS 12.2 beta 3",
    "16E5212f": "iOS 12.2 beta 4",
    "16E5223a": "iOS 12.2 beta 5",
    "16E5227a": "iOS 12.2 beta 6",
    "16E5227": "iOS 12.2 Pre-release",
    "16E227": "iOS 12.2",
    "16F5117h": "iOS 12.3 beta 1",
    "16F5129d": "iOS 12.3 beta 2",
    "16F5139e": "iOS 12.3 beta 3",
    "16F5148a": "iOS 12.3 beta 4",
    "16F5155a": "iOS 12.3 beta 5",
    "16F5156a": "iOS 12.3 beta 6",
    "16F156": "iOS 12.3",
    "16F8155": "iOS 12.3",
    "16F203": "iOS 12.3.1",
    "16F8202": "iOS 12.3.1",
    "16F250": "iOS 12.3.2",
    "16G5027g": "iOS 12.4 beta",
    "16G5027i": "iOS 12.4 beta 2",
    "16G5038d": "iOS 12.4 beta 3",
    "16G5046d": "iOS 12.4 beta 4",
    "16G5056d": "iOS 12.4 beta 5",
    "16G5069a": "iOS 12.4 beta 6",
    "16G5077a": "iOS 12.4 beta 7",
    "16G77": "iOS 12.4",
    "16G102": "iOS 12.4.1",
    "16G114": "iOS 12.4.2",
    "16G130": "iOS 12.4.3",
    "16G140": "iOS 12.4.4",
    "16G161": "iOS 12.4.5",
    "16G183": "iOS 12.4.6",
    "16G192": "iOS 12.4.7",
    "16G201": "iOS 12.4.8",
    "16H5": "iOS 12.4.9",
    "16H20": "iOS 12.5",
    "16H22": "iOS 12.5.1",
    "16H30": "iOS 12.5.2",
    "16H41": "iOS 12.5.3",
    "16H50": "iOS 12.5.4",
    "16H62": "iOS 12.5.5",
    "16H71": "iOS 12.5.6",
    "16H81": "iOS 12.5.7",
    "17A5492t": "iOS 13.0 beta 1",
    "17A5508m": "iOS 13.0 beta 2",
    "17A5522f": "iOS 13.0 beta 3",
    "17A5522g": "iOS 13.0 beta 3",
    "17A5534f": "iOS 13.0 beta 4",
    "17A5547d": "iOS 13.0 beta 5",
    "17A5556d": "iOS 13.0 beta 6",
    "17A5565b": "iOS 13.0 beta 7",
    "17A5572a": "iOS 13.0 beta 8",
    "17A577": "iOS 13.0",
    "17A5821e": "iOS 13.1 beta 1",
    "17A5831c": "iOS 13.1 beta 2",
    "17A5837a": "iOS 13.1 beta 3",
    "17A5844a": "iOS 13.1 beta 4",
    "17A5844b": "iOS 13.1 beta 4",
    "17A844": "iOS 13.1",
    "17A854": "iOS 13.1.1",
    "17A860": "iOS 13.1.2",
    "17A861": "iOS 13.1.2",
    "17A878": "iOS 13.1.3",
    "17B5059g": "iOS 13.2 beta 1",
    "17B5068e": "iOS 13.2 beta 2",
    "17B5077a": "iOS 13.2 beta 3",
    "17B5084a": "iOS 13.2 beta 4",
    "17B84": "iOS 13.2",
    "17B90": "iOS 13.2.1",
    "17B102": "iOS 13.2.2",
    "17B111": "iOS 13.2.3",
    "17C5032d": "iOS 13.3 beta 1",
    "17C5038a": "iOS 13.3 beta 2",
    "17C5046a": "iOS 13.3 beta 3",
    "17C5053a": "iOS 13.3 beta 4",
    "17C54": "iOS 13.3",
    "17D5026c": " iOS 13.3.1 beta 1",
    "17D5044a": " iOS 13.3.1 beta 2",
    "17D5050a": " iOS 13.3.1 beta 3",
    "17D50": "iOS 13.3.1",
    "17E5223h": "iOS 13.4 beta 1",
    "17E5233g": "iOS 13.4 beta 2",
    "17E5241d": "iOS 13.4 beta 3",
    "17E5249a": "iOS 13.4 beta 4",
    "17E5255a": "iOS 13.4 beta 5",
    "17E255": "iOS 13.4",
    "17E8255": "iOS 13.4",
    "17E262": "iOS 13.4.1",
    "17E8258": "iOS 13.4.1",
    "17F5034c": "iOS 13.5 beta 1",
    "17F5044d": "iOS 13.5 beta 2",
    "17F5054h": "iOS 13.5 beta 3",
    "17F5065a": "iOS 13.5 beta 4",
    "17F5075": "iOS 13.5 beta 5",
    "17F75": "iOS 13.5",
    "17F80": "iOS 13.5.1",
    "17G5035d": "iOS 13.6 beta 1",
    "17G5045c": "iOS 13.6 beta 2",
    "17G5059a": "iOS 13.6 beta 3",
    "17G5068": "iOS 13.6 beta 4",
    "17G68": "iOS 13.6",
    "17G80": "iOS 13.6.1",
    "17H35": "iOS 13.7",
    "18A5301v": "iOS 14.0 beta 1",
    "18A5319i": "iOS 14.0 beta 2",
    "18A5332f": "iOS 14.0 beta 3",
    "18A5342e": "iOS 14.0 beta 4",
    "18A5351d": "iOS 14.0 beta 5",
    "18A5357e": "iOS 14.0 beta 6",
    "18A5369b": "iOS 14.0 beta 7",
    "18A5373a": "iOS 14.0 beta 8",
    "18A373": "iOS 14.0",
    "18A393": "iOS 14.0.1",
    "18A8395": "iOS 14.1",
    "18B5052h": "iOS 14.2 beta 1",
    "18B5061e": "iOS 14.2 beta 2",
    "18B5072f": "iOS 14.2 beta 3",
    "18B5083a": "iOS 14.2 beta 4",
    "18B92": "iOS 14.2",
    "18B111": "iOS 14.2",
    "18B121": "iOS 14.2.1",
    "18C5044f": "iOS 14.3 beta 1",
    "18C5054c": "iOS 14.3 beta 2",
    "18C5061a": "iOS 14.3 beta 3",
    "18C65": "iOS 14.3 RC",
    "18C66": "iOS 14.3",
    "18D5030e": "iOS 14.4 beta 1",
    "18D5043d": "iOS 14.4 beta 2",
    "18D52": "iOS 14.4",
    "18D61": "iOS 14.4.1",
    "18D70": "iOS 14.4.2",
    "18E5140j": "iOS 14.5 beta 1",
    "18E5140k": "iOS 14.5 beta 1",
    "18E5154f": "iOS 14.5 beta 2",
    "18E5164h": "iOS 14.5 beta 3",
    "18E5178a": "iOS 14.5 beta 4",
    "18E5186a": "iOS 14.5 beta 5",
    "18E5194a": "iOS 14.5 beta 6",
    "18E5198a": "iOS 14.5 beta 7",
    "18E198": "iOS 14.5",
    "18E5199a": "iOS 14.5 beta 8",
    "18E199": "iOS 14.5",
    "18E212": "iOS 14.5.1",
    "18F5046f": "iOS 14.6 beta 1",
    "18F5055b": "iOS 14.6 beta 2",
    "18F5065a": "iOS 14.6 beta 3",
    "18F71": "iOS 14.6 RC",
    "18F72": "iOS 14.6",
    "18G5023c": "iOS 14.7 beta 1",
    "18G5033e": "iOS 14.7 beta 2",
    "18G5042c": "iOS 14.7 beta 3",
    "18G5052d": "iOS 14.7 beta 4",
    "18G5063a": "iOS 14.7 beta 5",
    "18G68": "iOS 14.7 RC",
    "18G69": "iOS 14.7",
    "18G82": "iOS 14.7.1",
    "18H17": "iOS 14.8",
    "18H107": "iOS 14.8.1",
    "19A5261w": "iOS 15.0 beta 1",
    "19A5281h": "iOS 15.0 beta 2",
    "19A5281j": "iOS 15.0 beta 2",
    "19A5297e": "iOS 15.0 beta 3",
    "19A5307g": "iOS 15.0 beta 4",
    "19A5318f": "iOS 15.0 beta 5",
    "19A5325f": "iOS 15.0 beta 6",
    "19A5337a": "iOS 15.0 beta 7",
    "19A5340a": "iOS 15.0 beta 8",
    "19A341": "iOS 15.0",
    "19A342": "iOS 15.0",
    "19A344": "iOS 15.0 RC",
    "19A345": "iOS 15.0",
    "19A346": "iOS 15.0",
    "19A348": "iOS 15.0.1",
    "19A404": "iOS 15.0.2",
    "19B5042h": "iOS 15.1 beta 1",
    "19B5052f": "iOS 15.1 beta 2",
    "19B5060d": "iOS 15.1 beta 3",
    "19B5068a": "iOS 15.1 beta 4",
    "19B74": "iOS 15.1",
    "19B75": "iOS 15.1",
    "19B81": "iOS 15.1.1",
    "19C5026i": "iOS 15.2 beta 1",
    "19C5036e": "iOS 15.2 beta 2",
    "19C5044b": "iOS 15.2 beta 3",
    "19C5050b": "iOS 15.2 beta 4",
    "19C56": "iOS 15.2",
    "19C57": "iOS 15.2",
    "19C63": "iOS 15.2.1",
    "19D5026g": "iOS 15.3 beta 1",
    "19D5040e": "iOS 15.3 beta 2",
    "19D49": "iOS 15.3 RC",
    "19D50": "iOS 15.3",
    "19D52": "iOS 15.3.1",
    "19E5209h": "iOS 15.4 beta 1",
    "19E5219e": "iOS 15.4 beta 2",
    "19E5225g": "iOS 15.4 beta 3",
    "19E5235a": "iOS 15.4 beta 4",
    "19E5241a": "iOS 15.4 beta 5",
    "19E241": "iOS 15.4",
    "19E258": "iOS 15.4.1",
    "19F5047e": "iOS 15.5 beta 1",
    "19F5057e": "iOS 15.5 beta 2",
    "19F5062g": "iOS 15.5 beta 3",
    "19F5070b": "iOS 15.5 beta 4",
    "19F77": "iOS 15.5",
    "19G5027e": "iOS 15.6 beta 1",
    "19G5037d": "iOS 15.6 beta 2",
    "19G5046d": "iOS 15.6 beta 3",
    "19G5056c": "iOS 15.6 beta 4",
    "19G5063a": "iOS 15.6 beta 5",
    "19G69": "iOS 15.6 RC",
    "19G71": "iOS 15.6",
    "19G82": "iOS 15.6.1",
    "19H12": "iOS 15.7",
    "19H115": "iOS 15.7.1 RC",
    "19H117": "iOS 15.7.1",
    "19G218": "iOS 15.7.2",
    "19H307": "iOS 15.7.3",
    "19H321": "iOS 15.7.4",
    "19H332": "iOS 15.7.5",
    "19H349": "iOS 15.7.6",
    "19H357": "iOS 15.7.7",
    "19H364": "iOS 15.7.8",
    "19H365": "iOS 15.7.9",
    "19H370": "iOS 15.8",
    "19H380": "iOS 15.8.1",
    "20A5283p": "iOS 16.0 beta 1",
    "20A5303i": "iOS 16.0 beta 2",
    "20A5312g": "iOS 16.0 beta 3",
    "20A5312j": "iOS 16.0 beta 3",
    "20A5328h": "iOS 16.0 beta 4",
    "20A5339d": "iOS 16.0 beta 5",
    "20A5349b": "iOS 16.0 beta 6",
    "20A5356a": "iOS 16.0 beta 7",
    "20A5358a": "iOS 16.0 beta 8",
    "20A357": "iOS 16.0",
    "20A362": "iOS 16.0",
    "20A371": "iOS 16.0.1",
    "20A380": "iOS 16.0.2",
    "20A392": "iOS 16.0.3",
    "20B5045d": "iOS 16.1 beta 1",
    "20B5050f": "iOS 16.1 beta 2",
    "20B5056e": "iOS 16.1 beta 3",
    "20B5064c": "iOS 16.1 beta 4",
    "20B5072b": "iOS 16.1 beta 5",
    "20B79": "iOS 16.1 RC",
    "20B82": "iOS 16.1",
    "20B101": "iOS 16.1.1",
    "20B110": "iOS 16.1.2",
    "20C5032e": "iOS 16.2 beta 1",
    "20C5043e": "iOS 16.2 beta 2",
    "20C5049e": "iOS 16.2 beta 3",
    "20C5058d": "iOS 16.2 beta 4",
    "20C65": "iOS 16.2",
    "20D5024e": "iOS 16.3 beta 1",
    "20D5035i": "iOS 16.3 beta 2",
    "20D47": "iOS 16.3",
    "20D50": "iOS 16.3",
    "20D67": "iOS 16.3.1",
    "20E5212f": "iOS 16.4 beta 1",
    "20E5223e": "iOS 16.4 beta 2",
    "20E5229e": "iOS 16.4 beta 3",
    "20E5239b": "iOS 16.4 beta 4",
    "20E246": "iOS 16.4 RC",
    "20E247": "iOS 16.4",
    "20E252": "iOS 16.4.1",
    "20E772520a": "iOS 16.4.1 (a)",
    "20F5028e": "iOS 16.5 beta 1",
    "20F5039e": "iOS 16.5 beta 2",
    "20F5050f": "iOS 16.5 beta 3",
    "20F5059a": "iOS 16.5 beta 4",
    "20F65": "iOS 16.5 RC",
    "20F66": "iOS 16.5",
    "20F75": "iOS 16.5.1",
    "20F770750b": "iOS 16.5.1 (a)",
    "20F770750d": "iOS 16.5.1 (c)",
    "20G5026e": "iOS 16.6 beta 1",
    "20G5037d": "iOS 16.6 beta 2",
    "20G5047d": "iOS 16.6 beta 3",
    "20G5058d": "iOS 16.6 beta 4",
    "20G5070a": "iOS 16.6 beta 5",
    "20G75": "iOS 16.6",
    "20G81": "iOS 16.6.1",
    "20H18": "iOS 16.7 RC",
    "20H19": "iOS 16.7",
    "20H30": "iOS 16.7.1",
    "20H115": "iOS 16.7.2",
    "20H232": "iOS 16.7.3",
    "20H240": "iOS 16.7.4",
    "20H307": "iOS 16.7.5",
    "21A5248v": "iOS 17.0 beta 1",
    "21A5268h": "iOS 17.0 beta 2",
    "21A5277h": "iOS 17.0 beta 3",
    "21A5277j": "iOS 17.0 beta 3 Update",
    "21A5291h": "iOS 17.0 beta 4",
    "21A5291j": "iOS 17.0 beta 4 Update",
    "21A5303d": "iOS 17.0 beta 5",
    "21A5312c": "iOS 17.0 beta 6",
    "21A5319a": "iOS 17.0 beta 7",
    "21A5326a": "iOS 17.0 beta 8",
    "21A327": "iOS 17.0",
    "21A329": "iOS 17.0",
    "21A331": "iOS 17.0",
    "21A340": "iOS 17.0.1",
    "21A350": "iOS 17.0.2",
    "21A351": "iOS 17.0.2",
    "21A360": "iOS 17.0.3",
    "21B5045h": "iOS 17.1 beta 1",
    "21B5056e": "iOS 17.1 beta 2",
    "21B5066a": "iOS 17.1 beta 3",
    "21B74": "iOS 17.1",
    "21B77": "iOS 17.1 RC 2",
    "21B80": "iOS 17.1",
    "21B91": "iOS 17.1.1",
    "21B101": "iOS 17.1.2",
    "21C5029g": "iOS 17.2 beta 1",
    "21C5040g": "iOS 17.2 beta 2",
    "21C5046c": "iOS 17.2 beta 3",
    "21C5054b": "iOS 17.2 beta 4",
    "21C62": "iOS 17.2",
    "21C66": "iOS 17.2.1",
    "21D5026f": "iOS 17.3 beta 1",
    "21D5036c": "iOS 17.3 beta 2",
    "21D5044a": "iOS 17.3 beta 3",
    "21D50": "iOS 17.3",
    "21D61": "iOS 17.3.1",
    "21E5184i": "iOS 17.4 beta 1",
    "21E5184k": "iOS 17.4 beta 1",
    "21E5195e": "iOS 17.4 beta 2",
    "21E5200d": "iOS 17.4 beta 3",
    "21E5209b": "iOS 17.4 beta 4",
    "4K78": "Mac OS X 10.0",
    "4L8": "Mac OS X 10.0.1",
    "4L13": "Mac OS X 10.0.1",
    "4P12": "Mac OS X 10.0.2",
    "4P13": "Mac OS X 10.0.3",
    "4Q12": "Mac OS X 10.0.4",
    "4R14": "Mac OS X 10.0.4",
    "4S10": "Mac OS X 10.0.4",
    "5D15": "Mac OS X 10.1 beta",
    "5F2": "Mac OS X 10.1 beta",
    "5F7": "Mac OS X 10.1 beta",
    "5F24": "Mac OS X 10.1 beta",
    "5F26": "Mac OS X 10.1 beta",
    "5G27": "Mac OS X 10.1 beta",
    "5G48": "Mac OS X 10.1 beta",
    "5G59": "Mac OS X 10.1 beta",
    "5G64": "Mac OS X 10.1.0",
    "5M28": "Mac OS X 10.1.1",
    "5M43": "Mac OS X 10.1.1",
    "5P48": "Mac OS X 10.1.2",
    "5P63": "Mac OS X 10.1.2",
    "5Q45": "Mac OS X 10.1.3",
    "5Q83": "Mac OS X 10.1.3",
    "5Q125": "Mac OS X 10.1.4",
    "5R60": "Mac OS X 10.1.4",
    "5R106": "Mac OS X 10.1.4",
    "5S60": "Mac OS X 10.1.5",
    "6C35": "Mac OS X 10.2.0 beta",
    "6C115": "Mac OS X 10.2.0",
    "6C115a": "Mac OS X 10.2.0",
    "6D52": "Mac OS X 10.2.1",
    "6F21": "Mac OS X 10.2.2",
    "6G30": "Mac OS X 10.2.3",
    "6H28": "Mac OS X 10.2.3",
    "6H30": "Mac OS X 10.2.3",
    "6G37": "Mac OS X 10.2.3",
    "6G50": "Mac OS X 10.2.3",
    "6H58": "Mac OS X 10.2.3",
    "6H60": "Mac OS X 10.2.3",
    "6I32": "Mac OS X 10.2.4",
    "6I34": "Mac OS X 10.2.4",
    "6L29": "Mac OS X 10.2.5",
    "6J73": "Mac OS X 10.2.5",
    "6L60": "Mac OS X 10.2.6",
    "6R42": "Mac OS X 10.2.7",
    "6R49": "Mac OS X 10.2.7",
    "6R52": "Mac OS X 10.2.7",
    "6R55": "Mac OS X 10.2.7",
    "6R65": "Mac OS X 10.2.7",
    "6S80": "Mac OS X 10.2.7",
    "6R73": "Mac OS X 10.2.8",
    "6S90": "Mac OS X 10.2.8",
    "7A179": "Mac OS X 10.3.0 beta",
    "7B85": "Mac OS X 10.3.0",
    "7B86": "Mac OS X 10.3.0",
    "7C9": "Mac OS X 10.3.0",
    "7C107": "Mac OS X 10.3.1",
    "7C150": "Mac OS X 10.3.1",
    "7D15": "Mac OS X 10.3.2",
    "7D24": "Mac OS X 10.3.2",
    "7D28": "Mac OS X 10.3.2",
    "7F44": "Mac OS X 10.3.3",
    "7G21": "Mac OS X 10.3.3",
    "7G33": "Mac OS X 10.3.3",
    "7G43": "Mac OS X 10.3.3",
    "7G51": "Mac OS X 10.3.3",
    "7H63": "Mac OS X 10.3.4",
    "7L18": "Mac OS X 10.3.4",
    "7L32": "Mac OS X 10.3.4",
    "7L33": "Mac OS X 10.3.4",
    "7L46": "Mac OS X 10.3.4",
    "7M34": "Mac OS X 10.3.5",
    "7P35": "Mac OS X 10.3.5",
    "7P134": "Mac OS X 10.3.5",
    "7P216": "Mac OS X 10.3.5",
    "7R28": "Mac OS X 10.3.6",
    "7S215": "Mac OS X 10.3.7",
    "7T11": "Mac OS X 10.3.7",
    "7T21": "Mac OS X 10.3.7",
    "7T51": "Mac OS X 10.3.7",
    "7T52": "Mac OS X 10.3.7",
    "7T62": "Mac OS X 10.3.7",
    "7U16": "Mac OS X 10.3.8",
    "7W98": "Mac OS X 10.3.9",
    "8A162": "Mac OS X 10.4.0 beta",
    "8A171": "Mac OS X 10.4.0 beta",
    "8A297": "Mac OS X 10.4.0 Server beta",
    "8A351": "Mac OS X 10.4.0 Server beta",
    "8A369": "Mac OS X 10.4.0 beta",
    "8A425": "Mac OS X 10.4.0 beta",
    "8A428": "Mac OS X 10.4.0",
    "8A432": "Mac OS X 10.4.0",
    "8B15": "Mac OS X 10.4.1",
    "8B17": "Mac OS X 10.4.1 Server",
    "8B1025": "Mac OS X 10.4.1",
    "8C46": "Mac OS X 10.4.2",
    "8C47": "Mac OS X 10.4.2",
    "8C64": "Mac OS X 10.4.2",
    "8D37": "Mac OS X 10.4.2",
    "8D40": "Mac OS X 10.4.2",
    "8D46": "Mac OS X 10.4.2",
    "8D47": "Mac OS X 10.4.2 Server",
    "8E90A": "Mac OS X 10.4.2",
    "8E102": "Mac OS X 10.4.2",
    "8E104": "Mac OS X 10.4.2",
    "8E45": "Mac OS X 10.4.2",
    "8E90": "Mac OS X 10.4.2",
    "8F46": "Mac OS X 10.4.3",
    "8F1099": "Mac OS X 10.4.3",
    "8F1111": "Mac OS X 10.4.3",
    "8G32": "Mac OS X 10.4.4",
    "8G1165": "Mac OS X 10.4.4",
    "8G1171": "Mac OS X 10.4.4",
    "8G1172": "Mac OS X 10.4.4",
    "8G1453": "Mac OS X 10.4.5",
    "8G1454": "Mac OS X 10.4.5",
    "8H14": "Mac OS X 10.4.5",
    "8H1619": "Mac OS X 10.4.5",
    "8I127": "Mac OS X 10.4.6",
    "8I1119": "Mac OS X 10.4.6",
    "8I1121": "Mac OS X 10.4.6",
    "8I2025": "Mac OS X 10.4.6",
    "8I2032": "Mac OS X 10.4.6",
    "8I2040": "Mac OS X 10.4.6",
    "8I2057": "Mac OS X 10.4.6",
    "8J135": "Mac OS X 10.4.7",
    "8J2135a": "Mac OS X 10.4.7",
    "8K1106": "Mac OS X 10.4.7",
    "8K1123": "Mac OS X 10.4.7",
    "8K1079": "Mac OS X 10.4.7 Server",
    "8N5107": "Mac OS X 10.4.7",
    "8L127": "Mac OS X 10.4.8",
    "8L2127": "Mac OS X 10.4.8",
    "8N1037": "Mac OS X 10.4.8",
    "8N1051": "Mac OS X 10.4.8",
    "8N1108": "Mac OS X 10.4.8",
    "8N1150": "Mac OS X 10.4.8",
    "8N1215": "Mac OS X 10.4.8",
    "8N1250": "Mac OS X 10.4.8",
    "8N1430": "Mac OS X 10.4.8",
    "8P135": "Mac OS X 10.4.9",
    "8P2137": "Mac OS X 10.4.9",
    "8P4037": "Mac OS X 10.4.9",
    "8P4112": "Mac OS X 10.4.9",
    "8Q1058": "Mac OS X 10.4.9",
    "8R218": "Mac OS X 10.4.10",
    "8R2218": "Mac OS X 10.4.10",
    "8R2232": "Mac OS X 10.4.10 Server",
    "8R3014": "Mac OS X 10.4.10",
    "8R3025": "Mac OS X 10.4.10",
    "8R3032": "Mac OS X 10.4.10",
    "8R3041": "Mac OS X 10.4.10",
    "8R4031": "Mac OS X 10.4.10",
    "8R4049": "Mac OS X 10.4.10",
    "8R4061a": "Mac OS X 10.4.10",
    "8R4088": "Mac OS X 10.4.10",
    "8S165": "Mac OS X 10.4.11",
    "8S2165": "Mac OS X 10.4.11",
    "8S2167": "Mac OS X 10.4.11",
    "8S2169": "Mac OS X 10.4.11 Server",
    "9A241": "Mac OS X 10.5.0 beta",
    "9Z1554": "Mac OS X 10.5.0 beta",
    "9A303": "Mac OS X 10.5.0 beta",
    "9A321": "Mac OS X 10.5.0 beta",
    "9A343": "Mac OS X 10.5.0 beta",
    "9A410": "Mac OS X 10.5.0 beta",
    "9A466": "Mac OS X 10.5.0 beta",
    "9A499": "Mac OS X 10.5.0 beta",
    "9A528a": "Mac OS X 10.5.0 Server beta",
    "9A559": "Mac OS X 10.5.0 beta",
    "9A3110": "Mac OS X 10.5.0",
    "9A3111": "Mac OS X 10.5.0",
    "9A3115A": "Mac OS X 10.5.0",
    "9A3129": "Mac OS X 10.5.0",
    "9A581": "Mac OS X 10.5.0",
    "9B18": "Mac OS X 10.5.1",
    "9B2117": "Mac OS X 10.5.1",
    "9B2324": "Mac OS X 10.5.1",
    "9C2015": "Mac OS X 10.5.2",
    "9C2018": "Mac OS X 10.5.2",
    "9C2028": "Mac OS X 10.5.2",
    "9C2031": "Mac OS X 10.5.2",
    "9C3033": "Mac OS X 10.5.2",
    "9C31": "Mac OS X 10.5.2",
    "9C7010": "Mac OS X 10.5.2",
    "9D34": "Mac OS X 10.5.3",
    "9E17": "Mac OS X 10.5.4",
    "9F2088": "Mac OS X 10.5.5",
    "9F2114": "Mac OS X 10.5.5",
    "9F2523": "Mac OS X 10.5.5",
    "9F2533": "Mac OS X 10.5.5",
    "9F33": "Mac OS X 10.5.5",
    "9G2030": "Mac OS X 10.5.6",
    "9G2110": "Mac OS X 10.5.6",
    "9G2133": "Mac OS X 10.5.6",
    "9G2141": "Mac OS X 10.5.6",
    "9G2152": "Mac OS X 10.5.6",
    "9G3553": "Mac OS X 10.5.6",
    "9G3556": "Mac OS X 10.5.6",
    "9G55": "Mac OS X 10.5.6",
    "9G66": "Mac OS X 10.5.6",
    "9G71": "Mac OS X 10.5.6",
    "9J3032": "Mac OS X 10.5.7",
    "9J3050": "Mac OS X 10.5.7",
    "9J61": "Mac OS X 10.5.7",
    "9L30": "Mac OS X 10.5.8",
    "9L34": "Mac OS X 10.5.8 Server",
    "10A96": "Mac OS X 10.6.0 WWDC '08 build",
    "10A190": "Mac OS X 10.6.0 beta 1",
    "10A222": "Mac OS X 10.6.0 beta 2",
    "10A261": "Mac OS X 10.6.0 beta 3",
    "10A286": "Mac OS X 10.6.0 beta 4",
    "10A314": "Mac OS X 10.6.0 beta 5",
    "10A354": "Mac OS X 10.6.0 beta 7",
    "10A380": "Mac OS X 10.6.0 WWDC '09 build",
    "10A403": "Mac OS X 10.6.0 Server beta",
    "10A432": "Mac OS X 10.6.0",
    "10A433": "Mac OS X 10.6.0 Server",
    "10A2047": "Mac OS X 10.6.1",
    "10A2062": "Mac OS X 10.6.1",
    "10A2155": "Mac OS X 10.6.1",
    "10B504": "Mac OS X 10.6.1",
    "10C540": "Mac OS X 10.6.2",
    "10C2234": "Mac OS X 10.6.2",
    "10D573": "Mac OS X 10.6.3",
    "10D575": "Mac OS X 10.6.3",
    "10D578": "Mac OS X 10.6.3",
    "10D2063a": "Mac OS X 10.6.3",
    "10D2094": "Mac OS X 10.6.3",
    "10D2125": "Mac OS X 10.6.3",
    "10D2162": "Mac OS X 10.6.3",
    "10D2235": "Mac OS X 10.6.3",
    "10D2322a": "Mac OS X 10.6.3",
    "10F569": "Mac OS X 10.6.4",
    "10F2056": "Mac OS X 10.6.4",
    "10F2061": "Mac OS X 10.6.4",
    "10F2090": "Mac OS X 10.6.4",
    "10F2108": "Mac OS X 10.6.4",
    "10F2521": "Mac OS X 10.6.4",
    "10F2554": "Mac OS X 10.6.4",
    "10F3061": "Mac OS X 10.6.4",
    "10H574": "Mac OS X 10.6.5",
    "10H717": "Mac OS X 10.6.5",
    "10J567": "Mac OS X 10.6.6",
    "10J3210": "Mac OS X 10.6.6",
    "10J4026": "Mac OS X 10.6.6",
    "10J869": "Mac OS X 10.6.7",
    "10J3250": "Mac OS X 10.6.7",
    "10J4138": "Mac OS X 10.6.7",
    "10J4139": "Mac OS X 10.6.7",
    "10K540": "Mac OS X 10.6.8",
    "10K549": "Mac OS X 10.6.8",
    "11A390": "Mac OS X 10.7.0 Preview 1",
    "11A419": "Mac OS X 10.7.0 Preview 2",
    "11A430e": "Mac OS X 10.7.0 Preview 2",
    "11A444d": "Mac OS X 10.7.0 Preview 2",
    "11A459e": "Mac OS X 10.7.0 Preview 3",
    "11A480b": "Mac OS X 10.7.0 Preview 4",
    "11A494a": "Mac OS X 10.7.0 Preview 4",
    "11A496a": "Mac OS X 10.7.0 Preview 4",
    "11A511a": "Mac OS X 10.7.0 Preview 5",
    "11A511": "Mac OS X 10.7.0",
    "11A511s": "Mac OS X 10.7.0",
    "11A2061": "Mac OS X 10.7.0",
    "11A2063": "Mac OS X 10.7.0",
    "11B26": "Mac OS X 10.7.1",
    "11B2118": "Mac OS X 10.7.1",
    "11C26": "Mac OS X 10.7.2 beta 1",
    "11C35": "Mac OS X 10.7.2 beta 2",
    "11C37": "Mac OS X 10.7.2 beta 3",
    "11C40": "Mac OS X 10.7.2 beta 4",
    "11C43": "Mac OS X 10.7.2 beta 5",
    "11C48": "Mac OS X 10.7.2 beta 6",
    "11C55": "Mac OS X 10.7.2 beta 7",
    "11C57": "Mac OS X 10.7.2 beta 8",
    "11C62": "Mac OS X 10.7.2 beta 9",
    "11C71": "Mac OS X 10.7.2 beta 10",
    "11C73": "Mac OS X 10.7.2 GM",
    "11C74": "Mac OS X 10.7.2",
    "11D16": "Mac OS X 10.7.3 beta 1",
    "11D24": "Mac OS X 10.7.3 beta 2",
    "11D33": "Mac OS X 10.7.3 beta 3",
    "11D36": "Mac OS X 10.7.3 beta 4",
    "11D42": "Mac OS X 10.7.3 beta 5",
    "11D46": "Mac OS X 10.7.3 beta 6",
    "11D50": "Mac OS X 10.7.3",
    "11D50b": "Mac OS X 10.7.3",
    "11D2001": "Mac OS X 10.7.3",
    "11E27": "Mac OS X 10.7.4 beta 1",
    "11E35": "Mac OS X 10.7.4 beta 2",
    "11E46": "Mac OS X 10.7.4 beta 3",
    "11E52": "Mac OS X 10.7.4 beta 4",
    "11E53": "Mac OS X 10.7.4",
    "11E54": "Mac OS X 10.7.4",
    "11E2068": "Mac OS X 10.7.4",
    "11E2617": "Mac OS X 10.7.4",
    "11E2705": "Mac OS X 10.7.4",
    "11G15": "Mac OS X 10.7.5 beta 1",
    "11G30": "Mac OS X 10.7.5 beta 2",
    "11G36": "Mac OS X 10.7.5 beta 3",
    "11G45": "Mac OS X 10.7.5 beta 4",
    "11G54": "Mac OS X 10.7.5 beta 5",
    "11G56": "Mac OS X 10.7.5",
    "11G63": "Mac OS X 10.7.5",
    "12A128p": "OS X 10.8.0 beta 1",
    "12A154q": "OS X 10.8.0 beta 2",
    "12A178q": "OS X 10.8.0 beta 3",
    "12A193i": "OS X 10.8.0 beta 4",
    "12A206j": "OS X 10.8.0 beta 5",
    "12A239": "OS X 10.8.0 beta 6",
    "12A248": "OS X 10.8.0 beta 7",
    "12A256": "OS X 10.8.0 beta 8",
    "12A269": "OS X 10.8.0",
    "12B13": "OS X 10.8.1 beta 1",
    "12B17": "OS X 10.8.1 beta 2",
    "12B19": "OS X 10.8.1",
    "12B2100": "OS X 10.8.1",
    "12C54": "OS X 10.8.2",
    "12C60": "OS X 10.8.2",
    "12C2034": "OS X 10.8.2",
    "12C3103": "OS X 10.8.2",
    "12C3104": "OS X 10.8.2",
    "12D78": "OS X 10.8.3",
    "12E55": "OS X 10.8.4",
    "12E3067": "OS X 10.8.4",
    "12E4022": "OS X 10.8.4",
    "12F37": "OS X 10.8.5",
    "12F45": "OS X 10.8.5",
    "12F2029": "OS X 10.8.5",
    "12F2501": "OS X 10.8.5",
    "12F2518": "OS X 10.8.5",
    "12F2542": "OS X 10.8.5",
    "12F2560": "OS X 10.8.5",
    "13A476u": "OS X 10.9.0 beta 1",
    "13A497d": "OS X 10.9.0 beta 2",
    "13A510d": "OS X 10.9.0 beta 3",
    "13A524d": "OS X 10.9.0 beta 4",
    "13A538g": "OS X 10.9.0 beta 5",
    "13A558": "OS X 10.9.0 beta 6",
    "13A569": "OS X 10.9.0 beta 7",
    "13A584": "OS X 10.9.0 beta 8",
    "13A598": "OS X 10.9.0 beta 9/GM",
    "13A603": "OS X 10.9.0",
    "13A2093": "OS X 10.9.0",
    "13A3017": "OS X 10.9.0",
    "13A4023": "OS X 10.9.0",
    "13B27": "OS X 10.9.1 beta 1",
    "13B35": "OS X 10.9.1 beta 2",
    "13B40": "OS X 10.9.1 beta 3",
    "13B42": "OS X 10.9.1",
    "13B3116": "OS X 10.9.1",
    "13C32": "OS X 10.9.2 beta 1",
    "13C39": "OS X 10.9.2 beta 2",
    "13C44": "OS X 10.9.2 beta 3",
    "13C48": "OS X 10.9.2 beta 4",
    "13C53": "OS X 10.9.2 beta 5",
    "13C59": "OS X 10.9.2 beta 6",
    "13C62": "OS X 10.9.2 beta 7",
    "13C64": "OS X 10.9.2",
    "13C1021": "OS X 10.9.2",
    "13D12": "OS X 10.9.3 beta 1",
    "13D17": "OS X 10.9.3 beta 2",
    "13D21": "OS X 10.9.3 beta 3",
    "13D28": "OS X 10.9.3 beta 4",
    "13D33": "OS X 10.9.3 beta 5",
    "13D38": "OS X 10.9.3 beta 6",
    "13D43": "OS X 10.9.3 beta 7",
    "13D45": "OS X 10.9.3 beta 8",
    "13D55": "OS X 10.9.3 beta 9",
    "13D57": "OS X 10.9.3 beta 10",
    "13D59": "OS X 10.9.3 beta 11",
    "13D61": "OS X 10.9.3 beta 12",
    "13D62": "OS X 10.9.3 beta 13",
    "13D65": "OS X 10.9.3",
    "13D2061": "OS X 10.9.3",
    "13E9": "OS X 10.9.4 beta 1",
    "13E16": "OS X 10.9.4 beta 2",
    "13E19": "OS X 10.9.4 beta 3",
    "13E25": "OS X 10.9.4 beta 4",
    "13E28": "OS X 10.9.4",
    "13F7": "OS X 10.9.5 beta 1",
    "13F12": "OS X 10.9.5 beta 2",
    "13F14": "OS X 10.9.5 beta 3",
    "13F18": "OS X 10.9.5 beta 4",
    "13F24": "OS X 10.9.5 beta 5",
    "13F25": "OS X 10.9.5 beta 6",
    "13F26": "OS X 10.9.5 beta 7",
    "13F31": "OS X 10.9.5 beta 8",
    "13F32": "OS X 10.9.5 beta 9",
    "13F34": "OS X 10.9.5 beta 10",
    "13F35": "OS X 10.9.5",
    "13F1066": "OS X 10.9.5",
    "13F1077": "OS X 10.9.5",
    "13F1096": "OS X 10.9.5",
    "13F1112": "OS X 10.9.5",
    "13F1134": "OS X 10.9.5",
    "13F1507": "OS X 10.9.5",
    "13F1603": "OS X 10.9.5",
    "13F1712": "OS X 10.9.5",
    "13F1808": "OS X 10.9.5",
    "13F1911": "OS X 10.9.5",
    "14A238x": "OS X 10.10.0 Preview 1",
    "14A261n": "OS X 10.10.0 Preview 2",
    "14A283o": "OS X 10.10.0 Preview 3",
    "14A298i": "OS X 10.10.0 Preview 4",
    "14A299l": "OS X 10.10.0 Preview 4",
    "14A314h": "OS X 10.10.0 Preview 5",
    "14A314i": "OS X 10.10.0 Preview 5",
    "14A329f": "OS X 10.10.0 Preview 6",
    "14A329r": "OS X 10.10.0 Preview 6",
    "14A343f": "OS X 10.10.0 Preview 7",
    "14A361c": "OS X 10.10.0 Preview 8",
    "14A364p": "OS X 10.10.0 Preview 8",
    "14A378a": "OS X 10.10.0 Preview 9",
    "14A378b": "OS X 10.10.0 Public Beta 4",
    "14A379a": "OS X 10.10.0 GM 1",
    "14A379b": "OS X 10.10.0 Public Beta 4",
    "14A386a": "OS X 10.10.0 GM 2",
    "14A386b": "OS X 10.10.0 Public Beta 5",
    "14A388a": "OS X 10.10.0 GM 3",
    "14A388b": "OS X 10.10.0 Public Beta 6",
    "14A389a": "OS X 10.10.0 GM 4",
    "14A389b": "OS X 10.10.0 Public Beta 7",
    "14A389": "OS X 10.10.0",
    "14B25": "OS X 10.10.1",
    "14C109": "OS X 10.10.2",
    "14C500": "OS X 10.10.2",
    "14C1510": "OS X 10.10.2",
    "14C1514": "OS X 10.10.2",
    "14C2043": "OS X 10.10.2",
    "14C2055": "OS X 10.10.2",
    "14C2061": "OS X 10.10.2",
    "14C2513": "OS X 10.10.2",
    "14D131": "OS X 10.10.3",
    "14D136": "OS X 10.10.3",
    "14D2134": "OS X 10.10.3",
    "14E46": "OS X 10.10.4",
    "14F27": "OS X 10.10.5",
    "14F1021": "OS X 10.10.5",
    "14F1505": "OS X 10.10.5",
    "14F1509": "OS X 10.10.5",
    "14F1605": "OS X 10.10.5",
    "14F1713": "OS X 10.10.5",
    "14F1808": "OS X 10.10.5",
    "14F1909": "OS X 10.10.5",
    "14F1912": "OS X 10.10.5",
    "14F2009": "OS X 10.10.5",
    "14F2109": "OS X 10.10.5",
    "14F2315": "OS X 10.10.5",
    "14F2411": "OS X 10.10.5",
    "14F2511": "OS X 10.10.5",
    "15A178w": "OS X 10.11.0 beta 1",
    "15A204f": "OS X 10.11.0 beta 2",
    "15A204h": "OS X 10.11.0 beta 2",
    "15A215h": "OS X 10.11.0 beta 3",
    "15A216g": "OS X 10.11.0 beta 3",
    "15A225f": "OS X 10.11.0 beta 4",
    "15A226f": "OS X 10.11.0 beta 4",
    "15A234d": "OS X 10.11.0 beta 5",
    "15A235d": "OS X 10.11.0 beta 5",
    "15A235e": "OS X 10.11.0 beta 5",
    "15A243d": "OS X 10.11.0 beta 6",
    "15A244d": "OS X 10.11.0 beta 6",
    "15A244e": "OS X 10.11.0 beta 6",
    "15A262c": "OS X 10.11.0 beta 7",
    "15A263c": "OS X 10.11.0 beta 7",
    "15A263e": "OS X 10.11.0 beta 7",
    "15A278b": "OS X 10.11.0 beta 8",
    "15A279b": "OS X 10.11.0 beta 8",
    "15A279d": "OS X 10.11.0 beta 8",
    "15A282a": "OS X 10.11.0 beta 9/GM 1",
    "15A282b": "OS X 10.11.0 beta 9.1/GM 1.1",
    "15A282c": "OS X 10.11.0 beta 9.2/GM 1.2",
    "15A284": "OS X 10.11.0",
    "15A2301": "OS X 10.11.0",
    "15A4310": "OS X 10.11.0",
    "15B17c": "OS X 10.11.1 beta 1",
    "15B22d": "OS X 10.11.1 beta 2",
    "15B30a": "OS X 10.11.1 beta 3",
    "15B38b": "OS X 10.11.1 beta 4",
    "15B42a": "OS X 10.11.1 beta 5",
    "15B42": "OS X 10.11.1",
    "15C27e": "OS X 10.11.2 beta 1",
    "15C31f": "OS X 10.11.2 beta 2",
    "15C40a": "OS X 10.11.2 beta 3",
    "15C47a": "OS X 10.11.2 beta 4",
    "15C48a": "OS X 10.11.2 beta 5",
    "15C50a": "OS X 10.11.2 beta 6",
    "15C50": "OS X 10.11.2",
    "15D9c": "OS X 10.11.3 beta 1",
    "15D13b": "OS X 10.11.3 beta 2",
    "15D21a": "OS X 10.11.3 beta 3",
    "15D21": "OS X 10.11.3",
    "15E27c": "OS X 10.11.4 beta 1",
    "15E27e": "OS X 10.11.4 beta 1",
    "15E33e": "OS X 10.11.4 beta 2",
    "15E39c": "OS X 10.11.4 beta 3",
    "15E39d": "OS X 10.11.4 beta 3.1",
    "15E49a": "OS X 10.11.4 beta 4",
    "15E56a": "OS X 10.11.4 beta 5",
    "15E61b": "OS X 10.11.4 beta 6",
    "15E64a": "OS X 10.11.4 beta 7",
    "15E65a": "OS X 10.11.4 beta 8",
    "15E65": "OS X 10.11.4",
    "15E2066": "OS X 10.11.4",
    "15F18b": "OS X 10.11.5 beta 1",
    "15F24b": "OS X 10.11.5 beta 2",
    "15F28b": "OS X 10.11.5 beta 3",
    "15F31a": "OS X 10.11.5 beta 4",
    "15F34a": "OS X 10.11.5 beta 5",
    "15F34": "OS X 10.11.5",
    "15G7a": "OS X 10.11.6 beta 1",
    "15G12a": "OS X 10.11.6 beta 2",
    "15G19a": "OS X 10.11.6 beta 3",
    "15G24b": "OS X 10.11.6 beta 4",
    "15G26a": "OS X 10.11.6 beta 5",
    "15G31a": "OS X 10.11.6 beta 6",
    "15G31": "OS X 10.11.6",
    "15G1004": "OS X 10.11.6",
    "15G1011": "OS X 10.11.6",
    "15G1108": "OS X 10.11.6",
    "15G1212": "OS X 10.11.6",
    "15G1217": "OS X 10.11.6",
    "15G1421": "OS X 10.11.6",
    "15G1510": "OS X 10.11.6",
    "15G1611": "OS X 10.11.6",
    "15G17023": "OS X 10.11.6",
    "15G18013": "OS X 10.11.6",
    "15G19009": "OS X 10.11.6",
    "15G20015": "OS X 10.11.6",
    "15G21013": "OS X 10.11.6",
    "15G22010": "OS X 10.11.6",
    "16A201w": "macOS 10.12.0 beta 1",
    "16A202w": "macOS 10.12.0 beta 1",
    "16A238m": "macOS 10.12.0 Public Beta 1",
    "16A239j": "macOS 10.12.0 beta 2",
    "16A240m": "macOS 10.12.0 beta 2",
    "16A254g": "macOS 10.12.0 beta 3",
    "16A269f": "macOS 10.12.0 Public Beta 3",
    "16A270f": "macOS 10.12.0 beta 4",
    "16A271f": "macOS 10.12.0 beta 4",
    "16A284a": "macOS 10.12.0 Public Beta 4",
    "16A285a": "macOS 10.12.0 Public Beta 4",
    "16A286a": "macOS 10.12.0 beta 5",
    "16A293a": "macOS 10.12.0 Public Beta 5",
    "16A294a": "macOS 10.12.0 beta 6",
    "16A295a": "macOS 10.12.0 beta 6",
    "16A303a": "macOS 10.12.0 Public Beta 6",
    "16A304a": "macOS 10.12.0 beta 7",
    "16A312a": "macOS 10.12.0 Public Beta 7",
    "16A313a": "macOS 10.12.0 beta 8",
    "16A319": "macOS 10.12.0 GM 2",
    "16A320": "macOS 10.12.0 GM 3",
    "16A321": "macOS 10.12.0 GM 4",
    "16A322": "macOS 10.12.0 GM 5",
    "16A323": "macOS 10.12.0",
    "16A2323a": "macOS 10.12.0",
    "16B2327e": "macOS 10.12.1 beta 1",
    "16B2333a": "macOS 10.12.1 beta 2",
    "16B2338c": "macOS 10.12.1 beta 3",
    "16B2548a": "macOS 10.12.1 beta 4",
    "16B2553a": "macOS 10.12.1 beta 5",
    "16B2555": "macOS 10.12.1",
    "16B2557": "macOS 10.12.1",
    "16B2657": "macOS 10.12.1",
    "16B2659": "macOS 10.12.1",
    "16C32e": "macOS 10.12.2 beta 1",
    "16C32f": "macOS 10.12.2 beta 1.1",
    "16C41b": "macOS 10.12.2 beta 2",
    "16C48b": "macOS 10.12.2 beta 3",
    "16C53a": "macOS 10.12.2 beta 4",
    "16C60b": "macOS 10.12.2 beta 5",
    "16C63a": "macOS 10.12.2 beta 6",
    "16C66a": "macOS 10.12.2 beta 7",
    "16C67": "macOS 10.12.2",
    "16C68": "macOS 10.12.2",
    "16D12b": "macOS 10.12.3 beta 1",
    "16D17a": "macOS 10.12.3 beta 2",
    "16D25a": "macOS 10.12.3 beta 3",
    "16D30a": "macOS 10.12.3 beta 4",
    "16D32": "macOS 10.12.3",
    "16E144f": "macOS 10.12.4 beta 1",
    "16E154a": "macOS 10.12.4 beta 2",
    "16E163f": "macOS 10.12.4 beta 3",
    "16E175b": "macOS 10.12.4 beta 4",
    "16E183b": "macOS 10.12.4 beta 5",
    "16E189a": "macOS 10.12.4 beta 6",
    "16E191a": "macOS 10.12.4 beta 7",
    "16E192b": "macOS 10.12.4 beta 8",
    "16E195": "macOS 10.12.4",
    "16E2193": "macOS 10.12.4",
    "16F43c": "macOS 10.12.5 beta 1",
    "16F54b": "macOS 10.12.5 beta 2",
    "16F60a": "macOS 10.12.5 beta 3",
    "16F67a": "macOS 10.12.5 beta 4",
    "16F69a": "macOS 10.12.5 beta 5",
    "16F71b": "macOS 10.12.5 beta 6",
    "16F73": "macOS 10.12.5",
    "16F2073": "macOS 10.12.5",
    "16G8c": "macOS 10.12.6 beta 1",
    "16G12b": "macOS 10.12.6 beta 2",
    "16G16b": "macOS 10.12.6 beta 3",
    "16G18a": "macOS 10.12.6 beta 4",
    "16G23a": "macOS 10.12.6 beta 5",
    "16G24b": "macOS 10.12.6 beta 6",
    "16G27": "macOS 10.12.6 GM",
    "16G29": "macOS 10.12.6",
    "16G1036": "macOS 10.12.6",
    "16G1114": "macOS 10.12.6",
    "16G1212": "macOS 10.12.6",
    "16G1314": "macOS 10.12.6",
    "16G1408": "macOS 10.12.6",
    "16G1510": "macOS 10.12.6",
    "16G1618": "macOS 10.12.6",
    "16G1710": "macOS 10.12.6",
    "16G1815": "macOS 10.12.6",
    "16G1917": "macOS 10.12.6",
    "16G1918": "macOS 10.12.6",
    "16G2016": "macOS 10.12.6",
    "16G2127": "macOS 10.12.6",
    "16G2128": "macOS 10.12.6",
    "16G2136": "macOS 10.12.6",
    "17A263z": "macOS 10.13.0 beta 1",
    "17A264c": "macOS 10.13.0 beta 1",
    "17A291j": "macOS 10.13.0 beta 2",
    "17A291m": "macOS 10.13.0 beta 2",
    "17A306f": "macOS 10.13.0 beta 3",
    "17A315i": "macOS 10.13.0 beta 4",
    "17A330h": "macOS 10.13.0 beta 5",
    "17A344b": "macOS 10.13.0 beta 6",
    "17A352a": "macOS 10.13.0 beta 7",
    "17A358a": "macOS 10.13.0 beta 8",
    "17A360a": "macOS 10.13.0 beta 9",
    "17A362a": "macOS 10.13.0 beta 10/GM",
    "17A365": "macOS 10.13.0",
    "17A405": "macOS 10.13.0",
    "17B25c": "macOS 10.13.1 beta 1",
    "17B35a": "macOS 10.13.1 beta 2",
    "17B42a": "macOS 10.13.1 beta 3",
    "17B45a": "macOS 10.13.1 beta 4",
    "17B46a": "macOS 10.13.1 beta 5",
    "17B48": "macOS 10.13.1",
    "17B1002": "macOS 10.13.1",
    "17B1003": "macOS 10.13.1",
    "17C60c": "macOS 10.13.2 beta 1",
    "17C67b": "macOS 10.13.2 beta 2",
    "17C76a": "macOS 10.13.2 beta 3",
    "17C79a": "macOS 10.13.2 beta 4",
    "17C83c": "macOS 10.13.2 beta 5",
    "17C85a": "macOS 10.13.2 beta 6",
    "17C88": "macOS 10.13.2",
    "17C89": "macOS 10.13.2",
    "17C111": "macOS 10.13.2",
    "17C205": "macOS 10.13.2",
    "17C2111": "macOS 10.13.2",
    "17C2205": "macOS 10.13.2",
    "17D20a": "macOS 10.13.3 beta 1",
    "17D25b": "macOS 10.13.3 beta 2",
    "17D29a": "macOS 10.13.3 beta 3",
    "17D34a": "macOS 10.13.3 beta 4",
    "17D39a": "macOS 10.13.3 beta 5",
    "17D46a": "macOS 10.13.3 beta 6",
    "17D2046a": "macOS 10.13.3 beta 6",
    "17D47": "macOS 10.13.3",
    "17D2047": "macOS 10.13.3",
    "17D102": "macOS 10.13.3",
    "17D2102": "macOS 10.13.3",
    "17E139j": "macOS 10.13.4 beta 1",
    "17E150f": "macOS 10.13.4 beta 2",
    "17E150g": "macOS 10.13.4 beta 2",
    "17E160e": "macOS 10.13.4 beta 3",
    "17E170c": "macOS 10.13.4 beta 4",
    "17E182a": "macOS 10.13.4 beta 5",
    "17E190a": "macOS 10.13.4 beta 6",
    "17E197a": "macOS 10.13.4 beta 7",
    "17E199": "macOS 10.13.4",
    "17E202": "macOS 10.13.4",
    "17F35e": "macOS 10.13.5 beta 1",
    "17F45c": "macOS 10.13.5 beta 2",
    "17F59b": "macOS 10.13.5 beta 3",
    "17F66a": "macOS 10.13.5 beta 4",
    "17F70a": "macOS 10.13.5 beta 5",
    "17F77": "macOS 10.13.5",
    "17G31f": "macOS 10.13.6 beta 1",
    "17G39b": "macOS 10.13.6 beta 2",
    "17G47b": "macOS 10.13.6 beta 3",
    "17G54a": "macOS 10.13.6 beta 4",
    "17G62a": "macOS 10.13.6 beta 5",
    "17G65": "macOS 10.13.6",
    "17G66": "macOS 10.13.6",
    "17G2112": "macOS 10.13.6",
    "17G2208": "macOS 10.13.6",
    "17G2307": "macOS 10.13.6",
    "17G3025": "macOS 10.13.6",
    "17G4015": "macOS 10.13.6",
    "17G5019": "macOS 10.13.6",
    "17G6029": "macOS 10.13.6",
    "17G6030": "macOS 10.13.6",
    "17G7024": "macOS 10.13.6",
    "17G8029": "macOS 10.13.6",
    "17G8030": "macOS 10.13.6",
    "17G8037": "macOS 10.13.6",
    "17G9016": "macOS 10.13.6",
    "17G10021": "macOS 10.13.6",
    "17G11023": "macOS 10.13.6",
    "17G12034": "macOS 10.13.6",
    "17G13033": "macOS 10.13.6",
    "17G13035": "macOS 10.13.6",
    "17G14019": "macOS 10.13.6",
    "17G14033": "macOS 10.13.6",
    "17G14042": "macOS 10.13.6",
    "18A293u": "macOS 10.14.0 beta 1",
    "18A314h": "macOS 10.14.0 beta 2",
    "18A314j": "macOS 10.14.0 beta 2",
    "18A314k": "macOS 10.14.0 beta 2",
    "18A326g": "macOS 10.14.0 beta 3",
    "18A326h": "macOS 10.14.0 beta 3",
    "18A336e": "macOS 10.14.0 beta 4",
    "18A347e": "macOS 10.14.0 beta 5",
    "18A353d": "macOS 10.14.0 beta 6",
    "18A365a": "macOS 10.14.0 beta 7",
    "18A371a": "macOS 10.14.0 beta 8",
    "18A377a": "macOS 10.14.0 beta 9",
    "18A384a": "macOS 10.14.0 beta 10",
    "18A389": "macOS 10.14.0 beta 11/GM 1",
    "18A390": "macOS 10.14.0 beta 12/GM 2",
    "18A391": "macOS 10.14.0",
    "18A2063": "macOS 10.14.0",
    "18B45d": "macOS 10.14.1 beta 1",
    "18B50c": "macOS 10.14.1 beta 2",
    "18B57c": "macOS 10.14.1 beta 3",
    "18B67a": "macOS 10.14.1 beta 4",
    "18B73a": "macOS 10.14.1 beta 5",
    "18B74": "macOS 10.14.1 GM",
    "18B75": "macOS 10.14.1",
    "18B2084": "macOS 10.14.1",
    "18B2103": "macOS 10.14.1",
    "18B2107": "macOS 10.14.1",
    "18B3094": "macOS 10.14.1",
    "18C31f": "macOS 10.14.2 beta 1",
    "18C31g": "macOS 10.14.2 beta 1",
    "18C38b": "macOS 10.14.2 beta 2",
    "18C48a": "macOS 10.14.2 beta 3",
    "18C52a": "macOS 10.14.2 beta 4",
    "18C54": "macOS 10.14.2",
    "18D21c": "macOS 10.14.3 beta 1",
    "18D32a": "macOS 10.14.3 beta 2",
    "18D38a": "macOS 10.14.3 beta 3",
    "18D39a": "macOS 10.14.3 beta 4",
    "18D41": "macOS 10.14.3 GM",
    "18D42": "macOS 10.14.3",
    "18D43": "macOS 10.14.3",
    "18D109": "macOS 10.14.3",
    "18E174f": "macOS 10.14.4 beta 1",
    "18E184e": "macOS 10.14.4 beta 2",
    "18E194d": "macOS 10.14.4 beta 3",
    "18E205e": "macOS 10.14.4 beta 4",
    "18E215a": "macOS 10.14.4 beta 5",
    "18E220a": "macOS 10.14.4 beta 6",
    "18E224": "macOS 10.14.4 GM",
    "18E226": "macOS 10.14.4",
    "18E227": "macOS 10.14.4",
    "18E2034": "macOS 10.14.4",
    "18F96h": "macOS 10.14.5 beta 1",
    "18F108f": "macOS 10.14.5 beta 2",
    "18F118d": "macOS 10.14.5 beta 3",
    "18F127a": "macOS 10.14.5 beta 4",
    "18F131a": "macOS 10.14.5 beta 5",
    "18F132a": "macOS 10.14.5 beta 6",
    "18F132": "macOS 10.14.5",
    "18F203": "macOS 10.14.5",
    "18F2058": "macOS 10.14.5",
    "18F2059": "macOS 10.14.5",
    "18G29g": "macOS 10.14.6 beta 1",
    "18G48f": "macOS 10.14.6 beta 2",
    "18G59b": "macOS 10.14.6 beta 3",
    "18G71a": "macOS 10.14.6 beta 4",
    "18G78a": "macOS 10.14.6 beta 5",
    "18G84": "macOS 10.14.6",
    "18G87": "macOS 10.14.6",
    "18G95": "macOS 10.14.6",
    "18G103": "macOS 10.14.6",
    "18G1012": "macOS 10.14.6",
    "18G2022": "macOS 10.14.6",
    "18G3020": "macOS 10.14.6",
    "18G4032": "macOS 10.14.6",
    "18G5033": "macOS 10.14.6",
    "18G6020": "macOS 10.14.6",
    "18G6032": "macOS 10.14.6",
    "18G6042": "macOS 10.14.6",
    "18G7016": "macOS 10.14.6",
    "18G8012": "macOS 10.14.6",
    "18G8022": "macOS 10.14.6",
    "18G9028": "macOS 10.14.6",
    "18G9216": "macOS 10.14.6",
    "18G9323": "macOS 10.14.6",
    "19A471t": "macOS 10.15.0 beta 1",
    "19A487I": "macOS 10.15.0 beta 2",
    "19A487l": "macOS 10.15.0 beta 2",
    "19A487m": "macOS 10.15.0 beta 2",
    "19A501i": "macOS 10.15.0 beta 3",
    "19A512f": "macOS 10.15.0 beta 4",
    "19A526h": "macOS 10.15.0 beta 5",
    "19A536g": "macOS 10.15.0 beta 6",
    "19A546d": "macOS 10.15.0 beta 7",
    "19A558d": "macOS 10.15.0 beta 8",
    "19A573a": "macOS 10.15.0 beta 9",
    "19A578c": "macOS 10.15.0 beta 10",
    "19A582a": "macOS 10.15.0 beta 11/GM 1",
    "19A583a": "macOS 10.15.0 beta 12/GM 2",
    "19A583": "macOS 10.15.0",
    "19A602": "macOS 10.15.0",
    "19A603": "macOS 10.15.0",
    "19B68f": "macOS 10.15.1 beta 1",
    "19B77a": "macOS 10.15.1 beta 2",
    "19B86a": "macOS 10.15.1 beta 3",
    "19B88": "macOS 10.15.1",
    "19B2093": "macOS 10.15.1",
    "19B2106": "macOS 10.15.1",
    "19C32e": "macOS 10.15.2 beta 1",
    "19C39d": "macOS 10.15.2 beta 2",
    "19C46a": "macOS 10.15.2 beta 3",
    "19C56a": "macOS 10.15.2 beta 4",
    "19C57": "macOS 10.15.2",
    "19C58": "macOS 10.15.2",
    "19D49f": "macOS 10.15.3 beta 1",
    "19D62e": "macOS 10.15.3 beta 2",
    "19D75a": "macOS 10.15.3 beta 3",
    "19D76": "macOS 10.15.3",
    "19D2064": "macOS 10.15.3",
    "19E224g": "macOS 10.15.4 beta 1",
    "19E234g": "macOS 10.15.4 beta 2",
    "19E242d": "macOS 10.15.4 beta 3",
    "19E250c": "macOS 10.15.4 beta 4",
    "19E258a": "macOS 10.15.4 beta 5",
    "19E264b": "macOS 10.15.4 GM",
    "19E266": "macOS 10.15.4",
    "19E287": "macOS 10.15.4",
    "19E2265": "macOS 10.15.4",
    "19E2269": "macOS 10.15.4",
    "19F53f": "macOS 10.15.5 beta 1",
    "19F62f": "macOS 10.15.5 beta 2",
    "19F72f": "macOS 10.15.5 beta 3",
    "19F83c": "macOS 10.15.5 beta 4",
    "19F94a": "macOS 10.15.5 GM",
    "19F96": "macOS 10.15.5",
    "19F101": "macOS 10.15.5",
    "19F2096": "macOS 10.15.5",
    "19F2200": "macOS 10.15.5",
    "19G36e": "macOS 10.15.6 beta 1",
    "19G46c": "macOS 10.15.6 beta 2",
    "19G60d": "macOS 10.15.6 beta 3",
    "19G71a": "macOS 10.15.6 GM",
    "19G73": "macOS 10.15.6",
    "19G2005": "macOS 10.15.6",
    "19G2006": "macOS 10.15.6",
    "19G2021": "macOS 10.15.6",
    "19G2531": "macOS 10.15.6",
    "19H2": "macOS 10.15.7",
    "19H4": "macOS 10.15.7",
    "19H15": "macOS 10.15.7",
    "19H114": "macOS 10.15.7",
    "19H512": "macOS 10.15.7",
    "19H524": "macOS 10.15.7",
    "19H1030": "macOS 10.15.7",
    "19H1217": "macOS 10.15.7",
    "19H1323": "macOS 10.15.7",
    "19H1417": "macOS 10.15.7",
    "19H1419": "macOS 10.15.7",
    "19H1519": "macOS 10.15.7",
    "19H1615": "macOS 10.15.7",
    "19H1713": "macOS 10.15.7",
    "19H1715": "macOS 10.15.7",
    "19H1824": "macOS 10.15.7",
    "19H1922": "macOS 10.15.7",
    "19H2026": "macOS 10.15.7",
    "20A4299v": "macOS 11.0.1 beta 1",
    "20A5299w": "macOS 11.0.1 SDK",
    "20A4300b": "macOS 11.0.1 beta 2",
    "20A5323l": "macOS 11.0.1 beta 3",
    "20A5343i": "macOS 11.0.1 beta 4",
    "20A5343j": "macOS 11.0.1 Public Beta 1",
    "20A5354i": "macOS 11.0.1 beta 5",
    "20A5364e": "macOS 11.0.1 beta 6",
    "20A5374g": "macOS 11.0.1 beta 7",
    "20A5374i": "macOS 11.0.1 beta 8",
    "20A5384c": "macOS 11.0.1 beta 9",
    "20A5395g": "macOS 11.0.1 beta 10",
    "20A2411": "macOS 11.0.1",
    "20B5012d": "macOS 11.0.1 beta 1",
    "20B5022a": "macOS 11.0.1 beta 2/RC 1",
    "20B28": "macOS 11.0.1 RC 2",
    "20B29": "macOS 11.0.1",
    "20B50": "macOS 11.0.1",
    "20C5048k": "macOS 11.1.0 beta 1",
    "20C5048i": "macOS 11.1.0 beta 1",
    "20C5048l": "macOS 11.1.0 beta 1",
    "20C5061b": "macOS 11.1.0 beta 2",
    "20C69": "macOS 11.1.0",
    "20D5029f": "macOS 11.2.0 beta 1",
    "20D5042d": "macOS 11.2.0 beta 2",
    "20D53": "macOS 11.2.0 RC 1",
    "20D62": "macOS 11.2.0 RC 2",
    "20D64": "macOS 11.2.0",
    "20D74": "macOS 11.2.1",
    "20D75": "macOS 11.2.1",
    "20D80": "macOS 11.2.2",
    "20D91": "macOS 11.2.3",
    "20E5172i": "macOS 11.3.0 beta 1",
    "20E8172i": "macOS 11.3.0 beta 1",
    "20E5186d": "macOS 11.3.0 beta 2",
    "20E5196f": "macOS 11.3.0 beta 3",
    "20E5210c": "macOS 11.3.0 beta 4",
    "20E5217a": "macOS 11.3.0 beta 5",
    "20E5224a": "macOS 11.3.0 beta 6",
    "20E5229a": "macOS 11.3.0 beta 7",
    "20E5231a": "macOS 11.3.0 beta 8",
    "20E232": "macOS 11.3.0",
    "20E241": "macOS 11.3.1",
    "20E2241": "macOS 11.3.1",
    "20F5046g": "macOS 11.4.0 beta 1",
    "20F5055c": "macOS 11.4.0 beta 2",
    "20F5065a": "macOS 11.4.0 beta 3",
    "20F71": "macOS 11.4.0",
    "20G5023d": "macOS 11.5 beta 1",
    "20G5033c": "macOS 11.5 beta 2",
    "20G5042c": "macOS 11.5 beta 3",
    "20G5052c": "macOS 11.5 beta 4",
    "20G5065a": "macOS 11.5 beta 5",
    "20G70": "macOS 11.5 RC 1",
    "20G71": "macOS 11.5",
    "20G80": "macOS 11.5.1",
    "20G95": "macOS 11.5.2",
    "20G165": "macOS 11.6",
    "20G211": "macOS 11.6.1 RC 1",
    "20G214": "macOS 11.6.1 RC 2",
    "20G219": "macOS 11.6.1 RC 3",
    "20G221": "macOS 11.6.1 RC 4",
    "20G224": "macOS 11.6.1",
    "20G303": "macOS 11.6.2 RC 1",
    "20G306": "macOS 11.6.2 RC 2",
    "20G311": "macOS 11.6.2 RC 3",
    "20G313": "macOS 11.6.2 RC 4",
    "20G314": "macOS 11.6.2",
    "20G405": "macOS 11.6.3 RC 1",
    "20G409": "macOS 11.6.3 RC 2",
    "20G413": "macOS 11.6.3 RC 3",
    "20G415": "macOS 11.6.3",
    "20G507": "macOS 11.6.4 RC",
    "20G417": "macOS 11.6.4",
    "20G517": "macOS 11.6.5 RC 1",
    "20G521": "macOS 11.6.5 RC 2",
    "20G525": "macOS 11.6.5 RC 3",
    "20G526": "macOS 11.6.5 RC 4",
    "20G527": "macOS 11.6.5",
    "20G604": "macOS 11.6.6 RC 1",
    "20G608": "macOS 11.6.6 RC 2",
    "20G614": "macOS 11.6.6 RC 3",
    "20G618": "macOS 11.6.6 RC 4",
    "20G623": "macOS 11.6.6 RC 5",
    "20G624": "macOS 11.6.6",
    "20G704": "macOS 11.6.7 RC 1",
    "20G710": "macOS 11.6.7 RC 2",
    "20G630": "macOS 11.6.7",
    "20G715": "macOS 11.6.8 RC 1",
    "20G720": "macOS 11.6.8 RC 2",
    "20G725": "macOS 11.6.8 RC 3",
    "20G728": "macOS 11.6.8 RC 4",
    "20G730": "macOS 11.6.8",
    "20G817": "macOS 11.7",
    "20G908": "macOS 11.7.1 RC 1",
    "20G912": "macOS 11.7.1 RC 2",
    "20G916": "macOS 11.7.1 RC 3",
    "20G918": "macOS 11.7.1",
    "20G1008": "macOS 11.7.2 RC 1",
    "20G1011": "macOS 11.7.2 RC 2",
    "20G1020": "macOS 11.7.2",
    "20G1102": "macOS 11.7.3 RC 1",
    "20G1113": "macOS 11.7.3 RC 2",
    "20G1116": "macOS 11.7.3",
    "20G1120": "macOS 11.7.4",
    "20G1205": "macOS 11.7.5 RC",
    "20G1210": "macOS 11.7.5 RC 2",
    "21G1215": "macOS 11.7.5 RC 3",
    "20G1220": "macOS 11.7.5 RC 4",
    "20G1225": "macOS 11.7.5",
    "20G1231": "macOS 11.7.6",
    "20G1329": "macOS 11.7.7 RC 1",
    "21G1338": "macOS 11.7.7 RC 2",
    "20G1342": "macOS 11.7.7 RC 3",
    "20G1345": "macOS 11.7.7",
    "20G1351": "macOS 11.7.8",
    "20G1403": "macOS 11.7.9 RC 1",
    "20G1407": "macOS 11.7.9 RC 2",
    "20G1413": "macOS 11.7.9 RC 3",
    "20G1416": "macOS 11.7.9 RC 4",
    "20G1424": "macOS 11.7.9 RC 5",
    "20G1426": "macOS 11.7.9",
    "20G1427": "macOS 11.7.10",
    "21A5248p": "macOS 12.0 beta 1",
    "21A5268h": "macOS 12.0 beta 2",
    "21A5284e": "macOS 12.0 beta 3",
    "21A5294g": "macOS 12.0 beta 4",
    "21A5304g": "macOS 12.0 beta 5",
    "21A5506j": "macOS 12.0 beta 6",
    "21A5522h": "macOS 12.0 beta 7",
    "21A5534d": "macOS 12.0 beta 8",
    "21A5543b": "macOS 12.0 beta 9",
    "21A5552a": "macOS 12.0 beta 10",
    "21A344": "macOS 12.0",
    "21A558": "macOS 12.0.1 RC",
    "21A559": "macOS 12.0.1",
    "21C5021h": "macOS 12.1 beta 1",
    "21C5031d": "macOS 12.1 beta 2",
    "21C5039b": "macOS 12.1 beta 3",
    "21C5045a": "macOS 12.1 beta 4",
    "21C51": "macOS 12.1 RC",
    "21C52": "macOS 12.1",
    "21D5025f": "macOS 12.2 beta 1",
    "21D5039d": "macOS 12.2 beta 2",
    "21D48": "macOS 12.2 RC",
    "21D49": "macOS 12.2",
    "21D2048": "macOS 12.2",
    "21D62": "macOS 12.2.1",
    "21E5196i": "macOS 12.3 beta 1",
    "21E5206e": "macOS 12.3 beta 2",
    "21E5212f": "macOS 12.3 beta 3",
    "21E5222a": "macOS 12.3 beta 4",
    "21E5227a": "macOS 12.3 beta 5",
    "21E230": "macOS 12.3",
    "21E258": "macOS 12.3.1",
    "21F5048e": "macOS 12.4 beta 1",
    "21F5058e": "macOS 12.4 beta 2",
    "21F5063e": "macOS 12.4 beta 3",
    "21F5071b": "macOS 12.4 beta 4",
    "21F79": "macOS 12.4",
    "21F2081": "macOS 12.4",
    "21F2092": "macOS 12.4",
    "21G5027d": "macOS 12.5 beta 1",
    "21G5037d": "macOS 12.5 beta 2",
    "21G5046c": "macOS 12.5 beta 3",
    "21G5056b": "macOS 12.5 beta 4",
    "21G5063a": "macOS 12.5 beta 5",
    "21G69": "macOS 12.5 RC",
    "21G72": "macOS 12.5",
    "21G83": "macOS 12.5.1",
    "21G115": "macOS 12.6",
    "21G207": "macOS 12.6.1 RC 1",
    "21G211": "macOS 12.6.1 RC 2",
    "21G215": "macOS 12.6.1 RC 3",
    "21G217": "macOS 12.6.1",
    "21G309": "macOS 12.6.2 RC 1",
    "21G312": "macOS 12.6.2 RC 2",
    "21G317": "macOS 12.6.2 RC 3",
    "21G320": "macOS 12.6.2",
    "21G403": "macOS 12.6.3 RC 1",
    "21G417": "macOS 12.6.3 RC 2",
    "21G419": "macOS 12.6.3",
    "21G506": "macOS 12.6.4 RC 1",
    "21G511": "macOS 12.6.4 RC 2",
    "21G516": "macOS 12.6.4 RC 3",
    "21G521": "macOS 12.6.4 RC 4",
    "21G526": "macOS 12.6.4",
    "21G531": "macOS 12.6.5",
    "21G630": "macOS 12.6.6 RC 1",
    "21G633": "macOS 12.6.6 RC 2",
    "21G639": "macOS 12.6.6 RC 3",
    "21G644": "macOS 12.6.6 RC 4",
    "21G646": "macOS 12.6.6",
    "21G651": "macOS 12.6.7",
    "21G703": "macOS 12.6.8 RC 1",
    "21G708": "macOS 12.6.8 RC 2",
    "21G713": "macOS 12.6.8 RC 3",
    "21G716": "macOS 12.6.8 RC 4",
    "21G724": "macOS 12.6.8 RC 5",
    "21G725": "macOS 12.6.8",
    "21G726": "macOS 12.6.9",
    "21G808": "macOS 12.7 RC",
    "21G813": "macOS 12.7 RC 2",
    "21G814": "macOS 12.7 RC 3",
    "21G816": "macOS 12.7",
    "21G913": "macOS 12.7.1 RC",
    "21G918": "macOS 12.7.1 RC 2",
    "21G920": "macOS 12.7.1",
    "21G1925": "macOS 12.7.2 RC",
    "21G1965": "macOS 12.7.2 RC 2",
    "21G1967": "macOS 12.7.2 RC 3",
    "21G1971": "macOS 12.7.2 RC 4",
    "21G1974": "macOS 12.7.2",
    "21H1006": "macOS 12.7.3 RC",
    "21H1009": "macOS 12.7.3 RC 2",
    "21H1013": "macOS 12.7.3 RC 3",
    "21H1015": "macOS 12.7.3",
    "21H1105": "macOS 12.7.4 RC",
    "21H1111": "macOS 12.7.4 RC 2",
    "21H1121": "macOS 12.7.4 RC 3",
    "22A5266r": "macOS 13.0 beta 1",
    "22A5286j": "macOS 13.0 beta 2",
    "22A5295h": "macOS 13.0 beta 3",
    "22A5295i": "macOS 13.0 beta 3",
    "22A5311f": "macOS 13.0 beta 4",
    "22A5321d": "macOS 13.0 beta 5",
    "22A5331f": "macOS 13.0 beta 6",
    "22A5342f": "macOS 13.0 beta 7",
    "22A5352e": "macOS 13.0 beta 8",
    "22A5358e": "macOS 13.0 beta 9",
    "22A5365d": "macOS 13.0 beta 10",
    "22A5373b": "macOS 13.0 beta 11",
    "22A379": "macOS 13.0 RC",
    "22A380": "macOS 13.0",
    "22A8380": "macOS 13.0",
    "22A400": "macOS 13.0.1",
    "22C5033e": "macOS 13.1 beta 1",
    "20C5044e": "macOS 13.1 beta 2",
    "22C5050e": "macOS 13.1 beta 3",
    "22C5059b": "macOS 13.1 beta 4",
    "22C65": "macOS 13.1",
    "22D5027d": "macOS 13.2 beta 1",
    "22D7750270d": "macOS 13.2 beta 1",
    "22D5038i": "macOS 13.2 beta 2",
    "22D49": "macOS 13.2",
    "22D68": "macOS 13.2.1",
    "22E5219e": "macOS 13.3 beta 1",
    "22E5230e": "macOS 13.3 beta 2",
    "22E5236f": "macOS 13.3 beta 3",
    "22E5246b": "macOS 13.3 beta 4",
    "22E252": "macOS 13.3",
    "22E261": "macOS 13.3.1",
    "22E772610a": "macOS 13.3.1 (a)",
    "22F5027f": "macOS 13.4 beta 1",
    "22F5037d": "macOS 13.4 beta 2",
    "22F5049e": "macOS 13.4 beta 3",
    "22F5059b": "macOS 13.4 beta 4",
    "22F62": "macOS 13.4 RC",
    "22F63": "macOS 13.4 RC 2",
    "22F66": "macOS 13.4",
    "22F2063": "macOS 13.4",
    "22F2073": "macOS 13.4",
    "22F82": "macOS 13.4.1",
    "22F2083": "macOS 13.4.1",
    "22F770820b": "macOS 13.4.1 (a)",
    "22F770820d": "macOS 13.4.1 (c)",
    "22G5027e": "macOS 13.5 beta 1",
    "22G5038d": "macOS 13.5 beta 2",
    "22G5048d": "macOS 13.5 beta 3",
    "22G5059d": "macOS 13.5 beta 4",
    "22G5072a": "macOS 13.5 beta 5",
    "22G74": "macOS 13.5",
    "22G90": "macOS 13.5.1",
    "22G91": "macOS 13.5.2",
    "22G109": "macOS 13.6 RC",
    "22G115": "macOS 13.6 RC 2",
    "22G116": "macOS 13.6 RC 3",
    "22G120": "macOS 13.6",
    "22G213": "macOS 13.6.1 RC",
    "22G311": "macOS 13.6.1 RC 2",
    "22G313": "macOS 13.6.1",
    "22G320": "macOS 13.6.2",
    "22G2321": "macOS 13.6.2",
    "22G417": "macOS 13.6.3 RC",
    "22G423": "macOS 13.6.3 RC 2",
    "22G430": "macOS 13.6.3 RC 3",
    "22G433": "macOS 13.6.3 RC 4",
    "22G436": "macOS 13.6.3",
    "22G504": "macOS 13.6.4 RC",
    "22G507": "macOS 13.6.4 RC 2",
    "22G511": "macOS 13.6.4 RC 3",
    "22G513": "macOS 13.6.4",
    "22G605": "macOS 13.6.5 RC",
    "22G610": "macOS 13.6.5 RC 2",
    "22G619": "macOS 13.6.5 RC 3",
    "23A5257q": "macOS 14.0 beta 1",
    "23A5276g": "macOS 14.0 beta 2",
    "23A5286g": "macOS 14.0 beta 3",
    "23A5286i": "macOS 14.0 beta 3 Update",
    "23A5301g": "macOS 14.0 beta 4",
    "23A5301h": "macOS 14.0 beta 4 Update",
    "23A5312d": "macOS 14.0 beta 5",
    "23A5328b": "macOS 14.0 beta 6",
    "23A5337a": "macOS 14.0 beta 7",
    "23A339": "macOS 14.0 RC",
    "23A344": "macOS 14.0",
    "23B5046f": "macOS 14.1 beta 1",
    "23B5056e": "macOS 14.1 beta 2",
    "23B5067a": "macOS 14.1 beta 3",
    "23B73": "macOS 14.1 RC",
    "23B2073": "macOS 14.1",
    "23B74": "macOS 14.1",
    "23B2077": "macOS 14.1",
    "23B81": "macOS 14.1.1",
    "23B2082": "macOS 14.1.1",
    "23B92": "macOS 14.1.2",
    "23B2091": "macOS 14.1.2",
    "23C5030f": "macOS 14.2 beta 1",
    "23C5041e": "macOS 14.2 beta 2",
    "23C5047e": "macOS 14.2 beta 3",
    "23C5055b": "macOS 14.2 beta 4",
    "23C63": "macOS 14.2 RC",
    "23C64": "macOS 14.2",
    "23C71": "macOS 14.2.1",
    "23D5033f": "macOS 14.3 beta 1",
    "23D5043d": "macOS 14.3 beta 2",
    "23D5051b": "macOS 14.3 beta 3",
    "23D56": "macOS 14.3",
    "23D60": "macOS 14.3.1",
    "23E5180j": "macOS 14.4 beta 1",
    "23E5191e": "macOS 14.4 beta 2",
    "23E5196e": "macOS 14.4 beta 3",
    "23E5205c": "macOS 14.4 beta 4",
    "12S507": "watchOS 1.0",
    "12S632": "watchOS 1.0.1",
    "13S5254w": "watchOS 2.0 beta 1",
    "13S5255c": "watchOS 2.0 beta 2",
    "13S5255d": "watchOS 2.0 beta 2",
    "13S5293e": "watchOS 2.0 beta 3",
    "13S5293f": "watchOS 2.0 beta 3",
    "13S5305d": "watchOS 2.0 beta 4",
    "13S5325c": "watchOS 2.0 beta 5",
    "13S343": "watchOS 2.0 GM",
    "13S344": "watchOS 2.0",
    "13S428": "watchOS 2.0.1",
    "13S661": "watchOS 2.1",
    "13V5098e": "watchOS 2.2 beta 1",
    "13V5108c": "watchOS 2.2 beta 2",
    "13V5117c": "watchOS 2.2 beta 3",
    "13V5129c": "watchOS 2.2 beta 4",
    "13V5141a": "watchOS 2.2 beta 5",
    "13V5143a": "watchOS 2.2 beta 6",
    "13V144": "watchOS 2.2",
    "13V413": "watchOS 2.2.1 beta 1",
    "13V420": "watchOS 2.2.1",
    "13V601": "watchOS 2.2.2 GM",
    "13V604": "watchOS 2.2.2",
    "14S5247t": "watchOS 3.0 beta 1",
    "14S5278d": "watchOS 3.0 beta 2",
    "14S5290d": "watchOS 3.0 beta 3",
    "14S5302d": "watchOS 3.0 beta 4",
    "14S5315a": "watchOS 3.0 beta 5",
    "14S5321a": "watchOS 3.0 beta 6",
    "14S326": "watchOS 3.0",
    "14S452": "watchOS 3.1 beta 1",
    "14S464": "watchOS 3.1 beta 2",
    "14S471": "watchOS 3.1",
    "14S5862d": "watchOS 3.1.1 beta 1",
    "14S5869b": "watchOS 3.1.1 beta 2",
    "14S5875b": "watchOS 3.1.1 beta 3",
    "14S879": "watchOS 3.1.1 beta 4",
    "14S883": "watchOS 3.1.1",
    "14S958": "watchOS 3.1.3 beta 1",
    "14S959": "watchOS 3.1.3 beta 2",
    "14S960": "watchOS 3.1.3",
    "14V5205d": "watchOS 3.2 beta 1",
    "14V5214d": "watchOS 3.2 beta 2",
    "14V5224d": "watchOS 3.2 beta 3",
    "14V5235b": "watchOS 3.2 beta 4",
    "14V5243a": "watchOS 3.2 beta 5",
    "14V5245a": "watchOS 3.2 beta 6",
    "14V5249a": "watchOS 3.2 beta 7",
    "14V249": "watchOS 3.2",
    "14F5065b": "watchOS 3.2.2 beta 1",
    "14V5475a": "watchOS 3.2.2 beta 2",
    "14V5480a": "watchOS 3.2.2 beta 3",
    "14V5485a": "watchOS 3.2.2 beta 4",
    "14V485": "watchOS 3.2.2",
    "14V5726a": "watchOS 3.2.3 beta 1",
    "14V5734a": "watchOS 3.2.3 beta 2",
    "14V5744a": "watchOS 3.2.3 beta 3",
    "14V5751a": "watchOS 3.2.3 beta 4",
    "14V753": "watchOS 3.2.3",
    "15R5281f": "watchOS 4.0 beta 1",
    "15R5307f": "watchOS 4.0 beta 2",
    "15R5321h": "watchOS 4.0 beta 3",
    "15R5331g": "watchOS 4.0 beta 4",
    "15R5345g": "watchOS 4.0 beta 5",
    "15R5357b": "watchOS 4.0 beta 6",
    "15R5365a": "watchOS 4.0 beta 7",
    "15R5371a": "watchOS 4.0 beta 8",
    "15R372": "watchOS 4.0",
    "15R654": "watchOS 4.0.1",
    "15R5823c": "watchOS 4.1 beta 1",
    "15R5835d": "watchOS 4.1 beta 2",
    "15R5843a": "watchOS 4.1 beta 3",
    "15R846": "watchOS 4.1",
    "15S5085b": "watchOS 4.2 beta 1",
    "15S5090c": "watchOS 4.2 beta 2",
    "15S5100a": "watchOS 4.2 beta 3",
    "15S5102b": "watchOS 4.2 beta 4",
    "15S102": "watchOS 4.2",
    "15S5530d": "watchOS 4.2.2 beta 1",
    "15S5534a": "watchOS 4.2.2 beta 2",
    "15S5536a": "watchOS 4.2.2 beta 3",
    "15S5540a": "watchOS 4.2.2 beta 4",
    "15S542": "watchOS 4.2.2",
    "15S600b": "watchOS 4.2.3",
    "15T5165e": "watchOS 4.3 beta 1",
    "15T5176c": "watchOS 4.3 beta 2",
    "15T5187e": "watchOS 4.3 beta 3",
    "15T5199f": "watchOS 4.3 beta 4",
    "15T5209a": "watchOS 4.3 beta 5",
    "15T5212a": "watchOS 4.3 beta 6",
    "15T212": "watchOS 4.3",
    "15T5535b": "watchOS 4.3.1 beta 1",
    "15T5545b": "watchOS 4.3.1 beta 2",
    "15T5555c": "watchOS 4.3.1 beta 3",
    "15T5565a": "watchOS 4.3.1 beta 4",
    "15T5567a": "watchOS 4.3.1 beta 5",
    "15T567": "watchOS 4.3.1",
    "15U5053b": "watchOS 4.3.2 beta 1",
    "15U5062a": "watchOS 4.3.2 beta 2",
    "15U5069a": "watchOS 4.3.2 beta 3",
    "15U70": "watchOS 4.3.2",
    "16R5283q": "watchOS 5.0 beta 1",
    "16R5283r": "watchOS 5.0 beta 1",
    "16R5303d": "watchOS 5.0 beta 2",
    "16R5313d": "watchOS 5.0 beta 3",
    "16R5322d": "watchOS 5.0 beta 4",
    "16R5334f": "watchOS 5.0 beta 5",
    "16R5340g": "watchOS 5.0 beta 6",
    "16R5349a": "watchOS 5.0 beta 7",
    "16R5357a": "watchOS 5.0 beta 8",
    "16R5360a": "watchOS 5.0 beta 9",
    "16R5363a": "watchOS 5.0 beta 10",
    "16R364": "watchOS 5.0",
    "16R381": "watchOS 5.0.1",
    "16R382": "watchOS 5.0.1",
    "16R5559d": "watchOS 5.1 beta 1",
    "16R5568d": "watchOS 5.1 beta 2",
    "16R5577c": "watchOS 5.1 beta 3",
    "16R5584a": "watchOS 5.1 beta 4",
    "16R5589c": "watchOS 5.1 beta 5",
    "16R591": "watchOS 5.1",
    "16R600": "watchOS 5.1.1",
    "16S5042a": "watchOS 5.1.2 beta 1",
    "16S5046a": "watchOS 5.1.2 beta 2",
    "16S46": "watchOS 5.1.2",
    "16S5523a": "watchOS 5.1.3 beta 1",
    "16S5531a": "watchOS 5.1.3 beta 2",
    "16S5535a": "watchOS 5.1.3 beta 3",
    "16S535": "watchOS 5.1.3",
    "16T5181f": "watchOS 5.2 beta 1",
    "16T5191d": "watchOS 5.2 beta 2",
    "16T5201c": "watchOS 5.2 beta 3",
    "16T5212e": "watchOS 5.2 beta 4",
    "16T5222a": "watchOS 5.2 beta 5",
    "16T5225a": "watchOS 5.2 beta 6",
    "16T225": "watchOS 5.2",
    "16U5079d": "watchOS 5.2.1 beta 1",
    "16U5091b": "watchOS 5.2.1 beta 2",
    "16U5101c": "watchOS 5.2.1 beta 3",
    "16U5110a": "watchOS 5.2.1 beta 4",
    "16U5113a": "watchOS 5.2.1 beta 5",
    "16U113": "watchOS 5.2.1",
    "16U5526f": "watchOS 5.3 beta 1",
    "16U5537b": "watchOS 5.3 beta 2",
    "16U5545c": "watchOS 5.3 beta 3",
    "16U5558b": "watchOS 5.3 beta 4",
    "16U5566a": "watchOS 5.3 beta 5",
    "16U5569a": "watchOS 5.3 beta 6",
    "16U569": "watchOS 5.3",
    "16U600": "watchOS 5.3.1",
    "16U611": "watchOS 5.3.2",
    "16U620": "watchOS 5.3.3",
    "16U627": "watchOS 5.3.4",
    "16U652": "watchOS 5.3.5",
    "16U662": "watchOS 5.3.6",
    "16U674": "watchOS 5.3.7",
    "16U680": "watchOS 5.3.8",
    "16U693": "watchOS 5.3.9",
    "17R5491t": "watchOS 6.0 beta 1",
    "17R5507l": "watchOS 6.0 beta 2",
    "17R5521e": "watchOS 6.0 beta 3",
    "17R5532f": "watchOS 6.0 beta 4",
    "17R5546f": "watchOS 6.0 beta 5",
    "17R5556d": "watchOS 6.0 beta 6",
    "17R5566a": "watchOS 6.0 beta 7",
    "17R5571a": "watchOS 6.0 beta 8",
    "17R5575a": "watchOS 6.0 beta 9",
    "17R575": "watchOS 6.0",
    "17R604": "watchOS 6.0.1",
    "17R605": "watchOS 6.0.1",
    "17S5054e": "watchOS 6.1 beta 1",
    "17S5059e": "watchOS 6.1 beta 2",
    "17S5068e": "watchOS 6.1 beta 3",
    "17S5076a": "watchOS 6.1 beta 4",
    "17S5083a": "watchOS 6.1 beta 5",
    "17S84": "watchOS 6.1",
    "17S5433b": "watchOS 6.1.1 beta 1",
    "17S5439a": "watchOS 6.1.1 beta 2",
    "17S5446a": "watchOS 6.1.1 beta 3",
    "17S5449b": "watchOS 6.1.1 beta 4",
    "17S449": "watchOS 6.1.1",
    "17S5775c": "watchOS 6.1.2 beta 1",
    "17S5792a": "watchOS 6.1.2 beta 2",
    "17S5796a": "watchOS 6.1.2 beta 3",
    "17S796": "watchOS 6.1.2",
    "17S811": "watchOS 6.1.3",
    "17T5224g": "watchOS 6.2 beta 1",
    "17T5234f": "watchOS 6.2 beta 2",
    "17T5244c": "watchOS 6.2 beta 3",
    "17T5251a": "watchOS 6.2 beta 4",
    "17T5254a": "watchOS 6.2 beta 5",
    "17T529": "watchOS 6.2",
    "17T530": "watchOS 6.2.1",
    "17T5580e": "watchOS 6.2.5 beta 1",
    "17T5590d": "watchOS 6.2.5 beta 2",
    "17T5600c": "watchOS 6.2.5 beta 3",
    "17T5607a": "watchOS 6.2.5 beta 4",
    "17T608": "watchOS 6.2.5",
    "17T620": "watchOS 6.2.6",
    "17U5535e": "watchOS 6.2.8 beta 1",
    "17U5545c": "watchOS 6.2.8 beta 2",
    "17U5559d": "watchOS 6.2.8 beta 3",
    "17U63": "watchOS 6.2.8",
    "17U203": "watchOS 6.2.9",
    "17U208": "watchOS 6.3",
    "18R5310a": "watchOS 7.0 beta 1",
    "18R5327h": "watchOS 7.0 beta 2",
    "18R5340d": "watchOS 7.0 beta 3",
    "18R5350e": "watchOS 7.0 beta 4",
    "18R5361d": "watchOS 7.0 beta 5",
    "18R5368d": "watchOS 7.0 beta 6",
    "18R5378a": "watchOS 7.0 beta 7",
    "18R5382a": "watchOS 7.0 beta 8",
    "18R382": "watchOS 7.0",
    "18R395": "watchOS 7.0.1",
    "18R402": "watchOS 7.0.2",
    "18R410": "watchOS 7.0.3",
    "18R5552f": "watchOS 7.1 beta 1",
    "18R5561e": "watchOS 7.1 beta 2",
    "18R5572f": "watchOS 7.1 beta 3",
    "18R5572g": "watchOS 7.1 beta 3",
    "18R5585a": "watchOS 7.1 beta 4",
    "18R5586a": "watchOS 7.1 beta 4",
    "18R589": "watchOS 7.1 RC",
    "18R590": "watchOS 7.1",
    "18S5545f": "watchOS 7.2 beta 1",
    "18S5555c": "watchOS 7.2 beta 2",
    "18S5561a": "watchOS 7.2 beta 3",
    "18S563": "watchOS 7.2",
    "18S564": "watchOS 7.2",
    "18S5780d": "watchOS 7.3 beta 1",
    "18S5793d": "watchOS 7.3 beta 2",
    "18S801": "watchOS 7.3",
    "18S811": "watchOS 7.3.1",
    "18S821": "watchOS 7.3.2",
    "18S830": "watchOS 7.3.3",
    "18T5144k": "watchOS 7.4 beta 1",
    "18T5159f": "watchOS 7.4 beta 2",
    "18T5169f": "watchOS 7.4 beta 3",
    "18T5183b": "watchOS 7.4 beta 4",
    "18T5190a": "watchOS 7.4 beta 5",
    "18T5193a": "watchOS 7.4 beta 6",
    "18T5194a": "watchOS 7.4 beta 7",
    "18T195": "watchOS 7.4",
    "18T201": "watchOS 7.4.1",
    "18T5546f": "watchOS 7.5 beta 1",
    "18T5555c": "watchOS 7.5 beta 2",
    "18T5564a": "watchOS 7.5 beta 3",
    "18T567": "watchOS 7.5",
    "18U5523d": "watchOS 7.6 beta 1",
    "18U5533b": "watchOS 7.6 beta 2",
    "18U5542b": "watchOS 7.6 beta 3",
    "18U5552d": "watchOS 7.6 beta 4",
    "18U5561a": "watchOS 7.6 beta 5",
    "18U63": "watchOS 7.6",
    "18U70": "watchOS 7.6.1",
    "18U80": "watchOS 7.6.2",
    "19R5266q": "watchOS 8.0 beta 1",
    "19R5286f": "watchOS 8.0 beta 2",
    "19R5302f": "watchOS 8.0 beta 3",
    "19R5312e": "watchOS 8.0 beta 4",
    "19R5323g": "watchOS 8.0 beta 5",
    "19R5330d": "watchOS 8.0 beta 6",
    "19R5340a": "watchOS 8.0 beta 7",
    "19R5342a": "watchOS 8.0 beta 8",
    "19R343": "watchOS 8.0",
    "19R346": "watchOS 8.0",
    "19R354": "watchOS 8.0.1",
    "19R5541f": "watchOS 8.1 beta 1",
    "19R5551d": "watchOS 8.1 beta 2",
    "19R5559e": "watchOS 8.1 beta 3",
    "19R5566a": "watchOS 8.1 beta 4",
    "19R570": "watchOS 8.1",
    "19R580": "watchOS 8.1.1",
    "19S5026e": "watchOS 8.3 beta 1",
    "19S5036d": "watchOS 8.3 beta 2",
    "19S5044c": "watchOS 8.3 beta 3",
    "19S5050c": "watchOS 8.3 beta 4",
    "19S55": "watchOS 8.3",
    "19S5525f": "watchOS 8.4 beta 1",
    "19S5539e": "watchOS 8.4 beta 2",
    "19S546": "watchOS 8.4",
    "19S550": "watchOS 8.4.1",
    "19S553": "watchOS 8.4.2",
    "19T5212h": "watchOS 8.5 beta 1",
    "19T5223e": "watchOS 8.5 beta 2",
    "19T5228d": "watchOS 8.5 beta 3",
    "19T5238a": "watchOS 8.5 beta 4",
    "19T5241a": "watchOS 8.5 beta 5",
    "19T242": "watchOS 8.5",
    "19T252": "watchOS 8.5.1",
    "19T5547f": "watchOS 8.6 beta 1",
    "19T5557d": "watchOS 8.6 beta 2",
    "19T5562f": "watchOS 8.6 beta 3",
    "19T5570a": "watchOS 8.6 beta 4",
    "19T572": "watchOS 8.6",
    "19U66": "watchOS 8.7",
    "19U67": "watchOS 8.7.1",
    "19U512": "watchOS 8.8.1",
    "20R5287q": "watchOS 9.0 beta 1",
    "20R5307h": "watchOS 9.0 beta 2",
    "20R5316f": "watchOS 9.0 beta 3",
    "20R5332g": "watchOS 9.0 beta 4",
    "20R5343e": "watchOS 9.0 beta 5",
    "20R5353a": "watchOS 9.0 beta 6",
    "20R5359a": "watchOS 9.0 beta 7",
    "20R361": "watchOS 9.0",
    "20R364": "watchOS 9.0",
    "20R8363": "watchOS 9.0",
    "20R8380": "watchOS 9.0.1",
    "20R383": "watchOS 9.0.2",
    "20R8391": "watchOS 9.0.2",
    "20S5044e": "watchOS 9.1 beta 1",
    "20S5049d": "watchOS 9.1 beta 2",
    "20S5055e": "watchOS 9.1 beta 3",
    "20S5063c": "watchOS 9.1 beta 4",
    "20S5072a": "watchOS 9.1 beta 5",
    "20S75": "watchOS 9.1",
    "20S5331e": "watchOS 9.2 beta 1",
    "20S5342d": "watchOS 9.2 beta 2",
    "20S5348d": "watchOS 9.2 beta 3",
    "20S5357b": "watchOS 9.2 beta 4",
    "20S361": "watchOS 9.2",
    "20S5626e": "watchOS 9.3 beta 1",
    "20S5637h": "watchOS 9.3 beta 2",
    "20S648": "watchOS 9.3",
    "20S664": "watchOS 9.3.1",
    "20T5222g": "watchOS 9.4 beta 1",
    "20T5233d": "watchOS 9.4 beta 2",
    "20T5239f": "watchOS 9.4 beta 3",
    "20T5249a": "watchOS 9.4 beta 4",
    "20T253": "watchOS 9.4",
    "20T5527c": "watchOS 9.5 beta 1",
    "20T5538d": "watchOS 9.5 beta 2",
    "20T5549e": "watchOS 9.5 beta 3",
    "20T5560a": "watchOS 9.5 beta 4",
    "20T562": "watchOS 9.5",
    "20T570": "watchOS 9.5.1",
    "20T571": "watchOS 9.5.2",
    "20U5527c": "watchOS 9.6 beta 1",
    "20U5538d": "watchOS 9.6 beta 2",
    "20U5548c": "watchOS 9.6 beta 3",
    "20U5559c": "watchOS 9.6 beta 4",
    "20U5570a": "watchOS 9.6 beta 5",
    "20U73": "watchOS 9.6",
    "20U80": "watchOS 9.6.1",
    "20U90": "watchOS 9.6.2",
    "20U502": "watchOS 9.6.3",
    "21R5275t": "watchOS 10.0 beta 1",
    "21R5295g": "watchOS 10.0 beta 2",
    "21R5305e": "watchOS 10.0 beta 3",
    "21R5320i": "watchOS 10.0 beta 4",
    "21R5332f": "watchOS 10.0 beta 5",
    "21R5341c": "watchOS 10.0 beta 6",
    "21R5349b": "watchOS 10.0 beta 7",
    "21R5355a": "watchOS 10.0 beta 8",
    "21R355": "watchOS 10.0",
    "21R356": "watchOS 10.0",
    "21R360": "watchOS 10.0.1",
    "21R371": "watchOS 10.0.2",
    "21S5042f": "watchOS 10.1 beta 1",
    "21S5053f": "watchOS 10.1 beta 2",
    "21S5063a": "watchOS 10.1 beta 3",
    "21S67": "watchOS 10.1",
    "21S71": "watchOS 10.1.1",
    "21S5331f": "watchOS 10.2 beta 1",
    "21S5342e": "watchOS 10.2 beta 2",
    "21S5349e": "watchOS 10.2 beta 3",
    "21S5358a": "watchOS 10.2 beta 4",
    "21S364": "watchOS 10.2",
    "21S5625c": "watchOS 10.3 beta 1",
    "21S5635d": "watchOS 10.3 beta 2",
    "21S5642a": "watchOS 10.3 beta 3",
    "21S644": "watchOS 10.3",
    "21S651": "watchOS 10.3.1",
    "21T5185g": "watchOS 10.4 beta 1",
    "21T5196d": "watchOS 10.4 beta 2",
    "21T5202e": "watchOS 10.4 beta 3",
    "21T5213a": "watchOS 10.4 beta 4",
}

domains = {
    "AppDomain-": "private/var/mobile/Containers/Data/Application",
    "AppDomainGroup-" : "private/var/mobile/Containers/Shared/AppGroup",
    "AppDomainPlugin-" : "private/var/mobile/Containers/Data/PluginKitPlugin",
    "CameraRollDomain" : "private/var/mobile/Media",
    "DatabaseDomain": "private/var/db",
    "HealthDomain": "private/var/mobile",
    "HomeDomain": "private/var/mobile",
    "HomeKitDomain": "private/var/mobile", 
    "InstallDomain": "private/var/installd",
    "KeyboardDomain": "private/var/mobile",
    "KeychainDomain" : "private/var/protected/trustd/private",
    "ManagedPreferencesDomain": "private/var/Managed Preferences",
    "MediaDomain": "private/var/mobile",
    "MobileDeviceDomain": "private/var/MobileDevice",
    "NetworkDomain": "private/var/networkd",
    "ProtectedDomain": "private/var/protected",
    "RootDomain": "private/var/root",
    "SysContainerDomain-": "private/var/containers/Data/System",
    "SysSharedContainerDomain-": "private/var/containers/Shared/SystemGroup",
    "SystemPreferencesDomain": "private/var/preferences",
    "TonesDomain": "private/var/mobile",
    "WirelessDomain": "private/var/wireless"
}

device_id = {
    "Watch1,1": "Apple Watch (1st generation) - 38mm",
    "Watch1,2": "Apple Watch (1st generation) - 42mm",
    "Watch2,3": "Apple Watch Series 2 - 38mm",
    "Watch2,4": "Apple Watch Series 2 - 42mm",
    "Watch2,6": "Apple Watch Series 1 - 38mm",
    "Watch2,7": "Apple Watch Series 1 - 42mm",
    "Watch3,1": "Apple Watch Series 3 Cellular - 38mm",
    "Watch3,2": "Apple Watch Series 3 Cellular - 42mm",
    "Watch3,3": "Apple Watch Series 3 - 38mm",
    "Watch3,4": "Apple Watch Series 3 - 42mm",
    "Watch4,1": "Apple Watch Series 4 - 40mm",
    "Watch4,2": "Apple Watch Series 4 - 44mm",
    "Watch4,3": "Apple Watch Series 4 Cellular - 40mm",
    "Watch4,4": "Apple Watch Series 4 Cellular - 44mm",
    "Watch5,1": "Apple Watch Series 5 - 40mm",
    "Watch5,2": "Apple Watch Series 5 - 44mm",
    "Watch5,3": "Apple Watch Series 5 Cellular - 40mm",
    "Watch5,4": "Apple Watch Series 5 Cellular - 44mm",
    "Watch5,9": "Apple Watch SE - 40mm",
    "Watch5,10": "Apple Watch SE - 44mm",
    "Watch5,11": "Apple Watch SE Cellular - 40mm",
    "Watch5,12": "Apple Watch SE Cellular - 44mm",
    "Watch6,1": "Apple Watch Series 6 - 40mm",
    "Watch6,2": "Apple Watch Series 6 - 44mm",
    "Watch6,3": "Apple Watch Series 6 Cellular - 40mm",
    "Watch6,4": "Apple Watch Series 6 Cellular - 44mm",
    "Watch6,6": "Apple Watch Series 7 - 41mm",
    "Watch6,7": "Apple Watch Series 7 - 45mm",
    "Watch6,8": "Apple Watch Series 7 Cellular - 41mm",
    "Watch6,9": "Apple Watch Series 7 Cellular - 45mm",
    "Watch6,10": "Apple Watch SE (2nd generation) - 40mm",
    "Watch6,11": "Apple Watch SE (2nd generation) - 44mm",
    "Watch6,12": "Apple Watch SE (2nd generation) Cellular - 40mm",
    "Watch6,13": "Apple Watch SE (2nd generation) Cellular - 44mm",
    "Watch6,14": "Apple Watch Series 8 - 41mm",
    "Watch6,15": "Apple Watch Series 8 - 45mm",
    "Watch6,16": "Apple Watch Series 8 Cellular - 41mm",
    "Watch6,17": "Apple Watch Series 8 Cellular - 45mm",
    "Watch6,18": "Apple Watch Ultra",
    "Watch7,1": "Apple Watch Series 9 - 41mm",
    "Watch7,2": "Apple Watch Series 9 - 45mm",
    "Watch7,3": "Apple Watch Series 9 Cellular - 41mm",
    "Watch7,4": "Apple Watch Series 9 Cellular - 45mm",
    "Watch7,5": "Apple Watch Ultra 2",
    "iPhone1,1": "iPhone",
    "iPhone1,2": "iPhone 3G",
    "iPhone2,1": "iPhone 3GS",
    "iPhone3,1": "iPhone 4 (GSM)",
    "iPhone3,2": "iPhone 4 (GSM, Revision A)",
    "iPhone3,3": "iPhone 4 (CDMA)",
    "iPhone4,1": "iPhone 4s",
    "iPhone5,1": "iPhone 5 (GSM)",
    "iPhone5,2": "iPhone 5 (CDMA)",
    "iPhone5,3": "iPhone 5c",
    "iPhone5,4": "iPhone 5c",
    "iPhone6,1": "iPhone 5s",
    "iPhone6,2": "iPhone 5s",
    "iPhone7,1": "iPhone 6 Plus",
    "iPhone7,2": "iPhone 6",
    "iPhone8,1": "iPhone 6s",
    "iPhone8,2": "iPhone 6s Plus",
    "iPhone8,4": "iPhone SE (1st generation)",
    "iPhone9,1": "iPhone 7",
    "iPhone9,2": "iPhone 7 Plus",
    "iPhone9,3": "iPhone 7",
    "iPhone9,4": "iPhone 7 Plus",
    "iPhone10,1": "iPhone 8",
    "iPhone10,2": "iPhone 8 Plus",
    "iPhone10,3": "iPhone X",
    "iPhone10,4": "iPhone 8",
    "iPhone10,5": "iPhone 8 Plus",
    "iPhone10,6": "iPhone X",
    "iPhone11,2": "iPhone XS",
    "iPhone11,4": "iPhone XS Max",
    "iPhone11,6": "iPhone XS Max",
    "iPhone11,8": "iPhone XR",
    "iPhone12,1": "iPhone 11",
    "iPhone12,3": "iPhone 11 Pro",
    "iPhone12,5": "iPhone 11 Pro Max",
    "iPhone12,8": "iPhone SE (2nd generation)",
    "iPhone13,1": "iPhone 12 mini",
    "iPhone13,2": "iPhone 12",
    "iPhone13,3": "iPhone 12 Pro",
    "iPhone13,4": "iPhone 12 Pro Max",
    "iPhone14,2": "iPhone 13 Pro",
    "iPhone14,3": "iPhone 13 Pro Max",
    "iPhone14,4": "iPhone 13 mini",
    "iPhone14,5": "iPhone 13",
    "iPhone14,6": "iPhone SE (3rd generation)",
    "iPhone14,7": "iPhone 14",
    "iPhone14,8": "iPhone 14 Plus",
    "iPhone15,2": "iPhone 14 Pro",
    "iPhone15,3": "iPhone 14 Pro Max",
    "iPhone15,4": "iPhone 15",
    "iPhone15,5": "iPhone 15 Plus",
    "iPhone16,1": "iPhone 15 Pro",
    "iPhone16,2": "iPhone 15 Pro Max",
    "iPad1,1": "iPad",
    "iPad1,2": "iPad 3G",
    "iPad2,1": "iPad (2nd generation)",
    "iPad2,2": "iPad (GSM) (2nd generation)",
    "iPad2,3": "iPad (CDMA) (2nd generation)",
    "iPad2,4": "iPad (New Revision) (2nd generation)",
    "iPad3,1": "iPad (3rd generation)",
    "iPad3,2": "iPad (CDMA) (3rd generation)",
    "iPad3,3": "iPad (GSM) (3rd generation)",
    "iPad2,5": "iPad mini",
    "iPad2,6": "iPad mini (GSM+LTE)",
    "iPad2,7": "iPad mini (CDMA+LTE)",
    "iPad3,4": "iPad (4th generation)",
    "iPad3,5": "iPad (GSM+LTE) (4th generation)",
    "iPad3,6": "iPad (CDMA+LTE) (4th generation)",
    "iPad4,1": "iPad Air (WiFi)",
    "iPad4,2": "iPad Air (GSM+CDMA)",
    "iPad4,3": "iPad Air (China) (1st generation)",
    "iPad4,4": "iPad mini Retina (WiFi)",
    "iPad4,5": "iPad mini Retina (GSM+CDMA)",
    "iPad4,6": "iPad mini Retina (China)",
    "iPad4,7": "iPad mini 3 (WiFi)",
    "iPad4,8": "iPad mini 3 (GSM+CDMA)",
    "iPad4,9": "iPad mini 3 (China)",
    "iPad5,1": "iPad mini 4 (WiFi)",
    "iPad5,2": "iPad mini (WiFi+Cellular) (4th generation)",
    "iPad5,3": "iPad Air 2 (WiFi)",
    "iPad5,4": "iPad Air 2 (Cellular)",
    "iPad6,3": "iPad Pro (9.7 inch, WiFi)",
    "iPad6,4": "iPad Pro (9.7 inch, WiFi+LTE)",
    "iPad6,7": "iPad Pro (12.9 inch, WiFi)",
    "iPad6,8": "iPad Pro (12.9 inch, WiFi+LTE)",
    "iPad6,11": "iPad (2017)",
    "iPad6,12": "iPad (2017)",
    "iPad7,1": "iPad Pro (WiFi) (2nd generation)",
    "iPad7,2": "iPad Pro (WiFi+Cellular) (2nd generation)",
    "iPad7,3": "iPad Pro 10.5-inch (2nd generation)",
    "iPad7,4": "iPad Pro 10.5-inch (2nd generation)",
    "iPad7,5": "iPad (WiFi) (6th generation)",
    "iPad7,6": "iPad (WiFi+Cellular) (6th generation)",
    "iPad7,11": "iPad 10.2-inch (WiFi) (7th generation)",
    "iPad7,12": "iPad 10.2-inch (WiFi+Cellular) (7th generation)",
    "iPad8,1": "iPad Pro 11 inch (WiFi) (3rd generation)",
    "iPad8,2": "iPad Pro 11 inch (1TB, WiFi) (3rd generation)",
    "iPad8,3": "iPad Pro 11 inch (WiFi+Cellular) (3rd generation)",
    "iPad8,4": "iPad Pro 11 inch (1TB, WiFi+Cellular) (3rd generation)",
    "iPad8,5": "iPad Pro 12.9 inch (WiFi) (3rd generation)",
    "iPad8,6": "iPad Pro 12.9 inch (1TB, WiFi) (3rd generation)",
    "iPad8,7": "iPad Pro 12.9 inch (WiFi+Cellular) (3rd generation)",
    "iPad8,8": "iPad Pro 12.9 inch (1TB, WiFi+Cellular) (3rd generation)",
    "iPad8,9": "iPad Pro 11 inch (WiFi) (4th generation)",
    "iPad8,10": "iPad Pro 11 inch (WiFi+Cellular) (4th generation)",
    "iPad8,11": "iPad Pro 12.9 inch (WiFi) (4th generation)",
    "iPad8,12": "iPad Pro 12.9 inch (WiFi+Cellular) (4th generation)",
    "iPad11,1": "iPad mini (WiFi) (5th generation)",
    "iPad11,2": "iPad mini  (5th generation)",
    "iPad11,3": "iPad Air (WiFi) (3rd generation)",
    "iPad11,4": "iPad Air  (3rd generation)",
    "iPad11,6": "iPad (WiFi) (8th generation)",
    "iPad11,7": "iPad (WiFi+Cellular) (8th generation)",
    "iPad12,1": "iPad (WiFi) (9th generation)",
    "iPad12,2": "iPad (WiFi+Cellular) (9th generation)",
    "iPad13,1": "iPad Air (WiFi) (4th generation)",
    "iPad13,2": "iPad Air (WiFi+Cellular) (4th generation)",
    "iPad13,4": "iPad Pro 11 inch (5th generation)",
    "iPad13,5": "iPad Pro 11 inch (5th generation)",
    "iPad13,6": "iPad Pro 11 inch (5th generation)",
    "iPad13,7": "iPad Pro 11 inch (5th generation)",
    "iPad13,8": "iPad Pro 12.9 inch (5th generation)",
    "iPad13,9": "iPad Pro 12.9 inch (5th generation)",
    "iPad13,10": "iPad Pro 12.9 inch (5th generation)",
    "iPad13,11": "iPad Pro 12.9 inch (5th generation)",
    "iPad13,16": "iPad Air (WiFi) (5th generation)",
    "iPad13,17": "iPad Air (WiFi+Cellular) (5th generation)",
    "iPad13,18": "iPad (10th generation)",
    "iPad13,19": "iPad (10th generation)",
    "iPad14,1": "iPad mini(WiFi) (6th generation)",
    "iPad14,2": "iPad mini(WiFi+Cellular) (6th generation)",
    "iPad14,3": "iPad Pro 11 inch (4th generation)",
    "iPad14,4": "iPad Pro 11 inch (4th generation)",
    "iPad14,5": "iPad Pro 12.9 inch (6th generation)",
    "iPad14,6": "iPad Pro 12.9 inch (6th generation)",
}

code_name = {
    "J1": "iPad (3rd Gen) (Wifi)",
    "J2": "iPad (3rd Gen) (Wifi & Cellular)",
    "J72": "iPad Air",
    "J82": "iPad Air 2",
    "J85": "iPad Mini w/ Retina Display",
    "J96": "iPad Mini 4",
    "J98": "iPad Pro",
    "J99": "iPad Pro",
    "K48": "iPad (1st Gen)",
    "K93": "iPad 2 (Wifi)",
    "K94": "iPad 2 (Wifi & GSM)",
    "K95": "iPad 2 (Wifi & CDMA)",
    "P101": "iPad (4th Gen) (Wifi)",
    "P103": "iPad (4th Gen) (Wifi & Cellular International)",
    "P105": "iPad Mini (1st Gen) (Wifi)",
    "P107": "iPad Mini (1st Gen) (Wifi & Cellular International)",
    "M68": "iPhone (1st Gen)",
    "N82": "iPhone 3G",
    "N88": "iPhone 3GS",
    "N90": "iPhone 4",
    "N92": "iPhone 4 (CDMA)",
    "N94": "iPhone 4S",
    "N41": "iPhone 5",
    "N42": "iPhone 5",
    "N48": "iPhone 5C",
    "Mesa": "Touch ID",
    "N51": "iPhone 5S",
    "N53": "iPhone 5S",
    "N61": "iPhone 6",
    "N56": "iPhone 6 Plus",
    "N69": "iPhone SE (1st Gen)",
    "N71": "iPhone 6S",
    "N66": "iPhone 6S Plus",
    "D10": "iPhone 7",
    "D11": "iPhone 7 Plus",
    "D20": "iPhone 8",
    "D21": "iPhone 8 Plus",
    "Pearl": "Face ID",
    "D22": "iPhone X",
    "N84": "iPhone XR",
    "D32": "iPhone XS",
    "D33": "iPhone XS Max",
    "N104": "iPhone 11",
    "D42": "iPhone 11 Pro",
    "D43": "iPhone 11 Pro Max",
    "D52G": "iPhone 12 Mini",
    "D53G": "iPhone 12",
    "D52P": "iPhone 12 Pro",
    "D52P": "iPhone 12 Pro Max",
    "D79": "iPhone SE (2nd Gen)",
    "D16": "iPhone 13 mini",
    "D17": "iPhone 13",
    "D63": "iPhone 13 Pro",
    "D64": "iPhone 13 Pro Max",
    "D27": "iPhone 14",
    "D28": "iPhone 14 Plus",
    "D73": "iPhone 14 Pro",
    "D74": "iPhone 14 Pro Max",
    "D37": "iPhone 15",
    "D38": "iPhone 15 Plus",
    "D83": "iPhone 15 Pro",
    "D84": "iPhone 15 Pro Max",
    "D49": "iPhone SE (3rd Gen)",
    "D59": "iPhone SE (4th Gen)",
}

platforms = {
    1:"iPad",
    2:"iPhone",
    3:"macOS",
    4:"macOS",
    6:"watchOS"
}

def get_root_path_from_domain(domain):
    if domain in domains:
        return domains[domain]
    elif ('-') in domain:
        dash_position = domain.find("-") + 1
        path = domains[domain[:dash_position]]
        bundle_identifier = domain[dash_position:]
        return join(path, bundle_identifier)
    return ''

