def determine_ngram_database(arch):
    if arch == "x86_64":
        return False, MOST_COMMON_3GRAMS_X86_64
    elif arch == "x86":
        return False, MOST_COMMON_3GRAMS_X86_32
    elif arch == "aarch64":
        return False, MOST_COMMON_3GRAMS_AARCH64
    elif arch == "armv7":
        return False, MOST_COMMON_3GRAMS_ARM32
    else:
        return False, None


# 1k most common 3-grams for X86_64
MOST_COMMON_3GRAMS_X86_64 = {
    'addaddadd',
    'addaddcmp',
    'addaddmov',
    'addaddpop',
    'addcallcmp',
    'addcallmov',
    'addcalltest',
    'addcmpja',
    'addcmpjae',
    'addcmpjb',
    'addcmpjbe',
    'addcmpje',
    'addcmpjg',
    'addcmpjge',
    'addcmpjl',
    'addcmpjle',
    'addcmpjne',
    'addjmpcmp',
    'addjmplea',
    'addjmpmov',
    'addleacmp',
    'addlealea',
    'addleamov',
    'addmovadd',
    'addmovand',
    'addmovcall',
    'addmovcmp',
    'addmovjmp',
    'addmovlea',
    'addmovmov',
    'addmovmovzx',
    'addmovpop',
    'addmovror',
    'addmovsub',
    'addmovtest',
    'addmovxor',
    'addmovzxcmp',
    'addmovzxmov',
    'addmovzxmovzx',
    'addmovzxtest',
    'addpopmov',
    'addpoppop',
    'addpopretn',
    'addretncall',
    'addshladd',
    'addsubmov',
    'addtestje',
    'addtestjne',
    'addxormov',
    'addxorpop',
    'addxorxor',
    'andaddmov',
    'andcmpje',
    'andcmpjne',
    'andjecmp',
    'andjemov',
    'andmovmov',
    'andnpdcvtsi2sdmovapd',
    'andormov',
    'andpdsubsdorpd',
    'andpducomisdjbe',
    'andtestje',
    'andtestjne',
    'calladdadd',
    'calladdcmp',
    'calladdjmp',
    'calladdlea',
    'calladdmov',
    'calladdpop',
    'calladdretn',
    'calladdtest',
    'calladdxor',
    'callcalllea',
    'callcallmov',
    'callcallxor',
    'callcmpja',
    'callcmpje',
    'callcmpjg',
    'callcmpjle',
    'callcmpjne',
    'callcmpmov',
    'calljmpcall',
    'calljmpcmp',
    'calljmplea',
    'calljmpmov',
    'calljmptest',
    'calljmpxor',
    'callleacall',
    'calllealea',
    'callleamov',
    'callleaveretn',
    'callleaxor',
    'callmovadd',
    'callmovcall',
    'callmovcmp',
    'callmovdqamov',
    'callmovjmp',
    'callmovlea',
    'callmovmov',
    'callmovmovsd',
    'callmovmovsxd',
    'callmovmovzx',
    'callmovpop',
    'callmovpxor',
    'callmovsdmov',
    'callmovsdmovsd',
    'callmovsub',
    'callmovsxdmov',
    'callmovtest',
    'callmovxor',
    'callmovzxmov',
    'callnopmov',
    'callpopmov',
    'callpoppop',
    'callpopxor',
    'callpushlea',
    'callpushmov',
    'callpushxor',
    'callpxormov',
    'callpxorpxor',
    'callsubmov',
    'callsubmovdqa',
    'callsubxor',
    'calltestje',
    'calltestjne',
    'calltestjns',
    'calltestjs',
    'calltestmov',
    'callxoradd',
    'callxorcall',
    'callxorjmp',
    'callxorlea',
    'callxormov',
    'callxorpop',
    'callxortest',
    'callxorxor',
    'cmovemovcall',
    'cmovemovmov',
    'cmpjaadd',
    'cmpjacmp',
    'cmpjaecmp',
    'cmpjaelea',
    'cmpjaemov',
    'cmpjaetest',
    'cmpjalea',
    'cmpjamov',
    'cmpjbcmp',
    'cmpjbecmp',
    'cmpjbelea',
    'cmpjbemov',
    'cmpjbjmp',
    'cmpjbmov',
    'cmpjeadd',
    'cmpjecall',
    'cmpjecmp',
    'cmpjeja',
    'cmpjejg',
    'cmpjejmp',
    'cmpjelea',
    'cmpjemov',
    'cmpjemovzx',
    'cmpjenop',
    'cmpjesub',
    'cmpjetest',
    'cmpjexor',
    'cmpjgcmp',
    'cmpjgemov',
    'cmpjgmov',
    'cmpjlecmp',
    'cmpjlelea',
    'cmpjlemov',
    'cmpjlmov',
    'cmpjneadd',
    'cmpjnecall',
    'cmpjnecmp',
    'cmpjnejmp',
    'cmpjnelea',
    'cmpjnemov',
    'cmpjnemovzx',
    'cmpjnenop',
    'cmpjnesub',
    'cmpjnetest',
    'cmpjnexor',
    'cmplealea',
    'cmpmovje',
    'cmpmovjne',
    'cmpmovlea',
    'cmpmovmov',
    'cmpmovsete',
    'cmpsdandpdsubsd',
    'cmpsetecmp',
    'cvtsi2sdmovapdcmpsd',
    'cvttsd2sipxormovsd',
    'endbr64pushmov',
    'imulmovmov',
    'jacmpje',
    'jaeleamov',
    'jaemovmov',
    'jaleamov',
    'jaleamovsxd',
    'jaleamovzx',
    'jamovadd',
    'jamovlea',
    'jamovmov',
    'jbecmpje',
    'jbecmpjne',
    'jbecvttsd2sipxor',
    'jbemovadd',
    'jbemovlea',
    'jbemovmov',
    'jbmovcall',
    'jbmovmov',
    'jeaddcmp',
    'jeaddmov',
    'jeaddpop',
    'jecalladd',
    'jecallcmp',
    'jecalljmp',
    'jecalllea',
    'jecallmov',
    'jecalltest',
    'jecmpja',
    'jecmpjbe',
    'jecmpje',
    'jecmpjg',
    'jecmpjle',
    'jecmpjne',
    'jecmpmov',
    'jejacmp',
    'jejmpcmp',
    'jejmpmov',
    'jejmpretn',
    'jeleacall',
    'jeleacmp',
    'jeleajmp',
    'jelealea',
    'jeleamov',
    'jeleaxor',
    'jemovadd',
    'jemovand',
    'jemovcall',
    'jemovcmp',
    'jemovjmp',
    'jemovlea',
    'jemovmov',
    'jemovmovzx',
    'jemovnop',
    'jemovpop',
    'jemovretn',
    'jemovshl',
    'jemovsub',
    'jemovsxdmov',
    'jemovtest',
    'jemovxor',
    'jemovzxcmp',
    'jemovzxmov',
    'jemovzxtest',
    'jenopmov',
    'jepushmov',
    'jesubmov',
    'jetestje',
    'jetestjne',
    'jexorcmp',
    'jexorjmp',
    'jexorlea',
    'jexormov',
    'jexorxor',
    'jgcmpje',
    'jgemovmov',
    'jgmovmov',
    'jleleamov',
    'jlemovlea',
    'jlemovmov',
    'jlesubmov',
    'jmpaddcmp',
    'jmpaddlea',
    'jmpaddmov',
    'jmpaddpop',
    'jmpcalljmp',
    'jmpcalllea',
    'jmpcallmov',
    'jmpcmpja',
    'jmpcmpjbe',
    'jmpcmpje',
    'jmpcmpjne',
    'jmpcmpmov',
    'jmpleacall',
    'jmpleacmp',
    'jmpleajmp',
    'jmplealea',
    'jmpleamov',
    'jmpleaxor',
    'jmpmovadd',
    'jmpmovand',
    'jmpmovcall',
    'jmpmovcmp',
    'jmpmovjmp',
    'jmpmovlea',
    'jmpmovmov',
    'jmpmovmovzx',
    'jmpmovpop',
    'jmpmovsub',
    'jmpmovsxdmov',
    'jmpmovtest',
    'jmpmovxor',
    'jmpmovzxcmp',
    'jmpmovzxmov',
    'jmpnopjmp',
    'jmpnopmov',
    'jmporjmp',
    'jmppoppop',
    'jmpsubmov',
    'jmptestje',
    'jmptestjne',
    'jmpxorcmp',
    'jmpxorjmp',
    'jmpxorlea',
    'jmpxormov',
    'jmpxorxor',
    'jneaddadd',
    'jneaddcmp',
    'jneaddmov',
    'jneaddpop',
    'jneaddretn',
    'jneaddxor',
    'jnecallmov',
    'jnecmpjbe',
    'jnecmpje',
    'jnecmpjne',
    'jnecmpmov',
    'jnejmpadd',
    'jnejmpcall',
    'jnejmpcmp',
    'jnejmplea',
    'jnejmpmov',
    'jneleaadd',
    'jneleacall',
    'jneleacmp',
    'jneleajmp',
    'jnelealea',
    'jneleamov',
    'jnemovadd',
    'jnemovand',
    'jnemovcall',
    'jnemovcmp',
    'jnemovjmp',
    'jnemovlea',
    'jnemovmov',
    'jnemovmovzx',
    'jnemovpop',
    'jnemovsub',
    'jnemovtest',
    'jnemovxor',
    'jnemovzxcmp',
    'jnemovzxmov',
    'jnenopmov',
    'jnepoppop',
    'jnepopretn',
    'jnetestje',
    'jnetestjne',
    'jnexorjmp',
    'jnexormov',
    'jnexortest',
    'jnexorxor',
    'jnsmovmov',
    'jsmovmov',
    'leaaddlea',
    'leaaddmov',
    'leacalladd',
    'leacallcall',
    'leacallcmp',
    'leacalljmp',
    'leacalllea',
    'leacallmov',
    'leacallnop',
    'leacallpop',
    'leacalltest',
    'leacallxor',
    'leacmovemov',
    'leacmpja',
    'leacmpjae',
    'leacmpjbe',
    'leacmpje',
    'leacmpjne',
    'leacmpmov',
    'leajmpadd',
    'leajmpcmp',
    'leajmplea',
    'leajmpmov',
    'lealeacall',
    'lealeacmovne',
    'lealeacmp',
    'lealeajmp',
    'lealealea',
    'lealeamov',
    'lealeamovq',
    'lealeapop',
    'lealeapush',
    'lealeasub',
    'lealeaxor',
    'leamovadd',
    'leamovcall',
    'leamovcmp',
    'leamovjmp',
    'leamovlea',
    'leamovmov',
    'leamovmovsxd',
    'leamovmovzx',
    'leamovnop',
    'leamovpop',
    'leamovpush',
    'leamovqlea',
    'leamovqmov',
    'leamovqmovq',
    'leamovshl',
    'leamovsub',
    'leamovsxdadd',
    'leamovtest',
    'leamovxor',
    'leamovzxmov',
    'leamovzxmovsxd',
    'leanopmov',
    'leapopjmp',
    'leapoplea',
    'leapopmov',
    'leapoppop',
    'leapushcall',
    'leapushlea',
    'leapushmov',
    'leapushpush',
    'leapushxor',
    'leashladd',
    'leasubcall',
    'leasubmov',
    'leatestje',
    'leatestjne',
    'leaxorcall',
    'leaxorlea',
    'leaxormov',
    'leaxorpush',
    'leaxorxor',
    'movaddadd',
    'movaddcall',
    'movaddcmp',
    'movaddjmp',
    'movaddlea',
    'movaddmov',
    'movaddmovzx',
    'movaddpop',
    'movaddretn',
    'movaddsub',
    'movaddtest',
    'movaddxor',
    'movandand',
    'movandcmp',
    'movandmov',
    'movandshl',
    'movandtest',
    'movapdandpducomisd',
    'movapdcmpsdandpd',
    'movapdmovmov',
    'movapscallmov',
    'movapsmovapscall',
    'movapsmovapsmov',
    'movapsmovapsmovaps',
    'movapsmovdqumovaps',
    'movapsmovmov',
    'movapstestje',
    'movcalladd',
    'movcallcall',
    'movcallcmp',
    'movcalljmp',
    'movcalllea',
    'movcallleave',
    'movcallmov',
    'movcallmovdqa',
    'movcallmovdqu',
    'movcallmovsd',
    'movcallmovsxd',
    'movcallmovzx',
    'movcallnop',
    'movcallpop',
    'movcallpush',
    'movcallpxor',
    'movcallsub',
    'movcalltest',
    'movcallxor',
    'movcdqelea',
    'movcdqidiv',
    'movcmovemov',
    'movcmpcmova',
    'movcmpja',
    'movcmpjae',
    'movcmpjb',
    'movcmpjbe',
    'movcmpje',
    'movcmpjg',
    'movcmpjge',
    'movcmpjl',
    'movcmpjle',
    'movcmpjne',
    'movcmpmov',
    'movcmpsete',
    'movcmpsetne',
    'movdqamovapsmovdqa',
    'movdqamovdqamov',
    'movdqamovdqamovdqa',
    'movdqamovmov',
    'movdqamovmovups',
    'movdqamovupsmov',
    'movdqumovapsmovdqu',
    'movdqumovdqumov',
    'movdqumovdqumovdqu',
    'movdqumovmov',
    'movdqumovmovups',
    'movdqumovupsmov',
    'movdqumovupsmovdqu',
    'movimuladd',
    'movimulmov',
    'movjecmp',
    'movjemov',
    'movjmpadd',
    'movjmpcall',
    'movjmpcmp',
    'movjmplea',
    'movjmpmov',
    'movjmpmovsxd',
    'movjmpmovzx',
    'movjmpnop',
    'movjmpsub',
    'movjmptest',
    'movjmpxor',
    'movjnecmp',
    'movjnemov',
    'movleaadd',
    'movleacall',
    'movleacmp',
    'movleajmp',
    'movlealea',
    'movleamov',
    'movleamovq',
    'movleamovsxd',
    'movleanop',
    'movleapop',
    'movleapush',
    'movleashl',
    'movleasub',
    'movleatest',
    'movleaveretn',
    'movleaxor',
    'movmovadd',
    'movmovand',
    'movmovapscall',
    'movmovapsmov',
    'movmovapsmovaps',
    'movmovcall',
    'movmovcdqe',
    'movmovcmovne',
    'movmovcmp',
    'movmovdqamov',
    'movmovdqumov',
    'movmovimul',
    'movmovje',
    'movmovjmp',
    'movmovjne',
    'movmovlea',
    'movmovleave',
    'movmovmov',
    'movmovmovaps',
    'movmovmovdqa',
    'movmovmovdqu',
    'movmovmovq',
    'movmovmovsd',
    'movmovmovss',
    'movmovmovsxd',
    'movmovmovups',
    'movmovmovzx',
    'movmovnop',
    'movmovor',
    'movmovpop',
    'movmovpush',
    'movmovpxor',
    'movmovqcall',
    'movmovqmov',
    'movmovretn',
    'movmovrol',
    'movmovsar',
    'movmovsdcall',
    'movmovsdmov',
    'movmovsdmovsd',
    'movmovshl',
    'movmovshr',
    'movmovsub',
    'movmovsxcmp',
    'movmovsxdadd',
    'movmovsxdcall',
    'movmovsxdlea',
    'movmovsxdmov',
    'movmovtest',
    'movmovupscall',
    'movmovupsmov',
    'movmovupsmovups',
    'movmovupstest',
    'movmovxor',
    'movmovzxadd',
    'movmovzxand',
    'movmovzxcmp',
    'movmovzxjmp',
    'movmovzxlea',
    'movmovzxmov',
    'movmovzxmovzx',
    'movmovzxor',
    'movmovzxshl',
    'movmovzxtest',
    'movmovzxxor',
    'movnopcmp',
    'movnopmov',
    'movorjmp',
    'movormov',
    'movpopjmp',
    'movpoplea',
    'movpopmov',
    'movpoppop',
    'movpopretn',
    'movpopxor',
    'movpushcall',
    'movpushlea',
    'movpushmov',
    'movpushpush',
    'movpushsub',
    'movpushxor',
    'movpxorlea',
    'movpxormov',
    'movpxorpxor',
    'movqcallmov',
    'movqleamov',
    'movqleapunpcklqdq',
    'movqmovcall',
    'movqmovlea',
    'movqmovmov',
    'movqmovmovq',
    'movqmovqlea',
    'movqpunpcklqdqmovups',
    'movretnmov',
    'movretnpush',
    'movrolxor',
    'movsarmov',
    'movsdandnpdcvtsi2sd',
    'movsdcallmov',
    'movsdcallmovsd',
    'movsdjmpmov',
    'movsdmovapdmovapd',
    'movsdmovcall',
    'movsdmovlea',
    'movsdmovmov',
    'movsdmovmovsd',
    'movsdmovsdcall',
    'movsdmovsdmov',
    'movsdmovsdmovapd',
    'movsdmovsdmovsd',
    'movsdtestje',
    'movshladd',
    'movshllea',
    'movshlmov',
    'movshradd',
    'movshrand',
    'movshrmov',
    'movshrxor',
    'movssmovssmovss',
    'movsubadd',
    'movsubcall',
    'movsubcmp',
    'movsubjmp',
    'movsubjne',
    'movsublea',
    'movsubmov',
    'movsubsar',
    'movsubsub',
    'movsubtest',
    'movsxdaddjmp',
    'movsxdaddmov',
    'movsxdcallmov',
    'movsxdleamov',
    'movsxdmovadd',
    'movsxdmovcall',
    'movsxdmovlea',
    'movsxdmovmov',
    'movsxdmovxor',
    'movsxmovmov',
    'movtestje',
    'movtestjg',
    'movtestjle',
    'movtestjne',
    'movtestjns',
    'movtestjs',
    'movtestmov',
    'movupscallmov',
    'movupsmovcall',
    'movupsmovdqumovups',
    'movupsmovmov',
    'movupsmovupsmov',
    'movupsmovupsmovups',
    'movupsmovupstest',
    'movupstestje',
    'movxoradd',
    'movxorand',
    'movxorcall',
    'movxorcmp',
    'movxorjmp',
    'movxorlea',
    'movxormov',
    'movxormovdqa',
    'movxormovzx',
    'movxornop',
    'movxorpop',
    'movxorpush',
    'movxorsub',
    'movxortest',
    'movxorxor',
    'movzxaddcmp',
    'movzxaddmov',
    'movzxandcmp',
    'movzxandmov',
    'movzxandtest',
    'movzxcmpja',
    'movzxcmpje',
    'movzxcmpjne',
    'movzxjmpmov',
    'movzxleacmp',
    'movzxleamov',
    'movzxmovadd',
    'movzxmovand',
    'movzxmovcall',
    'movzxmovcmp',
    'movzxmovjmp',
    'movzxmovlea',
    'movzxmovmov',
    'movzxmovmovzx',
    'movzxmovsxdadd',
    'movzxmovtest',
    'movzxmovzxadd',
    'movzxmovzxand',
    'movzxmovzxmov',
    'movzxormov',
    'movzxshlor',
    'movzxtestje',
    'movzxtestjne',
    'movzxxortest',
    'mulsdmulsdaddsd',
    'nopcmpje',
    'nopcmpjne',
    'nopjmpnop',
    'nopleaveretn',
    'nopmovadd',
    'nopmovcall',
    'nopmovlea',
    'nopmovmov',
    'nopmovsub',
    'nopmovtest',
    'nopmovzxadd',
    'nopmovzxmov',
    'noptestje',
    'orjmpmov',
    'ormovjmp',
    'ormovmov',
    'popjmpadd',
    'popjmpcall',
    'popjmplea',
    'popjmpmov',
    'popjmppop',
    'popjmptest',
    'popjmpxor',
    'popleajmp',
    'poplealea',
    'popleapop',
    'popmovjmp',
    'popmovmov',
    'popmovpop',
    'popmovretn',
    'poppopjmp',
    'poppopmov',
    'poppoppop',
    'poppopretn',
    'poppoptest',
    'popretnadd',
    'popretncall',
    'popretncmp',
    'popretnlea',
    'popretnmov',
    'popretnretn',
    'popretntest',
    'popretnxor',
    'poptestje',
    'popxorpop',
    'pushcalladd',
    'pushcallmov',
    'pushleacall',
    'pushlealea',
    'pushleamov',
    'pushleapush',
    'pushleaxor',
    'pushmovadd',
    'pushmovcall',
    'pushmovlea',
    'pushmovmov',
    'pushmovpush',
    'pushmovsub',
    'pushmovtest',
    'pushmovxor',
    'pushpushcall',
    'pushpushlea',
    'pushpushmov',
    'pushpushpush',
    'pushpushsub',
    'pushpushtest',
    'pushpushxor',
    'pushsubcall',
    'pushsublea',
    'pushsubmov',
    'pushsubtest',
    'pushtestje',
    'pushxorlea',
    'pushxormov',
    'pushxorpush',
    'pushxorxor',
    'pxorleamov',
    'pxormovcvtsi2sd',
    'pxormovlea',
    'pxormovmov',
    'pxormovsdandnpd',
    'pxorpxorcvtsi2sd',
    'pxorpxormov',
    'repcmpsbsetasbb',
    'retncallmov',
    'retncmpje',
    'retncmpjne',
    'retnleacall',
    'retnlealea',
    'retnleamov',
    'retnmovadd',
    'retnmovcall',
    'retnmovcmp',
    'retnmovjmp',
    'retnmovlea',
    'retnmovmov',
    'retnmovtest',
    'retnmovxor',
    'retnpushlea',
    'retntestje',
    'retntestjne',
    'retnxormov',
    'rolxormov',
    'rorxormov',
    'setasbbtest',
    'shladdmov',
    'shlcallmov',
    'shlleamov',
    'shlmovcall',
    'shlmovmov',
    'shraddmov',
    'shraddsar',
    'shrmovmov',
    'subaddmov',
    'subcalladd',
    'subcalllea',
    'subcallmov',
    'subcalltest',
    'subcmpja',
    'subcmpjb',
    'subcmpjbe',
    'subcmpje',
    'subcmpjne',
    'subjemov',
    'subjmpmov',
    'subjneadd',
    'subjnelea',
    'subjnemov',
    'subleacall',
    'sublealea',
    'subleamov',
    'submovadd',
    'submovcall',
    'submovcmp',
    'submovdqamovdqa',
    'submovjmp',
    'submovlea',
    'submovmov',
    'submovpush',
    'submovshr',
    'submovsub',
    'submovtest',
    'submovxor',
    'subpushmov',
    'subsdorpdmovapd',
    'subsubcmp',
    'subsubmov',
    'subtestje',
    'subtestjne',
    'subxormov',
    'subxorxor',
    'testcmovemov',
    'testjeadd',
    'testjecall',
    'testjecmp',
    'testjejmp',
    'testjelea',
    'testjemov',
    'testjemovsd',
    'testjemovsxd',
    'testjemovzx',
    'testjenop',
    'testjepop',
    'testjepush',
    'testjepxor',
    'testjesub',
    'testjetest',
    'testjexor',
    'testjgmov',
    'testjlelea',
    'testjlemov',
    'testjlemovsxd',
    'testjlenop',
    'testjlesub',
    'testjneadd',
    'testjnecall',
    'testjnecmp',
    'testjnejmp',
    'testjnelea',
    'testjnemov',
    'testjnemovzx',
    'testjnenop',
    'testjnepop',
    'testjnesub',
    'testjnetest',
    'testjnexor',
    'testjnsmov',
    'testjscmp',
    'testjsmov',
    'testleacmove',
    'testmovje',
    'testmovmov',
    'ucomisdjbecvttsd2si',
    'xoraddmov',
    'xoraddpop',
    'xorandje',
    'xorcalladd',
    'xorcallcall',
    'xorcallcmp',
    'xorcalljmp',
    'xorcalllea',
    'xorcallmov',
    'xorcallnop',
    'xorcallpop',
    'xorcalltest',
    'xorcallxor',
    'xorcmpje',
    'xorcmpjne',
    'xorcmpsete',
    'xorjmpadd',
    'xorjmpcall',
    'xorjmpcmp',
    'xorjmplea',
    'xorjmpmov',
    'xorjmpxor',
    'xorleacall',
    'xorlealea',
    'xorleamov',
    'xorleapush',
    'xorleaxor',
    'xormovadd',
    'xormovcall',
    'xormovcmp',
    'xormovdqamov',
    'xormovjmp',
    'xormovlea',
    'xormovmov',
    'xormovpop',
    'xormovpush',
    'xormovrol',
    'xormovsub',
    'xormovtest',
    'xormovxor',
    'xormovzxmov',
    'xornopmov',
    'xorpopjmp',
    'xorpopmov',
    'xorpoppop',
    'xorpopretn',
    'xorpushlea',
    'xorpushmov',
    'xorpushpush',
    'xorpushxor',
    'xortestje',
    'xortestjne',
    'xorxorcall',
    'xorxorjmp',
    'xorxorlea',
    'xorxormov',
    'xorxorpush',
    'xorxorxor'
}

# 1k most common 3-grams for X86_32
MOST_COMMON_3GRAMS_X86_32 = {
    'adcmovmov',
    'addadcadd',
    'addadcmov',
    'addaddadd',
    'addaddcmp',
    'addaddjmp',
    'addaddmov',
    'addaddpop',
    'addaddpush',
    'addaddsub',
    'addaddtest',
    'addcalladd',
    'addcallmov',
    'addcallsub',
    'addcmpja',
    'addcmpjae',
    'addcmpjb',
    'addcmpjbe',
    'addcmpje',
    'addcmpjg',
    'addcmpjge',
    'addcmpjl',
    'addcmpjle',
    'addcmpjne',
    'addcmpmov',
    'addjmpadd',
    'addjmpcall',
    'addjmpcmp',
    'addjmplea',
    'addjmpmov',
    'addjmppush',
    'addjmpsub',
    'addjmptest',
    'addjmpxor',
    'addleacmp',
    'addlealea',
    'addleamov',
    'addleapop',
    'addleapush',
    'addleasub',
    'addleaveretn',
    'addmovadc',
    'addmovadd',
    'addmovand',
    'addmovcall',
    'addmovcmp',
    'addmovjmp',
    'addmovlea',
    'addmovleave',
    'addmovmov',
    'addmovmovzx',
    'addmovpop',
    'addmovpush',
    'addmovshl',
    'addmovsub',
    'addmovtest',
    'addmovxor',
    'addmovzxcmp',
    'addmovzxjmp',
    'addmovzxmov',
    'addmovzxmovzx',
    'addmovzxtest',
    'addpoppop',
    'addpopretn',
    'addpushcall',
    'addpushlea',
    'addpushmov',
    'addpushpush',
    'addpushsub',
    'addsubcall',
    'addsubcmp',
    'addsubfld',
    'addsublea',
    'addsubmov',
    'addsubpush',
    'addtestje',
    'addtestjle',
    'addtestjne',
    'addtestjns',
    'addtestjs',
    'addtestmov',
    'addtestsetne',
    'addxoradd',
    'addxorjmp',
    'addxormov',
    'addxorpop',
    'addxortest',
    'andaddmov',
    'andcmpje',
    'andcmpjne',
    'andjecmp',
    'andjemov',
    'andmovjmp',
    'andmovmov',
    'andmovsub',
    'andormov',
    'andpushpush',
    'andtestje',
    'andtestjne',
    'calladdadd',
    'calladdcall',
    'calladdcmp',
    'calladdfld',
    'calladdjmp',
    'calladdlea',
    'calladdleave',
    'calladdmov',
    'calladdmovzx',
    'calladdpop',
    'calladdpush',
    'calladdretn',
    'calladdsub',
    'calladdtest',
    'calladdxor',
    'callcalladd',
    'callcallmov',
    'callcallpop',
    'callcmpje',
    'callcmpjne',
    'callfldadd',
    'callfldmov',
    'callfstppop',
    'calljmpmov',
    'calljmpsub',
    'callleaadd',
    'calllealea',
    'callleamov',
    'callleapop',
    'callleapush',
    'callmovadd',
    'callmovcall',
    'callmovcmp',
    'callmovjmp',
    'callmovlea',
    'callmovmov',
    'callmovmovzx',
    'callmovpop',
    'callmovpush',
    'callmovsub',
    'callmovtest',
    'callmovxor',
    'callmovzxadd',
    'callmovzxmov',
    'callpoplea',
    'callpopmov',
    'callpoppop',
    'callpoppush',
    'callpushcall',
    'callpushlea',
    'callpushmov',
    'callpushpush',
    'callsublea',
    'callsubmov',
    'callsubpush',
    'calltestje',
    'calltestjne',
    'callxormov',
    'cdqpushpush',
    'cmovemovmov',
    'cmpjaadd',
    'cmpjacmp',
    'cmpjaecmp',
    'cmpjaelea',
    'cmpjaemov',
    'cmpjaesub',
    'cmpjaetest',
    'cmpjajmp',
    'cmpjalea',
    'cmpjamov',
    'cmpjamovzx',
    'cmpjasub',
    'cmpjbecmp',
    'cmpjbejmp',
    'cmpjbelea',
    'cmpjbemov',
    'cmpjbemovzx',
    'cmpjbesub',
    'cmpjbjmp',
    'cmpjbmov',
    'cmpjbsub',
    'cmpjeadd',
    'cmpjecall',
    'cmpjecmp',
    'cmpjeja',
    'cmpjejg',
    'cmpjejmp',
    'cmpjelea',
    'cmpjemov',
    'cmpjemovzx',
    'cmpjepush',
    'cmpjesub',
    'cmpjetest',
    'cmpjexor',
    'cmpjgcmp',
    'cmpjgemov',
    'cmpjglea',
    'cmpjgmov',
    'cmpjgsub',
    'cmpjlecmp',
    'cmpjlelea',
    'cmpjlemov',
    'cmpjlesub',
    'cmpjlmov',
    'cmpjneadd',
    'cmpjnecall',
    'cmpjnecmp',
    'cmpjnefstp',
    'cmpjnejmp',
    'cmpjnelea',
    'cmpjnemov',
    'cmpjnemovzx',
    'cmpjnepush',
    'cmpjnesub',
    'cmpjnetest',
    'cmpjnexor',
    'cmpleaje',
    'cmpmovje',
    'cmpmovjne',
    'cmpmovmov',
    'cmpmovsbb',
    'cmpmovsete',
    'cmpsetecmp',
    'cmpsetnecmp',
    'divmovmov',
    'fcomifstpjbe',
    'fcomipfstpjbe',
    'fildmovmov',
    'fistpfldcwfld',
    'fistpfldcwmov',
    'fldcwfistpfldcw',
    'fldcwfrndintfldcw',
    'fldcwmovmov',
    'fldfldfld',
    'fldfldfmul',
    'fldfmulfaddp',
    'fldfmulfld',
    'fldfmulfxch',
    'fldfstfstp',
    'fldfstpfld',
    'fldfstppush',
    'fldfxchfcomi',
    'fldmovfstp',
    'fldmovmov',
    'fldsubfst',
    'fldsubfstp',
    'fmulfldfmul',
    'fnstcwmovzxor',
    'fstfstfstp',
    'fstfstpfld',
    'fstfstppush',
    'fstpaddcmp',
    'fstpaddpop',
    'fstpaddpush',
    'fstpcalladd',
    'fstpcallfld',
    'fstpcallmov',
    'fstpfildfstp',
    'fstpfldfld',
    'fstpfldfmul',
    'fstpfldfst',
    'fstpfldfstp',
    'fstpfldmov',
    'fstpfstfstp',
    'fstpfstpcall',
    'fstpfstpfstp',
    'fstpfstpjmp',
    'fstpfstpmov',
    'fstpfstppush',
    'fstpfxchfstp',
    'fstpjmpfstp',
    'fstpmovmov',
    'fstppoppop',
    'fstppushcall',
    'fstppushlea',
    'fstppushmov',
    'fstppushpush',
    'fstpsubpush',
    'fstptestje',
    'fucomifstpjpe',
    'fxchfcomifstp',
    'fxchfcomipfstp',
    'fxchfstpfld',
    'fxchfstpfstp',
    'fxchfstpfxch',
    'fxchfxchfxch',
    'fxchfxchjmp',
    'fxchjmpfstp',
    'imuladdmov',
    'imulimuladd',
    'imulmovadd',
    'imulmovmov',
    'incmovmov',
    'jacmpja',
    'jacmpjbe',
    'jacmpje',
    'jaeleamov',
    'jaemovmov',
    'jaetestje',
    'jamovadd',
    'jamovcmp',
    'jamovmov',
    'jamovtest',
    'jasubpush',
    'jbecmpje',
    'jbecmpjne',
    'jbemovadd',
    'jbemovlea',
    'jbemovmov',
    'jbmovmov',
    'jbsubpush',
    'jeaddcmp',
    'jeaddmov',
    'jeaddpop',
    'jecallmov',
    'jecallsub',
    'jecmpja',
    'jecmpjbe',
    'jecmpje',
    'jecmpjg',
    'jecmpjne',
    'jecmpmov',
    'jejacmp',
    'jejmpcmp',
    'jejmpmov',
    'jejmpsub',
    'jeleacmp',
    'jelealea',
    'jeleamov',
    'jeleanop',
    'jeleapush',
    'jeleasub',
    'jemovadd',
    'jemovand',
    'jemovcall',
    'jemovcmp',
    'jemovjmp',
    'jemovlea',
    'jemovmov',
    'jemovmovzx',
    'jemovpush',
    'jemovsub',
    'jemovtest',
    'jemovxor',
    'jemovzxcmp',
    'jemovzxmov',
    'jemovzxtest',
    'jepushlea',
    'jepushmov',
    'jepushpush',
    'jesublea',
    'jesubmov',
    'jesubpush',
    'jetestje',
    'jetestjne',
    'jexorcmp',
    'jexorjmp',
    'jexormov',
    'jgcmpje',
    'jgemovmov',
    'jgmovmov',
    'jleleamov',
    'jlemovlea',
    'jlemovmov',
    'jlemovsub',
    'jlemovtest',
    'jlesubpush',
    'jlmovmov',
    'jmpaddcmp',
    'jmpaddmov',
    'jmpaddpop',
    'jmpcallmov',
    'jmpcallsub',
    'jmpcmpja',
    'jmpcmpjbe',
    'jmpcmpje',
    'jmpcmpjne',
    'jmpcmpmov',
    'jmpfstpfstp',
    'jmpfstpfxch',
    'jmpfstpjmp',
    'jmpfstpmov',
    'jmpleacmp',
    'jmpleajmp',
    'jmpleamov',
    'jmpleapush',
    'jmpleasub',
    'jmpmovadd',
    'jmpmovand',
    'jmpmovcall',
    'jmpmovcmp',
    'jmpmovjmp',
    'jmpmovlea',
    'jmpmovmov',
    'jmpmovmovzx',
    'jmpmovpush',
    'jmpmovsub',
    'jmpmovtest',
    'jmpmovxor',
    'jmpmovzxmov',
    'jmpnopjmp',
    'jmporjmp',
    'jmppushlea',
    'jmppushmov',
    'jmppushpush',
    'jmpsubcmp',
    'jmpsublea',
    'jmpsubmov',
    'jmpsubpush',
    'jmptestje',
    'jmptestjne',
    'jmpxorjmp',
    'jmpxormov',
    'jneaddcmp',
    'jneaddmov',
    'jneaddpop',
    'jnecallmov',
    'jnecallsub',
    'jnecmpjbe',
    'jnecmpje',
    'jnecmpjne',
    'jnecmpmov',
    'jnejmpcmp',
    'jnejmpmov',
    'jnejmpsub',
    'jneleacmp',
    'jnelealea',
    'jneleamov',
    'jneleanop',
    'jneleapop',
    'jneleapush',
    'jneleasub',
    'jnemovadd',
    'jnemovand',
    'jnemovcall',
    'jnemovcmp',
    'jnemovjmp',
    'jnemovlea',
    'jnemovmov',
    'jnemovmovzx',
    'jnemovpush',
    'jnemovsub',
    'jnemovtest',
    'jnemovxor',
    'jnemovzxand',
    'jnemovzxmov',
    'jnepoppop',
    'jnepushlea',
    'jnepushpush',
    'jnesublea',
    'jnesubmov',
    'jnesubpush',
    'jnetestje',
    'jnetestjne',
    'jnexorjmp',
    'jnexormov',
    'jsmovmov',
    'jssubpush',
    'leaaddcmp',
    'leaaddlea',
    'leaaddmov',
    'leaaddpush',
    'leacalladd',
    'leacallmov',
    'leacmovemov',
    'leacmpja',
    'leacmpjae',
    'leacmpjbe',
    'leacmpje',
    'leacmpjne',
    'leacmpmov',
    'leajmpcall',
    'leajmpcmp',
    'leajmplea',
    'leajmpmov',
    'leajmppush',
    'leajmpsub',
    'lealeaadd',
    'lealeacmp',
    'lealealea',
    'lealeamov',
    'lealeapush',
    'lealeasub',
    'leamovadd',
    'leamovcall',
    'leamovcmp',
    'leamovjmp',
    'leamovlea',
    'leamovmov',
    'leamovmovzx',
    'leamovpop',
    'leamovpush',
    'leamovshl',
    'leamovsub',
    'leamovtest',
    'leamovxor',
    'leamovzxadd',
    'leamovzxmov',
    'leanopcmp',
    'leanopmov',
    'leanopsub',
    'leapoppop',
    'leapoppush',
    'leapushcall',
    'leapushjmp',
    'leapushlea',
    'leapushmov',
    'leapushpush',
    'leapushsub',
    'leasublea',
    'leasubmov',
    'leasubpush',
    'leatestje',
    'leatestjne',
    'leaxormov',
    'leaxorpush',
    'movaddadc',
    'movaddadd',
    'movaddand',
    'movaddcall',
    'movaddcmp',
    'movaddjmp',
    'movaddlea',
    'movaddmov',
    'movaddmovzx',
    'movaddpop',
    'movaddpush',
    'movaddsub',
    'movaddtest',
    'movaddxor',
    'movandadd',
    'movandand',
    'movandcmp',
    'movandmov',
    'movandor',
    'movandpush',
    'movandshl',
    'movandshr',
    'movandtest',
    'movcalladd',
    'movcallcall',
    'movcallcmp',
    'movcallfstp',
    'movcalljmp',
    'movcalllea',
    'movcallmov',
    'movcallpop',
    'movcallpush',
    'movcallsub',
    'movcalltest',
    'movcallxor',
    'movcdqidiv',
    'movcmpja',
    'movcmpjae',
    'movcmpjb',
    'movcmpjbe',
    'movcmpje',
    'movcmpjg',
    'movcmpjge',
    'movcmpjl',
    'movcmpjle',
    'movcmpjne',
    'movcmpmov',
    'movcmpsbb',
    'movcmpsete',
    'movcmpsetne',
    'movdivmov',
    'movfildmov',
    'movfldcwfistp',
    'movfldfld',
    'movfldmov',
    'movfstpcall',
    'movfstpfld',
    'movfstpmov',
    'movimuladd',
    'movimulimul',
    'movimulmov',
    'movincmov',
    'movjecmp',
    'movjelea',
    'movjemov',
    'movjesub',
    'movjmpadd',
    'movjmpcall',
    'movjmpcmp',
    'movjmpfstp',
    'movjmplea',
    'movjmpmov',
    'movjmpmovzx',
    'movjmppush',
    'movjmpsub',
    'movjmptest',
    'movjmpxor',
    'movjnecmp',
    'movjnemov',
    'movjnesub',
    'movleaadd',
    'movleaand',
    'movleacall',
    'movleacmp',
    'movleajmp',
    'movlealea',
    'movleamov',
    'movleamovzx',
    'movleanop',
    'movleapop',
    'movleapush',
    'movleashl',
    'movleasub',
    'movleatest',
    'movleaveretn',
    'movleaxor',
    'movmovadd',
    'movmovand',
    'movmovcall',
    'movmovcdq',
    'movmovcmp',
    'movmovdiv',
    'movmovfild',
    'movmovfld',
    'movmovfstp',
    'movmovimul',
    'movmovinc',
    'movmovje',
    'movmovjmp',
    'movmovjne',
    'movmovlea',
    'movmovleave',
    'movmovmov',
    'movmovmovsx',
    'movmovmovzx',
    'movmovmul',
    'movmovnop',
    'movmovor',
    'movmovpop',
    'movmovpush',
    'movmovrepmovsd',
    'movmovrepstosd',
    'movmovretn',
    'movmovsar',
    'movmovsbb',
    'movmovshl',
    'movmovshr',
    'movmovsub',
    'movmovsxcmp',
    'movmovsxmov',
    'movmovtest',
    'movmovxor',
    'movmovzxadd',
    'movmovzxand',
    'movmovzxcmp',
    'movmovzxjmp',
    'movmovzxlea',
    'movmovzxmov',
    'movmovzxmovzx',
    'movmovzxor',
    'movmovzxtest',
    'movmulmov',
    'movnopmov',
    'movorje',
    'movorjne',
    'movormov',
    'movpoplea',
    'movpopmov',
    'movpoppop',
    'movpoppush',
    'movpopretn',
    'movpushadd',
    'movpushcall',
    'movpushlea',
    'movpushmov',
    'movpushpush',
    'movpushsub',
    'movpushxor',
    'movsarmov',
    'movsbbjb',
    'movsbbjge',
    'movsbbmov',
    'movshladd',
    'movshland',
    'movshlcmp',
    'movshlmov',
    'movshlor',
    'movshradd',
    'movshrand',
    'movshrmov',
    'movsubadd',
    'movsubcall',
    'movsubcmp',
    'movsubimul',
    'movsubjmp',
    'movsubjne',
    'movsublea',
    'movsubmov',
    'movsubpush',
    'movsubsar',
    'movsubsbb',
    'movsubsub',
    'movsubtest',
    'movtestje',
    'movtestjg',
    'movtestjle',
    'movtestjne',
    'movtestjns',
    'movtestjs',
    'movtestlea',
    'movtestmov',
    'movtestsete',
    'movtestsetne',
    'movxoradd',
    'movxorand',
    'movxorcall',
    'movxorcmp',
    'movxordiv',
    'movxorjmp',
    'movxorlea',
    'movxormov',
    'movxormovzx',
    'movxoror',
    'movxorpush',
    'movxorsub',
    'movxortest',
    'movxorxor',
    'movzxaddadd',
    'movzxaddcmp',
    'movzxaddjmp',
    'movzxaddmov',
    'movzxandcmp',
    'movzxandmov',
    'movzxandor',
    'movzxandtest',
    'movzxcmpje',
    'movzxcmpjne',
    'movzxjmpmov',
    'movzxleacmp',
    'movzxleamov',
    'movzxmovadd',
    'movzxmovand',
    'movzxmovcmp',
    'movzxmovjmp',
    'movzxmovlea',
    'movzxmovmov',
    'movzxmovmovzx',
    'movzxmovshr',
    'movzxmovsub',
    'movzxmovtest',
    'movzxmovxor',
    'movzxmovzxand',
    'movzxmovzxmov',
    'movzxormov',
    'movzxpushpush',
    'movzxtestje',
    'movzxtestjne',
    'mulmovmov',
    'negmovmov',
    'nopjmpnop',
    'nopmovmov',
    'nopmovsub',
    'nopmovtest',
    'nopsubpush',
    'notandmov',
    'orjemov',
    'orjmpmov',
    'orjnemov',
    'ormovfldcw',
    'ormovjmp',
    'ormovmov',
    'popjmpmov',
    'popjmpsub',
    'popleamov',
    'popleapop',
    'popleapush',
    'popmovmov',
    'popmovpop',
    'popmovpush',
    'poppopjmp',
    'poppoplea',
    'poppopmov',
    'poppoppop',
    'poppoppush',
    'poppopretn',
    'poppushcall',
    'poppushlea',
    'poppushmov',
    'poppushpush',
    'popretnadd',
    'popretncall',
    'popretncmp',
    'popretnfstp',
    'popretnlea',
    'popretnmov',
    'popretnpush',
    'popretnsub',
    'popretntest',
    'popretnxor',
    'popxorpop',
    'pushaddcall',
    'pushaddpush',
    'pushcalladd',
    'pushcallcall',
    'pushcallfld',
    'pushcalljmp',
    'pushcalllea',
    'pushcallmov',
    'pushcallmovzx',
    'pushcallpop',
    'pushcallpush',
    'pushcallsub',
    'pushcallxor',
    'pushfldsub',
    'pushjmpmov',
    'pushjmppush',
    'pushjmpsub',
    'pushleacall',
    'pushleajmp',
    'pushlealea',
    'pushleamov',
    'pushleapush',
    'pushmovadd',
    'pushmovcall',
    'pushmovlea',
    'pushmovmov',
    'pushmovpush',
    'pushmovsub',
    'pushmovxor',
    'pushmovzxpush',
    'pushpushadd',
    'pushpushcall',
    'pushpushfld',
    'pushpushjmp',
    'pushpushlea',
    'pushpushmov',
    'pushpushpush',
    'pushpushsub',
    'pushpushxor',
    'pushsubcall',
    'pushsubfst',
    'pushsubfstp',
    'pushsubmov',
    'pushsubpush',
    'pushxorcall',
    'pushxormov',
    'pushxorpush',
    'repcmpsbsetasbb',
    'retncallsub',
    'retncmpje',
    'retncmpjne',
    'retnleamov',
    'retnmovadd',
    'retnmovcall',
    'retnmovcmp',
    'retnmovjmp',
    'retnmovlea',
    'retnmovmov',
    'retnmovsub',
    'retnmovtest',
    'retnmovxor',
    'retnpushpush',
    'retnsublea',
    'retnsubmov',
    'retnsubpush',
    'retntestje',
    'retntestjne',
    'sarmovmov',
    'sbbjbmov',
    'sbbjgemov',
    'sbbmovmov',
    'setasbbtest',
    'shladdmov',
    'shlmovmov',
    'shlpushpush',
    'shraddmov',
    'shraddsar',
    'shrmovmov',
    'subaddmov',
    'subaddpush',
    'subcalladd',
    'subcallmov',
    'subcallsub',
    'subcmpja',
    'subcmpjb',
    'subcmpjbe',
    'subcmpje',
    'subcmpjne',
    'subcmpmov',
    'subfldmov',
    'subfstfstp',
    'subfstpfld',
    'subfstppush',
    'subjmpmov',
    'subjneadd',
    'subjnemov',
    'subjnesub',
    'subleajmp',
    'sublealea',
    'subleamov',
    'subleapush',
    'subleasub',
    'submovadd',
    'submovcall',
    'submovcmp',
    'submovjmp',
    'submovlea',
    'submovmov',
    'submovmovzx',
    'submovpush',
    'submovshl',
    'submovshr',
    'submovsub',
    'submovtest',
    'subpushadd',
    'subpushcall',
    'subpushjmp',
    'subpushlea',
    'subpushmov',
    'subpushpush',
    'subsbbmov',
    'subsubmov',
    'subsubpush',
    'subtestje',
    'subxormov',
    'subxorpush',
    'testjeadd',
    'testjecall',
    'testjecmp',
    'testjefld',
    'testjejmp',
    'testjelea',
    'testjemov',
    'testjemovzx',
    'testjepush',
    'testjesub',
    'testjetest',
    'testjexor',
    'testjgmov',
    'testjlelea',
    'testjlemov',
    'testjlesub',
    'testjneadd',
    'testjnecall',
    'testjnecmp',
    'testjnejmp',
    'testjnelea',
    'testjnemov',
    'testjnemovzx',
    'testjnepop',
    'testjnepush',
    'testjnesub',
    'testjnetest',
    'testjnexor',
    'testjnsmov',
    'testjscmp',
    'testjsmov',
    'testjssub',
    'testleacmove',
    'testmovje',
    'testmovjne',
    'testmovmov',
    'xoraddadc',
    'xoraddmov',
    'xoraddpop',
    'xorandje',
    'xorcalladd',
    'xorcallmov',
    'xorcallsub',
    'xorcmpje',
    'xorcmpjne',
    'xorcmpmov',
    'xordivmov',
    'xorjmpcall',
    'xorjmpcmp',
    'xorjmpmov',
    'xorjmppush',
    'xorjmpsub',
    'xorleamov',
    'xorleanop',
    'xorleapush',
    'xormovadd',
    'xormovcall',
    'xormovcmp',
    'xormovjmp',
    'xormovlea',
    'xormovmov',
    'xormovor',
    'xormovpush',
    'xormovsub',
    'xormovtest',
    'xormovxor',
    'xororje',
    'xororjne',
    'xorpopmov',
    'xorpoppop',
    'xorpushcall',
    'xorpushlea',
    'xorpushmov',
    'xorpushpush',
    'xortestje',
    'xortestjne',
    'xorxorjmp',
    'xorxormov',
    'xorxoror'
}

# 1k most common 3-grams for AARCH64
MOST_COMMON_3GRAMS_AARCH64 = {
    'addaddadd',
    'addaddadrp',
    'addaddb',
    'addaddbl',
    'addaddcmp',
    'addaddldar',
    'addaddldr',
    'addaddmov',
    'addaddstp',
    'addaddstr',
    'addadrpadd',
    'addadrpadrp',
    'addadrpb',
    'addadrpldp',
    'addadrpldr',
    'addadrpmov',
    'addbadd',
    'addbadrp',
    'addbbl',
    'addbcmp',
    'addbladd',
    'addbladrp',
    'addblb',
    'addblbl',
    'addblcbnz',
    'addblcbz',
    'addblcmp',
    'addbldp',
    'addbldr',
    'addblldp',
    'addblldr',
    'addblmov',
    'addblstr',
    'addbmov',
    'addcmpadd',
    'addcmpb.eq',
    'addcmpb.gt',
    'addcmpb.hi',
    'addcmpb.hs',
    'addcmpb.le',
    'addcmpb.ls',
    'addcmpb.ne',
    'addldarcbz',
    'addldpadd',
    'addldpadrp',
    'addldpldp',
    'addldpmov',
    'addldpstp',
    'addldradd',
    'addldradrp',
    'addldrb',
    'addldrbcbnz',
    'addldrbcmp',
    'addldrbl',
    'addldrblr',
    'addldrcbnz',
    'addldrcbz',
    'addldrcmp',
    'addldrldp',
    'addldrldr',
    'addldrmov',
    'addldrstp',
    'addldrstr',
    'addldrsub',
    'addlsladd',
    'addmovadd',
    'addmovadrp',
    'addmovb',
    'addmovbl',
    'addmovcmp',
    'addmovldp',
    'addmovldr',
    'addmovmov',
    'addmovstp',
    'addmovstr',
    'addretmov',
    'addstpadd',
    'addstpadrp',
    'addstpbl',
    'addstpmov',
    'addstpstp',
    'addstpstr',
    'addstradd',
    'addstradrp',
    'addstrb',
    'addstrbl',
    'addstrcbz',
    'addstrcmp',
    'addstrldp',
    'addstrldr',
    'addstrldrb',
    'addstrmov',
    'addstrstp',
    'addstrstr',
    'addsubadd',
    'addsubmov',
    'adraddbr',
    'adrpaddadd',
    'adrpaddadrp',
    'adrpaddb',
    'adrpaddbl',
    'adrpaddcmp',
    'adrpaddldr',
    'adrpaddmov',
    'adrpaddret',
    'adrpaddstp',
    'adrpaddstr',
    'adrpadrpadd',
    'adrpadrpadrp',
    'adrpadrpldr',
    'adrpadrpmov',
    'adrpbladd',
    'adrpldpadd',
    'adrpldradd',
    'adrpldradrp',
    'adrpldrbl',
    'adrpldrcbz',
    'adrpldrldr',
    'adrpldrmov',
    'adrpldrstp',
    'adrpldrstr',
    'adrpmovadd',
    'adrpmovadrp',
    'adrpmovldr',
    'adrpmovmov',
    'adrpmovstp',
    'adrpstpadd',
    'adrpstpldr',
    'adrpstpmov',
    'adrpstradd',
    'andandcmp',
    'andcmpb.eq',
    'andcmpb.hi',
    'andcmpb.ne',
    'andeorand',
    'andmovmov',
    'andstrldr',
    'b.eqaddadd',
    'b.eqaddmov',
    'b.eqaddstr',
    'b.eqadrpadd',
    'b.eqadrpldr',
    'b.eqb.hicmp',
    'b.eqb.lscmp',
    'b.eqblmov',
    'b.eqcmpb.eq',
    'b.eqcmpb.ne',
    'b.eqldradd',
    'b.eqldrbcmp',
    'b.eqldrbl',
    'b.eqldrcbz',
    'b.eqldrcmp',
    'b.eqldrldr',
    'b.eqldrldrb',
    'b.eqldrmov',
    'b.eqldrstr',
    'b.eqmovadrp',
    'b.eqmovb',
    'b.eqmovbl',
    'b.eqmovcmp',
    'b.eqmovldr',
    'b.eqmovmov',
    'b.eqmovstr',
    'b.hicmpb.eq',
    'b.hildrcmp',
    'b.himovmov',
    'b.hsaddadd',
    'b.leldrmov',
    'b.lemovmov',
    'b.lscmpb.eq',
    'b.lsmovstrb',
    'b.lsstrbadd',
    'b.neaddadd',
    'b.neaddmov',
    'b.neadrpadd',
    'b.neadrpldr',
    'b.nebldr',
    'b.neldpadrp',
    'b.neldpldp',
    'b.neldpldr',
    'b.neldpmov',
    'b.neldradd',
    'b.neldrand',
    'b.neldrbcbnz',
    'b.neldrbcmp',
    'b.neldrbl',
    'b.neldrcbz',
    'b.neldrcmp',
    'b.neldrldp',
    'b.neldrldr',
    'b.neldrmov',
    'b.neldrstr',
    'b.nemovadrp',
    'b.nemovb',
    'b.nemovbl',
    'b.nemovldp',
    'b.nemovldr',
    'b.nemovmov',
    'b.nemovstr',
    'baddadd',
    'baddcmp',
    'baddmov',
    'baddstr',
    'badrpadd',
    'badrpadrp',
    'badrpldr',
    'badrpmov',
    'bblldr',
    'bblmov',
    'bcmpb.eq',
    'bcmpb.ne',
    'bcmpmov',
    'bladdadd',
    'bladdadrp',
    'bladdbl',
    'bladdcmp',
    'bladdldr',
    'bladdmov',
    'bladrpadd',
    'bladrpadrp',
    'bladrpldr',
    'bladrpmov',
    'blandcmp',
    'blandeor',
    'blbadd',
    'blbadrp',
    'blbbl',
    'blbcmp',
    'blbladrp',
    'blblbl',
    'blblcbnz',
    'blblcbz',
    'blbldp',
    'blbldr',
    'blblfmov',
    'blblldr',
    'blblmov',
    'blblstr',
    'blbmov',
    'blcbnzadrp',
    'blcbnzldp',
    'blcbnzldr',
    'blcbnzmov',
    'blcbzadd',
    'blcbzadrp',
    'blcbzbl',
    'blcbzcbz',
    'blcbzldp',
    'blcbzldr',
    'blcbzmov',
    'blcmnb.eq',
    'blcmpb.eq',
    'blcmpb.le',
    'blcmpb.ne',
    'blcmpccmp',
    'blcmpcset',
    'blcmpmov',
    'bldpadrp',
    'bldpldp',
    'bldpldr',
    'bldpmov',
    'bldradd',
    'bldradrp',
    'bldrand',
    'bldrb',
    'bldrbcmp',
    'bldrbl',
    'bldrcbnz',
    'bldrcbz',
    'bldrcmp',
    'bldrldp',
    'bldrldr',
    'bldrldrb',
    'bldrmov',
    'bldrstr',
    'blfmovfmov',
    'blfmovmov',
    'blldpadd',
    'blldpb',
    'blldpldp',
    'blldpldr',
    'blldpmov',
    'blldpret',
    'blldpstr',
    'blldradd',
    'blldradrp',
    'blldrb',
    'blldrbl',
    'blldrcbnz',
    'blldrcbz',
    'blldrcmp',
    'blldrldp',
    'blldrldr',
    'blldrmov',
    'blldrstr',
    'blmovadd',
    'blmovadrp',
    'blmovb',
    'blmovbl',
    'blmovcbnz',
    'blmovcbz',
    'blmovcmp',
    'blmovifmov',
    'blmovldp',
    'blmovldr',
    'blmovmov',
    'blmovstr',
    'blrldrldr',
    'blrldrmov',
    'blrmovldr',
    'blrmovmov',
    'blstpmov',
    'blstradd',
    'blstradrp',
    'blstrb',
    'blstrbl',
    'blstrcbz',
    'blstrldp',
    'blstrldr',
    'blstrmov',
    'bltbnzldr',
    'bltstb.eq',
    'bltstb.ne',
    'bmovadd',
    'bmovadrp',
    'bmovb',
    'bmovbl',
    'bmovcbz',
    'bmovcmp',
    'bmovldp',
    'bmovldr',
    'bmovmov',
    'bmovstr',
    'bnopb',
    'bnopldr',
    'bstpbl',
    'bstpstp',
    'bstrb',
    'bstrbl',
    'cbnzaddmov',
    'cbnzadrpadd',
    'cbnzadrpldr',
    'cbnzbldr',
    'cbnzblmov',
    'cbnzbmov',
    'cbnzldpadrp',
    'cbnzldpldp',
    'cbnzldpmov',
    'cbnzldradd',
    'cbnzldradrp',
    'cbnzldrbl',
    'cbnzldrcbnz',
    'cbnzldrcbz',
    'cbnzldrcmp',
    'cbnzldrldr',
    'cbnzldrmov',
    'cbnzmovb',
    'cbnzmovbl',
    'cbnzmovmov',
    'cbzaddadd',
    'cbzaddbl',
    'cbzaddldr',
    'cbzaddmov',
    'cbzadrpadd',
    'cbzadrpldr',
    'cbzadrpmov',
    'cbzblldr',
    'cbzblmov',
    'cbzbmov',
    'cbzcbzbl',
    'cbzcbzldr',
    'cbzcmpb.eq',
    'cbzcmpb.ne',
    'cbzldpadd',
    'cbzldpldp',
    'cbzldpmov',
    'cbzldradd',
    'cbzldradrp',
    'cbzldrbcbz',
    'cbzldrbl',
    'cbzldrcbnz',
    'cbzldrcbz',
    'cbzldrcmp',
    'cbzldrldp',
    'cbzldrldr',
    'cbzldrmov',
    'cbzldrstr',
    'cbzldrsub',
    'cbzmovadd',
    'cbzmovadrp',
    'cbzmovb',
    'cbzmovbl',
    'cbzmovldr',
    'cbzmovmov',
    'cbzmovstr',
    'cbzstpmov',
    'cbzstrmov',
    'ccmpb.eqmov',
    'ccmpb.neldr',
    'ccmpb.nemov',
    'cmnb.eqldr',
    'cmnb.nemov',
    'cmpaddcsel',
    'cmpb.eqadd',
    'cmpb.eqadrp',
    'cmpb.eqb',
    'cmpb.eqb.hi',
    'cmpb.eqb.ls',
    'cmpb.eqbl',
    'cmpb.eqcbz',
    'cmpb.eqcmp',
    'cmpb.eqldp',
    'cmpb.eqldr',
    'cmpb.eqldrb',
    'cmpb.eqmov',
    'cmpb.eqnop',
    'cmpb.eqstr',
    'cmpb.eqsub',
    'cmpb.geldr',
    'cmpb.gtcmp',
    'cmpb.gtldr',
    'cmpb.gtmov',
    'cmpb.hiadd',
    'cmpb.hiadrp',
    'cmpb.hicmp',
    'cmpb.hildr',
    'cmpb.himov',
    'cmpb.hsadd',
    'cmpb.hsldr',
    'cmpb.leadd',
    'cmpb.leadrp',
    'cmpb.leldr',
    'cmpb.lemov',
    'cmpb.lesub',
    'cmpb.loldr',
    'cmpb.lomov',
    'cmpb.lsadd',
    'cmpb.lsldr',
    'cmpb.lsmov',
    'cmpb.lsstrb',
    'cmpb.ltldr',
    'cmpb.neadd',
    'cmpb.neadrp',
    'cmpb.neb',
    'cmpb.nebl',
    'cmpb.necbz',
    'cmpb.necmp',
    'cmpb.neldp',
    'cmpb.neldr',
    'cmpb.neldrb',
    'cmpb.nemov',
    'cmpb.nestr',
    'cmpccmpb.eq',
    'cmpccmpb.ne',
    'cmpcselcmp',
    'cmpcsetand',
    'cmpcsetb',
    'cmpcsetcmp',
    'cmpmovccmp',
    'cmpmovcsel',
    'cmpmovcset',
    'cmpmovmov',
    'csetcmpcset',
    'eorandcmp',
    'fmovadrpadd',
    'fmovblmov',
    'fmovfmovfmov',
    'fmovfmovmov',
    'fmovldrmov',
    'fmovmovbl',
    'fmovmovmov',
    'ldarcbzadd',
    'ldpaddadd',
    'ldpaddadrp',
    'ldpaddb',
    'ldpaddldp',
    'ldpaddldr',
    'ldpaddmov',
    'ldpaddret',
    'ldpaddstr',
    'ldpadrpadd',
    'ldpadrpadrp',
    'ldpadrpldp',
    'ldpadrpldr',
    'ldpbadrp',
    'ldpbbl',
    'ldpbldp',
    'ldpbldr',
    'ldpbmov',
    'ldpcmpb.eq',
    'ldpldpadd',
    'ldpldpadrp',
    'ldpldpb',
    'ldpldpldp',
    'ldpldpldr',
    'ldpldpret',
    'ldpldpstr',
    'ldpldradd',
    'ldpldradrp',
    'ldpldrb',
    'ldpldrbl',
    'ldpldrldp',
    'ldpldrldr',
    'ldpldrmov',
    'ldpldrstr',
    'ldpmovb',
    'ldpmovbl',
    'ldpmovldp',
    'ldpmovldr',
    'ldpmovmov',
    'ldpretadd',
    'ldpretadrp',
    'ldpretbl',
    'ldpretcbz',
    'ldpretcmp',
    'ldpretldp',
    'ldpretldr',
    'ldpretmov',
    'ldpretstr',
    'ldpstpadd',
    'ldpstpldp',
    'ldpstpldr',
    'ldpstpmov',
    'ldpstpstr',
    'ldpstrbmov',
    'ldpstrldp',
    'ldpstrldr',
    'ldpstrmov',
    'ldraddadd',
    'ldraddadrp',
    'ldraddb',
    'ldraddbl',
    'ldraddbr',
    'ldraddcmp',
    'ldraddldp',
    'ldraddldr',
    'ldraddldrb',
    'ldraddmov',
    'ldraddret',
    'ldraddstp',
    'ldraddstr',
    'ldraddsub',
    'ldradrpadd',
    'ldradrpadrp',
    'ldradrpldp',
    'ldradrpldr',
    'ldradrpmov',
    'ldrandcmp',
    'ldrandstr',
    'ldrbadd',
    'ldrbadrp',
    'ldrbandcmp',
    'ldrbbl',
    'ldrbcbnzldr',
    'ldrbcbnzldrb',
    'ldrbcbnzmov',
    'ldrbcbzldr',
    'ldrbcbzmov',
    'ldrbcmp',
    'ldrbcmpb.eq',
    'ldrbcmpb.ne',
    'ldrbladd',
    'ldrbladrp',
    'ldrbland',
    'ldrblb',
    'ldrblbl',
    'ldrblcbnz',
    'ldrblcbz',
    'ldrblcmp',
    'ldrbldp',
    'ldrbldr',
    'ldrblldp',
    'ldrblldr',
    'ldrblmov',
    'ldrblrb',
    'ldrblrldr',
    'ldrblrmov',
    'ldrblstp',
    'ldrblstr',
    'ldrbmov',
    'ldrborrstrb',
    'ldrbsuband',
    'ldrcbnzadrp',
    'ldrcbnzb',
    'ldrcbnzldp',
    'ldrcbnzldr',
    'ldrcbnzmov',
    'ldrcbzadd',
    'ldrcbzadrp',
    'ldrcbzb',
    'ldrcbzbl',
    'ldrcbzcmp',
    'ldrcbzldp',
    'ldrcbzldr',
    'ldrcbzldrb',
    'ldrcbzmov',
    'ldrcbzstr',
    'ldrcmnb.eq',
    'ldrcmpb.eq',
    'ldrcmpb.ge',
    'ldrcmpb.gt',
    'ldrcmpb.hi',
    'ldrcmpb.hs',
    'ldrcmpb.le',
    'ldrcmpb.lo',
    'ldrcmpb.ls',
    'ldrcmpb.lt',
    'ldrcmpb.ne',
    'ldrcmpccmp',
    'ldrcmpcsel',
    'ldrcmpcset',
    'ldrhadradd',
    'ldrldpb',
    'ldrldpcmp',
    'ldrldpldp',
    'ldrldpldr',
    'ldrldpret',
    'ldrldradd',
    'ldrldradrp',
    'ldrldrand',
    'ldrldrb',
    'ldrldrband',
    'ldrldrbcbz',
    'ldrldrbcmp',
    'ldrldrbl',
    'ldrldrblr',
    'ldrldrcbnz',
    'ldrldrcbz',
    'ldrldrcmp',
    'ldrldrldp',
    'ldrldrldr',
    'ldrldrldrb',
    'ldrldrlsl',
    'ldrldrmov',
    'ldrldrorr',
    'ldrldrsbcmp',
    'ldrldrstr',
    'ldrldrsub',
    'ldrldrsubs',
    'ldrlsladd',
    'ldrlslldr',
    'ldrmovadd',
    'ldrmovadrp',
    'ldrmovb',
    'ldrmovbl',
    'ldrmovbr',
    'ldrmovcbz',
    'ldrmovcmp',
    'ldrmovldp',
    'ldrmovldr',
    'ldrmovlsl',
    'ldrmovmov',
    'ldrmovmovk',
    'ldrmovstp',
    'ldrmovstr',
    'ldrmovstrb',
    'ldrmovsub',
    'ldrorrstr',
    'ldrstpadd',
    'ldrstpadrp',
    'ldrstpldr',
    'ldrstpmov',
    'ldrstpstp',
    'ldrstpstr',
    'ldrstradd',
    'ldrstradrp',
    'ldrstrb',
    'ldrstrbl',
    'ldrstrcbnz',
    'ldrstrcbz',
    'ldrstrcmp',
    'ldrstrldp',
    'ldrstrldr',
    'ldrstrmov',
    'ldrstrstp',
    'ldrstrstr',
    'ldrstrstrb',
    'ldrsubadd',
    'ldrsubbl',
    'ldrsubcmp',
    'ldrsubldr',
    'ldrsubmov',
    'ldrsubsmov',
    'ldrsubstr',
    'lsladdldr',
    'lsladdlsl',
    'lslldradd',
    'movaddadd',
    'movaddadrp',
    'movaddb',
    'movaddbl',
    'movaddcmp',
    'movaddldr',
    'movaddmov',
    'movaddstp',
    'movaddstr',
    'movadrpadd',
    'movadrpadrp',
    'movadrpbl',
    'movadrpldr',
    'movadrpmov',
    'movb.neldp',
    'movb.neldr',
    'movb.nemov',
    'movbadd',
    'movbadrp',
    'movbbl',
    'movbcmp',
    'movbladd',
    'movbladrp',
    'movblb',
    'movblbl',
    'movblcbnz',
    'movblcbz',
    'movblcmn',
    'movblcmp',
    'movbldp',
    'movbldr',
    'movbldrb',
    'movblfmov',
    'movblldp',
    'movblldr',
    'movblldrb',
    'movblmov',
    'movblmovi',
    'movblrldr',
    'movblrmov',
    'movblstr',
    'movblsub',
    'movbltbnz',
    'movbltst',
    'movbmov',
    'movcbnzb',
    'movcbnzldr',
    'movcbnzmov',
    'movcbzadrp',
    'movcbzb',
    'movcbzbl',
    'movcbzldr',
    'movcbzmov',
    'movcbzstp',
    'movcbzstr',
    'movcmpb.eq',
    'movcmpb.gt',
    'movcmpb.hi',
    'movcmpb.le',
    'movcmpb.ls',
    'movcmpb.ne',
    'movcmpccmp',
    'movcmpcset',
    'movfmovfmov',
    'movfmovmov',
    'movkcmpb.eq',
    'movkmovkmovk',
    'movldpadd',
    'movldpadrp',
    'movldpb',
    'movldpldp',
    'movldpldr',
    'movldpmov',
    'movldpret',
    'movldpstp',
    'movldpstr',
    'movldradd',
    'movldradrp',
    'movldrb',
    'movldrbcmp',
    'movldrbl',
    'movldrblr',
    'movldrcbnz',
    'movldrcbz',
    'movldrcmp',
    'movldrldp',
    'movldrldr',
    'movldrmov',
    'movldrstp',
    'movldrstr',
    'movldrsub',
    'movlsladd',
    'movmovadd',
    'movmovadrp',
    'movmovand',
    'movmovb',
    'movmovbl',
    'movmovblr',
    'movmovcbnz',
    'movmovcbz',
    'movmovcmp',
    'movmovfmov',
    'movmovkcmp',
    'movmovkfmov',
    'movmovkmov',
    'movmovldp',
    'movmovldr',
    'movmovldrb',
    'movmovmov',
    'movmovmovk',
    'movmovnop',
    'movmovstp',
    'movmovstr',
    'movmovstrb',
    'movmovsub',
    'movnopldr',
    'movstpadd',
    'movstpadrp',
    'movstpbl',
    'movstpcbz',
    'movstpldr',
    'movstpmov',
    'movstpstp',
    'movstpstr',
    'movstradd',
    'movstradrp',
    'movstrb',
    'movstrbadd',
    'movstrbb',
    'movstrbl',
    'movstrbldr',
    'movstrbmov',
    'movstrcbz',
    'movstrcmp',
    'movstrldp',
    'movstrldr',
    'movstrmov',
    'movstrstp',
    'movstrstr',
    'movsubbl',
    'movsubcmp',
    'movsubmov',
    'nopbnop',
    'nopldrldr',
    'nopldrmov',
    'nopmovmov',
    'nopnopmov',
    'nopnopnop',
    'nopnopstp',
    'nopstpadrp',
    'nopstpmov',
    'orrstrldr',
    'retaddmov',
    'retadrpadd',
    'retadrpldr',
    'retblbl',
    'retblmov',
    'retldpadrp',
    'retldpldp',
    'retldradrp',
    'retldrldr',
    'retldrmov',
    'retmovadrp',
    'retmovb',
    'retmovbl',
    'retmovmov',
    'retmovret',
    'stpaddadd',
    'stpaddldr',
    'stpaddmov',
    'stpaddstp',
    'stpaddstr',
    'stpadrpadd',
    'stpadrpadrp',
    'stpadrpldr',
    'stpadrpmov',
    'stpadrpstp',
    'stpbladrp',
    'stpblldr',
    'stpblmov',
    'stpcbzmov',
    'stpldpstp',
    'stpldrldr',
    'stpldrstp',
    'stpldrstr',
    'stpmovadd',
    'stpmovadrp',
    'stpmovbl',
    'stpmovcbz',
    'stpmovldp',
    'stpmovldr',
    'stpmovmov',
    'stpmovstp',
    'stpmovstr',
    'stpstpbl',
    'stpstpldr',
    'stpstpmov',
    'stpstpstp',
    'stpstpstr',
    'stpstrbl',
    'stpstrcmp',
    'stpstrldr',
    'stpstrstp',
    'stpstrstr',
    'straddadd',
    'straddbl',
    'straddcmp',
    'straddldr',
    'straddldrb',
    'straddmov',
    'straddstr',
    'stradrpadd',
    'stradrpldr',
    'stradrpstp',
    'stradrpstr',
    'strbadd',
    'strbaddcmp',
    'strbaddmov',
    'strbadrp',
    'strbbl',
    'strbbmov',
    'strbcmp',
    'strbcmpb.eq',
    'strbladd',
    'strbladrp',
    'strblb',
    'strblbl',
    'strblcbz',
    'strbldp',
    'strbldr',
    'strbldrb',
    'strbldrldr',
    'strblldp',
    'strblldr',
    'strblmov',
    'strblstr',
    'strbmov',
    'strbstr',
    'strbstrbstrb',
    'strcbnzldr',
    'strcbnzmov',
    'strcbzadd',
    'strcbzbl',
    'strcbzldr',
    'strcbzmov',
    'strcmpb.eq',
    'strcmpb.gt',
    'strcmpb.le',
    'strcmpb.ne',
    'strldpldp',
    'strldpldr',
    'strldpmov',
    'strldpret',
    'strldpstr',
    'strldradd',
    'strldrb',
    'strldrbcmp',
    'strldrbl',
    'strldrcbnz',
    'strldrcbz',
    'strldrcmp',
    'strldrldp',
    'strldrldr',
    'strldrldrb',
    'strldrmov',
    'strldrstp',
    'strldrstr',
    'strmovadd',
    'strmovadrp',
    'strmovb',
    'strmovbl',
    'strmovcbz',
    'strmovcmp',
    'strmovldp',
    'strmovldr',
    'strmovmov',
    'strmovstp',
    'strmovstr',
    'strmovstrb',
    'strstpbl',
    'strstpstp',
    'strstpstr',
    'strstradd',
    'strstrb',
    'strstrbl',
    'strstrbldr',
    'strstrcbz',
    'strstrcmp',
    'strstrldp',
    'strstrldr',
    'strstrmov',
    'strstrstp',
    'strstrstr',
    'strstrstrb',
    'subaddadd',
    'subaddmov',
    'subadrpldr',
    'subandcmp',
    'subblldr',
    'subcmpb.hi',
    'subcmpb.ls',
    'submovadd',
    'submovbl',
    'submovmov',
    'subsmovb.ne',
    'substpadd',
    'substrcmp',
    'substrldr',
    'substrstr',
    'tstb.eqldr',
    'tstb.eqmov',
    'tstb.neldr',
    'tstb.nemov'
}

# 1k most common 3-grams for ARM32
MOST_COMMON_3GRAMS_ARM32 = {
    'adc.sadcorr',
    'adcorr.sbiceq',
    'adcsubhscmp',
    'adctstsubeq',
    'add.sadccmp',
    'add.sadcorr.s',
    'add.sbgtadd',
    'add.sbleadd',
    'addaddadd',
    'addaddb',
    'addaddbl',
    'addaddcmp',
    'addaddldr',
    'addaddldrb',
    'addaddlsl',
    'addaddmov',
    'addaddpop',
    'addaddstr',
    'addaddsub',
    'addbbl',
    'addbcmp',
    'addbeqldr',
    'addbeqmov',
    'addbladd',
    'addblb',
    'addblbl',
    'addblcmp',
    'addbldr',
    'addblldr',
    'addblldrb',
    'addblmov',
    'addblstr',
    'addblsub.s',
    'addbmov',
    'addbneldr',
    'addcmpadd',
    'addcmpbeq',
    'addcmpbhi',
    'addcmpbhs',
    'addcmpbls',
    'addcmpbne',
    'addcmpldr',
    'addcmpmov',
    'addcmpmovhi',
    'addcmpstr',
    'addeqsubsub.s',
    'addgeorrgepopge',
    'addldmstm',
    'addldradd',
    'addldrb',
    'addldrbadd',
    'addldrbcmp',
    'addldrbeq',
    'addldrbl',
    'addldrbx',
    'addldrcmp',
    'addldrdmov',
    'addldrldr',
    'addldrmov',
    'addldrpop',
    'addldrstr',
    'addldrsub',
    'addlsbb',
    'addlsladd',
    'addlslmov',
    'addmovadd',
    'addmovb',
    'addmovbl',
    'addmovblx',
    'addmovcmp',
    'addmovldr',
    'addmovmov',
    'addmovstm',
    'addmovstr',
    'addmovstrb',
    'addmovstrd',
    'addmvnmov',
    'addpopadd',
    'addpopb',
    'addpopbl',
    'addpopbx',
    'addpopcmp',
    'addpopldr',
    'addpopmov',
    'addpushldr',
    'addrsblelsl',
    'addrsblsl',
    'addrsblsr',
    'addstmldm',
    'addstmldr',
    'addstmmov',
    'addstradd',
    'addstrb',
    'addstrbeq',
    'addstrbl',
    'addstrcmp',
    'addstrdldrd',
    'addstrldr',
    'addstrldrb',
    'addstrmov',
    'addstrpop',
    'addstrstr',
    'addsubadd',
    'addsubbl',
    'addsubcmp',
    'addsubldr',
    'addsubmov',
    'addsubstr',
    'adraddldr',
    'andandcmp',
    'andcmpbeq',
    'andcmpbne',
    'andeqandeqandeq',
    'andlsl.sadc',
    'andorrorr',
    'andstrldr',
    'baddadd',
    'baddcmp',
    'baddmov',
    'baddrsble',
    'bbb',
    'bblb',
    'bblbl',
    'bbldr',
    'bblldr',
    'bblmov',
    'bbmov',
    'bcmpbeq',
    'bcmpbne',
    'bcmpmov',
    'beqaddadd',
    'beqaddcmp',
    'beqaddldr',
    'beqaddmov',
    'beqaddpop',
    'beqaddstr',
    'beqblbl',
    'beqblcmp',
    'beqbldr',
    'beqblldr',
    'beqblmov',
    'beqbmov',
    'beqcmpbeq',
    'beqcmpbne',
    'beqcmpmov',
    'beqcmpmoveq',
    'beqcmpmovne',
    'beqldradd',
    'beqldrb',
    'beqldrbcmp',
    'beqldrbl',
    'beqldrcmp',
    'beqldrldr',
    'beqldrldrb',
    'beqldrmov',
    'beqldrstr',
    'beqldrsub',
    'beqmovadd',
    'beqmovb',
    'beqmovbl',
    'beqmovldr',
    'beqmovmov',
    'beqmovpop',
    'beqmovstr',
    'beqstrldr',
    'beqstrstr',
    'beqsubcmp',
    'beqsubmov',
    'bgeadd.sbgt',
    'bgeadd.sble',
    'bgeldradd',
    'bgeldrldr',
    'bgtaddrsb',
    'bgtldrldr',
    'bhicmpbeq',
    'bhildrcmp',
    'bhildrldr',
    'bhsaddadd',
    'bhsldrldr',
    'biccmpbne',
    'biceqpoprsb',
    'bladdadd',
    'bladdbl',
    'bladdcmp',
    'bladdldr',
    'bladdmov',
    'bladdpop',
    'bladdstr',
    'blbadd',
    'blbbl',
    'blbcmp',
    'blbladd',
    'blblb',
    'blblbl',
    'blblcmp',
    'blbldr',
    'blblldr',
    'blblmov',
    'blblstr',
    'blblstrd',
    'blblsub.s',
    'blbmov',
    'blcmnbeq',
    'blcmpadd',
    'blcmpbeq',
    'blcmpblt',
    'blcmpbne',
    'blcmpclz',
    'blcmpldr',
    'blcmpldrne',
    'blcmpmov',
    'blcmpmoveq',
    'blcmpmovne',
    'blcmppopeq',
    'blcmppopne',
    'blcmpstr',
    'bldradd',
    'bldrb',
    'bldrbcmp',
    'bldrbl',
    'bldrcmp',
    'bldrldr',
    'bldrldrb',
    'bldrlsl',
    'bldrmov',
    'bldrstr',
    'bldrsub',
    'bleaddrsb',
    'bleldradd',
    'bleldrldr',
    'bleldrmov',
    'blemovmov',
    'blldradd',
    'blldrb',
    'blldrbcmp',
    'blldrbl',
    'blldrcmp',
    'blldrdbl',
    'blldrdmov',
    'blldrdstrd',
    'blldrldr',
    'blldrldrb',
    'blldrmov',
    'blldrmvn',
    'blldrpop',
    'blldrstr',
    'blldrsub',
    'blmovadd',
    'blmovb',
    'blmovbl',
    'blmovcmp',
    'blmoveor',
    'blmovldr',
    'blmovmov',
    'blmovpop',
    'blmovstr',
    'blmovstrb',
    'blmovsub',
    'blmvnmov',
    'blpopb',
    'blsldradd',
    'blsldrcmp',
    'blsldrldr',
    'blstradd',
    'blstrb',
    'blstrbl',
    'blstrdldr',
    'blstrdmov',
    'blstrldr',
    'blstrmov',
    'blstrpop',
    'blstrstr',
    'blsub.sbeq',
    'blsub.sbne',
    'blsub.smovne',
    'blsub.sstr',
    'blsubmov',
    'bltldrldr',
    'blxbldr',
    'blxcmpbne',
    'blxldradd',
    'blxldrcmp',
    'blxldrldr',
    'blxldrmov',
    'blxmovmov',
    'bmovadd',
    'bmovb',
    'bmovbl',
    'bmovcmp',
    'bmovldr',
    'bmovmov',
    'bmovstr',
    'bneaddadd',
    'bneaddcmp',
    'bneaddldr',
    'bneaddmov',
    'bneaddpop',
    'bneaddstr',
    'bnebcmp',
    'bnebldr',
    'bneblldr',
    'bneblmov',
    'bnebmov',
    'bnecmpbeq',
    'bnecmpbne',
    'bneeorand',
    'bneldradd',
    'bneldrb',
    'bneldrbcmp',
    'bneldrbl',
    'bneldrcmp',
    'bneldrldr',
    'bneldrldrb',
    'bneldrmov',
    'bneldrstr',
    'bnemovadd',
    'bnemovb',
    'bnemovbl',
    'bnemovldr',
    'bnemovmov',
    'bnemovpop',
    'bnemovstr',
    'bneorr.sbne',
    'bstrldr',
    'bsubcmp',
    'bxeqpushmov',
    'bxldradd',
    'bxldrldr',
    'bxmovbx',
    'clzaddeqsub',
    'clzlsrmoveq',
    'cmnbeqcmp',
    'cmnbeqldr',
    'cmnbneldr',
    'cmpadcsubhs',
    'cmpaddadd',
    'cmpaddbeq',
    'cmpaddbne',
    'cmpaddldr',
    'cmpaddlsb',
    'cmpaddmov',
    'cmpaddstr',
    'cmpbeqadd',
    'cmpbeqb',
    'cmpbeqbl',
    'cmpbeqcmp',
    'cmpbeqldm',
    'cmpbeqldr',
    'cmpbeqldrb',
    'cmpbeqldrd',
    'cmpbeqmov',
    'cmpbeqstr',
    'cmpbeqsub',
    'cmpbgeldr',
    'cmpbgtcmp',
    'cmpbgtldr',
    'cmpbhicmp',
    'cmpbhildr',
    'cmpbhimov',
    'cmpbhsadd',
    'cmpbhsldr',
    'cmpbleldr',
    'cmpblemov',
    'cmpblocmp',
    'cmpbloldr',
    'cmpblscmp',
    'cmpblsldr',
    'cmpblsmov',
    'cmpbltcmp',
    'cmpbltldr',
    'cmpbltmov',
    'cmpbneadd',
    'cmpbneb',
    'cmpbnebl',
    'cmpbnecmp',
    'cmpbneldr',
    'cmpbneldrb',
    'cmpbneldrd',
    'cmpbnemov',
    'cmpbnepop',
    'cmpbnestr',
    'cmpbnesub',
    'cmpclzlsr',
    'cmpcmpeqbeq',
    'cmpcmpeqbne',
    'cmpcmpnebeq',
    'cmpcmpnebne',
    'cmpcmpnemov',
    'cmpcmpnemoveq',
    'cmpldradd',
    'cmpldrbeq',
    'cmpldrbne',
    'cmpldrldr',
    'cmpldrmov',
    'cmpldrnemov',
    'cmpldrstr',
    'cmplsr.seqadc.s',
    'cmpmovbeq',
    'cmpmovbne',
    'cmpmoveqandne',
    'cmpmoveqbeq',
    'cmpmoveqmoveq',
    'cmpmoveqmovne',
    'cmpmovhistrbhi',
    'cmpmovmov',
    'cmpmovneandeq',
    'cmpmovnebeq',
    'cmpmovnebne',
    'cmpmovnemoveq',
    'cmpmovnemovne',
    'cmpmovstr',
    'cmpnemoveqmovne',
    'cmppopeqbl',
    'cmppopeqldr',
    'cmppopeqmov',
    'cmppopneldr',
    'cmpstrbeq',
    'cmpstrbne',
    'cmpstrstr',
    'cmpstrstrb',
    'cmpsubbeq',
    'eor.smovbne',
    'eorandcmp',
    'eorandeor',
    'eoreoreor',
    'ldmaddmov',
    'ldmaddstm',
    'ldmldrbl',
    'ldmmovstm',
    'ldmmovstr',
    'ldmstmadd',
    'ldmstmldm',
    'ldmstmldr',
    'ldmstmmov',
    'ldradd.sadc',
    'ldraddadd',
    'ldraddb',
    'ldraddbl',
    'ldraddbx',
    'ldraddcmp',
    'ldraddldr',
    'ldraddldrb',
    'ldraddlsl',
    'ldraddmov',
    'ldraddpop',
    'ldraddpush',
    'ldraddstr',
    'ldraddsub',
    'ldrandcmp',
    'ldrandldr',
    'ldrbadd',
    'ldrbaddcmp',
    'ldrbandand',
    'ldrbandcmp',
    'ldrbbl',
    'ldrbcmp',
    'ldrbcmpbeq',
    'ldrbcmpbne',
    'ldrbcmpcmpne',
    'ldrbeqcmp',
    'ldrbeqldr',
    'ldrbladd',
    'ldrblb',
    'ldrblbl',
    'ldrblcmp',
    'ldrbldr',
    'ldrbldrborr',
    'ldrbldrcmp',
    'ldrblldr',
    'ldrblldrd',
    'ldrblmov',
    'ldrblstr',
    'ldrblsub.s',
    'ldrblxb',
    'ldrblxldr',
    'ldrblxmov',
    'ldrbmov',
    'ldrbmovcmp',
    'ldrbmovldr',
    'ldrborrldrb',
    'ldrbstrbldr',
    'ldrbsubcmp',
    'ldrbtstbne',
    'ldrcmnbeq',
    'ldrcmpadd',
    'ldrcmpbeq',
    'ldrcmpbge',
    'ldrcmpbgt',
    'ldrcmpbhi',
    'ldrcmpbhs',
    'ldrcmpble',
    'ldrcmpblo',
    'ldrcmpbls',
    'ldrcmpblt',
    'ldrcmpbne',
    'ldrcmpbxeq',
    'ldrcmpcmpeq',
    'ldrcmpcmpne',
    'ldrcmpldr',
    'ldrcmpldrne',
    'ldrcmpmov',
    'ldrcmpmoveq',
    'ldrcmpmovne',
    'ldrcmppopeq',
    'ldrcmpsbc.s',
    'ldrcmpstr',
    'ldrcmpsub',
    'ldrdaddstrd',
    'ldrdblbl',
    'ldrdblcmp',
    'ldrdblldr',
    'ldrdblldrd',
    'ldrdblmov',
    'ldrdldrdbl',
    'ldrdldrdmov',
    'ldrdldrmov',
    'ldrdldrstrd',
    'ldrdmovbl',
    'ldrdmovmov',
    'ldrdmovstrd',
    'ldrdstrdldr',
    'ldrdstrdldrd',
    'ldrdstrdmov',
    'ldreor.smov',
    'ldrldradd',
    'ldrldradd.s',
    'ldrldrand',
    'ldrldrb',
    'ldrldrband',
    'ldrldrbcmp',
    'ldrldrbeq',
    'ldrldrbic',
    'ldrldrbl',
    'ldrldrblx',
    'ldrldrbmov',
    'ldrldrcmp',
    'ldrldreor.s',
    'ldrldrldr',
    'ldrldrldrb',
    'ldrldrldrd',
    'ldrldrlsl',
    'ldrldrmov',
    'ldrldrmul',
    'ldrldrmvn',
    'ldrldrorr',
    'ldrldrpop',
    'ldrldrpush',
    'ldrldrsbcmp',
    'ldrldrstr',
    'ldrldrstrd',
    'ldrldrsub',
    'ldrldrsub.s',
    'ldrlsladd',
    'ldrlslldr',
    'ldrlsllsr',
    'ldrmovadd',
    'ldrmovb',
    'ldrmovbeq',
    'ldrmovbic',
    'ldrmovbl',
    'ldrmovblx',
    'ldrmovcmp',
    'ldrmovldr',
    'ldrmovldrb',
    'ldrmovldrd',
    'ldrmovlsl',
    'ldrmovmov',
    'ldrmovpop',
    'ldrmovstr',
    'ldrmovstrb',
    'ldrmovstrd',
    'ldrmovsub',
    'ldrmvnadd',
    'ldrnemovmov',
    'ldrorrldr',
    'ldrorrstr',
    'ldrpopadd',
    'ldrpopldr',
    'ldrpopmov',
    'ldrpushadd',
    'ldrpushcmp',
    'ldrpushldr',
    'ldrpushmov',
    'ldrstmldr',
    'ldrstmmov',
    'ldrstradd',
    'ldrstrb',
    'ldrstrbeq',
    'ldrstrbl',
    'ldrstrcmp',
    'ldrstrdldr',
    'ldrstrldr',
    'ldrstrmov',
    'ldrstrstr',
    'ldrstrsub',
    'ldrsub.smovne',
    'ldrsubadd',
    'ldrsubbl',
    'ldrsubcmp',
    'ldrsubldr',
    'ldrsubmov',
    'ldrsubstr',
    'ldrsubsub',
    'ldrsubsub.s',
    'ldrtstbeq',
    'ldrtstbne',
    'lsl.sadc.sadc',
    'lsl.sadctst',
    'lsladdadd',
    'lsladdldr',
    'lsladdlsl',
    'lslldradd',
    'lsllesub.saddge',
    'lsllsrb',
    'lsllsrcmp',
    'lsllsrldr',
    'lsllsrorr',
    'lslmovldr',
    'lslorrlelslle',
    'lslorrlsl',
    'lslstrldr',
    'lsr.seqadc.sadc',
    'lsrbadd',
    'lsrcmpbne',
    'lsrldradd',
    'lsrmoveqcmp',
    'lsrmovpop',
    'lsrorrand',
    'lsrorrlsr',
    'lsrorrmov',
    'lsrorrorr',
    'lsrstrldr',
    'movaddadd',
    'movaddb',
    'movaddbl',
    'movaddcmp',
    'movaddldr',
    'movaddmov',
    'movaddpop',
    'movaddstmib',
    'movaddstr',
    'movaddstrb',
    'movbadd',
    'movbbl',
    'movbcmp',
    'movbeqbl',
    'movbeqcmp',
    'movbeqldr',
    'movbeqmov',
    'movbladd',
    'movblb',
    'movblbl',
    'movblcmn',
    'movblcmp',
    'movbldr',
    'movbldrb',
    'movblldr',
    'movblldrb',
    'movblldrd',
    'movblmov',
    'movblmvn',
    'movblpop',
    'movblstr',
    'movblstrd',
    'movblsub',
    'movblsub.s',
    'movblxcmp',
    'movblxldr',
    'movblxmov',
    'movbmov',
    'movbneadd',
    'movbneldr',
    'movbnemov',
    'movbsub',
    'movcmpadd',
    'movcmpbeq',
    'movcmpbne',
    'movcmpldr',
    'movcmpldrne',
    'movcmpmov',
    'movcmpstr',
    'moveorand',
    'moveqandnecmp',
    'moveqbeqldr',
    'moveqbeqmov',
    'moveqclzaddeq',
    'moveqcmppopeq',
    'moveqmoveqclz',
    'movhistrbhiadd',
    'movldmadd',
    'movldradd',
    'movldrb',
    'movldrbcmp',
    'movldrbl',
    'movldrblx',
    'movldrcmp',
    'movldrdbl',
    'movldrdmov',
    'movldrldr',
    'movldrmov',
    'movldrstr',
    'movldrstrd',
    'movldrsub',
    'movlsladd',
    'movmovadd',
    'movmovb',
    'movmovbeq',
    'movmovbl',
    'movmovblx',
    'movmovbne',
    'movmovcmp',
    'movmovldm',
    'movmovldr',
    'movmovldrb',
    'movmovldrd',
    'movmovmov',
    'movmovpop',
    'movmovstm',
    'movmovstr',
    'movmovstrb',
    'movmovstrd',
    'movmovsub',
    'movmvnmov',
    'movmvnstr',
    'movneandeqcmp',
    'movpopb',
    'movpopbx',
    'movpopcmp',
    'movpopldr',
    'movpoplsr',
    'movpopmov',
    'movpoporr',
    'movstmbl',
    'movstmldm',
    'movstmldr',
    'movstmmov',
    'movstradd',
    'movstrb',
    'movstrbb',
    'movstrbblx',
    'movstrbeq',
    'movstrbl',
    'movstrbldr',
    'movstrbmov',
    'movstrbstrb',
    'movstrdbl',
    'movstrdldr',
    'movstrdldrd',
    'movstrdmov',
    'movstrdstr',
    'movstrdstrd',
    'movstrldm',
    'movstrldr',
    'movstrmov',
    'movstrpop',
    'movstrstm',
    'movstrstr',
    'movstrstrb',
    'movstrstrd',
    'movsubadd',
    'movsubbl',
    'movsubldr',
    'movsubmov',
    'movsubpop',
    'movsubstr',
    'mvnbldr',
    'mvnmovbl',
    'mvnmovmov',
    'mvnstrldr',
    'mvnstrstr',
    'mvnsub.sbge',
    'orr.sbiceqpop',
    'orrgepopgemvn',
    'orrldrborr',
    'orrldrstr',
    'orrlelsllesub.s',
    'orrmovpop',
    'orrorrlsl',
    'orrorrmov',
    'orrorrpop',
    'orrpoprsb',
    'orrstrldr',
    'popaddadd',
    'popaddbx',
    'popaddmov',
    'popandorr',
    'popbadd',
    'popbbl',
    'popblbl',
    'popbldr',
    'popblldr',
    'popblmov',
    'popbmov',
    'popbxldr',
    'popbxmov',
    'popcmpbeq',
    'popcmpbne',
    'popgemvnsub.s',
    'popldradd',
    'popldrcmp',
    'popldrldr',
    'popldrmov',
    'poplsrmov',
    'popmovb',
    'popmovbl',
    'popmovmov',
    'popmovpop',
    'poporrorr',
    'poprsbrsb',
    'pushaddldr',
    'pushaddsub',
    'pushldradd',
    'pushldrcmp',
    'pushldrldr',
    'pushldrmov',
    'pushldrsub',
    'pushmovbl',
    'pushmovldr',
    'pushmovmov',
    'pushmovsub',
    'pushsub.sbeq',
    'pushsub.ssub',
    'pushsubadd',
    'pushsubbl',
    'pushsubldr',
    'pushsubmov',
    'pushsubstr',
    'rsblelslorrle',
    'rsblsllsr',
    'rsblsrorr',
    'rsbrsblsr',
    'stmaddmov',
    'stmblldr',
    'stmldmadd',
    'stmldmmov',
    'stmldmstm',
    'stmldradd',
    'stmldrldr',
    'stmldrmov',
    'stmmovldr',
    'stmmovmov',
    'straddadd',
    'straddbl',
    'straddcmp',
    'straddldr',
    'straddmov',
    'straddpop',
    'straddstr',
    'straddsub',
    'strbadd',
    'strbbeqldr',
    'strbbl',
    'strbbldr',
    'strbblxldr',
    'strbbmov',
    'strbcmp',
    'strbeqadd',
    'strbeqbl',
    'strbeqcmp',
    'strbeqldr',
    'strbeqmov',
    'strbeqstr',
    'strbhiaddcmp',
    'strbladd',
    'strblb',
    'strblbl',
    'strblcmp',
    'strbldr',
    'strbldradd',
    'strbldrb',
    'strbldrcmp',
    'strbldrldr',
    'strbldrmov',
    'strblldr',
    'strblmov',
    'strblstr',
    'strblsub.s',
    'strbmov',
    'strbmovmov',
    'strbneldr',
    'strbnemov',
    'strbstrbbeq',
    'strbstrbstrb',
    'strcmpbeq',
    'strcmpbne',
    'strdbldr',
    'strdblldr',
    'strdblmov',
    'strdldrbl',
    'strdldrdbl',
    'strdldrdmov',
    'strdldrdstrd',
    'strdldrldr',
    'strdldrmov',
    'strdldrstr',
    'strdmovbl',
    'strdmovmov',
    'strdmovstr',
    'strdstrdbl',
    'strdstrdldr',
    'strdstrdmov',
    'strdstrdstrd',
    'strdstrmov',
    'strdstrstr',
    'strldmadd',
    'strldmstm',
    'strldradd',
    'strldrand',
    'strldrb',
    'strldrbcmp',
    'strldrbl',
    'strldrcmp',
    'strldrdmov',
    'strldrldr',
    'strldrldrb',
    'strldrlsl',
    'strldrmov',
    'strldrstr',
    'strldrsub',
    'strmovadd',
    'strmovb',
    'strmovbeq',
    'strmovbl',
    'strmovldr',
    'strmovmov',
    'strmovpop',
    'strmovstm',
    'strmovstr',
    'strmovstrb',
    'strpopldr',
    'strpopmov',
    'strstradd',
    'strstrb',
    'strstrbeq',
    'strstrbl',
    'strstrbldr',
    'strstrbne',
    'strstrbstr',
    'strstrbstrb',
    'strstrdbl',
    'strstrldm',
    'strstrldr',
    'strstrldrd',
    'strstrmov',
    'strstrpop',
    'strstrstr',
    'strstrstrb',
    'strstrstrd',
    'strsubstr',
    'sub.saddgeorrge',
    'sub.sbeqbl',
    'sub.sbeqcmp',
    'sub.sbeqldr',
    'sub.sbeqmov',
    'sub.sbgeadd.s',
    'sub.sbneldr',
    'sub.sbnemov',
    'sub.sldrstr',
    'sub.smovneb',
    'sub.smovnecmp',
    'sub.ssubbeq',
    'subaddadd',
    'subaddcmp',
    'subaddldr',
    'subaddmov',
    'subaddstr',
    'subbeqmov',
    'subblldr',
    'subblmov',
    'subclzlsr',
    'subcmpaddls',
    'subcmpbeq',
    'subcmpbhi',
    'subcmpbls',
    'subcmpldr',
    'subcmpmov',
    'subcmpstr',
    'subeqbeqorr',
    'subhscmpadc',
    'subldradd',
    'subldrldr',
    'subldrmov',
    'subldrstr',
    'submovadd',
    'submovbl',
    'submovldr',
    'submovmov',
    'submovstr',
    'substrldr',
    'substrmov',
    'substrstr',
    'subsub.sbge',
    'subsubcmp',
    'subsubldr',
    'subsubmov',
    'teqbneorr.s',
    'teqmoveqmoveq',
    'tstbeqldr',
    'tstbneldr',
    'tstsubeqbeq'
}
