from typing import List, OptionalDOCS_CONFIG = "https://aqtinstall.readthedocs.io/en/stable/configuration.html#configuration"class AqtException(Exception):    def __init__(self, *args, suggested_action: Optional[List[str]] = None, should_show_help: bool = False, **kwargs):        self.suggested_action: List[str] = suggested_action or []        self.should_show_help: bool = should_show_help or False        super(AqtException, self).__init__(*args, **kwargs)    def __format__(self, format_spec: str) -> str:        base_msg = "{}".format(super(AqtException, self).__format__(format_spec))        if not self.suggested_action:            return base_msg        return f"{base_msg}\n{self._format_suggested_follow_up()}"    def _format_suggested_follow_up(self) -> str:        return ("=" * 30 + "Suggested follow-up:" + "=" * 30 + "\n") + "\n".join(            ["* " + suggestion for suggestion in self.suggested_action]        )    def append_suggested_follow_up(self, suggestions: List[str]) -> None:        self.suggested_action.extend(suggestions)class ArchiveDownloadError(AqtException):    passclass ArchiveChecksumError(ArchiveDownloadError):    passclass ChecksumDownloadFailure(ArchiveDownloadError):    def __init__(self, *args, suggested_action: Optional[List[str]] = None, **kwargs):        if suggested_action is None:            suggested_action = []        suggested_action.extend(            [                "Check your internet connection",                "Consider modifying `requests.max_retries_to_retrieve_hash` in settings.ini",                f"Consider modifying `mirrors.trusted_mirrors` in settings.ini (see {DOCS_CONFIG})",            ]        )        super(ChecksumDownloadFailure, self).__init__(            *args, suggested_action=suggested_action, should_show_help=True, **kwargs        )class ArchiveConnectionError(AqtException):    passclass ArchiveListError(AqtException):    passclass NoPackageFound(AqtException):    passclass EmptyMetadata(AqtException):    passclass CliInputError(AqtException):    passclass CliKeyboardInterrupt(AqtException):    passclass ArchiveExtractionError(AqtException):    passclass UpdaterError(AqtException):    passclass OutOfMemory(AqtException):    passclass OutOfDiskSpace(AqtException):    passclass DiskAccessNotPermitted(AqtException):    pass