import refrom textwrap import dedentfrom typing import Any, List, Sequence, Unionfrom unittest.mock import Mockfrom omegaconf import DictConfig, OmegaConffrom pytest import mark, raisesfrom hydra import TaskFunctionfrom hydra._internal.callbacks import Callbacksfrom hydra._internal.config_loader_impl import ConfigLoaderImplfrom hydra._internal.utils import create_config_search_pathfrom hydra.core.config_loader import ConfigLoaderfrom hydra.core.plugins import Pluginsfrom hydra.core.utils import JobReturn, _check_hydra_contextfrom hydra.plugins.launcher import Launcherfrom hydra.plugins.sweeper import Sweeperfrom hydra.test_utils.test_utils import chdir_hydra_rootfrom hydra.types import HydraContextchdir_hydra_root()class IncompatibleSweeper(Sweeper):    def __init__(self) -> None:        pass    def setup(  # type: ignore        self,        config: DictConfig,        config_loader: ConfigLoader,        task_function: TaskFunction,    ) -> None:        pass    def sweep(self, arguments: List[str]) -> Any:        passclass IncompatibleLauncher(Launcher):    def __init__(self) -> None:        pass    def setup(  # type: ignore        self,        config: DictConfig,        config_loader: ConfigLoader,        task_function: TaskFunction,    ) -> None:        pass    def launch(  # type: ignore[empty-body]        self, job_overrides: Sequence[Sequence[str]], initial_job_idx: int    ) -> Sequence[JobReturn]:        pass@mark.parametrize(    "plugin, config",    [        (IncompatibleLauncher(), OmegaConf.create({"hydra": {"launcher": {}}})),        (IncompatibleSweeper(), OmegaConf.create({"hydra": {"sweeper": {}}})),    ],)def test_setup_plugins(    monkeypatch: Any, plugin: Union[Launcher, Sweeper], config: DictConfig) -> None:    task_function = Mock(spec=TaskFunction)    config_loader = ConfigLoaderImpl(config_search_path=create_config_search_path(None))    hydra_context = HydraContext(config_loader=config_loader, callbacks=Callbacks())    plugin_instance = Plugins.instance()    monkeypatch.setattr(Plugins, "check_usage", lambda _: None)    monkeypatch.setattr(plugin_instance, "_instantiate", lambda _: plugin)    msg = "setup() got an unexpected keyword argument 'hydra_context'"    with raises(TypeError, match=re.escape(msg)):        if isinstance(plugin, Launcher):            Plugins.instance().instantiate_launcher(                hydra_context=hydra_context,                task_function=task_function,                config=config,            )        else:            Plugins.instance().instantiate_sweeper(                hydra_context=hydra_context,                task_function=task_function,                config=config,            )def test_run_job() -> None:    hydra_context = None    msg = dedent(        """        run_job's signature has changed: the `hydra_context` arg is now required.        For more info, check https://github.com/facebookresearch/hydra/pull/1581."""    )    with raises(TypeError, match=msg):        _check_hydra_context(hydra_context)