import loggingfrom pathlib import Pathfrom typing import Any, Dict, List, Sequencefrom hydra.core.hydra_config import HydraConfigfrom hydra.core.singleton import Singletonfrom hydra.core.utils import (    JobReturn,    configure_log,    filter_overrides,    run_job,    setup_globals,)from hydra.types import HydraContext, TaskFunctionfrom joblib import Parallel, delayed  # type: ignorefrom omegaconf import DictConfig, open_dictfrom .joblib_launcher import JoblibLauncherlog = logging.getLogger(__name__)def execute_job(    idx: int,    overrides: Sequence[str],    hydra_context: HydraContext,    config: DictConfig,    task_function: TaskFunction,    singleton_state: Dict[Any, Any],) -> JobReturn:    """Calls `run_job` in parallel"""    setup_globals()    Singleton.set_state(singleton_state)    sweep_config = hydra_context.config_loader.load_sweep_config(        config, list(overrides)    )    with open_dict(sweep_config):        sweep_config.hydra.job.id = f"{sweep_config.hydra.job.name}_{idx}"        sweep_config.hydra.job.num = idx    HydraConfig.instance().set_config(sweep_config)    ret = run_job(        hydra_context=hydra_context,        config=sweep_config,        task_function=task_function,        job_dir_key="hydra.sweep.dir",        job_subdir_key="hydra.sweep.subdir",    )    return retdef process_joblib_cfg(joblib_cfg: Dict[str, Any]) -> None:    for k in ["pre_dispatch", "batch_size", "max_nbytes"]:        if k in joblib_cfg.keys():            try:                val = joblib_cfg.get(k)                if val:                    joblib_cfg[k] = int(val)            except ValueError:                passdef launch(    launcher: JoblibLauncher,    job_overrides: Sequence[Sequence[str]],    initial_job_idx: int,) -> Sequence[JobReturn]:    """    :param job_overrides: a List of List<String>, where each inner list is the arguments for one job run.    :param initial_job_idx: Initial job idx in batch.    :return: an array of return values from run_job with indexes corresponding to the input list indexes.    """    setup_globals()    assert launcher.config is not None    assert launcher.task_function is not None    assert launcher.hydra_context is not None    configure_log(launcher.config.hydra.hydra_logging, launcher.config.hydra.verbose)    sweep_dir = Path(str(launcher.config.hydra.sweep.dir))    sweep_dir.mkdir(parents=True, exist_ok=True)    # Joblib's backend is hard-coded to loky since the threading    # backend is incompatible with Hydra    joblib_cfg = launcher.joblib    joblib_cfg["backend"] = "loky"    process_joblib_cfg(joblib_cfg)    log.info(        "Joblib.Parallel({}) is launching {} jobs".format(            ",".join(f"{k}={v}" for k, v in joblib_cfg.items()),            len(job_overrides),        )    )    log.info(f"Launching jobs, sweep output dir : {sweep_dir}")    for idx, overrides in enumerate(job_overrides):        log.info("\t#{} : {}".format(idx, " ".join(filter_overrides(overrides))))    singleton_state = Singleton.get_state()    runs = Parallel(**joblib_cfg)(        delayed(execute_job)(            initial_job_idx + idx,            overrides,            launcher.hydra_context,            launcher.config,            launcher.task_function,            singleton_state,        )        for idx, overrides in enumerate(job_overrides)    )    assert isinstance(runs, List)    for run in runs:        assert isinstance(run, JobReturn)    return runs