from dataclasses import dataclass, fieldfrom typing import Any, Listfrom omegaconf import MISSINGimport hydrafrom hydra.core.config_store import ConfigStorefrom hydra.utils import instantiateclass DBConnection:    def __init__(self, driver: str, host: str, port: int) -> None:        self.driver = driver        self.host = host        self.port = port    def connect(self) -> None:        print(f"{self.driver} connecting to {self.host}")class MySQLConnection(DBConnection):    def __init__(self, driver: str, host: str, port: int) -> None:        super().__init__(driver=driver, host=host, port=port)class PostgreSQLConnection(DBConnection):    def __init__(self, driver: str, host: str, port: int, timeout: int) -> None:        super().__init__(driver=driver, host=host, port=port)        self.timeout = timeout@dataclassclass DBConfig:    driver: str = MISSING    host: str = "localhost"    port: int = 80@dataclassclass MySQLConfig(DBConfig):    _target_: str = "my_app.MySQLConnection"    driver: str = "MySQL"    port: int = 1234@dataclassclass PostGreSQLConfig(DBConfig):    _target_: str = "my_app.PostgreSQLConnection"    driver: str = "PostgreSQL"    port: int = 5678    timeout: int = 10@dataclassclass Config:    defaults: List[Any] = field(        default_factory=lambda: [            "_self_",            {"db": "mysql"},        ]    )    db: DBConfig = MISSINGcs = ConfigStore.instance()cs.store(name="config", node=Config)cs.store(group="db", name="mysql", node=MySQLConfig)cs.store(group="db", name="postgresql", node=PostGreSQLConfig)@hydra.main(version_base=None, config_name="config")def my_app(cfg: Config) -> None:    connection = instantiate(cfg.db)    connection.connect()if __name__ == "__main__":    my_app()