from dataclasses import dataclassfrom typing import Collection, Optional, Tuplefrom . import mappingUsbId = Tuple[int, int]VENDORS = ("bitcointrezor.com", "trezor.io")@dataclass(eq=True, frozen=True)class TrezorModel:    name: str    internal_name: str    minimum_version: Tuple[int, int, int]    vendors: Collection[str]    usb_ids: Collection[UsbId]    default_mapping: mapping.ProtobufMapping# ==== internal names ====T1B1 = TrezorModel(    name="1",    internal_name="T1B1",    minimum_version=(1, 8, 0),    vendors=VENDORS,    usb_ids=((0x534C, 0x0001),),    default_mapping=mapping.DEFAULT_MAPPING,)T2T1 = TrezorModel(    name="T",    internal_name="T2T1",    minimum_version=(2, 1, 0),    vendors=VENDORS,    usb_ids=((0x1209, 0x53C1), (0x1209, 0x53C0)),    default_mapping=mapping.DEFAULT_MAPPING,)T2B1 = TrezorModel(    name="Safe 3",    internal_name="T2B1",    minimum_version=(2, 1, 0),    vendors=VENDORS,    usb_ids=((0x1209, 0x53C1), (0x1209, 0x53C0)),    default_mapping=mapping.DEFAULT_MAPPING,)DISC1 = TrezorModel(    name="DISC1",    internal_name="D001",    minimum_version=(2, 1, 0),    vendors=VENDORS,    usb_ids=((0x1209, 0x53C1), (0x1209, 0x53C0)),    default_mapping=mapping.DEFAULT_MAPPING,)# ==== model based names ====TREZOR_ONE = T1B1TREZOR_T = T2T1TREZOR_R = T2B1TREZOR_SAFE3 = T2B1TREZOR_DISC1 = DISC1TREZORS = {T1B1, T2T1, T2B1, DISC1}def by_name(name: Optional[str]) -> Optional[TrezorModel]:    if name is None:        return T1B1    for model in TREZORS:        if model.name == name:            return model    return Nonedef by_internal_name(name: Optional[str]) -> Optional[TrezorModel]:    if name is None:        return None    for model in TREZORS:        if model.internal_name == name:            return model    return None