# Automatically generated by pb2py
# fmt: off
# isort:skip_file

from enum import IntEnum
from typing import List, Optional

from . import protobuf


class MessageType(IntEnum):
    Initialize = 0
    Ping = 1
    Success = 2
    Failure = 3
    ChangePin = 4
    WipeDevice = 5
    GetEntropy = 9
    Entropy = 10
    LoadDevice = 13
    ResetDevice = 14
    Features = 17
    PinMatrixRequest = 18
    PinMatrixAck = 19
    Cancel = 20
    LockDevice = 24
    ApplySettings = 25
    ButtonRequest = 26
    ButtonAck = 27
    ApplyFlags = 28
    BackupDevice = 34
    EntropyRequest = 35
    EntropyAck = 36
    PassphraseRequest = 41
    PassphraseAck = 42
    RecoveryDevice = 45
    WordRequest = 46
    WordAck = 47
    GetFeatures = 55
    SdProtect = 79
    ChangeWipeCode = 82
    EndSession = 83
    DoPreauthorized = 84
    PreauthorizedRequest = 85
    CancelAuthorization = 86
    RebootToBootloader = 87
    Deprecated_PassphraseStateRequest = 77
    Deprecated_PassphraseStateAck = 78
    FirmwareErase = 6
    FirmwareUpload = 7
    FirmwareRequest = 8
    SelfTest = 32
    GetPublicKey = 11
    PublicKey = 12
    SignTx = 15
    TxRequest = 21
    TxAck = 22
    GetAddress = 29
    Address = 30
    SignMessage = 38
    VerifyMessage = 39
    MessageSignature = 40
    GetOwnershipId = 43
    OwnershipId = 44
    GetOwnershipProof = 49
    OwnershipProof = 50
    AuthorizeCoinJoin = 51
    DebugLinkDecision = 100
    DebugLinkGetState = 101
    DebugLinkState = 102
    DebugLinkStop = 103
    DebugLinkLog = 104
    DebugLinkMemoryRead = 110
    DebugLinkMemory = 111
    DebugLinkMemoryWrite = 112
    DebugLinkFlashErase = 113
    DebugLinkLayout = 9001
    DebugLinkReseedRandom = 9002
    DebugLinkRecordScreen = 9003
    DebugLinkEraseSdCard = 9005
    DebugLinkWatchLayout = 9006


class FailureType(IntEnum):
    UnexpectedMessage = 1
    ButtonExpected = 2
    DataError = 3
    ActionCancelled = 4
    PinExpected = 5
    PinCancelled = 6
    PinInvalid = 7
    InvalidSignature = 8
    ProcessError = 9
    NotEnoughFunds = 10
    NotInitialized = 11
    PinMismatch = 12
    WipeCodeMismatch = 13
    InvalidSession = 14
    FirmwareError = 99


class ButtonRequestType(IntEnum):
    Other = 1
    FeeOverThreshold = 2
    ConfirmOutput = 3
    ResetDevice = 4
    ConfirmWord = 5
    WipeDevice = 6
    ProtectCall = 7
    SignTx = 8
    FirmwareCheck = 9
    Address = 10
    PublicKey = 11
    MnemonicWordCount = 12
    MnemonicInput = 13
    _Deprecated_ButtonRequest_PassphraseType = 14
    UnknownDerivationPath = 15
    RecoveryHomepage = 16
    Success = 17
    Warning = 18
    PassphraseEntry = 19
    PinEntry = 20


class PinMatrixRequestType(IntEnum):
    Current = 1
    NewFirst = 2
    NewSecond = 3
    WipeCodeFirst = 4
    WipeCodeSecond = 5


class InputScriptType(IntEnum):
    SPENDADDRESS = 0
    SPENDMULTISIG = 1
    EXTERNAL = 2
    SPENDWITNESS = 3
    SPENDP2SHWITNESS = 4
    SPENDTAPROOT = 5


class OutputScriptType(IntEnum):
    PAYTOADDRESS = 0
    PAYTOSCRIPTHASH = 1
    PAYTOMULTISIG = 2
    PAYTOOPRETURN = 3
    PAYTOWITNESS = 4
    PAYTOP2SHWITNESS = 5
    PAYTOTAPROOT = 6


class DecredStakingSpendType(IntEnum):
    SSGen = 0
    SSRTX = 1


class AmountUnit(IntEnum):
    BITCOIN = 0
    MILLIBITCOIN = 1
    MICROBITCOIN = 2
    SATOSHI = 3


class RequestType(IntEnum):
    TXINPUT = 0
    TXOUTPUT = 1
    TXMETA = 2
    TXFINISHED = 3
    TXEXTRADATA = 4
    TXORIGINPUT = 5
    TXORIGOUTPUT = 6


class BackupType(IntEnum):
    Bip39 = 0
    Slip39_Basic = 1
    Slip39_Advanced = 2


class SafetyCheckLevel(IntEnum):
    Strict = 0
    PromptAlways = 1
    PromptTemporarily = 2


class Capability(IntEnum):
    Bitcoin = 1
    Bitcoin_like = 2
    Binance = 3
    Cardano = 4
    Crypto = 5
    EOS = 6
    Ethereum = 7
    Lisk = 8
    Monero = 9
    NEM = 10
    Ripple = 11
    Stellar = 12
    Tezos = 13
    U2F = 14
    Shamir = 15
    ShamirGroups = 16
    PassphraseEntry = 17


class SdProtectOperationType(IntEnum):
    DISABLE = 0
    ENABLE = 1
    REFRESH = 2


class RecoveryDeviceType(IntEnum):
    ScrambledWords = 0
    Matrix = 1


class WordRequestType(IntEnum):
    Plain = 0
    Matrix9 = 1
    Matrix6 = 2


class DebugSwipeDirection(IntEnum):
    UP = 0
    DOWN = 1
    LEFT = 2
    RIGHT = 3


class Success(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 2
    FIELDS = {
        1: protobuf.Field("message", "string", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        message: Optional["str"] = '',
    ) -> None:
        self.message = message


class Failure(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 3
    FIELDS = {
        1: protobuf.Field("code", "FailureType", repeated=False, required=False),
        2: protobuf.Field("message", "string", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        code: Optional["FailureType"] = None,
        message: Optional["str"] = None,
    ) -> None:
        self.code = code
        self.message = message


class ButtonRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 26
    FIELDS = {
        1: protobuf.Field("code", "ButtonRequestType", repeated=False, required=False),
        2: protobuf.Field("pages", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        code: Optional["ButtonRequestType"] = None,
        pages: Optional["int"] = None,
    ) -> None:
        self.code = code
        self.pages = pages


class ButtonAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 27


class PinMatrixRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 18
    FIELDS = {
        1: protobuf.Field("type", "PinMatrixRequestType", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        type: Optional["PinMatrixRequestType"] = None,
    ) -> None:
        self.type = type


class PinMatrixAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 19
    FIELDS = {
        1: protobuf.Field("pin", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        pin: "str",
    ) -> None:
        self.pin = pin


class PassphraseRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 41
    FIELDS = {
        1: protobuf.Field("_on_device", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        _on_device: Optional["bool"] = None,
    ) -> None:
        self._on_device = _on_device


class PassphraseAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 42
    FIELDS = {
        1: protobuf.Field("passphrase", "string", repeated=False, required=False),
        2: protobuf.Field("_state", "bytes", repeated=False, required=False),
        3: protobuf.Field("on_device", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        passphrase: Optional["str"] = None,
        _state: Optional["bytes"] = None,
        on_device: Optional["bool"] = None,
    ) -> None:
        self.passphrase = passphrase
        self._state = _state
        self.on_device = on_device


class Deprecated_PassphraseStateRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 77
    FIELDS = {
        1: protobuf.Field("state", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        state: Optional["bytes"] = None,
    ) -> None:
        self.state = state


class Deprecated_PassphraseStateAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 78


class HDNodeType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("depth", "uint32", repeated=False, required=True),
        2: protobuf.Field("fingerprint", "uint32", repeated=False, required=True),
        3: protobuf.Field("child_num", "uint32", repeated=False, required=True),
        4: protobuf.Field("chain_code", "bytes", repeated=False, required=True),
        5: protobuf.Field("private_key", "bytes", repeated=False, required=False),
        6: protobuf.Field("public_key", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        depth: "int",
        fingerprint: "int",
        child_num: "int",
        chain_code: "bytes",
        public_key: "bytes",
        private_key: Optional["bytes"] = None,
    ) -> None:
        self.depth = depth
        self.fingerprint = fingerprint
        self.child_num = child_num
        self.chain_code = chain_code
        self.public_key = public_key
        self.private_key = private_key


class MultisigRedeemScriptType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("pubkeys", "HDNodePathType", repeated=True, required=False),
        2: protobuf.Field("signatures", "bytes", repeated=True, required=False),
        3: protobuf.Field("m", "uint32", repeated=False, required=True),
        4: protobuf.Field("nodes", "HDNodeType", repeated=True, required=False),
        5: protobuf.Field("address_n", "uint32", repeated=True, required=False),
    }

    def __init__(
        self,
        *,
        m: "int",
        pubkeys: Optional[List["HDNodePathType"]] = None,
        signatures: Optional[List["bytes"]] = None,
        nodes: Optional[List["HDNodeType"]] = None,
        address_n: Optional[List["int"]] = None,
    ) -> None:
        self.pubkeys = pubkeys if pubkeys is not None else []
        self.signatures = signatures if signatures is not None else []
        self.nodes = nodes if nodes is not None else []
        self.address_n = address_n if address_n is not None else []
        self.m = m


class GetPublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 11
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("ecdsa_curve_name", "string", repeated=False, required=False),
        3: protobuf.Field("show_display", "bool", repeated=False, required=False),
        4: protobuf.Field("coin_name", "string", repeated=False, required=False),
        5: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        6: protobuf.Field("ignore_xpub_magic", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address_n: Optional[List["int"]] = None,
        ecdsa_curve_name: Optional["str"] = None,
        show_display: Optional["bool"] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        ignore_xpub_magic: Optional["bool"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.ecdsa_curve_name = ecdsa_curve_name
        self.show_display = show_display
        self.coin_name = coin_name
        self.script_type = script_type
        self.ignore_xpub_magic = ignore_xpub_magic


class PublicKey(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 12
    FIELDS = {
        1: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
        2: protobuf.Field("xpub", "string", repeated=False, required=True),
        3: protobuf.Field("root_fingerprint", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        node: "HDNodeType",
        xpub: "str",
        root_fingerprint: Optional["int"] = None,
    ) -> None:
        self.node = node
        self.xpub = xpub
        self.root_fingerprint = root_fingerprint


class GetAddress(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 29
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False),
        3: protobuf.Field("show_display", "bool", repeated=False, required=False),
        4: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        5: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        6: protobuf.Field("ignore_xpub_magic", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address_n: Optional[List["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        show_display: Optional["bool"] = None,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        ignore_xpub_magic: Optional["bool"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.coin_name = coin_name
        self.show_display = show_display
        self.multisig = multisig
        self.script_type = script_type
        self.ignore_xpub_magic = ignore_xpub_magic


class Address(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 30
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
    ) -> None:
        self.address = address


class GetOwnershipId(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 43
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False),
        3: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        4: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address_n: Optional[List["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        multisig: Optional["MultisigRedeemScriptType"] = None,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.coin_name = coin_name
        self.multisig = multisig
        self.script_type = script_type


class OwnershipId(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 44
    FIELDS = {
        1: protobuf.Field("ownership_id", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        ownership_id: "bytes",
    ) -> None:
        self.ownership_id = ownership_id


class SignMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 38
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("message", "bytes", repeated=False, required=True),
        3: protobuf.Field("coin_name", "string", repeated=False, required=False),
        4: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        5: protobuf.Field("no_script_type", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        message: "bytes",
        address_n: Optional[List["int"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        no_script_type: Optional["bool"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.message = message
        self.coin_name = coin_name
        self.script_type = script_type
        self.no_script_type = no_script_type


class MessageSignature(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 40
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        address: "str",
        signature: "bytes",
    ) -> None:
        self.address = address
        self.signature = signature


class VerifyMessage(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 39
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
        3: protobuf.Field("message", "bytes", repeated=False, required=True),
        4: protobuf.Field("coin_name", "string", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address: "str",
        signature: "bytes",
        message: "bytes",
        coin_name: Optional["str"] = 'Bitcoin',
    ) -> None:
        self.address = address
        self.signature = signature
        self.message = message
        self.coin_name = coin_name


class SignTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 15
    FIELDS = {
        1: protobuf.Field("outputs_count", "uint32", repeated=False, required=True),
        2: protobuf.Field("inputs_count", "uint32", repeated=False, required=True),
        3: protobuf.Field("coin_name", "string", repeated=False, required=False),
        4: protobuf.Field("version", "uint32", repeated=False, required=False),
        5: protobuf.Field("lock_time", "uint32", repeated=False, required=False),
        6: protobuf.Field("expiry", "uint32", repeated=False, required=False),
        7: protobuf.Field("overwintered", "bool", repeated=False, required=False),
        8: protobuf.Field("version_group_id", "uint32", repeated=False, required=False),
        9: protobuf.Field("timestamp", "uint32", repeated=False, required=False),
        10: protobuf.Field("branch_id", "uint32", repeated=False, required=False),
        11: protobuf.Field("amount_unit", "AmountUnit", repeated=False, required=False),
        12: protobuf.Field("decred_staking_ticket", "bool", repeated=False, required=False),
        13: protobuf.Field("serialize", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        outputs_count: "int",
        inputs_count: "int",
        coin_name: Optional["str"] = 'Bitcoin',
        version: Optional["int"] = 1,
        lock_time: Optional["int"] = 0,
        expiry: Optional["int"] = None,
        overwintered: Optional["bool"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
        amount_unit: Optional["AmountUnit"] = AmountUnit.BITCOIN,
        decred_staking_ticket: Optional["bool"] = False,
        serialize: Optional["bool"] = True,
    ) -> None:
        self.outputs_count = outputs_count
        self.inputs_count = inputs_count
        self.coin_name = coin_name
        self.version = version
        self.lock_time = lock_time
        self.expiry = expiry
        self.overwintered = overwintered
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id
        self.amount_unit = amount_unit
        self.decred_staking_ticket = decred_staking_ticket
        self.serialize = serialize


class TxRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 21
    FIELDS = {
        1: protobuf.Field("request_type", "RequestType", repeated=False, required=False),
        2: protobuf.Field("details", "TxRequestDetailsType", repeated=False, required=False),
        3: protobuf.Field("serialized", "TxRequestSerializedType", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        request_type: Optional["RequestType"] = None,
        details: Optional["TxRequestDetailsType"] = None,
        serialized: Optional["TxRequestSerializedType"] = None,
    ) -> None:
        self.request_type = request_type
        self.details = details
        self.serialized = serialized


class TxAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TransactionType", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        tx: Optional["TransactionType"] = None,
    ) -> None:
        self.tx = tx


class TxInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=False),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=False),
        6: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        7: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        8: protobuf.Field("amount", "uint64", repeated=False, required=True),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False),
        13: protobuf.Field("witness", "bytes", repeated=False, required=False),
        14: protobuf.Field("ownership_proof", "bytes", repeated=False, required=False),
        15: protobuf.Field("commitment_data", "bytes", repeated=False, required=False),
        16: protobuf.Field("orig_hash", "bytes", repeated=False, required=False),
        17: protobuf.Field("orig_index", "uint32", repeated=False, required=False),
        18: protobuf.Field("decred_staking_spend", "DecredStakingSpendType", repeated=False, required=False),
        19: protobuf.Field("script_pubkey", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        amount: "int",
        address_n: Optional[List["int"]] = None,
        script_sig: Optional["bytes"] = None,
        sequence: Optional["int"] = 4294967295,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        decred_tree: Optional["int"] = None,
        witness: Optional["bytes"] = None,
        ownership_proof: Optional["bytes"] = None,
        commitment_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        decred_staking_spend: Optional["DecredStakingSpendType"] = None,
        script_pubkey: Optional["bytes"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.amount = amount
        self.script_sig = script_sig
        self.sequence = sequence
        self.script_type = script_type
        self.multisig = multisig
        self.decred_tree = decred_tree
        self.witness = witness
        self.ownership_proof = ownership_proof
        self.commitment_data = commitment_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.decred_staking_spend = decred_staking_spend
        self.script_pubkey = script_pubkey


class TxOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        3: protobuf.Field("amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("script_type", "OutputScriptType", repeated=False, required=False),
        5: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        6: protobuf.Field("op_return_data", "bytes", repeated=False, required=False),
        10: protobuf.Field("orig_hash", "bytes", repeated=False, required=False),
        11: protobuf.Field("orig_index", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        amount: "int",
        address_n: Optional[List["int"]] = None,
        address: Optional["str"] = None,
        script_type: Optional["OutputScriptType"] = OutputScriptType.PAYTOADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        op_return_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.amount = amount
        self.address = address
        self.script_type = script_type
        self.multisig = multisig
        self.op_return_data = op_return_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index


class PrevTx(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=True),
        4: protobuf.Field("lock_time", "uint32", repeated=False, required=True),
        6: protobuf.Field("inputs_count", "uint32", repeated=False, required=True),
        7: protobuf.Field("outputs_count", "uint32", repeated=False, required=True),
        9: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False),
        10: protobuf.Field("expiry", "uint32", repeated=False, required=False),
        12: protobuf.Field("version_group_id", "uint32", repeated=False, required=False),
        13: protobuf.Field("timestamp", "uint32", repeated=False, required=False),
        14: protobuf.Field("branch_id", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        version: "int",
        lock_time: "int",
        inputs_count: "int",
        outputs_count: "int",
        extra_data_len: Optional["int"] = 0,
        expiry: Optional["int"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
    ) -> None:
        self.version = version
        self.lock_time = lock_time
        self.inputs_count = inputs_count
        self.outputs_count = outputs_count
        self.extra_data_len = extra_data_len
        self.expiry = expiry
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id


class PrevInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=True),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=True),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        script_sig: "bytes",
        sequence: "int",
        decred_tree: Optional["int"] = None,
    ) -> None:
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.script_sig = script_sig
        self.sequence = sequence
        self.decred_tree = decred_tree


class PrevOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=True),
        2: protobuf.Field("script_pubkey", "bytes", repeated=False, required=True),
        3: protobuf.Field("decred_script_version", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        amount: "int",
        script_pubkey: "bytes",
        decred_script_version: Optional["int"] = None,
    ) -> None:
        self.amount = amount
        self.script_pubkey = script_pubkey
        self.decred_script_version = decred_script_version


class TxAckInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckInputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckInputWrapper",
    ) -> None:
        self.tx = tx


class TxAckOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckOutputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckOutputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevMeta(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "PrevTx", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "PrevTx",
    ) -> None:
        self.tx = tx


class TxAckPrevInput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevInputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevInputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevOutput(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevOutputWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevOutputWrapper",
    ) -> None:
        self.tx = tx


class TxAckPrevExtraData(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 22
    FIELDS = {
        1: protobuf.Field("tx", "TxAckPrevExtraDataWrapper", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        tx: "TxAckPrevExtraDataWrapper",
    ) -> None:
        self.tx = tx


class GetOwnershipProof(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 49
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("coin_name", "string", repeated=False, required=False),
        3: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        4: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        5: protobuf.Field("user_confirmation", "bool", repeated=False, required=False),
        6: protobuf.Field("ownership_ids", "bytes", repeated=True, required=False),
        7: protobuf.Field("commitment_data", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address_n: Optional[List["int"]] = None,
        ownership_ids: Optional[List["bytes"]] = None,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDWITNESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        user_confirmation: Optional["bool"] = False,
        commitment_data: Optional["bytes"] = b'',
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.ownership_ids = ownership_ids if ownership_ids is not None else []
        self.coin_name = coin_name
        self.script_type = script_type
        self.multisig = multisig
        self.user_confirmation = user_confirmation
        self.commitment_data = commitment_data


class OwnershipProof(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 50
    FIELDS = {
        1: protobuf.Field("ownership_proof", "bytes", repeated=False, required=True),
        2: protobuf.Field("signature", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        ownership_proof: "bytes",
        signature: "bytes",
    ) -> None:
        self.ownership_proof = ownership_proof
        self.signature = signature


class AuthorizeCoinJoin(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 51
    FIELDS = {
        1: protobuf.Field("coordinator", "string", repeated=False, required=True),
        2: protobuf.Field("max_total_fee", "uint64", repeated=False, required=True),
        3: protobuf.Field("fee_per_anonymity", "uint32", repeated=False, required=False),
        4: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        5: protobuf.Field("coin_name", "string", repeated=False, required=False),
        6: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        11: protobuf.Field("amount_unit", "AmountUnit", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        coordinator: "str",
        max_total_fee: "int",
        address_n: Optional[List["int"]] = None,
        fee_per_anonymity: Optional["int"] = 0,
        coin_name: Optional["str"] = 'Bitcoin',
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        amount_unit: Optional["AmountUnit"] = AmountUnit.BITCOIN,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.coordinator = coordinator
        self.max_total_fee = max_total_fee
        self.fee_per_anonymity = fee_per_anonymity
        self.coin_name = coin_name
        self.script_type = script_type
        self.amount_unit = amount_unit


class HDNodePathType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("node", "HDNodeType", repeated=False, required=True),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False),
    }

    def __init__(
        self,
        *,
        node: "HDNodeType",
        address_n: Optional[List["int"]] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.node = node


class TxRequestDetailsType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("request_index", "uint32", repeated=False, required=False),
        2: protobuf.Field("tx_hash", "bytes", repeated=False, required=False),
        3: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False),
        4: protobuf.Field("extra_data_offset", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        request_index: Optional["int"] = None,
        tx_hash: Optional["bytes"] = None,
        extra_data_len: Optional["int"] = None,
        extra_data_offset: Optional["int"] = None,
    ) -> None:
        self.request_index = request_index
        self.tx_hash = tx_hash
        self.extra_data_len = extra_data_len
        self.extra_data_offset = extra_data_offset


class TxRequestSerializedType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("signature_index", "uint32", repeated=False, required=False),
        2: protobuf.Field("signature", "bytes", repeated=False, required=False),
        3: protobuf.Field("serialized_tx", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        signature_index: Optional["int"] = None,
        signature: Optional["bytes"] = None,
        serialized_tx: Optional["bytes"] = None,
    ) -> None:
        self.signature_index = signature_index
        self.signature = signature
        self.serialized_tx = serialized_tx


class TransactionType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("version", "uint32", repeated=False, required=False),
        2: protobuf.Field("inputs", "TxInputType", repeated=True, required=False),
        3: protobuf.Field("bin_outputs", "TxOutputBinType", repeated=True, required=False),
        4: protobuf.Field("lock_time", "uint32", repeated=False, required=False),
        5: protobuf.Field("outputs", "TxOutputType", repeated=True, required=False),
        6: protobuf.Field("inputs_cnt", "uint32", repeated=False, required=False),
        7: protobuf.Field("outputs_cnt", "uint32", repeated=False, required=False),
        8: protobuf.Field("extra_data", "bytes", repeated=False, required=False),
        9: protobuf.Field("extra_data_len", "uint32", repeated=False, required=False),
        10: protobuf.Field("expiry", "uint32", repeated=False, required=False),
        11: protobuf.Field("overwintered", "bool", repeated=False, required=False),
        12: protobuf.Field("version_group_id", "uint32", repeated=False, required=False),
        13: protobuf.Field("timestamp", "uint32", repeated=False, required=False),
        14: protobuf.Field("branch_id", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        inputs: Optional[List["TxInputType"]] = None,
        bin_outputs: Optional[List["TxOutputBinType"]] = None,
        outputs: Optional[List["TxOutputType"]] = None,
        version: Optional["int"] = None,
        lock_time: Optional["int"] = None,
        inputs_cnt: Optional["int"] = None,
        outputs_cnt: Optional["int"] = None,
        extra_data: Optional["bytes"] = None,
        extra_data_len: Optional["int"] = None,
        expiry: Optional["int"] = None,
        overwintered: Optional["bool"] = None,
        version_group_id: Optional["int"] = None,
        timestamp: Optional["int"] = None,
        branch_id: Optional["int"] = None,
    ) -> None:
        self.inputs = inputs if inputs is not None else []
        self.bin_outputs = bin_outputs if bin_outputs is not None else []
        self.outputs = outputs if outputs is not None else []
        self.version = version
        self.lock_time = lock_time
        self.inputs_cnt = inputs_cnt
        self.outputs_cnt = outputs_cnt
        self.extra_data = extra_data
        self.extra_data_len = extra_data_len
        self.expiry = expiry
        self.overwintered = overwintered
        self.version_group_id = version_group_id
        self.timestamp = timestamp
        self.branch_id = branch_id


class TxInputType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        2: protobuf.Field("prev_hash", "bytes", repeated=False, required=True),
        3: protobuf.Field("prev_index", "uint32", repeated=False, required=True),
        4: protobuf.Field("script_sig", "bytes", repeated=False, required=False),
        5: protobuf.Field("sequence", "uint32", repeated=False, required=False),
        6: protobuf.Field("script_type", "InputScriptType", repeated=False, required=False),
        7: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        8: protobuf.Field("amount", "uint64", repeated=False, required=False),
        9: protobuf.Field("decred_tree", "uint32", repeated=False, required=False),
        13: protobuf.Field("witness", "bytes", repeated=False, required=False),
        14: protobuf.Field("ownership_proof", "bytes", repeated=False, required=False),
        15: protobuf.Field("commitment_data", "bytes", repeated=False, required=False),
        16: protobuf.Field("orig_hash", "bytes", repeated=False, required=False),
        17: protobuf.Field("orig_index", "uint32", repeated=False, required=False),
        18: protobuf.Field("decred_staking_spend", "DecredStakingSpendType", repeated=False, required=False),
        19: protobuf.Field("script_pubkey", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        prev_hash: "bytes",
        prev_index: "int",
        address_n: Optional[List["int"]] = None,
        script_sig: Optional["bytes"] = None,
        sequence: Optional["int"] = 4294967295,
        script_type: Optional["InputScriptType"] = InputScriptType.SPENDADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        amount: Optional["int"] = None,
        decred_tree: Optional["int"] = None,
        witness: Optional["bytes"] = None,
        ownership_proof: Optional["bytes"] = None,
        commitment_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
        decred_staking_spend: Optional["DecredStakingSpendType"] = None,
        script_pubkey: Optional["bytes"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.prev_hash = prev_hash
        self.prev_index = prev_index
        self.script_sig = script_sig
        self.sequence = sequence
        self.script_type = script_type
        self.multisig = multisig
        self.amount = amount
        self.decred_tree = decred_tree
        self.witness = witness
        self.ownership_proof = ownership_proof
        self.commitment_data = commitment_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index
        self.decred_staking_spend = decred_staking_spend
        self.script_pubkey = script_pubkey


class TxOutputBinType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("amount", "uint64", repeated=False, required=True),
        2: protobuf.Field("script_pubkey", "bytes", repeated=False, required=True),
        3: protobuf.Field("decred_script_version", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        amount: "int",
        script_pubkey: "bytes",
        decred_script_version: Optional["int"] = None,
    ) -> None:
        self.amount = amount
        self.script_pubkey = script_pubkey
        self.decred_script_version = decred_script_version


class TxOutputType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("address", "string", repeated=False, required=False),
        2: protobuf.Field("address_n", "uint32", repeated=True, required=False),
        3: protobuf.Field("amount", "uint64", repeated=False, required=True),
        4: protobuf.Field("script_type", "OutputScriptType", repeated=False, required=False),
        5: protobuf.Field("multisig", "MultisigRedeemScriptType", repeated=False, required=False),
        6: protobuf.Field("op_return_data", "bytes", repeated=False, required=False),
        10: protobuf.Field("orig_hash", "bytes", repeated=False, required=False),
        11: protobuf.Field("orig_index", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        amount: "int",
        address_n: Optional[List["int"]] = None,
        address: Optional["str"] = None,
        script_type: Optional["OutputScriptType"] = OutputScriptType.PAYTOADDRESS,
        multisig: Optional["MultisigRedeemScriptType"] = None,
        op_return_data: Optional["bytes"] = None,
        orig_hash: Optional["bytes"] = None,
        orig_index: Optional["int"] = None,
    ) -> None:
        self.address_n = address_n if address_n is not None else []
        self.amount = amount
        self.address = address
        self.script_type = script_type
        self.multisig = multisig
        self.op_return_data = op_return_data
        self.orig_hash = orig_hash
        self.orig_index = orig_index


class TxAckInputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("input", "TxInput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        input: "TxInput",
    ) -> None:
        self.input = input


class TxAckOutputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        5: protobuf.Field("output", "TxOutput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        output: "TxOutput",
    ) -> None:
        self.output = output


class TxAckPrevInputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        2: protobuf.Field("input", "PrevInput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        input: "PrevInput",
    ) -> None:
        self.input = input


class TxAckPrevOutputWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        3: protobuf.Field("output", "PrevOutput", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        output: "PrevOutput",
    ) -> None:
        self.output = output


class TxAckPrevExtraDataWrapper(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        8: protobuf.Field("extra_data_chunk", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        extra_data_chunk: "bytes",
    ) -> None:
        self.extra_data_chunk = extra_data_chunk


class FirmwareErase(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 6
    FIELDS = {
        1: protobuf.Field("length", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        length: Optional["int"] = None,
    ) -> None:
        self.length = length


class FirmwareRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 8
    FIELDS = {
        1: protobuf.Field("offset", "uint32", repeated=False, required=False),
        2: protobuf.Field("length", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        offset: Optional["int"] = None,
        length: Optional["int"] = None,
    ) -> None:
        self.offset = offset
        self.length = length


class FirmwareUpload(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 7
    FIELDS = {
        1: protobuf.Field("payload", "bytes", repeated=False, required=True),
        2: protobuf.Field("hash", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        payload: "bytes",
        hash: Optional["bytes"] = None,
    ) -> None:
        self.payload = payload
        self.hash = hash


class SelfTest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 32
    FIELDS = {
        1: protobuf.Field("payload", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        payload: Optional["bytes"] = None,
    ) -> None:
        self.payload = payload


class IdentityType(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = None
    FIELDS = {
        1: protobuf.Field("proto", "string", repeated=False, required=False),
        2: protobuf.Field("user", "string", repeated=False, required=False),
        3: protobuf.Field("host", "string", repeated=False, required=False),
        4: protobuf.Field("port", "string", repeated=False, required=False),
        5: protobuf.Field("path", "string", repeated=False, required=False),
        6: protobuf.Field("index", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        proto: Optional["str"] = None,
        user: Optional["str"] = None,
        host: Optional["str"] = None,
        port: Optional["str"] = None,
        path: Optional["str"] = None,
        index: Optional["int"] = 0,
    ) -> None:
        self.proto = proto
        self.user = user
        self.host = host
        self.port = port
        self.path = path
        self.index = index


class Initialize(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 0
    FIELDS = {
        1: protobuf.Field("session_id", "bytes", repeated=False, required=False),
        3: protobuf.Field("derive_cardano", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        session_id: Optional["bytes"] = None,
        derive_cardano: Optional["bool"] = None,
    ) -> None:
        self.session_id = session_id
        self.derive_cardano = derive_cardano


class GetFeatures(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 55


class Features(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 17
    FIELDS = {
        1: protobuf.Field("vendor", "string", repeated=False, required=False),
        2: protobuf.Field("major_version", "uint32", repeated=False, required=True),
        3: protobuf.Field("minor_version", "uint32", repeated=False, required=True),
        4: protobuf.Field("patch_version", "uint32", repeated=False, required=True),
        5: protobuf.Field("bootloader_mode", "bool", repeated=False, required=False),
        6: protobuf.Field("device_id", "string", repeated=False, required=False),
        7: protobuf.Field("pin_protection", "bool", repeated=False, required=False),
        8: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False),
        9: protobuf.Field("language", "string", repeated=False, required=False),
        10: protobuf.Field("label", "string", repeated=False, required=False),
        12: protobuf.Field("initialized", "bool", repeated=False, required=False),
        13: protobuf.Field("revision", "bytes", repeated=False, required=False),
        14: protobuf.Field("bootloader_hash", "bytes", repeated=False, required=False),
        15: protobuf.Field("imported", "bool", repeated=False, required=False),
        16: protobuf.Field("unlocked", "bool", repeated=False, required=False),
        18: protobuf.Field("firmware_present", "bool", repeated=False, required=False),
        19: protobuf.Field("needs_backup", "bool", repeated=False, required=False),
        20: protobuf.Field("flags", "uint32", repeated=False, required=False),
        21: protobuf.Field("model", "string", repeated=False, required=False),
        22: protobuf.Field("fw_major", "uint32", repeated=False, required=False),
        23: protobuf.Field("fw_minor", "uint32", repeated=False, required=False),
        24: protobuf.Field("fw_patch", "uint32", repeated=False, required=False),
        25: protobuf.Field("fw_vendor", "string", repeated=False, required=False),
        26: protobuf.Field("fw_vendor_keys", "bytes", repeated=False, required=False),
        27: protobuf.Field("unfinished_backup", "bool", repeated=False, required=False),
        28: protobuf.Field("no_backup", "bool", repeated=False, required=False),
        29: protobuf.Field("recovery_mode", "bool", repeated=False, required=False),
        30: protobuf.Field("capabilities", "Capability", repeated=True, required=False),
        31: protobuf.Field("backup_type", "BackupType", repeated=False, required=False),
        32: protobuf.Field("sd_card_present", "bool", repeated=False, required=False),
        33: protobuf.Field("sd_protection", "bool", repeated=False, required=False),
        34: protobuf.Field("wipe_code_protection", "bool", repeated=False, required=False),
        35: protobuf.Field("session_id", "bytes", repeated=False, required=False),
        36: protobuf.Field("passphrase_always_on_device", "bool", repeated=False, required=False),
        37: protobuf.Field("safety_checks", "SafetyCheckLevel", repeated=False, required=False),
        38: protobuf.Field("auto_lock_delay_ms", "uint32", repeated=False, required=False),
        39: protobuf.Field("display_rotation", "uint32", repeated=False, required=False),
        40: protobuf.Field("experimental_features", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        major_version: "int",
        minor_version: "int",
        patch_version: "int",
        capabilities: Optional[List["Capability"]] = None,
        vendor: Optional["str"] = None,
        bootloader_mode: Optional["bool"] = None,
        device_id: Optional["str"] = None,
        pin_protection: Optional["bool"] = None,
        passphrase_protection: Optional["bool"] = None,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        initialized: Optional["bool"] = None,
        revision: Optional["bytes"] = None,
        bootloader_hash: Optional["bytes"] = None,
        imported: Optional["bool"] = None,
        unlocked: Optional["bool"] = None,
        firmware_present: Optional["bool"] = None,
        needs_backup: Optional["bool"] = None,
        flags: Optional["int"] = None,
        model: Optional["str"] = None,
        fw_major: Optional["int"] = None,
        fw_minor: Optional["int"] = None,
        fw_patch: Optional["int"] = None,
        fw_vendor: Optional["str"] = None,
        fw_vendor_keys: Optional["bytes"] = None,
        unfinished_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
        recovery_mode: Optional["bool"] = None,
        backup_type: Optional["BackupType"] = None,
        sd_card_present: Optional["bool"] = None,
        sd_protection: Optional["bool"] = None,
        wipe_code_protection: Optional["bool"] = None,
        session_id: Optional["bytes"] = None,
        passphrase_always_on_device: Optional["bool"] = None,
        safety_checks: Optional["SafetyCheckLevel"] = None,
        auto_lock_delay_ms: Optional["int"] = None,
        display_rotation: Optional["int"] = None,
        experimental_features: Optional["bool"] = None,
    ) -> None:
        self.capabilities = capabilities if capabilities is not None else []
        self.major_version = major_version
        self.minor_version = minor_version
        self.patch_version = patch_version
        self.vendor = vendor
        self.bootloader_mode = bootloader_mode
        self.device_id = device_id
        self.pin_protection = pin_protection
        self.passphrase_protection = passphrase_protection
        self.language = language
        self.label = label
        self.initialized = initialized
        self.revision = revision
        self.bootloader_hash = bootloader_hash
        self.imported = imported
        self.unlocked = unlocked
        self.firmware_present = firmware_present
        self.needs_backup = needs_backup
        self.flags = flags
        self.model = model
        self.fw_major = fw_major
        self.fw_minor = fw_minor
        self.fw_patch = fw_patch
        self.fw_vendor = fw_vendor
        self.fw_vendor_keys = fw_vendor_keys
        self.unfinished_backup = unfinished_backup
        self.no_backup = no_backup
        self.recovery_mode = recovery_mode
        self.backup_type = backup_type
        self.sd_card_present = sd_card_present
        self.sd_protection = sd_protection
        self.wipe_code_protection = wipe_code_protection
        self.session_id = session_id
        self.passphrase_always_on_device = passphrase_always_on_device
        self.safety_checks = safety_checks
        self.auto_lock_delay_ms = auto_lock_delay_ms
        self.display_rotation = display_rotation
        self.experimental_features = experimental_features


class LockDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 24


class EndSession(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 83


class ApplySettings(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 25
    FIELDS = {
        1: protobuf.Field("language", "string", repeated=False, required=False),
        2: protobuf.Field("label", "string", repeated=False, required=False),
        3: protobuf.Field("use_passphrase", "bool", repeated=False, required=False),
        4: protobuf.Field("homescreen", "bytes", repeated=False, required=False),
        6: protobuf.Field("auto_lock_delay_ms", "uint32", repeated=False, required=False),
        7: protobuf.Field("display_rotation", "uint32", repeated=False, required=False),
        8: protobuf.Field("passphrase_always_on_device", "bool", repeated=False, required=False),
        9: protobuf.Field("safety_checks", "SafetyCheckLevel", repeated=False, required=False),
        10: protobuf.Field("experimental_features", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        use_passphrase: Optional["bool"] = None,
        homescreen: Optional["bytes"] = None,
        auto_lock_delay_ms: Optional["int"] = None,
        display_rotation: Optional["int"] = None,
        passphrase_always_on_device: Optional["bool"] = None,
        safety_checks: Optional["SafetyCheckLevel"] = None,
        experimental_features: Optional["bool"] = None,
    ) -> None:
        self.language = language
        self.label = label
        self.use_passphrase = use_passphrase
        self.homescreen = homescreen
        self.auto_lock_delay_ms = auto_lock_delay_ms
        self.display_rotation = display_rotation
        self.passphrase_always_on_device = passphrase_always_on_device
        self.safety_checks = safety_checks
        self.experimental_features = experimental_features


class ApplyFlags(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 28
    FIELDS = {
        1: protobuf.Field("flags", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        flags: "int",
    ) -> None:
        self.flags = flags


class ChangePin(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 4
    FIELDS = {
        1: protobuf.Field("remove", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        remove: Optional["bool"] = None,
    ) -> None:
        self.remove = remove


class ChangeWipeCode(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 82
    FIELDS = {
        1: protobuf.Field("remove", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        remove: Optional["bool"] = None,
    ) -> None:
        self.remove = remove


class SdProtect(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 79
    FIELDS = {
        1: protobuf.Field("operation", "SdProtectOperationType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        operation: "SdProtectOperationType",
    ) -> None:
        self.operation = operation


class Ping(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 1
    FIELDS = {
        1: protobuf.Field("message", "string", repeated=False, required=False),
        2: protobuf.Field("button_protection", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        message: Optional["str"] = '',
        button_protection: Optional["bool"] = None,
    ) -> None:
        self.message = message
        self.button_protection = button_protection


class Cancel(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 20


class GetEntropy(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9
    FIELDS = {
        1: protobuf.Field("size", "uint32", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        size: "int",
    ) -> None:
        self.size = size


class Entropy(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 10
    FIELDS = {
        1: protobuf.Field("entropy", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        entropy: "bytes",
    ) -> None:
        self.entropy = entropy


class WipeDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 5


class LoadDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 13
    FIELDS = {
        1: protobuf.Field("mnemonics", "string", repeated=True, required=False),
        3: protobuf.Field("pin", "string", repeated=False, required=False),
        4: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False),
        5: protobuf.Field("language", "string", repeated=False, required=False),
        6: protobuf.Field("label", "string", repeated=False, required=False),
        7: protobuf.Field("skip_checksum", "bool", repeated=False, required=False),
        8: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False),
        9: protobuf.Field("needs_backup", "bool", repeated=False, required=False),
        10: protobuf.Field("no_backup", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        mnemonics: Optional[List["str"]] = None,
        pin: Optional["str"] = None,
        passphrase_protection: Optional["bool"] = None,
        language: Optional["str"] = 'en-US',
        label: Optional["str"] = None,
        skip_checksum: Optional["bool"] = None,
        u2f_counter: Optional["int"] = None,
        needs_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
    ) -> None:
        self.mnemonics = mnemonics if mnemonics is not None else []
        self.pin = pin
        self.passphrase_protection = passphrase_protection
        self.language = language
        self.label = label
        self.skip_checksum = skip_checksum
        self.u2f_counter = u2f_counter
        self.needs_backup = needs_backup
        self.no_backup = no_backup


class ResetDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 14
    FIELDS = {
        1: protobuf.Field("display_random", "bool", repeated=False, required=False),
        2: protobuf.Field("strength", "uint32", repeated=False, required=False),
        3: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False),
        4: protobuf.Field("pin_protection", "bool", repeated=False, required=False),
        5: protobuf.Field("language", "string", repeated=False, required=False),
        6: protobuf.Field("label", "string", repeated=False, required=False),
        7: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False),
        8: protobuf.Field("skip_backup", "bool", repeated=False, required=False),
        9: protobuf.Field("no_backup", "bool", repeated=False, required=False),
        10: protobuf.Field("backup_type", "BackupType", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        display_random: Optional["bool"] = None,
        strength: Optional["int"] = 256,
        passphrase_protection: Optional["bool"] = None,
        pin_protection: Optional["bool"] = None,
        language: Optional["str"] = 'en-US',
        label: Optional["str"] = None,
        u2f_counter: Optional["int"] = None,
        skip_backup: Optional["bool"] = None,
        no_backup: Optional["bool"] = None,
        backup_type: Optional["BackupType"] = BackupType.Bip39,
    ) -> None:
        self.display_random = display_random
        self.strength = strength
        self.passphrase_protection = passphrase_protection
        self.pin_protection = pin_protection
        self.language = language
        self.label = label
        self.u2f_counter = u2f_counter
        self.skip_backup = skip_backup
        self.no_backup = no_backup
        self.backup_type = backup_type


class BackupDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 34


class EntropyRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 35


class EntropyAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 36
    FIELDS = {
        1: protobuf.Field("entropy", "bytes", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        entropy: "bytes",
    ) -> None:
        self.entropy = entropy


class RecoveryDevice(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 45
    FIELDS = {
        1: protobuf.Field("word_count", "uint32", repeated=False, required=False),
        2: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False),
        3: protobuf.Field("pin_protection", "bool", repeated=False, required=False),
        4: protobuf.Field("language", "string", repeated=False, required=False),
        5: protobuf.Field("label", "string", repeated=False, required=False),
        6: protobuf.Field("enforce_wordlist", "bool", repeated=False, required=False),
        8: protobuf.Field("type", "RecoveryDeviceType", repeated=False, required=False),
        9: protobuf.Field("u2f_counter", "uint32", repeated=False, required=False),
        10: protobuf.Field("dry_run", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        word_count: Optional["int"] = None,
        passphrase_protection: Optional["bool"] = None,
        pin_protection: Optional["bool"] = None,
        language: Optional["str"] = None,
        label: Optional["str"] = None,
        enforce_wordlist: Optional["bool"] = None,
        type: Optional["RecoveryDeviceType"] = None,
        u2f_counter: Optional["int"] = None,
        dry_run: Optional["bool"] = None,
    ) -> None:
        self.word_count = word_count
        self.passphrase_protection = passphrase_protection
        self.pin_protection = pin_protection
        self.language = language
        self.label = label
        self.enforce_wordlist = enforce_wordlist
        self.type = type
        self.u2f_counter = u2f_counter
        self.dry_run = dry_run


class WordRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 46
    FIELDS = {
        1: protobuf.Field("type", "WordRequestType", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        type: "WordRequestType",
    ) -> None:
        self.type = type


class WordAck(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 47
    FIELDS = {
        1: protobuf.Field("word", "string", repeated=False, required=True),
    }

    def __init__(
        self,
        *,
        word: "str",
    ) -> None:
        self.word = word


class DoPreauthorized(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 84


class PreauthorizedRequest(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 85


class CancelAuthorization(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 86


class RebootToBootloader(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 87


class DebugLinkDecision(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 100
    FIELDS = {
        1: protobuf.Field("yes_no", "bool", repeated=False, required=False),
        2: protobuf.Field("swipe", "DebugSwipeDirection", repeated=False, required=False),
        3: protobuf.Field("input", "string", repeated=False, required=False),
        4: protobuf.Field("x", "uint32", repeated=False, required=False),
        5: protobuf.Field("y", "uint32", repeated=False, required=False),
        6: protobuf.Field("wait", "bool", repeated=False, required=False),
        7: protobuf.Field("hold_ms", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        yes_no: Optional["bool"] = None,
        swipe: Optional["DebugSwipeDirection"] = None,
        input: Optional["str"] = None,
        x: Optional["int"] = None,
        y: Optional["int"] = None,
        wait: Optional["bool"] = None,
        hold_ms: Optional["int"] = None,
    ) -> None:
        self.yes_no = yes_no
        self.swipe = swipe
        self.input = input
        self.x = x
        self.y = y
        self.wait = wait
        self.hold_ms = hold_ms


class DebugLinkLayout(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9001
    FIELDS = {
        1: protobuf.Field("lines", "string", repeated=True, required=False),
    }

    def __init__(
        self,
        *,
        lines: Optional[List["str"]] = None,
    ) -> None:
        self.lines = lines if lines is not None else []


class DebugLinkReseedRandom(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9002
    FIELDS = {
        1: protobuf.Field("value", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        value: Optional["int"] = None,
    ) -> None:
        self.value = value


class DebugLinkRecordScreen(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9003
    FIELDS = {
        1: protobuf.Field("target_directory", "string", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        target_directory: Optional["str"] = None,
    ) -> None:
        self.target_directory = target_directory


class DebugLinkGetState(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 101
    FIELDS = {
        1: protobuf.Field("wait_word_list", "bool", repeated=False, required=False),
        2: protobuf.Field("wait_word_pos", "bool", repeated=False, required=False),
        3: protobuf.Field("wait_layout", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        wait_word_list: Optional["bool"] = None,
        wait_word_pos: Optional["bool"] = None,
        wait_layout: Optional["bool"] = None,
    ) -> None:
        self.wait_word_list = wait_word_list
        self.wait_word_pos = wait_word_pos
        self.wait_layout = wait_layout


class DebugLinkState(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 102
    FIELDS = {
        1: protobuf.Field("layout", "bytes", repeated=False, required=False),
        2: protobuf.Field("pin", "string", repeated=False, required=False),
        3: protobuf.Field("matrix", "string", repeated=False, required=False),
        4: protobuf.Field("mnemonic_secret", "bytes", repeated=False, required=False),
        5: protobuf.Field("node", "HDNodeType", repeated=False, required=False),
        6: protobuf.Field("passphrase_protection", "bool", repeated=False, required=False),
        7: protobuf.Field("reset_word", "string", repeated=False, required=False),
        8: protobuf.Field("reset_entropy", "bytes", repeated=False, required=False),
        9: protobuf.Field("recovery_fake_word", "string", repeated=False, required=False),
        10: protobuf.Field("recovery_word_pos", "uint32", repeated=False, required=False),
        11: protobuf.Field("reset_word_pos", "uint32", repeated=False, required=False),
        12: protobuf.Field("mnemonic_type", "BackupType", repeated=False, required=False),
        13: protobuf.Field("layout_lines", "string", repeated=True, required=False),
    }

    def __init__(
        self,
        *,
        layout_lines: Optional[List["str"]] = None,
        layout: Optional["bytes"] = None,
        pin: Optional["str"] = None,
        matrix: Optional["str"] = None,
        mnemonic_secret: Optional["bytes"] = None,
        node: Optional["HDNodeType"] = None,
        passphrase_protection: Optional["bool"] = None,
        reset_word: Optional["str"] = None,
        reset_entropy: Optional["bytes"] = None,
        recovery_fake_word: Optional["str"] = None,
        recovery_word_pos: Optional["int"] = None,
        reset_word_pos: Optional["int"] = None,
        mnemonic_type: Optional["BackupType"] = None,
    ) -> None:
        self.layout_lines = layout_lines if layout_lines is not None else []
        self.layout = layout
        self.pin = pin
        self.matrix = matrix
        self.mnemonic_secret = mnemonic_secret
        self.node = node
        self.passphrase_protection = passphrase_protection
        self.reset_word = reset_word
        self.reset_entropy = reset_entropy
        self.recovery_fake_word = recovery_fake_word
        self.recovery_word_pos = recovery_word_pos
        self.reset_word_pos = reset_word_pos
        self.mnemonic_type = mnemonic_type


class DebugLinkStop(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 103


class DebugLinkLog(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 104
    FIELDS = {
        1: protobuf.Field("level", "uint32", repeated=False, required=False),
        2: protobuf.Field("bucket", "string", repeated=False, required=False),
        3: protobuf.Field("text", "string", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        level: Optional["int"] = None,
        bucket: Optional["str"] = None,
        text: Optional["str"] = None,
    ) -> None:
        self.level = level
        self.bucket = bucket
        self.text = text


class DebugLinkMemoryRead(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 110
    FIELDS = {
        1: protobuf.Field("address", "uint32", repeated=False, required=False),
        2: protobuf.Field("length", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address: Optional["int"] = None,
        length: Optional["int"] = None,
    ) -> None:
        self.address = address
        self.length = length


class DebugLinkMemory(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 111
    FIELDS = {
        1: protobuf.Field("memory", "bytes", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        memory: Optional["bytes"] = None,
    ) -> None:
        self.memory = memory


class DebugLinkMemoryWrite(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 112
    FIELDS = {
        1: protobuf.Field("address", "uint32", repeated=False, required=False),
        2: protobuf.Field("memory", "bytes", repeated=False, required=False),
        3: protobuf.Field("flash", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        address: Optional["int"] = None,
        memory: Optional["bytes"] = None,
        flash: Optional["bool"] = None,
    ) -> None:
        self.address = address
        self.memory = memory
        self.flash = flash


class DebugLinkFlashErase(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 113
    FIELDS = {
        1: protobuf.Field("sector", "uint32", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        sector: Optional["int"] = None,
    ) -> None:
        self.sector = sector


class DebugLinkEraseSdCard(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9005
    FIELDS = {
        1: protobuf.Field("format", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        format: Optional["bool"] = None,
    ) -> None:
        self.format = format


class DebugLinkWatchLayout(protobuf.MessageType):
    MESSAGE_WIRE_TYPE = 9006
    FIELDS = {
        1: protobuf.Field("watch", "bool", repeated=False, required=False),
    }

    def __init__(
        self,
        *,
        watch: Optional["bool"] = None,
    ) -> None:
        self.watch = watch
