import loggingfrom typing import Optional, Set, Typefrom typing_extensions import Protocol, runtime_checkablefrom . import protobuf@runtime_checkableclass HasProtobuf(Protocol):    protobuf: protobuf.MessageTypeOMITTED_MESSAGES: Set[Type[protobuf.MessageType]] = set()DUMP_BYTES = 5DUMP_PACKETS = 4logging.addLevelName(DUMP_BYTES, "BYTES")logging.addLevelName(DUMP_PACKETS, "PACKETS")class PrettyProtobufFormatter(logging.Formatter):    def format(self, record: logging.LogRecord) -> str:        time = self.formatTime(record)        message = "[{time}] {source} {level}: {msg}".format(            time=time,            level=record.levelname.upper(),            source=record.name,            msg=super().format(record),        )        if isinstance(record, HasProtobuf):            if type(record.protobuf) in OMITTED_MESSAGES:                message += f" ({record.protobuf.ByteSize()} bytes)"            else:                message += "\n" + protobuf.format_message(record.protobuf)        return messagedef enable_debug_output(    verbosity: int = 1, handler: Optional[logging.Handler] = None) -> None:    if handler is None:        handler = logging.StreamHandler()    formatter = PrettyProtobufFormatter()    handler.setFormatter(formatter)    level = logging.NOTSET    if verbosity > 0:        level = logging.DEBUG    if verbosity > 1:        level = DUMP_BYTES    if verbosity > 2:        level = DUMP_PACKETS    logger = logging.getLogger(__name__.rsplit(".", 1)[0])    logger.setLevel(level)    logger.addHandler(handler)