import torchfrom torch import nnimport numpy as npfrom gaussiansplatting.utils.graphics_utils import getWorld2View2, getProjectionMatrix, focal2fov, fov2focal,getWorld2View2_tensor,getWorld2View_tensorclass Camera(nn.Module):    def __init__(self, c2w, FoVy, height, width,                 trans=torch.tensor([0.0, 0.0, 0.0]), scale=1.0, data_device = "cuda"                 ):        super(Camera, self).__init__()        FoVx = focal2fov(fov2focal(FoVy, height), width)        # FoVx = focal2fov(fov2focal(FoVy, width), height)        w2c = torch.inverse(c2w)        # rectify...        w2c[1:3, :3] *= -1        w2c[:3, 3] *= -1        self.FoVx = FoVx        self.FoVy = FoVy        self.image_height =height        self.image_width = width        try:            self.data_device = torch.device(data_device)        except Exception as e:            print(e)            print(f"[Warning] Custom device {data_device} failed, fallback to default cuda device" )            self.data_device = torch.device("cuda")        self.zfar = 100.0        self.znear = 0.01        self.trans = trans.float()        self.scale = scale        self.world_view_transform = w2c.transpose(0, 1).float().cuda()        self.projection_matrix = getProjectionMatrix(znear=self.znear, zfar=self.zfar, fovX=self.FoVx, fovY=self.FoVy).transpose(0,1).float().cuda()        self.full_proj_transform = (self.world_view_transform.unsqueeze(0).bmm(self.projection_matrix.unsqueeze(0))).squeeze(0).float()        self.camera_center = self.world_view_transform.inverse()[3, :3].float()        # print('self.camera_center',self.camera_center)class MiniCam:    def __init__(self, width, height, fovy, fovx, znear, zfar, world_view_transform, full_proj_transform):        self.image_width = width        self.image_height = height            self.FoVy = fovy        self.FoVx = fovx        self.znear = znear        self.zfar = zfar        self.world_view_transform = world_view_transform        self.full_proj_transform = full_proj_transform        view_inv = torch.inverse(self.world_view_transform)        self.camera_center = view_inv[3][:3]