from __future__ import absolute_importfrom __future__ import divisionfrom __future__ import print_functionimport osimport yamlimport numpy as npfrom easydict import EasyDict as edictconfig = edict()config.OUTPUT_DIR = ''config.LOG_DIR = ''config.DATA_DIR = ''config.GPUS = '0'config.WORKERS = 4config.PRINT_FREQ = 20# Cudnn related paramsconfig.CUDNN = edict()config.CUDNN.BENCHMARK = Trueconfig.CUDNN.DETERMINISTIC = Falseconfig.CUDNN.ENABLED = True# pose_resnet related paramsPOSE_RESNET = edict()POSE_RESNET.NUM_LAYERS = 50POSE_RESNET.DECONV_WITH_BIAS = FalsePOSE_RESNET.NUM_DECONV_LAYERS = 3POSE_RESNET.NUM_DECONV_FILTERS = [256, 256, 256]POSE_RESNET.NUM_DECONV_KERNELS = [4, 4, 4]POSE_RESNET.FINAL_CONV_KERNEL = 1POSE_RESNET.TARGET_TYPE = 'gaussian'POSE_RESNET.HEATMAP_SIZE = [64, 64]  # width * height, ex: 24 * 32POSE_RESNET.SIGMA = 2MODEL_EXTRAS = {    'pose_resnet': POSE_RESNET,}# common params for NETWORKconfig.MODEL = edict()config.MODEL.NAME = 'pose_resnet'config.MODEL.INIT_WEIGHTS = Trueconfig.MODEL.PRETRAINED = ''config.MODEL.NUM_JOINTS = 16config.MODEL.IMAGE_SIZE = [256, 256]  # width * height, ex: 192 * 256config.MODEL.EXTRA = MODEL_EXTRAS[config.MODEL.NAME]config.MODEL.STYLE = 'pytorch'config.LOSS = edict()config.LOSS.USE_TARGET_WEIGHT = True# DATASET related paramsconfig.DATASET = edict()config.DATASET.ROOT = ''config.DATASET.DATASET = 'mpii'config.DATASET.TRAIN_SET = 'train'config.DATASET.TEST_SET = 'valid'config.DATASET.DATA_FORMAT = 'jpg'config.DATASET.HYBRID_JOINTS_TYPE = ''config.DATASET.SELECT_DATA = False# training data augmentationconfig.DATASET.FLIP = Trueconfig.DATASET.SCALE_FACTOR = 0.25config.DATASET.ROT_FACTOR = 30# trainconfig.TRAIN = edict()config.TRAIN.LR_FACTOR = 0.1config.TRAIN.LR_STEP = [90, 110]config.TRAIN.LR = 0.001config.TRAIN.OPTIMIZER = 'adam'config.TRAIN.MOMENTUM = 0.9config.TRAIN.WD = 0.0001config.TRAIN.NESTEROV = Falseconfig.TRAIN.GAMMA1 = 0.99config.TRAIN.GAMMA2 = 0.0config.TRAIN.BEGIN_EPOCH = 0config.TRAIN.END_EPOCH = 140config.TRAIN.RESUME = Falseconfig.TRAIN.CHECKPOINT = ''config.TRAIN.BATCH_SIZE = 32config.TRAIN.SHUFFLE = True# testingconfig.TEST = edict()# size of images for each deviceconfig.TEST.BATCH_SIZE = 32# Test Model Epochconfig.TEST.FLIP_TEST = Falseconfig.TEST.POST_PROCESS = Trueconfig.TEST.SHIFT_HEATMAP = Trueconfig.TEST.USE_GT_BBOX = False# nmsconfig.TEST.OKS_THRE = 0.5config.TEST.IN_VIS_THRE = 0.0config.TEST.COCO_BBOX_FILE = ''config.TEST.BBOX_THRE = 1.0config.TEST.MODEL_FILE = ''config.TEST.IMAGE_THRE = 0.0config.TEST.NMS_THRE = 1.0# debugconfig.DEBUG = edict()config.DEBUG.DEBUG = Falseconfig.DEBUG.SAVE_BATCH_IMAGES_GT = Falseconfig.DEBUG.SAVE_BATCH_IMAGES_PRED = Falseconfig.DEBUG.SAVE_HEATMAPS_GT = Falseconfig.DEBUG.SAVE_HEATMAPS_PRED = Falsedef _update_dict(k, v):    if k == 'DATASET':        if 'MEAN' in v and v['MEAN']:            v['MEAN'] = np.array([eval(x) if isinstance(x, str) else x                                  for x in v['MEAN']])        if 'STD' in v and v['STD']:            v['STD'] = np.array([eval(x) if isinstance(x, str) else x                                 for x in v['STD']])    if k == 'MODEL':        if 'EXTRA' in v and 'HEATMAP_SIZE' in v['EXTRA']:            if isinstance(v['EXTRA']['HEATMAP_SIZE'], int):                v['EXTRA']['HEATMAP_SIZE'] = np.array(                    [v['EXTRA']['HEATMAP_SIZE'], v['EXTRA']['HEATMAP_SIZE']])            else:                v['EXTRA']['HEATMAP_SIZE'] = np.array(                    v['EXTRA']['HEATMAP_SIZE'])        if 'IMAGE_SIZE' in v:            if isinstance(v['IMAGE_SIZE'], int):                v['IMAGE_SIZE'] = np.array([v['IMAGE_SIZE'], v['IMAGE_SIZE']])            else:                v['IMAGE_SIZE'] = np.array(v['IMAGE_SIZE'])    for vk, vv in v.items():        if vk in config[k]:            config[k][vk] = vv        else:            raise ValueError("{}.{} not exist in config.py".format(k, vk))def update_config(config_file):    exp_config = None    with open(config_file) as f:        exp_config = edict(yaml.load(f))        for k, v in exp_config.items():            if k in config:                if isinstance(v, dict):                    _update_dict(k, v)                else:                    if k == 'SCALES':                        config[k][0] = (tuple(v))                    else:                        config[k] = v            else:                raise ValueError("{} not exist in config.py".format(k))def gen_config(config_file):    cfg = dict(config)    for k, v in cfg.items():        if isinstance(v, edict):            cfg[k] = dict(v)    with open(config_file, 'w') as f:        yaml.dump(dict(cfg), f, default_flow_style=False)def update_dir(model_dir, log_dir, data_dir):    if model_dir:        config.OUTPUT_DIR = model_dir    if log_dir:        config.LOG_DIR = log_dir    if data_dir:        config.DATA_DIR = data_dir    config.DATASET.ROOT = os.path.join(            config.DATA_DIR, config.DATASET.ROOT)    config.TEST.COCO_BBOX_FILE = os.path.join(            config.DATA_DIR, config.TEST.COCO_BBOX_FILE)    config.MODEL.PRETRAINED = os.path.join(            config.DATA_DIR, config.MODEL.PRETRAINED)def get_model_name(cfg):    name = cfg.MODEL.NAME    full_name = cfg.MODEL.NAME    extra = cfg.MODEL.EXTRA    if name in ['pose_resnet']:        name = '{model}_{num_layers}'.format(            model=name,            num_layers=extra.NUM_LAYERS)        deconv_suffix = ''.join(            'd{}'.format(num_filters)            for num_filters in extra.NUM_DECONV_FILTERS)        full_name = '{height}x{width}_{name}_{deconv_suffix}'.format(            height=cfg.MODEL.IMAGE_SIZE[1],            width=cfg.MODEL.IMAGE_SIZE[0],            name=name,            deconv_suffix=deconv_suffix)    else:        raise ValueError('Unkown model: {}'.format(cfg.MODEL))    return name, full_nameif __name__ == '__main__':    import sys    gen_config(sys.argv[1])