from bisect import bisect_rightimport torchclass _My_LRScheduler(object):    def __init__(self, optimizer, last_epoch=-1):        # if not isinstance(optimizer, Optimizer):            #raise TypeError('{} is not an Optimizer'.format(                #type(optimizer).__name__))        self.optimizer = optimizer        if last_epoch == -1:            for group in optimizer.param_groups:                group.setdefault('initial_lr', group['lr'])        else:            for i, group in enumerate(optimizer.param_groups):                if 'initial_lr' not in group:                    raise KeyError("param 'initial_lr' is not specified "                                   "in param_groups[{}] when resuming an optimizer".format(i))        self.base_lrs = list(map(lambda group: group['initial_lr'], optimizer.param_groups))        self.step(last_epoch + 1)        self.last_epoch = last_epoch    def state_dict(self):        """Returns the state of the scheduler as a :class:`dict`.        It contains an entry for every variable in self.__dict__ which        is not the optimizer.        """        return {key: value for key, value in self.__dict__.items() if key != 'optimizer'}    def load_state_dict(self, state_dict):        """Loads the schedulers state.        Arguments:            state_dict (dict): scheduler state. Should be an object returned                from a call to :meth:`state_dict`.        """        self.__dict__.update(state_dict)    def get_lr(self):        raise NotImplementedError    def step(self, epoch=None):        if epoch is None:            epoch = self.last_epoch + 1        self.last_epoch = epoch        for param_group, lr in zip(self.optimizer.param_groups, self.get_lr()):            param_group['lr'] = lr# FIXME ideally this would be achieved with a CombinedLRScheduler,# separating MultiStepLR with WarmupLR# but the current LRScheduler design doesn't allow itclass WarmupMultiStepLR(_My_LRScheduler):    def __init__(        self,        optimizer,        milestones,        gamma=0.1,        warmup_factor=1.0 / 3,        warmup_iters=500,        warmup_method="linear",        last_epoch=-1,    ):        if not list(milestones) == sorted(milestones):            raise ValueError(                "Milestones should be a list of" " increasing integers. Got {}",                milestones,            )        if warmup_method not in ("constant", "linear"):            raise ValueError(                "Only 'constant' or 'linear' warmup_method accepted"                "got {}".format(warmup_method)            )        self.milestones = milestones        self.gamma = gamma        self.warmup_factor = warmup_factor        self.warmup_iters = warmup_iters        self.warmup_method = warmup_method        super(WarmupMultiStepLR, self).__init__(optimizer, last_epoch)    def get_lr(self):        warmup_factor = 1        if self.last_epoch < self.warmup_iters:            if self.warmup_method == "constant":                warmup_factor = self.warmup_factor            elif self.warmup_method == "linear":                alpha = self.last_epoch / self.warmup_iters                warmup_factor = self.warmup_factor * (1 - alpha) + alpha        return [            base_lr            * warmup_factor            * self.gamma ** bisect_right(self.milestones, self.last_epoch)            for base_lr in self.base_lrs        ]