import mathimport randomimport torchimport torchvisionfrom torchvision.transforms import functional as Fclass Compose(object):    def __init__(self, transforms):        self.transforms = transforms    def __call__(self, image, target):        for t in self.transforms:            image, target = t(image, target)        return image, target    def __repr__(self):        format_string = self.__class__.__name__ + "("        for t in self.transforms:            format_string += "\n"            format_string += "    {0}".format(t)        format_string += "\n)"        return format_stringclass Resize(object):    def __init__(self, min_size, max_size, align_factor=0):        self.min_size = min_size        self.max_size = max_size        self.align_factor = align_factor    # modified from torchvision to add support for max size    def get_size(self, image_size):        w, h = image_size        # size = self.min_size        # max_size = self.max_size        if type(self.min_size) == tuple:            idx = random.randint(0, len(self.min_size)-1)            size = self.min_size[idx]            max_size = self.max_size[idx]        else:            size = self.min_size            max_size = self.max_size        if max_size is not None:            min_original_size = float(min((w, h)))            max_original_size = float(max((w, h)))            if max_original_size / min_original_size * size > max_size:                size = int(round(max_size * min_original_size / max_original_size))        if (w <= h and w == size) or (h <= w and h == size):            return (h, w)        if w < h:            ow = size            oh = int(size * h / w)        else:            oh = size            ow = int(size * w / h)        return (oh, ow)    # modified from torchvision to add support for padding align    def get_pad_size(self, image_size):        if self.align_factor == 0:            return (0,0,0,0)        w, h = image_size        factor = self.align_factor        pw = int(math.ceil(w/factor) * factor)        ph = int(math.ceil(h/factor) * factor)        return (0, 0, ph-h, pw-w)    def __call__(self, image, target):        size = self.get_size(image.size)        pad_size = self.get_pad_size(size)        image = F.resize(image, size)        image = F.pad(image, pad_size)        target = target.resize(image.size)        return image, targetclass RandomHorizontalFlip(object):    def __init__(self, prob=0.5):        self.prob = prob    def __call__(self, image, target):        if random.random() < self.prob:            image = F.hflip(image)            target = target.transpose(0)        return image, targetclass ToTensor(object):    def __call__(self, image, target):        return F.to_tensor(image), targetclass Normalize(object):    def __init__(self, mean, std, to_bgr255=True):        self.mean = mean        self.std = std        self.to_bgr255 = to_bgr255    def __call__(self, image, target):        if self.to_bgr255:            image = image[[2, 1, 0]] * 255        image = F.normalize(image, mean=self.mean, std=self.std)        return image, target