C_DISCLAIMER = """
/*
   DO NOT EDIT THIS FILE!

   This file is automatically generated by {clsname}
   See also hpy.tools.autogen and hpy/tools/public_api.h

   Run this to regenerate:
       make autogen

*/
"""

class AutoGenFile:
    LANGUAGE = 'C'
    PATH = None
    DISCLAIMER = None

    def __init__(self, api):
        if self.DISCLAIMER is None and self.LANGUAGE == 'C':
            self.DISCLAIMER = C_DISCLAIMER
        self.api = api

    def generate(self):
        raise NotImplementedError

    def write(self, root):
        cls = self.__class__
        clsname = '%s.%s' % (cls.__module__, cls.__name__)
        with root.join(self.PATH).open('w') as f:
            if self.DISCLAIMER is not None:
                f.write(self.DISCLAIMER.format(clsname=clsname))
                f.write('\n')
            f.write(self.generate())
            f.write('\n')
