import loggingimport pathlibimport liefclass ExecutablesPatcherError(RuntimeError):    passclass ExecutablesPatcher:    def __init__(self):        self.script_interpreters_paths = {}        self.binary_interpreters_paths = {}        self.logger = logging.getLogger("ExecutablesPatcher")    def patch_interpreted_executable(self, path: pathlib.Path):        try:            with open(path, "r+") as f:                shebang = f.readline()                patched_shebang = self.make_bin_path_in_shebang_relative(shebang)                f.seek(0)                f.write(patched_shebang)                self._register_interpreter_used_in_shebang(path, patched_shebang)        except Exception as e:            self.logger.warning("Unable to patch script shebang %s: %s", path, e)    def _register_interpreter_used_in_shebang(self, executable_path, shebang):        interpreter_path = self.read_interpreter_path_from_shebang(shebang)        self.script_interpreters_paths[executable_path] = interpreter_path    @staticmethod    def read_interpreter_path_from_shebang(shebang):        interpreter_path = shebang[2:].strip()        interpreter_path = interpreter_path.split(" ")[0]        return interpreter_path    @staticmethod    def make_bin_path_in_shebang_relative(shebang):        shebang_len = len(shebang)        idx = 2        while shebang_len > idx and (shebang[idx] == "/" or shebang[idx] == " "):            idx = idx + 1        patched = shebang[:2] + " " * (idx - 2) + shebang[idx:]        return patched    def patch_binary_executable(self, path: pathlib.Path):        try:            binary = lief.parse(path.__str__())            interpreter_path = binary.interpreter            if interpreter_path:                patched_interpreter_path = interpreter_path.lstrip("/")                binary.interpreter = patched_interpreter_path                binary.write(path.__str__())                self.binary_interpreters_paths[path] = patched_interpreter_path        except Exception as e:            logging.warning(f"Unable to patch binary executables: {e}")