import shleximport libconfimport liefimport urllib3def identify_module_library_paths(files):    """Identifies library paths for a module"""    library_paths = set()    for file in files:        file_dir = file.parent.__str__()        # only parse file if the directory is not already in the library paths        if file_dir not in library_paths:            binary = lief.parse(file.__str__())            if is_binary_a_shared_library(binary):                library_paths.add(file_dir)    return library_pathsdef is_binary_a_shared_library(binary):    """Checks if a binary is a shared library"""    # read soname from ELF header    if binary:        soname = binary.get(lief.ELF.DYNAMIC_TAGS.SONAME)        return soname is not None    return Falsedef download_file_by_chunks_using_urlib3(apprun_url, target_path):    """Downloads a file by chunks using urllib3"""    http = urllib3.PoolManager()    r = http.request("GET", apprun_url)    with open(target_path, "wb") as f:        for chunk in r.iter_content(chunk_size=8192):            if chunk:                f.write(chunk)def write_config_file(config, path):    """Writes a config file"""    with open(path, "w") as f:        config_data = libconf.dumps(config)        f.write(config_data)def read_shebang(path):    try:        with open(path, "rb") as fhandler:            line = fhandler.readline().strip().decode()        if len(line) > 2 and line[0:2] == '#!':            shebang_split = shlex.split(line[2:].strip())            return shebang_split    except UnicodeDecodeError:        pass    return Nonedef remove_left_slashes_on_shebang(chunk):    """Removes left slashes on shebang"""    for i in range(2, len(chunk)):        # if the character is not a slash, we are done        if chunk[i] != ord("/") and chunk[i] != ord(" "):            return chunk[:2] + b" " * (i - 2) + chunk[i:]    return chunkdef replace_app_dir_in_path(appdir, path):    """Replaces the app dir in a path"""    path_str = str(path)    appdir_str = str(appdir)    return path_str.replace(appdir_str, "$APPDIR")