# Generated by Django 3.1.7 on 2021-04-01 02:07

import uuid

from django.db import migrations, models


def populate_uuid(apps, schema_editor):
    Enrollment = apps.get_model("students", "Enrollment")
    for enrollment in Enrollment.objects.all():
        enrollment.uuid = uuid.uuid4()
        enrollment.save()


class Migration(migrations.Migration):
    dependencies = [("students", "0001_initial")]

    operations = [
        migrations.AddField(
            model_name="enrollment",
            name="uuid",
            field=models.UUIDField(blank=True, null=True),
        ),
        migrations.RunPython(populate_uuid, migrations.RunPython.noop),
        migrations.AlterField(
            model_name="enrollment",
            name="uuid",
            field=models.UUIDField(db_index=True, default=uuid.uuid4),
        ),
    ]
