# Generated by Django 3.2.11 on 2022-01-27 02:16

from django.db import migrations, models


def set_order_to_id(apps, schema_editor):
    GradeLevel = apps.get_model("schools", "GradeLevel")
    for grade_level in GradeLevel.objects.all():
        grade_level.order = grade_level.id
        grade_level.save()


class Migration(migrations.Migration):
    dependencies = [
        ("schools", "0004_schoolbreak_students"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="gradelevel",
            options={"ordering": ("order",)},
        ),
        migrations.AddField(
            model_name="gradelevel",
            name="order",
            field=models.PositiveIntegerField(
                db_index=True, default=0, editable=False, verbose_name="order"
            ),
            preserve_default=False,
        ),
        migrations.RunPython(set_order_to_id, migrations.RunPython.noop),
    ]
