# Generated by Django 3.0.7 on 2020-08-08 15:46

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [("schools", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="Course",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "days_of_week",
                    models.PositiveIntegerField(
                        default=31, help_text="The days of the week when this runs"
                    ),
                ),
                ("name", models.CharField(max_length=256)),
                ("uuid", models.UUIDField(db_index=True, default=uuid.uuid4)),
                (
                    "default_task_duration",
                    models.IntegerField(
                        default=30, help_text="The default task duration in minutes"
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="CourseTask",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        db_index=True, editable=False, verbose_name="order"
                    ),
                ),
                ("uuid", models.UUIDField(db_index=True, default=uuid.uuid4)),
                ("description", models.TextField()),
                (
                    "duration",
                    models.PositiveIntegerField(
                        help_text="The expected length of the task in minutes"
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="course_tasks",
                        to="courses.Course",
                    ),
                ),
                (
                    "grade_level",
                    models.ForeignKey(
                        blank=True,
                        help_text="A grade level when a task is specific to a grade",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="schools.GradeLevel",
                    ),
                ),
            ],
            options={"ordering": ("order",), "abstract": False},
        ),
        migrations.CreateModel(
            name="GradeLevelCoursesThroughModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order",
                    models.PositiveIntegerField(
                        db_index=True, editable=False, verbose_name="order"
                    ),
                ),
                (
                    "course",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="courses.Course"
                    ),
                ),
                (
                    "grade_level",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="schools.GradeLevel",
                    ),
                ),
            ],
            options={"ordering": ("grade_level", "order")},
        ),
        migrations.CreateModel(
            name="GradedWork",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "course_task",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="graded_work",
                        to="courses.CourseTask",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="course",
            name="grade_levels",
            field=models.ManyToManyField(
                related_name="courses",
                through="courses.GradeLevelCoursesThroughModel",
                to="schools.GradeLevel",
            ),
        ),
    ]
