import fnmatchfrom appimagebuilder.modules.deploy.apt import listingsfrom appimagebuilder.utils.dpkg_query import DpkgQueryclass PackageFilter:    """    Filters a given apt packages removing:    - packages that are required by other packages in the list    - packages that are known to reduce the bundle portability    - packages that are useless in a bundle (i.e.: system services)    """    def __init__(self):        self.exclusion_patterns = set().union(            listings.apt_core, listings.system_services, listings.graphics        )    def filter(self, packages):        # discard duplicates and ease future operations        packages = set(packages)        packages = self.discard_simblings(packages)        packages = self.discard_blacklisted(packages)        return packages    def discard_blacklisted(self, packages):        filtered_packages = set()        for pkg in packages:            pkg_name = pkg.split(":")[0]            if not self._is_package_blacklisted(pkg_name):                filtered_packages.add(pkg)        return filtered_packages    def _is_package_blacklisted(self, pkg_name):        for pattern in self.exclusion_patterns:            if fnmatch.fnmatch(pkg_name, pattern):                return True        return False    def discard_simblings(self, packages):        dpkg_query = DpkgQuery()        dependency_map = dpkg_query.depends(packages)        dependencies = set()        for dependencies_list in dependency_map.values():            dependencies = dependencies.union(dependencies_list)        filtered_packages = set()        for pkg in packages:            pkg_name = pkg.split(":")[0]            if pkg_name not in dependencies:                filtered_packages.add(pkg)        return filtered_packages