"""Aliases for manufacturers and model IDs."""

from __future__ import annotations

MANUFACTURER_3A_SMARTHOME = "3A Smart Home DE"
MANUFACTURER_AQARA = "Aqara"
MANUFACTURER_ATHOM = "Athom_Technology"
MANUFACTURER_DENON = "Denon"
MANUFACTURER_FEIBIT = "Feibit Inc co.  "
MANUFACTURER_FIBARO = "Fibargroup"
MANUFACTURER_GE_APPLIANCES = "GE Appliances"
MANUFACTURER_GOOGLE = "Google Inc."
MANUFACTURER_GREENWAVE = "GreenWave Reality Inc."
MANUFACTURER_IKEA = "IKEA of Sweden"
MANUFACTURER_LEDVANCE = "LEDVANCE"
MANUFACTURER_LEXMAN = "Lexman"
MANUFACTURER_LIDL = "lidl"
MANUFACTURER_LINKIND = "Linkind"
MANUFACTURER_MELITECH = "MeLiTec"
MANUFACTURER_MULLER_LIGHT = "Müller Licht"
MANUFACTURER_NEO_ELECTRONICS = "Shenzhen Neo Electronics Co., Ltd."
MANUFACTURER_NODON = "NoDon"
MANUFACTURER_NOUS = "Nous"
MANUFACTURER_OSRAM = "OSRAM"
MANUFACTURER_SIGNIFY = "Signify Netherlands B.V."
MANUFACTURER_SONOS = "Sonos"
MANUFACTURER_TUYA = "TuYa"
MANUFACTURER_WIZ = "WiZ"
MANUFACTURER_YEELIGHT = "Yeelight"
MANUFACTURER_WLED = "WLED"

MANUFACTURER_ALIASES = {
    "ADEO": MANUFACTURER_LEXMAN,
    "Fibaro": MANUFACTURER_FIBARO,
    "Greenwave": MANUFACTURER_GREENWAVE,
    "HEOS": MANUFACTURER_DENON,
    "IKEA": MANUFACTURER_IKEA,
    "LightZone": MANUFACTURER_MELITECH,
    "LUMI": MANUFACTURER_AQARA,
    "MLI": MANUFACTURER_MULLER_LIGHT,
    "Music Assistant": MANUFACTURER_SONOS,
    "Neo Coolcam": MANUFACTURER_NEO_ELECTRONICS,
    "ID-RF": MANUFACTURER_NODON,
    "Philips": MANUFACTURER_SIGNIFY,
    "Xiaomi": MANUFACTURER_AQARA,
    "Yeelight Technology": MANUFACTURER_YEELIGHT,
    "_TZ3000_riwp3k79": MANUFACTURER_LIDL,
    "lk": MANUFACTURER_LINKIND,
    "ge": MANUFACTURER_GE_APPLIANCES,
}

MANUFACTURER_DIRECTORY_MAPPING = {
    MANUFACTURER_3A_SMARTHOME: "3a smarthome",
    MANUFACTURER_AQARA: "aqara",
    MANUFACTURER_ATHOM: "athom",
    MANUFACTURER_DENON: "denon",
    MANUFACTURER_FEIBIT: "jiawen",
    MANUFACTURER_FIBARO: "fibaro",
    MANUFACTURER_GOOGLE: "google",
    MANUFACTURER_GREENWAVE: "greenwave",
    MANUFACTURER_IKEA: "ikea",
    MANUFACTURER_LEDVANCE: "ledvance",
    MANUFACTURER_LEXMAN: "lexman",
    MANUFACTURER_LINKIND: "linkind",
    MANUFACTURER_MELITECH: "melitec",
    MANUFACTURER_MULLER_LIGHT: "mueller-licht",
    MANUFACTURER_NEO_ELECTRONICS: "neo-coolcam",
    MANUFACTURER_NODON: "nodon",
    MANUFACTURER_NOUS: "nous",
    MANUFACTURER_OSRAM: "osram",
    MANUFACTURER_SIGNIFY: "signify",
    MANUFACTURER_TUYA: "tuya",
    MANUFACTURER_WIZ: "wiz",
    MANUFACTURER_YEELIGHT: "yeelight",
    MANUFACTURER_GE_APPLIANCES: "ge",
}
